/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.id.LexingIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.IndexPattern;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class BaseFilterLexerUtil {
    private BaseFilterLexerUtil() {
    }

    @NotNull
    public static Map<IdIndexEntry, Integer> calcIdEntries(@NotNull FileContent content, @NotNull IdAndToDoScannerBasedOnFilterLexer indexer) {
        boolean needIdIndex;
        if (content == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(0);
        }
        if (indexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(1);
        }
        if (!(needIdIndex = IdTableBuilding.getFileTypeIndexer(content.getFileType()) instanceof LexingIdIndexer)) {
            Map<IdIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                BaseFilterLexerUtil.$$$reportNull$$$0(2);
            }
            return map;
        }
        IdDataConsumer consumer = new IdDataConsumer();
        BaseFilterLexerUtil.scanContentWithCheckCanceled(content, indexer.createLexer(new OccurrenceConsumer(consumer, false)));
        Map<IdIndexEntry, Integer> map = consumer.getResult();
        if (map == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public static Map<TodoIndexEntry, Integer> calcTodoEntries(@NotNull FileContent content, @NotNull IdAndToDoScannerBasedOnFilterLexer indexer) {
        IndexPattern[] todoPatterns;
        if (content == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(4);
        }
        if (indexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(5);
        }
        boolean needTodo = TodoIndexers.needsTodoIndex((IndexedFile)content) || content.getFile() instanceof LightVirtualFile;
        IndexPattern[] indexPatternArray = todoPatterns = needTodo ? IndexPatternUtil.getIndexPatterns() : IndexPattern.EMPTY_ARRAY;
        if (todoPatterns.length == 0) {
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                BaseFilterLexerUtil.$$$reportNull$$$0(6);
            }
            return map;
        }
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        BaseFilterLexerUtil.scanContentWithCheckCanceled(content, indexer.createLexer(occurrenceConsumer));
        Map<TodoIndexEntry, Integer> todoMap = null;
        for (IndexPattern indexPattern : todoPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            if (todoMap == null) {
                todoMap = new HashMap<TodoIndexEntry, Integer>();
            }
            todoMap.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        Map<TodoIndexEntry, Integer> map = todoMap != null ? todoMap : Collections.emptyMap();
        if (map == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @ApiStatus.Internal
    public static void scanContentWithCheckCanceled(@NotNull FileContent content, @NotNull Lexer filterLexer) {
        if (content == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(8);
        }
        if (filterLexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(9);
        }
        filterLexer.start(content.getContentAsText());
        int tokenIdx = 0;
        while (filterLexer.getTokenType() != null) {
            if (tokenIdx++ % 128 == 0) {
                ProgressManager.checkCanceled();
            }
            filterLexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/BaseFilterLexerUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/BaseFilterLexerUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIdEntries";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTodoEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcIdEntries";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcTodoEntries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scanContentWithCheckCanceled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

