/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IndexCacheManagerImpl
implements CacheManager {
    @NotNull
    private final Project myProject;

    public IndexCacheManagerImpl(@NotNull Project project) {
        if (project == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public PsiFile @NotNull [] getFilesWithWord(@NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.processFilesWithWord((Processor<? super PsiFile>)processor, word, occurrenceMask, scope, caseSensitively);
        PsiFile[] psiFileArray = result.isEmpty() ? PsiFile.EMPTY_ARRAY : result.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(4);
        }
        return psiFileArray;
    }

    public VirtualFile @NotNull [] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDefault()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(7);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList(5);
        Processor processor = Processors.cancelableCollectProcessor(result);
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> this.collectVirtualFilesWithWord(word, occurenceMask, scope, caseSensitively, (Processor<? super VirtualFile>)processor));
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    public boolean processVirtualFilesWithAllWords(@NotNull Collection<String> words, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively, @NotNull Processor<? super VirtualFile> processor) {
        if (words == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        PsiSearchHelperImpl.TextIndexQuery query = PsiSearchHelperImpl.TextIndexQuery.fromWords(words, caseSensitively, false, occurrenceMask);
        if (PsiSearchHelperImpl.LOG.isTraceEnabled()) {
            PsiSearchHelperImpl.LOG.trace("searching for words " + String.valueOf(words) + " in " + String.valueOf(scope));
        }
        try {
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(query.toFileBasedIndexQueries(), scope, processor);
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    private void collectVirtualFilesWithWord(@NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively, @NotNull Processor<? super VirtualFile> fileProcessor) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(13);
        }
        if (fileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(14);
        }
        this.processVirtualFilesWithAllWords(Collections.singleton(word), occurrenceMask, scope, caseSensitively, fileProcessor);
    }

    public boolean processFilesWithWord(final @NotNull Processor<? super PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (psiFileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(15);
        }
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(17);
        }
        ArrayList result = new ArrayList(5);
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.collectVirtualFilesWithWord(word, occurrenceMask, scope, caseSensitively, (Processor<? super VirtualFile>)processor);
        if (result.isEmpty()) {
            return true;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(this){

            public boolean processInReadAction(VirtualFile virtualFile) {
                if (virtualFile.isValid()) {
                    PsiFile psiFile = psiManager.findFile(virtualFile);
                    return psiFile == null || psiFileProcessor.process((Object)psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : result) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithWord";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesWithWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithWord";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesWithWord";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFilesWithAllWords";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectVirtualFilesWithWord";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithWord";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

