/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.search.IndexPattern;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public final class OccurrenceConsumer {
    private final IdDataConsumer myIndexDataConsumer;
    private Object2IntMap<IndexPattern> myTodoOccurrences;
    private final boolean myNeedToDo;

    public OccurrenceConsumer(IdDataConsumer indexDataConsumer, boolean needToDo) {
        this.myIndexDataConsumer = indexDataConsumer;
        this.myNeedToDo = needToDo;
    }

    public void addOccurrence(CharSequence charSequence, char[] charArray, int start, int end, int occurrenceMask) {
        if (this.myIndexDataConsumer == null) {
            return;
        }
        if (charArray != null) {
            this.myIndexDataConsumer.addOccurrence(charArray, start, end, occurrenceMask);
        } else {
            this.myIndexDataConsumer.addOccurrence(charSequence, start, end, occurrenceMask);
        }
    }

    public void incTodoOccurrence(IndexPattern pattern) {
        if (this.myTodoOccurrences == null) {
            this.myTodoOccurrences = new Object2IntOpenHashMap();
        }
        this.myTodoOccurrences.mergeInt((Object)pattern, 1, Math::addExact);
    }

    public int getOccurrenceCount(IndexPattern pattern) {
        return this.myTodoOccurrences == null ? 0 : this.myTodoOccurrences.getInt((Object)pattern);
    }

    public boolean isNeedToDo() {
        return this.myNeedToDo;
    }
}

