/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.cache.impl.id.IdEntryToScopeMapImpl;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class IdDataConsumer {
    @NotNull
    private final IdEntryToScopeMapImpl hashToScopeMap = new IdEntryToScopeMapImpl();

    @NotNull
    public Map<IdIndexEntry, Integer> getResult() {
        if (this.hashToScopeMap.size() < 500) {
            this.hashToScopeMap.ensureSerializedDataCached();
        }
        IdEntryToScopeMapImpl idEntryToScopeMapImpl = this.hashToScopeMap;
        if (idEntryToScopeMapImpl == null) {
            IdDataConsumer.$$$reportNull$$$0(0);
        }
        return idEntryToScopeMapImpl;
    }

    public void addOccurrence(char[] chars, int start, int end, int occurrenceMask) {
        this.addOccurrence(null, chars, start, end, occurrenceMask);
    }

    public void addOccurrence(CharSequence charSequence, int start, int end, int occurrenceMask) {
        this.addOccurrence(charSequence, null, start, end, occurrenceMask);
    }

    private void addOccurrence(CharSequence charSequence, char[] chars, int start, int end, int occurrenceMask) {
        int hash;
        int hashNoCase;
        boolean hasArray;
        if (end == start || occurrenceMask == 0) {
            return;
        }
        boolean bl = hasArray = chars != null;
        if (IdIndexEntry.useStrongerHash()) {
            hashNoCase = 0;
            hash = 0;
            boolean different = false;
            for (int off = start; off < end; ++off) {
                char c = hasArray ? chars[off] : charSequence.charAt(off);
                char lowerC = StringUtil.toLowerCase((char)c);
                if (!different && c != lowerC) {
                    different = true;
                    hashNoCase = hash;
                }
                hash = 31 * hash + c;
                if (!different) continue;
                hashNoCase = 31 * hashNoCase + lowerC;
            }
            if (!different) {
                hashNoCase = hash;
            }
        } else {
            char firstChar = hasArray ? chars[start] : charSequence.charAt(start);
            char lastChar = hasArray ? chars[end - 1] : charSequence.charAt(end - 1);
            hash = (firstChar << 8) + (lastChar << 4) + end - start;
            char firstCharLower = StringUtil.toLowerCase((char)firstChar);
            char lastCharLower = StringUtil.toLowerCase((char)lastChar);
            hashNoCase = firstCharLower == firstChar && lastCharLower == lastChar ? hash : (firstCharLower << 8) + (lastCharLower << 4) + end - start;
        }
        this.hashToScopeMap.updateMask(hash, occurrenceMask);
        if (hashNoCase != hash) {
            this.hashToScopeMap.updateMask(hashNoCase, occurrenceMask);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/IdDataConsumer", "getResult"));
    }
}

