/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoIndexers
extends FileTypeExtension<DataIndexer<TodoIndexEntry, Integer, FileContent>> {
    @ApiStatus.Internal
    public static final TodoIndexers INSTANCE = new TodoIndexers();
    private static final ExtensionPointName<ExtraPlaceChecker> EP_NAME = ExtensionPointName.create((String)"com.intellij.todoExtraPlaces");

    @ApiStatus.Internal
    private TodoIndexers() {
        super("com.intellij.todoIndexer");
    }

    @ApiStatus.Internal
    public static boolean needsTodoIndex(@NotNull IndexedFile file) {
        if (file == null) {
            TodoIndexers.$$$reportNull$$$0(0);
        }
        if (FileBasedIndex.IGNORE_PLAIN_TEXT_FILES && file.getFileType() == PlainTextFileType.INSTANCE) {
            return false;
        }
        VirtualFile vFile = file.getFile();
        if (!vFile.isInLocalFileSystem()) {
            return false;
        }
        Project project = file.getProject();
        if (project != null) {
            if (project.isDefault()) {
                return false;
            }
            if (ProjectFileIndex.getInstance((Project)project).isInContent(vFile)) {
                return true;
            }
        }
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(project, file.getFile())) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean belongsToProject(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TodoIndexers.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TodoIndexers.$$$reportNull$$$0(2);
        }
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(project, file)) continue;
            return true;
        }
        return ProjectFileIndex.getInstance((Project)project).isInContent(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndexers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "needsTodoIndex";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "belongsToProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ExtraPlaceChecker {
        public boolean accept(@Nullable Project var1, @NotNull VirtualFile var2);
    }
}

