/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubElementRegistryServiceImplKt;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.stubs.StubSerializerEnumerator;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TemplateLanguageStubBaseVersion;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InMemoryDataEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SerializationManagerImpl.class);
    private final AtomicBoolean myNameStorageCrashed;
    @NotNull
    private final Supplier<? extends Path> myFile;
    private final boolean myUnmodifiable;
    private final AtomicBoolean myInitialized;
    private volatile Path myOpenFile;
    private volatile StubSerializationHelper myStubSerializationHelper;
    private volatile StubSerializerEnumerator mySerializerEnumerator;
    private volatile boolean mySerializersLoaded;

    public SerializationManagerImpl(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            SerializationManagerImpl.$$$reportNull$$$0(0);
        }
        this(() -> FileBasedIndex.USE_IN_MEMORY_INDEX ? null : PathManager.getIndexRoot().resolve("rep.names"), false, coroutineScope);
    }

    @NonInjectable
    public SerializationManagerImpl(@NotNull Path nameStorageFile, boolean unmodifiable, @NotNull CoroutineScope coroutineScope) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(1);
        }
        if (coroutineScope == null) {
            SerializationManagerImpl.$$$reportNull$$$0(2);
        }
        this(() -> nameStorageFile, unmodifiable, coroutineScope);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonInjectable
    public SerializationManagerImpl(@NotNull Supplier<? extends @Nullable Path> nameStorageFile, boolean unmodifiable, @NotNull CoroutineScope coroutineScope) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(3);
        }
        if (coroutineScope == null) {
            SerializationManagerImpl.$$$reportNull$$$0(4);
        }
        this.myNameStorageCrashed = new AtomicBoolean();
        this.myInitialized = new AtomicBoolean();
        this.myFile = nameStorageFile;
        this.myUnmodifiable = unmodifiable;
        this.initialize();
        StubElementTypeHolderEP.EP_NAME.addChangeListener(coroutineScope, this::dropSerializerData);
        StubElementRegistryServiceImplKt.STUB_REGISTRY_EP.addChangeListener(coroutineScope, this::dropSerializerData);
        @NotNull @NotNull ExtensionPoint point = StubElementRegistryServiceImplKt.STUB_DEFINITION_EP.getPoint();
        if (point != null) {
            point.addChangeListener(coroutineScope, this::dropSerializerData);
        }
    }

    @Override
    public void initialize() {
        if (this.myInitialized.get()) {
            return;
        }
        this.doInitialize();
    }

    private void doInitialize() {
        try {
            StubSerializerEnumerator enumerator;
            this.mySerializerEnumerator = enumerator = new StubSerializerEnumerator(this.openNameStorage(), this.myUnmodifiable);
            this.myStubSerializationHelper = new StubSerializationHelper(enumerator);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
        }
        finally {
            this.myInitialized.set(true);
        }
    }

    @NotNull
    private DataEnumeratorEx<String> openNameStorage() throws IOException {
        this.myOpenFile = this.myFile.get();
        if (this.myOpenFile == null) {
            return new InMemoryDataEnumerator();
        }
        DataEnumeratorEx dataEnumeratorEx = (DataEnumeratorEx)PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions().readOnly(this.myUnmodifiable).with(() -> new PersistentStringEnumerator(this.myOpenFile, true));
        if (dataEnumeratorEx == null) {
            SerializationManagerImpl.$$$reportNull$$$0(5);
        }
        return dataEnumeratorEx;
    }

    @ApiStatus.Internal
    public Map<String, Integer> dumpNameStorage() {
        return this.mySerializerEnumerator.dump();
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage(@NotNull Exception corruptionCause) {
        if (corruptionCause == null) {
            SerializationManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myNameStorageCrashed.getAndSet(false)) {
            if (this.myUnmodifiable) {
                LOG.error("Data provided by unmodifiable serialization manager can be invalid after repair");
            }
            LOG.info("Name storage is repaired");
            StubSerializerEnumerator enumerator = this.mySerializerEnumerator;
            if (enumerator != null) {
                try {
                    enumerator.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.myOpenFile != null) {
                IOUtil.deleteAllFilesStartingWith((Path)this.myOpenFile);
            }
            this.doInitialize();
        }
    }

    @Override
    public void flushNameStorage() throws IOException {
        this.mySerializerEnumerator.flush();
    }

    private void registerSerializer(ObjectStubSerializer<?, ? extends Stub> serializer2) {
        this.registerSerializer(serializer2.getExternalId(), () -> serializer2);
    }

    @Override
    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage(new Exception("Indexes are requested to rebuild"));
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    public void dispose() {
        this.performShutdown();
    }

    @Override
    public void performShutdown() {
        String name;
        if (!this.myInitialized.compareAndSet(true, false)) {
            return;
        }
        String string = name = this.myOpenFile != null ? this.myOpenFile.toString() : "in-memory storage";
        if (!this.myUnmodifiable) {
            LOG.info("Start shutting down " + name);
        }
        try {
            this.mySerializerEnumerator.close();
            if (!this.myUnmodifiable) {
                LOG.info("Finished shutting down " + name);
            }
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.error((Throwable)e);
        }
    }

    private void registerSerializer(@NotNull String externalId, @NotNull Supplier<? extends ObjectStubSerializer<?, ? extends Stub>> lazySerializer) {
        if (externalId == null) {
            SerializationManagerImpl.$$$reportNull$$$0(7);
        }
        if (lazySerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(8);
        }
        try {
            this.mySerializerEnumerator.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(9);
        }
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(10);
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(11);
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(12);
        }
        return stub;
    }

    @Override
    public void reSerialize(@NotNull InputStream inStub, @NotNull OutputStream outStub, @NotNull StubTreeSerializer newSerializationManager) throws IOException {
        if (inStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(13);
        }
        if (outStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(14);
        }
        if (newSerializationManager == null) {
            SerializationManagerImpl.$$$reportNull$$$0(15);
        }
        this.initSerializers();
        ((SerializationManagerEx)newSerializationManager).initSerializers();
        this.myStubSerializationHelper.reSerializeStub(new DataInputStream(inStub), new DataOutputStream(outStub), ((SerializationManagerImpl)newSerializationManager).myStubSerializationHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initSerializers() {
        if (this.mySerializersLoaded) {
            return;
        }
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            if (this.mySerializersLoaded) {
                return;
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                SerializationManagerImpl.instantiateElementTypesFromFields();
                StubIndexEx.initExtensions();
            });
            this.registerSerializer((ObjectStubSerializer<?, ? extends Stub>)PsiFileStubImpl.TYPE);
            List lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            StubElementRegistryService stubElementRegistryService = StubElementRegistryService.getInstance();
            record TypeAndSerializer(@NotNull IElementType type, @NotNull ObjectStubSerializer<?, Stub> serializer) {
                @NotNull
                private final IElementType type;
                @NotNull
                private final ObjectStubSerializer<?, Stub> serializer;

                TypeAndSerializer(@NotNull IElementType type, @NotNull ObjectStubSerializer<?, Stub> serializer2) {
                    if (type == null) {
                        TypeAndSerializer.$$$reportNull$$$0(0);
                    }
                    if (serializer2 == null) {
                        TypeAndSerializer.$$$reportNull$$$0(1);
                    }
                }

                @NotNull
                public IElementType type() {
                    IElementType iElementType = this.type;
                    if (iElementType == null) {
                        TypeAndSerializer.$$$reportNull$$$0(2);
                    }
                    return iElementType;
                }

                @NotNull
                public ObjectStubSerializer<?, Stub> serializer() {
                    ObjectStubSerializer<?, Stub> objectStubSerializer = this.serializer;
                    if (objectStubSerializer == null) {
                        TypeAndSerializer.$$$reportNull$$$0(3);
                    }
                    return objectStubSerializer;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serializer";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl$1TypeAndSerializer";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl$1TypeAndSerializer";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "type";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializer";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3 -> new IllegalStateException(string);
                    };
                }
            }
            ArrayList<TypeAndSerializer> stubElementTypes = new ArrayList<TypeAndSerializer>(IElementType.mapNotNull(type -> {
                @NotNull ObjectStubSerializer serializer2 = stubElementRegistryService.getStubSerializer(type);
                if (serializer2 == null) {
                    return null;
                }
                return new TypeAndSerializer((IElementType)type, (ObjectStubSerializer<?, Stub>)serializer2);
            }));
            stubElementTypes.sort(Comparator.comparing(tas -> tas.type.getLanguage().getID()).thenComparing(tas -> tas.type.getDebugName()));
            for (TypeAndSerializer tas2 : stubElementTypes) {
                ObjectStubSerializer<?, Stub> serializer2 = tas2.serializer;
                if ("psi.file".equals(serializer2.getExternalId())) continue;
                this.registerSerializer(serializer2);
            }
            List<StubFieldAccessor> sortedLazySerializers = lazySerializers.stream().sorted(Comparator.comparing(sfa -> sfa.externalId)).toList();
            for (StubFieldAccessor lazySerializer : sortedLazySerializers) {
                this.registerSerializer(lazySerializer.externalId, (Supplier<? extends ObjectStubSerializer<?, ? extends Stub>>)lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    @NotNull
    ObjectStubSerializer<?, ? extends Stub> getSerializer(@NotNull String name) throws SerializerNotFoundException {
        if (name == null) {
            SerializationManagerImpl.$$$reportNull$$$0(16);
        }
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer = this.mySerializerEnumerator.getSerializer(name);
        if (objectStubSerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(17);
        }
        return objectStubSerializer;
    }

    @Nullable
    public String getSerializerName(@NotNull ObjectStubSerializer<?, ? extends Stub> serializer2) {
        if (serializer2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(18);
        }
        return this.mySerializerEnumerator.getSerializerName(serializer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSerializerData() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            IStubElementType.dropRegisteredTypes();
            TemplateLanguageStubBaseVersion.dropVersion();
            StubSerializerEnumerator enumerator = this.mySerializerEnumerator;
            if (enumerator != null) {
                enumerator.dropRegisteredSerializers();
            } else {
                this.nameStorageCrashed();
            }
            this.mySerializersLoaded = false;
        }
    }

    private static void instantiateElementTypesFromFields() {
        FileTypeRegistry.getInstance().getRegisteredFileTypes();
        SerializationManagerImpl.getExtensions(BinaryFileStubBuilders.INSTANCE, builder -> {});
        SerializationManagerImpl.getExtensions(LanguageParserDefinitions.INSTANCE, ParserDefinition::getFileNodeType);
    }

    private static <T> void getExtensions(@NotNull KeyedExtensionCollector<T, ?> collector, @NotNull Consumer<? super T> consumer) {
        ExtensionPointImpl point;
        if (collector == null) {
            SerializationManagerImpl.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(20);
        }
        if ((point = (ExtensionPointImpl)collector.getPoint()) != null) {
            Iterator iterator = point.iterator();
            while (iterator.hasNext()) {
                consumer.accept(((KeyedLazyInstance)iterator.next()).getInstance());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorageFile";
                break;
            }
            case 5: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "corruptionCause";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazySerializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openNameStorage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 12: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "repairNameStorage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerSerializer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSerializer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSerializerName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 17 -> new IllegalStateException(string);
        };
    }
}

