/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializedStubTree {
    final byte[] myTreeBytes;
    final int myTreeByteLength;
    final byte[] myIndexedStubBytes;
    final int myIndexedStubByteLength;
    private final DeserializedIndexedStubs myDeserializedIndexedStubs;
    @NotNull
    private final StubTreeSerializer mySerializationManager;
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    private byte[] myTreeHash;
    public static final Stub NO_STUB = new Stub(){

        public Stub getParentStub() {
            return null;
        }

        @NotNull
        public List<? extends Stub> getChildrenStubs() {
            List list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        public ObjectStubSerializer<?, ?> getStubType() {
            return null;
        }

        public String toString() {
            return "<no stub>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializedStubTree$1", "getChildrenStubs"));
        }
    };

    public SerializedStubTree(byte @NotNull [] treeBytes, int treeByteLength, byte @NotNull [] indexedStubBytes, int indexedStubByteLength, @Nullable Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs, @NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull StubTreeSerializer serializationManager) {
        if (stubIndexesExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(1);
        }
        if (treeBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(2);
        }
        if (indexedStubBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(3);
        }
        this.myTreeBytes = treeBytes;
        this.myTreeByteLength = treeByteLength;
        this.myIndexedStubBytes = indexedStubBytes;
        this.myIndexedStubByteLength = indexedStubByteLength;
        this.myDeserializedIndexedStubs = indexedStubs == null ? new DeserializedIndexedStubs() : new DeserializedIndexedStubs(indexedStubs);
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    @NotNull
    public static SerializedStubTree serializeStub(@NotNull Stub rootStub, @NotNull StubTreeSerializer serializationManager, @NotNull StubForwardIndexExternalizer<?> forwardIndexExternalizer) throws IOException {
        if (rootStub == null) {
            SerializedStubTree.$$$reportNull$$$0(4);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(5);
        }
        if (forwardIndexExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(6);
        }
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        serializationManager.serialize(rootStub, (OutputStream)bytes);
        byte[] treeBytes = bytes.getInternalBuffer();
        int treeByteLength = bytes.size();
        ObjectStubBase root = (ObjectStubBase)rootStub;
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs = SerializedStubTree.indexTree((Stub)root);
        BufferExposingByteArrayOutputStream indexBytes = new BufferExposingByteArrayOutputStream();
        forwardIndexExternalizer.save((DataOutput)new DataOutputStream((OutputStream)indexBytes), indexedStubs);
        byte[] indexedStubBytes = indexBytes.getInternalBuffer();
        int indexedStubByteLength = indexBytes.size();
        return new SerializedStubTree(treeBytes, treeByteLength, indexedStubBytes, indexedStubByteLength, indexedStubs, forwardIndexExternalizer, serializationManager);
    }

    @NotNull
    public SerializedStubTree reSerialize(@NotNull StubTreeSerializer newSerializationManager, @NotNull StubForwardIndexExternalizer<?> newForwardIndexSerializer) throws IOException {
        int reSerializedIndexByteLength;
        byte[] reSerializedIndexBytes;
        if (newSerializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(7);
        }
        if (newForwardIndexSerializer == null) {
            SerializedStubTree.$$$reportNull$$$0(8);
        }
        BufferExposingByteArrayOutputStream outStub = new BufferExposingByteArrayOutputStream();
        ((SerializationManagerEx)this.mySerializationManager).reSerialize(new ByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength), (OutputStream)outStub, newSerializationManager);
        if (this.myStubIndexesExternalizer == newForwardIndexSerializer) {
            reSerializedIndexBytes = this.myIndexedStubBytes;
            reSerializedIndexByteLength = this.myIndexedStubByteLength;
        } else {
            BufferExposingByteArrayOutputStream reSerializedStubIndices = new BufferExposingByteArrayOutputStream();
            newForwardIndexSerializer.save((DataOutput)new DataOutputStream((OutputStream)reSerializedStubIndices), this.getStubIndicesValueMap());
            reSerializedIndexBytes = reSerializedStubIndices.getInternalBuffer();
            reSerializedIndexByteLength = reSerializedStubIndices.size();
        }
        return new SerializedStubTree(outStub.getInternalBuffer(), outStub.size(), reSerializedIndexBytes, reSerializedIndexByteLength, this.myDeserializedIndexedStubs.myMap, newForwardIndexSerializer, newSerializationManager);
    }

    void restoreIndexedStubs() throws IOException {
        if (this.myDeserializedIndexedStubs.myState != DeserializedIndexedStubs.RestoreState.RESTORED) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength));
            Object restoredMap = this.myStubIndexesExternalizer.read(in);
            this.myDeserializedIndexedStubs.setRestoredMap((Map<StubIndexKey<?, ?>, Map<Object, StubIdList>>)restoredMap);
        }
    }

    <K> StubIdList restoreIndexedStubs(@NotNull StubIndexKey<K, ?> indexKey, @NotNull K key) throws IOException {
        Map<Object, StubIdList> incompleteMap;
        if (indexKey == null) {
            SerializedStubTree.$$$reportNull$$$0(9);
        }
        if (key == null) {
            SerializedStubTree.$$$reportNull$$$0(10);
        }
        if ((incompleteMap = this.myDeserializedIndexedStubs.getIfRestored(indexKey)) == null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength));
            Map<Object, Map<Object, StubIdList>> readData = this.myStubIndexesExternalizer.doRead(dataInputStream, indexKey, null);
            if (readData == null) {
                readData = Collections.emptyMap();
            }
            if ((incompleteMap = readData.get(indexKey)) == null) {
                incompleteMap = Collections.emptyMap();
            }
            this.myDeserializedIndexedStubs.setPartialMap(incompleteMap, indexKey);
        }
        return incompleteMap.get(key);
    }

    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndicesValueMap() {
        try {
            this.restoreIndexedStubs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map = this.myDeserializedIndexedStubs.myMap;
        if (map == null) {
            SerializedStubTree.$$$reportNull$$$0(11);
        }
        return map;
    }

    @NotNull
    public Stub getStub() throws SerializerNotFoundException {
        if (this.myTreeByteLength == 0) {
            Stub stub = NO_STUB;
            if (stub == null) {
                SerializedStubTree.$$$reportNull$$$0(12);
            }
            return stub;
        }
        Stub stub = this.mySerializationManager.deserialize((InputStream)new UnsyncByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength));
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(13);
        }
        return stub;
    }

    @NotNull
    public SerializedStubTree withoutStub() {
        try {
            this.restoreIndexedStubs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new SerializedStubTree(ArrayUtil.EMPTY_BYTE_ARRAY, 0, this.myIndexedStubBytes, this.myIndexedStubByteLength, this.myDeserializedIndexedStubs.myMap, this.myStubIndexesExternalizer, this.mySerializationManager);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myTreeByteLength;
        if (length != thatTree.myTreeByteLength) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.myTreeBytes[i] == thatTree.myTreeBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.myTreeByteLength; ++i) {
            result = 31 * result + this.myTreeBytes[i];
        }
        return result;
    }

    @NotNull
    static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexTree(@NotNull Stub root) {
        if (root == null) {
            SerializedStubTree.$$$reportNull$$$0(14);
        }
        StubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree((ObjectStubBase)root, false);
        Map map = objectStubTree.indexStubTree(k -> StubIndexKeyDescriptorCache.INSTANCE.getKeyHashingStrategy(k));
        for (StubIndexKey key : map.keySet()) {
            Map value = (Map)map.get(key);
            for (Object k2 : value.keySet()) {
                int[] ints = (int[])value.get(k2);
                StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                value.put(k2, stubList);
            }
        }
        Map map2 = map;
        if (map2 == null) {
            SerializedStubTree.$$$reportNull$$$0(15);
        }
        return map2;
    }

    public synchronized byte @NotNull [] getTreeHash() {
        if (this.myTreeHash == null) {
            MessageDigest digest = DigestUtil.sha256();
            digest.update(String.valueOf(this.myTreeByteLength).getBytes(StandardCharsets.UTF_8));
            digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
            digest.update(this.myTreeBytes, 0, this.myTreeByteLength);
            this.myTreeHash = digest.digest();
        }
        if (this.myTreeHash == null) {
            SerializedStubTree.$$$reportNull$$$0(16);
        }
        return this.myTreeHash;
    }

    public String toString() {
        return "Stub[" + String.valueOf(this.myDeserializedIndexedStubs) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBytes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedStubBytes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexExternalizer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newForwardIndexSerializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndicesValueMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "indexTree";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreIndexedStubs";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "indexTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static class DeserializedIndexedStubs {
        @NotNull
        private volatile RestoreState myState;
        @Nullable(value="nullable when myState == NOT_RESTORED")
        private volatile @Nullable(value="nullable when myState == NOT_RESTORED") Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> myMap;

        DeserializedIndexedStubs(@NotNull Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map) {
            if (map == null) {
                DeserializedIndexedStubs.$$$reportNull$$$0(0);
            }
            this.myState = RestoreState.RESTORED;
            this.myMap = Collections.unmodifiableMap(map);
        }

        DeserializedIndexedStubs() {
            this.myState = RestoreState.NOT_RESTORED;
        }

        synchronized Map<Object, StubIdList> getIfRestored(StubIndexKey<?, ?> indexKey) {
            Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map = this.myMap;
            return map != null ? map.get(indexKey) : null;
        }

        synchronized void setRestoredMap(Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> restoredMap) {
            if (this.myState == RestoreState.NOT_RESTORED || this.myState == RestoreState.INCOMPLETE) {
                this.myState = RestoreState.RESTORED;
                this.myMap = Collections.unmodifiableMap(restoredMap);
            }
        }

        synchronized void setPartialMap(Map<Object, StubIdList> partialMap, StubIndexKey<?, ?> stubIndexKey) {
            if (this.myState == RestoreState.RESTORED) {
                return;
            }
            if (this.myState == RestoreState.NOT_RESTORED) {
                this.myState = RestoreState.INCOMPLETE;
                this.myMap = new HashMap(1);
            }
            Objects.requireNonNull(this.myMap).put(stubIndexKey, partialMap);
        }

        public String toString() {
            return "map=" + String.valueOf(this.myMap) + ",state=" + String.valueOf((Object)this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/stubs/SerializedStubTree$DeserializedIndexedStubs", "<init>"));
        }

        private static enum RestoreState {
            NOT_RESTORED,
            INCOMPLETE,
            RESTORED;

        }
    }
}

