/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StubCumulativeInputDiffBuilder
extends DirectInputDataDiffBuilder<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(SerializedStubTree.class);
    @Nullable
    private final SerializedStubTree myCurrentTree;

    StubCumulativeInputDiffBuilder(int inputId, @Nullable SerializedStubTree currentTree) {
        super(inputId);
        this.myCurrentTree = currentTree;
    }

    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull UpdatedEntryProcessor<? super Integer, ? super SerializedStubTree> changesProcessor) throws StorageException {
        if (newData == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(0);
        }
        if (changesProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(1);
        }
        return this.differentiate(newData, changesProcessor, false);
    }

    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull UpdatedEntryProcessor<? super Integer, ? super SerializedStubTree> changesProcessor, boolean dryRun) throws StorageException {
        if (newData == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(2);
        }
        if (changesProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(3);
        }
        if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
            LOG.info((dryRun ? "[dry run]" : "") + "differentiate: inputId=" + this.myInputId + ",newData.isEmpty=" + newData.isEmpty() + ", myCurrentTree is " + (this.myCurrentTree == null ? "null" : "not null"));
        }
        if (!newData.isEmpty()) {
            SerializedStubTree newSerializedStubTree = newData.values().iterator().next();
            if (this.myCurrentTree != null) {
                if (StubCumulativeInputDiffBuilder.treesAreEqual(newSerializedStubTree, this.myCurrentTree)) {
                    if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                        LOG.info((dryRun ? "[dry run]" : "") + "equal trees: inputId=" + this.myInputId + ",myTreeLen=" + this.myCurrentTree.myTreeByteLength + ",myStubLen=" + this.myCurrentTree.myIndexedStubByteLength + ",newTreeLen=" + newSerializedStubTree.myTreeByteLength + ",newStubLen=" + newSerializedStubTree.myIndexedStubByteLength);
                    }
                    return false;
                }
                if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                    LOG.info((dryRun ? "[dry run]" : "") + "different trees: inputId=" + this.myInputId + ",myStubLen=" + this.myCurrentTree.myIndexedStubByteLength + ",newStubLen=" + newSerializedStubTree.myIndexedStubByteLength);
                }
                changesProcessor.removed((Object)this.myInputId, this.myInputId);
            }
            changesProcessor.added((Object)this.myInputId, (Object)newSerializedStubTree, this.myInputId);
            if (!dryRun) {
                this.updateStubIndices(newSerializedStubTree);
            }
        } else {
            if (this.myCurrentTree == null) {
                if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                    LOG.info((dryRun ? "[dry run]" : "") + "myCurrentTree=null, inputId=" + this.myInputId);
                }
                return false;
            }
            changesProcessor.removed((Object)this.myInputId, this.myInputId);
            if (!dryRun) {
                this.updateStubIndices(null);
            }
        }
        return true;
    }

    @Nullable
    @ApiStatus.Internal
    public SerializedStubTree getSerializedStubTree() {
        return this.myCurrentTree;
    }

    @NotNull
    public Collection<Integer> getKeys() {
        Set<Integer> set = this.myCurrentTree != null ? Collections.singleton(this.myInputId) : Collections.emptySet();
        if (set == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean treesAreEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(5);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(6);
        }
        return Arrays.equals(currentTree.getTreeHash(), newSerializedStubTree.getTreeHash()) && StubCumulativeInputDiffBuilder.treesAreReallyEqual(newSerializedStubTree, currentTree);
    }

    private static boolean treesAreReallyEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(7);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(8);
        }
        if (newSerializedStubTree.equals(currentTree)) {
            return true;
        }
        if (IndexDebugProperties.DEBUG) {
            StubCumulativeInputDiffBuilder.reportStubTreeHashCollision(newSerializedStubTree, currentTree);
        }
        return false;
    }

    private void updateStubIndices(@Nullable SerializedStubTree newTree) {
        try {
            Map oldForwardIndex = this.myCurrentTree == null ? Collections.emptyMap() : this.myCurrentTree.getStubIndicesValueMap();
            Map<Object, Object> newForwardIndex = newTree == null ? Collections.emptyMap() : newTree.getStubIndicesValueMap();
            Set affectedIndexes = ContainerUtil.union(oldForwardIndex.keySet(), newForwardIndex.keySet());
            StubIndexEx stubIndex = (StubIndexEx)StubIndex.getInstance();
            if (FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES) {
                stubIndex.getLogger().info("stub indexes " + (newTree == null ? "deletion" : "update") + ": file = " + this.myInputId + " indexes " + String.valueOf(affectedIndexes));
            }
            for (StubIndexKey key : affectedIndexes) {
                Set oldKeys = oldForwardIndex.getOrDefault(key, Collections.emptyMap()).keySet();
                Set newKeys = newForwardIndex.getOrDefault(key, Collections.emptyMap()).keySet();
                stubIndex.updateIndex(key, this.myInputId, oldKeys, newKeys);
            }
        }
        catch (ProcessCanceledException e) {
            LOG.error("ProcessCanceledException is not expected here", (Throwable)e);
            throw e;
        }
    }

    private static void reportStubTreeHashCollision(@NotNull SerializedStubTree newTree, @NotNull SerializedStubTree existingTree) {
        if (newTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(9);
        }
        if (existingTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(10);
        }
        String oldTreeDump = "\nexisting tree " + StubCumulativeInputDiffBuilder.dumpStub(existingTree);
        String newTreeDump = "\nnew tree " + StubCumulativeInputDiffBuilder.dumpStub(newTree);
        byte[] hash = newTree.getTreeHash();
        LOG.info("Stub tree hashing collision. Different trees have the same hash = " + StringUtil.toHexString((byte[])hash) + ". " + oldTreeDump + newTreeDump, (Throwable)new Exception());
    }

    @NotNull
    private static String dumpStub(@NotNull SerializedStubTree tree) {
        String deserialized;
        if (tree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(11);
        }
        try {
            deserialized = "stub: " + DebugUtil.stubTreeToString((Stub)tree.getStub());
        }
        catch (SerializerNotFoundException e) {
            LOG.error((Throwable)e);
            deserialized = "error while stub deserialization: " + e.getMessage();
        }
        String string = deserialized + "\n bytes: " + StringUtil.toHexString((byte[])tree.myTreeBytes);
        if (string == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesProcessor";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializedStubTree";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingTree";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "treesAreEqual";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "treesAreReallyEqual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportStubTreeHashCollision";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dumpStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12 -> new IllegalStateException(string);
        };
    }
}

