/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.diagnostic.IndexIdRuleValidator;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class IndexLookupTimingsReporting {
    private static final Logger LOG = Logger.getInstance(IndexLookupTimingsReporting.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.SECONDS.toMillis(10L));
    private static final IJTracer OTEL_TRACER = TelemetryManager.getInstance().getTracer(PlatformScopesKt.Indexes);
    private static final boolean REPORT_INDIVIDUAL_LOOKUPS_TO_FUS = SystemProperties.getBooleanProperty((String)"IndexLookupTimingsReporting.REPORT_INDIVIDUAL_LOOKUPS_TO_FUS", (boolean)false);
    public static final boolean REPORT_INDIVIDUAL_LOOKUPS_TO_OPEN_TELEMETRY = SystemProperties.getBooleanProperty((String)"IndexLookupTimingsReporting.REPORT_INDIVIDUAL_LOOKUPS_TO_OPEN_TELEMETRY", (boolean)false);
    private static final String SPAN_NAME_INDEX_LOOKUP_ALL_KEYS = "index lookup: all keys";
    private static final String SPAN_NAME_INDEX_LOOKUP_ENTRIES = "index lookup: file entries";
    private static final String SPAN_NAME_INDEX_LOOKUP_STUBS = "index lookup: stub entries";
    private static final String SPAN_NAME_INDEX_UP_TO_DATE_CHECK = "index up-to-date check";
    private static final String SPAN_NAME_STUB_TREE_DESERIALIZATION = "stub tree deserialization";
    private static final boolean COLLECT_AGGREGATED_STATS = SystemProperties.getBooleanProperty((String)"IndexLookupTimingsReporting.COLLECT_AGGREGATED_STATS", (boolean)true);
    private static final boolean REPORT_AGGREGATED_STATS_TO_FUS = SystemProperties.getBooleanProperty((String)"IndexLookupTimingsReporting.REPORT_AGGREGATED_STATS_TO_FUS", (boolean)true);
    private static final int REPORT_TO_FUS_INDIVIDUAL_LOOKUPS_ONLY_LONGER_THAN_MS = SystemProperties.getIntProperty((String)"IndexLookupTimingsReporting.REPORT_TO_FUS_INDIVIDUAL_LOOKUPS_ONLY_LONGER_THAN_MS", (int)100);
    private static final boolean REPORT_AGGREGATED_STATS_TO_OPEN_TELEMETRY = SystemProperties.getBooleanProperty((String)"IndexLookupTimingsReporting.REPORT_AGGREGATED_STATS_TO_OPEN_TELEMETRY", (boolean)true);
    @VisibleForTesting
    public static final int MAX_LOOKUP_DEPTH = Integer.getInteger("IndexLookup.MAX_LOOKUP_DEPTH", 16);
    @VisibleForTesting
    public static final boolean THROW_ON_INCORRECT_USAGE = SystemProperties.getBooleanProperty((String)"IndexLookup.THROW_ON_INCORRECT_USAGE", (boolean)false);
    private static final EventLogGroup INDEX_USAGE_GROUP = new EventLogGroup("index.usage", 3);
    private static final EventLogGroup INDEX_USAGE_AGGREGATES_GROUP = new EventLogGroup("index.usage.aggregates", 3);
    private static final StringEventField FIELD_INDEX_ID = EventFields.StringValidatedByCustomRule((String)"index_id", IndexIdRuleValidator.class);
    private static final BooleanEventField FIELD_LOOKUP_FAILED = EventFields.Boolean((String)"lookup_failed");
    private static final BooleanEventField FIELD_LOOKUP_CANCELLED = EventFields.Boolean((String)"lookup_cancelled");
    private static final LongEventField FIELD_LOOKUP_DURATION_MS = EventFields.Long((String)"lookup_duration_ms");
    private static final LongEventField FIELD_UP_TO_DATE_CHECK_DURATION_MS = EventFields.Long((String)"up_to_date_check_ms");
    private static final LongEventField FIELD_STUB_TREE_DESERIALIZING_DURATION_MS = EventFields.Long((String)"psi_tree_deserializing_ms");
    private static final IntEventField FIELD_LOOKUP_KEYS_COUNT = EventFields.Int((String)"keys");
    private static final EnumEventField<LookupOperation> FIELD_LOOKUP_KEYS_OP = EventFields.Enum((String)"lookup_op", LookupOperation.class, kind -> kind.name().toLowerCase(Locale.US));
    private static final IntEventField FIELD_TOTAL_KEYS_INDEXED_COUNT = EventFields.Int((String)"total_keys_indexed");

    static enum LookupOperation {
        AND,
        OR,
        UNKNOWN;

    }

    private static final class IndexOperationToOTelMetricsReporter
    implements AutoCloseable {
        private static final Recorder allKeysLookupDurationMsHisto = new Recorder((long)IndexOperationAggregatesCollector.MAX_TRACKABLE_DURATION_MS, 2);
        private static final Recorder entriesLookupDurationsMsHisto = new Recorder((long)IndexOperationAggregatesCollector.MAX_TRACKABLE_DURATION_MS, 2);
        private static final Recorder stubEntriesLookupDurationsMsHisto = new Recorder((long)IndexOperationAggregatesCollector.MAX_TRACKABLE_DURATION_MS, 2);
        private final ObservableLongMeasurement allKeysTotalLookups;
        private final ObservableDoubleMeasurement allKeysLookupDurationAvg;
        private final ObservableDoubleMeasurement allKeysLookupDuration90P;
        private final ObservableDoubleMeasurement allKeysLookupDurationMax;
        private final ObservableLongMeasurement entriesTotalLookups;
        private final ObservableDoubleMeasurement entriesLookupDurationAvg;
        private final ObservableDoubleMeasurement entriesLookupDuration90P;
        private final ObservableDoubleMeasurement entriesLookupDurationMax;
        private final ObservableLongMeasurement stubsTotalLookups;
        private final ObservableDoubleMeasurement stubsLookupDurationAvg;
        private final ObservableDoubleMeasurement stubsLookupDuration90P;
        private final ObservableDoubleMeasurement stubsLookupDurationMax;
        private final BatchCallback batchCallbackHandle;
        private transient Histogram allKeysIntervalHisto;
        private long allKeysLookups = 0L;
        private transient Histogram entriesIntervalHisto;
        private long entriesLookups = 0L;
        private transient Histogram stubsIntervalHisto;
        private long stubsLookups = 0L;

        private IndexOperationToOTelMetricsReporter() {
            Meter meter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.Indexes);
            this.allKeysTotalLookups = meter.counterBuilder("Indexes.allKeys.lookups").buildObserver();
            this.allKeysLookupDurationAvg = meter.gaugeBuilder("Indexes.allKeys.lookupDurationAvgMs").buildObserver();
            this.allKeysLookupDuration90P = meter.gaugeBuilder("Indexes.allKeys.lookupDuration90PMs").buildObserver();
            this.allKeysLookupDurationMax = meter.gaugeBuilder("Indexes.allKeys.lookupDurationMaxMs").buildObserver();
            this.entriesTotalLookups = meter.counterBuilder("Indexes.entries.lookups").buildObserver();
            this.entriesLookupDurationAvg = meter.gaugeBuilder("Indexes.entries.lookupDurationAvgMs").buildObserver();
            this.entriesLookupDuration90P = meter.gaugeBuilder("Indexes.entries.lookupDuration90PMs").buildObserver();
            this.entriesLookupDurationMax = meter.gaugeBuilder("Indexes.entries.lookupDurationMaxMs").buildObserver();
            this.stubsTotalLookups = meter.counterBuilder("Indexes.stubs.lookups").buildObserver();
            this.stubsLookupDurationAvg = meter.gaugeBuilder("Indexes.stubs.lookupDurationAvgMs").buildObserver();
            this.stubsLookupDuration90P = meter.gaugeBuilder("Indexes.stubs.lookupDuration90PMs").buildObserver();
            this.stubsLookupDurationMax = meter.gaugeBuilder("Indexes.stubs.lookupDurationMaxMs").buildObserver();
            this.batchCallbackHandle = meter.batchCallback(this::drainValuesToOTel, (ObservableMeasurement)this.allKeysTotalLookups, new ObservableMeasurement[]{this.allKeysLookupDurationAvg, this.allKeysLookupDuration90P, this.allKeysLookupDurationMax, this.entriesTotalLookups, this.entriesLookupDurationAvg, this.entriesLookupDuration90P, this.entriesLookupDurationMax, this.stubsTotalLookups, this.stubsLookupDurationAvg, this.stubsLookupDuration90P, this.stubsLookupDurationMax});
        }

        private void drainValuesToOTel() {
            this.allKeysIntervalHisto = allKeysLookupDurationMsHisto.getIntervalHistogram(this.allKeysIntervalHisto);
            this.allKeysTotalLookups.record(this.allKeysLookups);
            this.allKeysLookupDurationAvg.record(this.allKeysIntervalHisto.getMean());
            this.allKeysLookupDuration90P.record((double)this.allKeysIntervalHisto.getValueAtPercentile(90.0));
            this.allKeysLookupDurationMax.record((double)this.allKeysIntervalHisto.getMaxValue());
            this.entriesIntervalHisto = entriesLookupDurationsMsHisto.getIntervalHistogram(this.entriesIntervalHisto);
            this.entriesTotalLookups.record(this.entriesLookups);
            this.entriesLookupDurationAvg.record(this.entriesIntervalHisto.getMean());
            this.entriesLookupDuration90P.record((double)this.entriesIntervalHisto.getValueAtPercentile(90.0));
            this.entriesLookupDurationMax.record((double)this.entriesIntervalHisto.getMaxValue());
            this.stubsIntervalHisto = stubEntriesLookupDurationsMsHisto.getIntervalHistogram(this.stubsIntervalHisto);
            this.stubsTotalLookups.record(this.stubsLookups);
            this.stubsLookupDurationAvg.record(this.stubsIntervalHisto.getMean());
            this.stubsLookupDuration90P.record((double)this.stubsIntervalHisto.getValueAtPercentile(90.0));
            this.stubsLookupDurationMax.record((double)this.stubsIntervalHisto.getMaxValue());
        }

        public void reportAllKeysLookup(long clampedDurationMs) {
            allKeysLookupDurationMsHisto.recordValue(clampedDurationMs);
            ++this.allKeysLookups;
        }

        public void reportEntryLookup(long clampedDurationMs) {
            entriesLookupDurationsMsHisto.recordValue(clampedDurationMs);
            ++this.entriesLookups;
        }

        public void recordStubEntryLookup(long clampedDurationMs) {
            stubEntriesLookupDurationsMsHisto.recordValue(clampedDurationMs);
            ++this.stubsLookups;
        }

        @Override
        public void close() {
            this.batchCallbackHandle.close();
        }
    }

    public static final class IndexOperationAggregatesCollector
    extends ApplicationUsagesCollector {
        public static final int MAX_TRACKABLE_DURATION_MS = SystemProperties.getIntProperty((String)"IndexLookupTimingsReporting.MAX_TRACKABLE_DURATION_MS", (int)5000);
        private static final IntEventField FIELD_LOOKUPS_TOTAL = EventFields.Int((String)"lookups_total");
        private static final IntEventField FIELD_LOOKUPS_FAILED = EventFields.Int((String)"lookups_failed");
        private static final IntEventField FIELD_LOOKUPS_CANCELLED = EventFields.Int((String)"lookups_cancelled");
        private static final DoubleEventField FIELD_LOOKUP_DURATION_MEAN = EventFields.Double((String)"lookup_duration_mean_ms");
        private static final IntEventField FIELD_LOOKUP_DURATION_90P = EventFields.Int((String)"lookup_duration_90ile_ms");
        private static final IntEventField FIELD_LOOKUP_DURATION_95P = EventFields.Int((String)"lookup_duration_95ile_ms");
        private static final IntEventField FIELD_LOOKUP_DURATION_99P = EventFields.Int((String)"lookup_duration_99ile_ms");
        private static final IntEventField FIELD_LOOKUP_DURATION_MAX = EventFields.Int((String)"lookup_duration_max_ms");
        private static final VarargEventId EVENT_INDEX_ALL_KEYS_LOOKUP = INDEX_USAGE_AGGREGATES_GROUP.registerVarargEvent("lookup.all_keys", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUPS_TOTAL, FIELD_LOOKUPS_FAILED, FIELD_LOOKUPS_CANCELLED, FIELD_LOOKUP_DURATION_MEAN, FIELD_LOOKUP_DURATION_90P, FIELD_LOOKUP_DURATION_95P, FIELD_LOOKUP_DURATION_99P, FIELD_LOOKUP_DURATION_MAX});
        private static final VarargEventId EVENT_INDEX_ENTRIES_LOOKUP = INDEX_USAGE_AGGREGATES_GROUP.registerVarargEvent("lookup.entries", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUPS_TOTAL, FIELD_LOOKUPS_FAILED, FIELD_LOOKUPS_CANCELLED, FIELD_LOOKUP_DURATION_MEAN, FIELD_LOOKUP_DURATION_90P, FIELD_LOOKUP_DURATION_95P, FIELD_LOOKUP_DURATION_99P, FIELD_LOOKUP_DURATION_MAX});
        private static final VarargEventId EVENT_STUB_INDEX_ENTRIES_LOOKUP = INDEX_USAGE_AGGREGATES_GROUP.registerVarargEvent("lookup.stub_entries", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUPS_TOTAL, FIELD_LOOKUPS_FAILED, FIELD_LOOKUPS_CANCELLED, FIELD_LOOKUP_DURATION_MEAN, FIELD_LOOKUP_DURATION_90P, FIELD_LOOKUP_DURATION_95P, FIELD_LOOKUP_DURATION_99P, FIELD_LOOKUP_DURATION_MAX});
        private static final ConcurrentHashMap<IndexId<?, ?>, Recorder> allKeysLookupDurationsMsByIndexId = new ConcurrentHashMap();
        private static final ConcurrentHashMap<IndexId<?, ?>, Recorder> entriesLookupDurationsMsByIndexId = new ConcurrentHashMap();
        private static final ConcurrentHashMap<IndexId<?, ?>, Recorder> stubEntriesLookupDurationsMsByIndexId = new ConcurrentHashMap();
        @Nullable
        private static final IndexOperationToOTelMetricsReporter otelReporter = REPORT_AGGREGATED_STATS_TO_OPEN_TELEMETRY ? new IndexOperationToOTelMetricsReporter() : null;

        public IndexOperationAggregatesCollector() {
            if (!this.isValid()) {
                throw new AssertionError((Object)(String.valueOf(this.getGroup()) + " is not valid groupId"));
            }
        }

        public EventLogGroup getGroup() {
            return INDEX_USAGE_AGGREGATES_GROUP;
        }

        public static void recordAllKeysLookup(IndexId<?, ?> indexId, boolean failed, long durationMs) {
            if (!failed) {
                Recorder recorder = allKeysLookupDurationsMsByIndexId.computeIfAbsent(indexId, __ -> new Recorder((long)MAX_TRACKABLE_DURATION_MS, 2));
                long clampedDurationMs = MathUtil.clamp((long)durationMs, (long)0L, (long)MAX_TRACKABLE_DURATION_MS);
                recorder.recordValue(clampedDurationMs);
                if (otelReporter != null) {
                    otelReporter.reportAllKeysLookup(clampedDurationMs);
                }
            }
        }

        public static void recordEntriesByKeysLookup(IndexId<?, ?> indexId, boolean failed, long durationMs) {
            if (!failed) {
                Recorder recorder = entriesLookupDurationsMsByIndexId.computeIfAbsent(indexId, __ -> new Recorder((long)MAX_TRACKABLE_DURATION_MS, 2));
                long clampedDurationMs = MathUtil.clamp((long)durationMs, (long)0L, (long)MAX_TRACKABLE_DURATION_MS);
                recorder.recordValue(clampedDurationMs);
                if (otelReporter != null) {
                    otelReporter.reportEntryLookup(clampedDurationMs);
                }
            }
        }

        public static void recordStubEntriesByKeysLookup(IndexId<?, ?> indexId, boolean failed, long durationMs) {
            if (!failed) {
                Recorder recorder = stubEntriesLookupDurationsMsByIndexId.computeIfAbsent(indexId, __ -> new Recorder((long)MAX_TRACKABLE_DURATION_MS, 2));
                long clampedDurationMs = MathUtil.clamp((long)durationMs, (long)0L, (long)MAX_TRACKABLE_DURATION_MS);
                recorder.recordValue(clampedDurationMs);
                if (otelReporter != null) {
                    otelReporter.recordStubEntryLookup(clampedDurationMs);
                }
            }
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            if (REPORT_AGGREGATED_STATS_TO_FUS) {
                Set allKeysLookupStats = allKeysLookupDurationsMsByIndexId.entrySet().stream().map(e -> {
                    IndexId indexId = (IndexId)e.getKey();
                    Recorder recorderForIndex = (Recorder)e.getValue();
                    Histogram recordedValuesHistogram = recorderForIndex.getIntervalHistogram();
                    return EVENT_INDEX_ALL_KEYS_LOOKUP.metric(new EventPair[]{FIELD_INDEX_ID.with((Object)indexId.getName()), FIELD_LOOKUPS_TOTAL.with((Object)((int)recordedValuesHistogram.getTotalCount())), FIELD_LOOKUP_DURATION_MEAN.with((Object)recordedValuesHistogram.getMean()), FIELD_LOOKUP_DURATION_90P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(90.0))), FIELD_LOOKUP_DURATION_95P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(95.0))), FIELD_LOOKUP_DURATION_99P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(99.0))), FIELD_LOOKUP_DURATION_MAX.with((Object)((int)recordedValuesHistogram.getMaxValue()))});
                }).collect(Collectors.toSet());
                Set entriesLookupStats = entriesLookupDurationsMsByIndexId.entrySet().stream().map(e -> {
                    IndexId indexId = (IndexId)e.getKey();
                    Recorder recorderForIndex = (Recorder)e.getValue();
                    Histogram recordedValuesHistogram = recorderForIndex.getIntervalHistogram();
                    return EVENT_INDEX_ENTRIES_LOOKUP.metric(new EventPair[]{FIELD_INDEX_ID.with((Object)indexId.getName()), FIELD_LOOKUPS_TOTAL.with((Object)((int)recordedValuesHistogram.getTotalCount())), FIELD_LOOKUP_DURATION_MEAN.with((Object)recordedValuesHistogram.getMean()), FIELD_LOOKUP_DURATION_90P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(90.0))), FIELD_LOOKUP_DURATION_95P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(95.0))), FIELD_LOOKUP_DURATION_99P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(99.0))), FIELD_LOOKUP_DURATION_MAX.with((Object)((int)recordedValuesHistogram.getMaxValue()))});
                }).collect(Collectors.toSet());
                Set stubEntriesLookupStats = stubEntriesLookupDurationsMsByIndexId.entrySet().stream().map(e -> {
                    IndexId indexId = (IndexId)e.getKey();
                    Recorder recorderForIndex = (Recorder)e.getValue();
                    Histogram recordedValuesHistogram = recorderForIndex.getIntervalHistogram();
                    return EVENT_STUB_INDEX_ENTRIES_LOOKUP.metric(new EventPair[]{FIELD_INDEX_ID.with((Object)indexId.getName()), FIELD_LOOKUPS_TOTAL.with((Object)((int)recordedValuesHistogram.getTotalCount())), FIELD_LOOKUP_DURATION_MEAN.with((Object)recordedValuesHistogram.getMean()), FIELD_LOOKUP_DURATION_90P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(90.0))), FIELD_LOOKUP_DURATION_95P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(95.0))), FIELD_LOOKUP_DURATION_99P.with((Object)((int)recordedValuesHistogram.getValueAtPercentile(99.0))), FIELD_LOOKUP_DURATION_MAX.with((Object)((int)recordedValuesHistogram.getMaxValue()))});
                }).collect(Collectors.toSet());
                HashSet<MetricEvent> all = new HashSet<MetricEvent>();
                all.addAll(allKeysLookupStats);
                all.addAll(entriesLookupStats);
                all.addAll(stubEntriesLookupStats);
                HashSet<MetricEvent> hashSet = all;
                if (hashSet == null) {
                    IndexOperationAggregatesCollector.$$$reportNull$$$0(0);
                }
                return hashSet;
            }
            Set<MetricEvent> set = Set.of(EVENT_INDEX_ALL_KEYS_LOOKUP.metric(new EventPair[]{FIELD_INDEX_ID.with((Object)"")}));
            if (set == null) {
                IndexOperationAggregatesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationAggregatesCollector", "getMetrics"));
        }
    }

    public static final class IndexOperationFusCollector
    extends CounterUsagesCollector {
        private static final VarargEventId EVENT_INDEX_ALL_KEYS_LOOKUP = INDEX_USAGE_GROUP.registerVarargEvent("lookup.all_keys", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUP_FAILED, FIELD_LOOKUP_CANCELLED, FIELD_LOOKUP_DURATION_MS, FIELD_UP_TO_DATE_CHECK_DURATION_MS, FIELD_TOTAL_KEYS_INDEXED_COUNT});
        private static final IntEventField FIELD_LOOKUP_RESULT_ENTRIES_COUNT = EventFields.Int((String)"entries_found");
        private static final VarargEventId EVENT_STUB_INDEX_LOOKUP_ENTRIES_BY_KEY = INDEX_USAGE_GROUP.registerVarargEvent("lookup.stub_entries", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUP_FAILED, FIELD_LOOKUP_CANCELLED, FIELD_LOOKUP_DURATION_MS, FIELD_UP_TO_DATE_CHECK_DURATION_MS, FIELD_STUB_TREE_DESERIALIZING_DURATION_MS, FIELD_TOTAL_KEYS_INDEXED_COUNT, FIELD_LOOKUP_RESULT_ENTRIES_COUNT});
        private static final VarargEventId EVENT_INDEX_LOOKUP_ENTRIES_BY_KEYS = INDEX_USAGE_GROUP.registerVarargEvent("lookup.entries", new EventField[]{FIELD_INDEX_ID, FIELD_LOOKUP_FAILED, FIELD_LOOKUP_CANCELLED, FIELD_LOOKUP_DURATION_MS, FIELD_UP_TO_DATE_CHECK_DURATION_MS, FIELD_LOOKUP_KEYS_COUNT, FIELD_LOOKUP_KEYS_OP, FIELD_TOTAL_KEYS_INDEXED_COUNT, FIELD_LOOKUP_RESULT_ENTRIES_COUNT});
        public static final ThreadLocal<LookupAllKeysTrace> TRACE_OF_ALL_KEYS_LOOKUP = new ThreadLocal<LookupAllKeysTrace>(){

            @Override
            protected LookupAllKeysTrace initialValue() {
                return new LookupAllKeysTrace(this);
            }
        };
        public static final ThreadLocal<LookupEntriesByKeysTrace> TRACE_OF_ENTRIES_LOOKUP = new ThreadLocal<LookupEntriesByKeysTrace>(){

            @Override
            protected LookupEntriesByKeysTrace initialValue() {
                return new LookupEntriesByKeysTrace(this);
            }
        };
        public static final ThreadLocal<LookupStubEntriesByKeyTrace> TRACE_OF_STUB_ENTRIES_LOOKUP = new ThreadLocal<LookupStubEntriesByKeyTrace>(){

            @Override
            protected LookupStubEntriesByKeyTrace initialValue() {
                return new LookupStubEntriesByKeyTrace(this);
            }
        };

        public EventLogGroup getGroup() {
            return INDEX_USAGE_GROUP;
        }

        public static LookupAllKeysTrace lookupAllKeysStarted(IndexId<?, ?> indexId) {
            return TRACE_OF_ALL_KEYS_LOOKUP.get().lookupStarted((IndexId)indexId);
        }

        public static LookupEntriesByKeysTrace lookupEntriesStarted(IndexId<?, ?> indexId) {
            return TRACE_OF_ENTRIES_LOOKUP.get().lookupStarted((IndexId)indexId);
        }

        public static LookupStubEntriesByKeyTrace lookupStubEntriesStarted(IndexId<?, ?> indexId) {
            return TRACE_OF_STUB_ENTRIES_LOOKUP.get().lookupStarted((IndexId)indexId);
        }

        public static final class LookupAllKeysTrace
        extends LookupTraceBase<LookupAllKeysTrace> {
            private long indexValidationFinishedAtMs;

            private LookupAllKeysTrace(ThreadLocal<LookupAllKeysTrace> current) {
                super(current);
            }

            @Override
            public LookupAllKeysTrace lookupStarted(@NotNull IndexId<?, ?> indexId) {
                if (indexId == null) {
                    LookupAllKeysTrace.$$$reportNull$$$0(0);
                }
                LookupAllKeysTrace trace = (LookupAllKeysTrace)super.lookupStarted(indexId);
                this.indexValidationFinishedAtMs = -1L;
                return trace;
            }

            public LookupAllKeysTrace indexValidationFinished() {
                if (this.traceWasStarted()) {
                    this.indexValidationFinishedAtMs = System.currentTimeMillis();
                }
                return this;
            }

            @Override
            protected void reportDetailedDataToFUS(long lookupFinishedAtMs) {
                long lookupDurationMs = lookupFinishedAtMs - this.lookupStartedAtMs;
                EVENT_INDEX_ALL_KEYS_LOOKUP.log(new EventPair[]{FIELD_INDEX_ID.with((Object)this.indexId.getName()), FIELD_UP_TO_DATE_CHECK_DURATION_MS.with((Object)(this.indexValidationFinishedAtMs - this.lookupStartedAtMs)), FIELD_LOOKUP_DURATION_MS.with((Object)lookupDurationMs), FIELD_LOOKUP_CANCELLED.with((Object)this.lookupCancelled), FIELD_LOOKUP_FAILED.with((Object)this.lookupFailed), FIELD_TOTAL_KEYS_INDEXED_COUNT.with((Object)this.totalKeysIndexed)});
            }

            @Override
            protected void reportDetailedDataToOTel(long lookupFinishedAtMs) {
                Span lookupSpan = OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_LOOKUP_ALL_KEYS).setAttribute("index_id", this.indexId.getName()).setAttribute("total_keys_in_index", (long)this.totalKeysIndexed).setAttribute("lookup_result_size", (long)this.lookupResultSize).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan();
                lookupSpan.setStatus(this.lookupFailed ? StatusCode.ERROR : StatusCode.OK);
                try (Scope scope = lookupSpan.makeCurrent();){
                    OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_UP_TO_DATE_CHECK).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan().end(this.indexValidationFinishedAtMs, TimeUnit.MILLISECONDS);
                }
                lookupSpan.end(lookupFinishedAtMs, TimeUnit.MILLISECONDS);
            }

            @Override
            protected void collectAggregatedData(long lookupFinishedAtMs) {
                long lookupDurationMs = lookupFinishedAtMs - this.lookupStartedAtMs;
                IndexOperationAggregatesCollector.recordAllKeysLookup(this.indexId, this.lookupFailed, lookupDurationMs);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationFusCollector$LookupAllKeysTrace", "lookupStarted"));
            }
        }

        public static final class LookupEntriesByKeysTrace
        extends LookupTraceBase<LookupEntriesByKeysTrace> {
            private long indexValidationFinishedAtMs;
            private int lookupKeysCount = -1;
            private LookupOperation lookupOperation = LookupOperation.UNKNOWN;

            private LookupEntriesByKeysTrace(ThreadLocal<LookupEntriesByKeysTrace> current) {
                super(current);
            }

            @Override
            public LookupEntriesByKeysTrace lookupStarted(@NotNull IndexId<?, ?> indexId) {
                if (indexId == null) {
                    LookupEntriesByKeysTrace.$$$reportNull$$$0(0);
                }
                LookupEntriesByKeysTrace trace = (LookupEntriesByKeysTrace)super.lookupStarted(indexId);
                this.lookupOperation = LookupOperation.UNKNOWN;
                this.lookupKeysCount = -1;
                this.indexValidationFinishedAtMs = -1L;
                return trace;
            }

            public LookupEntriesByKeysTrace indexValidationFinished() {
                if (this.traceWasStarted()) {
                    this.indexValidationFinishedAtMs = System.currentTimeMillis();
                }
                return this;
            }

            @Override
            protected void reportDetailedDataToFUS(long lookupFinishedAtMs) {
                EVENT_INDEX_LOOKUP_ENTRIES_BY_KEYS.log(new EventPair[]{FIELD_INDEX_ID.with((Object)this.indexId.getName()), FIELD_UP_TO_DATE_CHECK_DURATION_MS.with((Object)(this.indexValidationFinishedAtMs > 0L ? this.indexValidationFinishedAtMs - this.lookupStartedAtMs : 0L)), FIELD_LOOKUP_DURATION_MS.with((Object)(lookupFinishedAtMs - this.lookupStartedAtMs)), FIELD_LOOKUP_CANCELLED.with((Object)this.lookupCancelled), FIELD_LOOKUP_FAILED.with((Object)this.lookupFailed), FIELD_LOOKUP_KEYS_OP.with((Object)this.lookupOperation), FIELD_LOOKUP_KEYS_COUNT.with((Object)this.lookupKeysCount), FIELD_TOTAL_KEYS_INDEXED_COUNT.with((Object)this.totalKeysIndexed), FIELD_LOOKUP_RESULT_ENTRIES_COUNT.with((Object)this.lookupResultSize)});
            }

            @Override
            protected void reportDetailedDataToOTel(long lookupFinishedAtMs) {
                Span lookupSpan = OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_LOOKUP_ENTRIES).setAttribute("index_id", this.indexId.getName()).setAttribute("total_keys_in_index", (long)this.totalKeysIndexed).setAttribute("lookup_result_size", (long)this.lookupResultSize).setAttribute("lookup_keys", (long)this.lookupKeysCount).setAttribute("lookup_op", this.lookupOperation.name()).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan();
                lookupSpan.setStatus(this.lookupFailed ? StatusCode.ERROR : StatusCode.OK);
                try (Scope scope = lookupSpan.makeCurrent();){
                    if (this.indexValidationFinishedAtMs > 0L) {
                        OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_UP_TO_DATE_CHECK).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan().end(this.indexValidationFinishedAtMs, TimeUnit.MILLISECONDS);
                    }
                }
                lookupSpan.end(lookupFinishedAtMs, TimeUnit.MILLISECONDS);
            }

            @Override
            protected void collectAggregatedData(long lookupFinishedAtMs) {
                long lookupDurationMs = lookupFinishedAtMs - this.lookupStartedAtMs;
                IndexOperationAggregatesCollector.recordEntriesByKeysLookup(this.indexId, this.lookupFailed, lookupDurationMs);
            }

            public LookupEntriesByKeysTrace keysWithAND(int keysCount) {
                this.lookupKeysCount = keysCount;
                this.lookupOperation = LookupOperation.AND;
                return this;
            }

            public LookupEntriesByKeysTrace keysWithOR(int keysCount) {
                this.lookupKeysCount = keysCount;
                this.lookupOperation = LookupOperation.OR;
                return this;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationFusCollector$LookupEntriesByKeysTrace", "lookupStarted"));
            }
        }

        public static final class LookupStubEntriesByKeyTrace
        extends LookupTraceBase<LookupStubEntriesByKeyTrace> {
            private long indexValidationFinishedAtMs;
            private long stubTreesDeserializingStarted;

            private LookupStubEntriesByKeyTrace(ThreadLocal<LookupStubEntriesByKeyTrace> current) {
                super(current);
            }

            @Override
            public LookupStubEntriesByKeyTrace lookupStarted(@NotNull IndexId<?, ?> indexId) {
                if (indexId == null) {
                    LookupStubEntriesByKeyTrace.$$$reportNull$$$0(0);
                }
                LookupStubEntriesByKeyTrace trace = (LookupStubEntriesByKeyTrace)super.lookupStarted(indexId);
                this.indexValidationFinishedAtMs = -1L;
                this.stubTreesDeserializingStarted = -1L;
                return trace;
            }

            public LookupStubEntriesByKeyTrace indexValidationFinished() {
                if (this.traceWasStarted()) {
                    this.indexValidationFinishedAtMs = System.currentTimeMillis();
                }
                return this;
            }

            public LookupStubEntriesByKeyTrace stubTreesDeserializingStarted() {
                if (this.traceWasStarted()) {
                    this.stubTreesDeserializingStarted = System.currentTimeMillis();
                }
                return this;
            }

            @Override
            protected void reportDetailedDataToFUS(long lookupFinishedAtMs) {
                EVENT_STUB_INDEX_LOOKUP_ENTRIES_BY_KEY.log(new EventPair[]{FIELD_INDEX_ID.with((Object)this.indexId.getName()), FIELD_UP_TO_DATE_CHECK_DURATION_MS.with((Object)(this.indexValidationFinishedAtMs > 0L ? this.indexValidationFinishedAtMs - this.lookupStartedAtMs : 0L)), FIELD_STUB_TREE_DESERIALIZING_DURATION_MS.with((Object)(this.stubTreesDeserializingStarted > 0L ? lookupFinishedAtMs - this.stubTreesDeserializingStarted : 0L)), FIELD_LOOKUP_DURATION_MS.with((Object)(lookupFinishedAtMs - this.lookupStartedAtMs)), FIELD_LOOKUP_CANCELLED.with((Object)this.lookupCancelled), FIELD_LOOKUP_FAILED.with((Object)this.lookupFailed), FIELD_TOTAL_KEYS_INDEXED_COUNT.with((Object)this.totalKeysIndexed), FIELD_LOOKUP_RESULT_ENTRIES_COUNT.with((Object)this.lookupResultSize)});
            }

            @Override
            protected void reportDetailedDataToOTel(long lookupFinishedAtMs) {
                Span lookupSpan = OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_LOOKUP_STUBS).setAttribute("index_id", this.indexId.getName()).setAttribute("total_keys_in_index", (long)this.totalKeysIndexed).setAttribute("lookup_result_size", (long)this.lookupResultSize).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan();
                lookupSpan.setStatus(this.lookupFailed ? StatusCode.ERROR : StatusCode.OK);
                try (Scope scope = lookupSpan.makeCurrent();){
                    if (this.indexValidationFinishedAtMs > 0L) {
                        OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_INDEX_UP_TO_DATE_CHECK).setStartTimestamp(this.lookupStartedAtMs, TimeUnit.MILLISECONDS).startSpan().end(this.indexValidationFinishedAtMs, TimeUnit.MILLISECONDS);
                    }
                    if (this.stubTreesDeserializingStarted > 0L) {
                        OTEL_TRACER.spanBuilder(IndexLookupTimingsReporting.SPAN_NAME_STUB_TREE_DESERIALIZATION).setStartTimestamp(this.stubTreesDeserializingStarted, TimeUnit.MILLISECONDS).startSpan().end(lookupFinishedAtMs, TimeUnit.MILLISECONDS);
                    }
                }
                lookupSpan.end(lookupFinishedAtMs, TimeUnit.MILLISECONDS);
            }

            @Override
            protected void collectAggregatedData(long lookupFinishedAtMs) {
                long lookupDurationMs = lookupFinishedAtMs - this.lookupStartedAtMs;
                IndexOperationAggregatesCollector.recordStubEntriesByKeysLookup(this.indexId, this.lookupFailed, lookupDurationMs);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationFusCollector$LookupStubEntriesByKeyTrace", "lookupStarted"));
            }
        }

        @VisibleForTesting
        @ApiStatus.Internal
        public static abstract class LookupTraceBase<T extends LookupTraceBase<T>>
        implements AutoCloseable,
        Cloneable {
            protected T parentTrace = null;
            protected int depth = -1;
            protected final ThreadLocal<T> currentTraceHolder;
            @Nullable
            protected IndexId<?, ?> indexId;
            protected long lookupStartedAtMs;
            protected boolean lookupFailed;
            protected boolean lookupCancelled;
            protected int totalKeysIndexed;
            protected int lookupResultSize;

            protected LookupTraceBase(ThreadLocal<T> current) {
                this.currentTraceHolder = current;
            }

            protected T lookupStarted(@NotNull IndexId<?, ?> indexId) {
                if (indexId == null) {
                    LookupTraceBase.$$$reportNull$$$0(0);
                }
                if (this.depth > MAX_LOOKUP_DEPTH) {
                    this.logOrThrowMisuse();
                } else if (this.depth >= 0) {
                    Object childTrace = this.clone();
                    this.currentTraceHolder.set(childTrace);
                    ((LookupTraceBase)childTrace).setupTraceBeforeStart(indexId, this.typeSafeThis());
                    return (T)childTrace;
                }
                this.setupTraceBeforeStart(indexId, null);
                return this.typeSafeThis();
            }

            protected void setupTraceBeforeStart(@NotNull IndexId<?, ?> indexId, @Nullable T parentTrace) {
                if (indexId == null) {
                    LookupTraceBase.$$$reportNull$$$0(1);
                }
                this.indexId = indexId;
                this.lookupFailed = false;
                this.lookupCancelled = false;
                this.totalKeysIndexed = -1;
                this.lookupResultSize = -1;
                this.parentTrace = parentTrace;
                this.depth = this.parentTrace == null ? 0 : ((LookupTraceBase)this.parentTrace).depth + 1;
                this.lookupStartedAtMs = System.currentTimeMillis();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void lookupFinished() {
                if (!this.mustBeStarted()) {
                    return;
                }
                try {
                    Objects.requireNonNull(this.indexId, "indexId must be set here");
                    long lookupFinishedAtMs = System.currentTimeMillis();
                    long lookupDurationMs = lookupFinishedAtMs - this.lookupStartedAtMs;
                    if (REPORT_INDIVIDUAL_LOOKUPS_TO_FUS && (lookupDurationMs > (long)REPORT_TO_FUS_INDIVIDUAL_LOOKUPS_ONLY_LONGER_THAN_MS || this.lookupFailed)) {
                        this.reportDetailedDataToFUS(lookupFinishedAtMs);
                    }
                    if (REPORT_INDIVIDUAL_LOOKUPS_TO_OPEN_TELEMETRY) {
                        this.reportDetailedDataToOTel(lookupFinishedAtMs);
                    }
                    if (COLLECT_AGGREGATED_STATS) {
                        this.collectAggregatedData(lookupFinishedAtMs);
                    }
                }
                finally {
                    if (this.parentTrace != null) {
                        this.currentTraceHolder.set(this.parentTrace);
                    } else {
                        this.depth = -1;
                    }
                }
            }

            protected abstract void reportDetailedDataToFUS(long var1);

            protected abstract void reportDetailedDataToOTel(long var1);

            protected abstract void collectAggregatedData(long var1);

            @Override
            public final void close() {
                this.lookupFinished();
            }

            public T withProject(@Nullable Project project) {
                return this.typeSafeThis();
            }

            public T lookupFailed() {
                if (this.traceWasStarted()) {
                    this.lookupFailed = true;
                }
                return this.typeSafeThis();
            }

            public T lookupCancelled() {
                if (this.traceWasStarted()) {
                    this.lookupCancelled = true;
                }
                return this.typeSafeThis();
            }

            public T totalKeysIndexed(int totalKeysIndexed) {
                if (this.traceWasStarted()) {
                    this.totalKeysIndexed = totalKeysIndexed;
                }
                return this.typeSafeThis();
            }

            public T lookupResultSize(int size) {
                if (this.traceWasStarted()) {
                    this.lookupResultSize = size;
                }
                return this.typeSafeThis();
            }

            public String toString() {
                return this.getClass().getSimpleName() + "{indexId=" + String.valueOf(this.indexId) + ", depth=" + this.depth + ", is started? =" + this.traceWasStarted() + ", lookupStartedAtMs=" + this.lookupStartedAtMs + "}";
            }

            protected T clone() {
                try {
                    return (T)((LookupTraceBase)super.clone());
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError("Code bug: Cloneable must not throw CloneNotSupportedException", e);
                }
            }

            @NotNull
            private T typeSafeThis() {
                LookupTraceBase lookupTraceBase = this;
                if (lookupTraceBase == null) {
                    LookupTraceBase.$$$reportNull$$$0(2);
                }
                return (T)lookupTraceBase;
            }

            private void logOrThrowMisuse() {
                String errorMessage = ".lookupStarted() was called " + this.depth + " times (>" + MAX_LOOKUP_DEPTH + " max) without matching .close()/.lookupFinished() -> probably code bug?\n" + String.valueOf(this);
                if (THROW_ON_INCORRECT_USAGE) {
                    throw new AssertionError((Object)errorMessage);
                }
                THROTTLED_LOG.warn(errorMessage);
            }

            protected boolean mustBeStarted() {
                boolean wasStarted = this.traceWasStarted();
                if (!wasStarted) {
                    String errorMessage = "Code bug: .lookupStarted() must be called before. " + String.valueOf(this);
                    if (THROW_ON_INCORRECT_USAGE) {
                        throw new AssertionError((Object)errorMessage);
                    }
                    THROTTLED_LOG.warn(errorMessage);
                }
                return wasStarted;
            }

            @VisibleForTesting
            @ApiStatus.Internal
            public boolean traceWasStarted() {
                return this.depth >= 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationFusCollector$LookupTraceBase";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/indexing/diagnostic/IndexLookupTimingsReporting$IndexOperationFusCollector$LookupTraceBase";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "typeSafeThis";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "lookupStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setupTraceBeforeStart";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

