/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.hints;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/hints/NonBinaryFileTypeInputFilter;", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "acceptInput", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "<init>", "(Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;)V", "acceptFileType", "Lcom/intellij/util/ThreeState;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "slowPathIfFileTypeHintUnsure", "", "file", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.platform.indexing.impl"})
@ApiStatus.Experimental
public final class NonBinaryFileTypeInputFilter
extends BaseFileTypeInputFilter {
    @NotNull
    private final FileBasedIndex.InputFilter acceptInput;

    public NonBinaryFileTypeInputFilter(@NotNull FileBasedIndex.InputFilter acceptInput) {
        Intrinsics.checkNotNullParameter((Object)acceptInput, (String)"acceptInput");
        super(FileTypeSubstitutionStrategy.AFTER_SUBSTITUTION);
        this.acceptInput = acceptInput;
    }

    @Override
    @NotNull
    public ThreeState acceptFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return fileType.isBinary() ? ThreeState.NO : ThreeState.UNSURE;
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.acceptInput.acceptInput(file.getFile());
    }
}

