/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubGistContentsCollector;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002J\u0017\u0010\u0018\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0017\u0010\u001a\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0012\u001a\u00020\nH\u0014J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/DefaultGithubGistContentsCollector;", "Lorg/jetbrains/plugins/github/GithubGistContentsCollector;", "<init>", "()V", "getGistFileName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "collectContents", "", "Lorg/jetbrains/plugins/github/api/data/request/GithubGistRequest$FileContent;", "gistEventData", "Lorg/jetbrains/plugins/github/GithubGistContentsCollector$GistEventData;", "getContentFromEditor", "file", "getSelectedText", "getContentFromFile", "project", "Lcom/intellij/openapi/project/Project;", "prefix", "getFileContents", "Lcom/intellij/openapi/util/NlsSafe;", "getFileContentInternal", "getContentFromDirectory", "dir", "addPrefix", "name", "addTrailingSlash", "", "isFileIgnored", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nDefaultGithubGistContentsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGithubGistContentsCollector.kt\norg/jetbrains/plugins/github/DefaultGithubGistContentsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public class DefaultGithubGistContentsCollector
implements GithubGistContentsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = GithubUtil.LOG;

    @Override
    @Nullable
    public String getGistFileName(@Nullable Editor editor, @Nullable VirtualFile[] files) {
        VirtualFile[] onlyFile;
        VirtualFile[] virtualFileArray = files;
        if (virtualFileArray != null && (virtualFileArray = (VirtualFile[])ArraysKt.singleOrNull((Object[])virtualFileArray)) != null) {
            VirtualFile[] virtualFileArray2;
            VirtualFile[] it = virtualFileArray2 = virtualFileArray;
            boolean bl = false;
            v1 = !it.isDirectory() ? virtualFileArray2 : null;
        } else {
            v1 = onlyFile = null;
        }
        if (onlyFile != null) {
            return onlyFile.getName();
        }
        if (editor != null) {
            return "";
        }
        return null;
    }

    @Override
    @NotNull
    public List<GithubGistRequest.FileContent> collectContents(@NotNull GithubGistContentsCollector.GistEventData gistEventData) {
        VirtualFile[] myFiles;
        List<GithubGistRequest.FileContent> contents;
        Intrinsics.checkNotNullParameter((Object)gistEventData, (String)"gistEventData");
        Project project = gistEventData.component1();
        Editor editor = gistEventData.component2();
        VirtualFile file = gistEventData.component3();
        VirtualFile[] files = gistEventData.component4();
        if (editor != null && (contents = this.getContentFromEditor(editor, file)) != null) {
            return contents;
        }
        VirtualFile[] virtualFileArray = files;
        if (files == null) {
            VirtualFile virtualFile = file;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                VirtualFile[] virtualFileArray2 = new VirtualFile[]{it};
                virtualFileArray = virtualFileArray2;
            } else {
                virtualFileArray = null;
            }
        }
        if ((myFiles = virtualFileArray) != null) {
            List list;
            List $this$collectContents_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (VirtualFile vf : myFiles) {
                $this$collectContents_u24lambda_u241.addAll((Collection)this.getContentFromFile(vf, project, null));
            }
            return CollectionsKt.build((List)list);
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    protected List<GithubGistRequest.FileContent> getContentFromEditor(@NotNull Editor editor, @Nullable VirtualFile file) {
        String text;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = this.getSelectedText(editor);
        if (string == null) {
            String string2 = editor.getDocument().getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        if (StringsKt.isBlank((CharSequence)(text = string))) {
            return null;
        }
        VirtualFile virtualFile = file;
        String string3 = virtualFile != null ? virtualFile.getName() : null;
        if (string3 == null) {
            string3 = "";
        }
        String fileName = string3;
        return CollectionsKt.listOf((Object)new GithubGistRequest.FileContent(fileName, text));
    }

    @Nullable
    protected final String getSelectedText(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (String)ReadAction.compute(() -> DefaultGithubGistContentsCollector.getSelectedText$lambda$0(editor));
    }

    private final List<GithubGistRequest.FileContent> getContentFromFile(VirtualFile file, Project project, String prefix) {
        if (file.isDirectory()) {
            return this.getContentFromDirectory(file, project, prefix);
        }
        if (file.getFileType().isBinary()) {
            Object[] objectArray = new Object[]{file.getName()};
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.binary.file", objectArray));
            return CollectionsKt.emptyList();
        }
        String content2 = (String)WriteAction.computeAndWait(() -> DefaultGithubGistContentsCollector.getContentFromFile$lambda$0(this, file));
        if (content2 == null) {
            Object[] objectArray = new Object[]{file.getName()};
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.content.read", objectArray));
            return CollectionsKt.emptyList();
        }
        if (StringsKt.isBlank((CharSequence)content2)) {
            return CollectionsKt.emptyList();
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String filename = this.addPrefix(string, prefix, false);
        return CollectionsKt.listOf((Object)new GithubGistRequest.FileContent(filename, content2));
    }

    private final String getFileContents(VirtualFile file) {
        try {
            return this.getFileContentInternal(file);
        }
        catch (IOException e) {
            LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected String getFileContentInternal(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getDocument(file);
        if (document != null) {
            fileDocumentManager2.saveDocument(document);
            return document.getText();
        }
        byte[] byArray = file.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        byte[] byArray2 = byArray;
        Charset charset = file.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }

    private final List<GithubGistRequest.FileContent> getContentFromDirectory(VirtualFile dir, Project project, String prefix) {
        List contents = new ArrayList();
        VirtualFile[] virtualFileArray = dir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        for (VirtualFile file : virtualFileArray) {
            Intrinsics.checkNotNull((Object)file);
            if (this.isFileIgnored(file, project)) continue;
            String string = dir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String pref = this.addPrefix(string, prefix, true);
            contents.addAll((Collection)this.getContentFromFile(file, project, pref));
        }
        return contents;
    }

    private final String addPrefix(String name, String prefix, boolean addTrailingSlash) {
        String string = prefix;
        if (string == null) {
            string = "";
        }
        Object pref = string;
        pref = (String)pref + name;
        if (addTrailingSlash) {
            pref = (String)pref + "_";
        }
        return pref;
    }

    private final boolean isFileIgnored(VirtualFile file, Project project) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager manager = changeListManager;
        return manager.isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }

    private static final String getSelectedText$lambda$0(Editor $editor) {
        return $editor.getSelectionModel().getSelectedText();
    }

    private static final String getContentFromFile$lambda$0(DefaultGithubGistContentsCollector this$0, VirtualFile $file) {
        return this$0.getFileContents($file);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/DefaultGithubGistContentsCollector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

