/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.file.codereview.CodeReviewDiffVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileKt;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001%B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c2\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c2\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile;", "Lcom/intellij/collaboration/file/codereview/CodeReviewDiffVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "getFileManagerId", "()Ljava/lang/String;", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "getPresentableName", "isValid", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "findProjectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "TitleProvider", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRDiffVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n30#2,2:71\n30#2,2:73\n1#3:75\n13#4:76\n13#4:77\n*S KotlinDebug\n*F\n+ 1 GHPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile\n*L\n39#1:71,2\n45#1:73,2\n48#1:76\n52#1:77\n*E\n"})
public final class GHPRDiffVirtualFile
extends CodeReviewDiffVirtualFile
implements GHPRVirtualFile {
    @NotNull
    private final String fileManagerId;
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(GHPRDiffVirtualFileKt.access$getFileName(pullRequest));
        this.fileManagerId = fileManagerId;
        this.project = project;
        this.repository = repository;
        this.pullRequest = pullRequest;
    }

    @Override
    @NotNull
    public String getFileManagerId() {
        return this.fileManagerId;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GHPRVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.getFileManagerId(), this.project, this.repository, this.pullRequest, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GHPRDiffVirtualFileKt.access$getPresentablePath(this.repository, this.pullRequest);
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.pullRequest.getNumber()};
        String string = GithubBundle.message("pull.request.diff.editor.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isValid() {
        return this.findProjectVm() != null;
    }

    @NotNull
    public DiffEditorViewer createViewer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GHPRDiffService> serviceClass$iv = GHPRDiffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((GHPRDiffService)object).createGHPRDiffProcessor(this.repository, this.pullRequest);
    }

    private final GHPRConnectedProjectViewModel findProjectVm() {
        try {
            Object object;
            if (this.project.isDisposed()) {
                return null;
            }
            Object $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GHPRProjectViewModel> serviceClass$iv = GHPRProjectViewModel.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel = (GHPRConnectedProjectViewModel)((GHPRProjectViewModel)object2).getConnectedProjectVm().getValue();
            if (gHPRConnectedProjectViewModel != null) {
                Object it = $this$service$iv = gHPRConnectedProjectViewModel;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getRepository(), (Object)this.repository) ? $this$service$iv : null;
            } else {
                object = null;
            }
            return object;
        }
        catch (CancellationException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GHPRDiffVirtualFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new RuntimeException(e));
            return null;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GHPRDiffVirtualFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public final String component1() {
        return this.fileManagerId;
    }

    private final Project component2() {
        return this.project;
    }

    private final GHRepositoryCoordinates component3() {
        return this.repository;
    }

    private final GHPRIdentifier component4() {
        return this.pullRequest;
    }

    @NotNull
    public final GHPRDiffVirtualFile copy(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return new GHPRDiffVirtualFile(fileManagerId, project, repository, pullRequest);
    }

    public static /* synthetic */ GHPRDiffVirtualFile copy$default(GHPRDiffVirtualFile gHPRDiffVirtualFile, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, GHPRIdentifier gHPRIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            string = gHPRDiffVirtualFile.fileManagerId;
        }
        if ((n & 2) != 0) {
            project = gHPRDiffVirtualFile.project;
        }
        if ((n & 4) != 0) {
            gHRepositoryCoordinates = gHPRDiffVirtualFile.repository;
        }
        if ((n & 8) != 0) {
            gHPRIdentifier = gHPRDiffVirtualFile.pullRequest;
        }
        return gHPRDiffVirtualFile.copy(string, project, gHRepositoryCoordinates, gHPRIdentifier);
    }

    @NotNull
    public String toString() {
        return "GHPRDiffVirtualFile(fileManagerId=" + this.fileManagerId + ", project=" + this.project + ", repository=" + this.repository + ", pullRequest=" + this.pullRequest + ")";
    }

    public int hashCode() {
        int result = this.fileManagerId.hashCode();
        result = result * 31 + this.project.hashCode();
        result = result * 31 + this.repository.hashCode();
        result = result * 31 + this.pullRequest.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRDiffVirtualFile)) {
            return false;
        }
        GHPRDiffVirtualFile gHPRDiffVirtualFile = (GHPRDiffVirtualFile)other;
        if (!Intrinsics.areEqual((Object)this.fileManagerId, (Object)gHPRDiffVirtualFile.fileManagerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)gHPRDiffVirtualFile.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.repository, (Object)gHPRDiffVirtualFile.repository)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pullRequest, (Object)gHPRDiffVirtualFile.pullRequest);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile$TitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "<init>", "()V", "getEditorTabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
    public static final class TitleProvider
    implements EditorTabTitleProvider {
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file instanceof GHPRDiffVirtualFile ? ((GHPRDiffVirtualFile)file).getPresentableName() : null;
        }
    }
}

