/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestOperation;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.pullrequest.GHPRAction;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListSearchValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001gB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u000e\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00107\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00108\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00109\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010:\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010;\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010<\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010=\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010>\u001a\u0002052\u0006\u0010?\u001a\u000206J\u000e\u0010@\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010A\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010B\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010C\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020+J\u001e\u0010I\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020PJ&\u0010_\u001a\u00020\r2\u0006\u0010`\u001a\u00020]2\u0006\u0010a\u001a\u00020(2\u0006\u0010b\u001a\u00020G2\u0006\u0010c\u001a\u00020(J\u001e\u0010d\u001a\u00020\r2\u0006\u0010^\u001a\u00020P2\u0006\u0010e\u001a\u00020(2\u0006\u0010f\u001a\u000206R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020604X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010G0FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010H\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010G\u0012\u0006\u0012\u0004\u0018\u00010G04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020P0OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020V0OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010Z\u001a\u0014\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002060[X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "COUNTERS_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getGroup", "SELECTORS_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "LIST_OPENED_EVENT", "logSelectorsOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "logListOpened", "COMMENTS_RESIZED_EVENT", "MULTILINE_COMMENTS_CREATED", "logResizedComments", "logMultilineCommentsCreated", "FILTER_SEARCH_PRESENT", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "FILTER_STATE_PRESENT", "FILTER_AUTHOR_PRESENT", "FILTER_ASSIGNEE_PRESENT", "FILTER_REVIEW_PRESENT", "FILTER_LABEL_PRESENT", "FILTER_SORT_PRESENT", "FILTERS_APPLIED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logListFiltersApplied", "filters", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRListSearchValue;", "DETAILS_OPENED_EVENT", "NEW_OPENED_EVENT", "logDetailsOpened", "logNewPRViewOpened", "TIMELINE_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DIFF_OPENED_EVENT", "MERGED_EVENT", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestMergeMethod;", "DETAILS_BRANCHES_EVENT", "DETAILS_BRANCH_CHECKED_OUT_EVENT", "DETAILS_COMMIT_CHOSEN_EVENT", "DETAILS_NEXT_COMMIT_EVENT", "DETAILS_PREV_COMMIT_EVENT", "DETAILS_CHANGE_EVENT", "DETAILS_CHECKS_EVENT", "DETAILS_ACTION_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRAction;", "", "logDetailsBranchesOpened", "logDetailsBranchCheckedOut", "logDetailsCommitChosen", "logDetailsNextCommitChosen", "logDetailsPrevCommitChosen", "logDetailsChecksOpened", "logDetailsActionInvoked", "action", "isDefault", "logTimelineOpened", "logDiffOpened", "logChangeSelected", "logMergedEvent", "method", "anonymizedId", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "SERVER_META_EVENT", "logEnterpriseServerMeta", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "meta", "Lorg/jetbrains/plugins/github/api/data/GHEnterpriseServerMeta;", "API_REQUEST_OPERATION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestOperation;", "API_REQUEST_RATELIMIT_REMAINING_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "API_REQUEST_RATELIMIT_USED_FIELD", "API_REQUEST_RATELIMIT_GUESSED_FIELD", "API_REQUEST_RATELIMIT_RESOURCE_FIELD", "Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$RateLimitResource;", "API_REQUEST_STATUS_CODE_FIELD", "API_REQUEST_EVENT", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "API_REQUEST_RATES_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "logApiRequestStart", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "operation", "logApiResponseReceived", "activity", "remaining", "resourceName", "statusCode", "logApiResponseRates", "used", "isGuessed", "RateLimitResource", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,332:1\n13385#2,3:333\n13385#2,3:336\n13#3:339\n263#4:340\n261#4,3:341\n256#4,4:344\n256#4,4:348\n*S KotlinDebug\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n*L\n152#1:333,3\n157#1:336,3\n31#1:339\n107#1:340\n121#1:341,3\n207#1:344,4\n230#1:348,4\n*E\n"})
public final class GHPRStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final GHPRStatisticsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup COUNTERS_GROUP;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final EventId SELECTORS_OPENED_EVENT;
    @NotNull
    private static final EventId LIST_OPENED_EVENT;
    @NotNull
    private static final EventId COMMENTS_RESIZED_EVENT;
    @NotNull
    private static final EventId MULTILINE_COMMENTS_CREATED;
    @NotNull
    private static final BooleanEventField FILTER_SEARCH_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_STATE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_AUTHOR_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_ASSIGNEE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_REVIEW_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_LABEL_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_SORT_PRESENT;
    @NotNull
    private static final VarargEventId FILTERS_APPLIED_EVENT;
    @NotNull
    private static final EventId DETAILS_OPENED_EVENT;
    @NotNull
    private static final EventId NEW_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> TIMELINE_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> DIFF_OPENED_EVENT;
    @NotNull
    private static final EventId1<GithubPullRequestMergeMethod> MERGED_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCHES_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCH_CHECKED_OUT_EVENT;
    @NotNull
    private static final EventId DETAILS_COMMIT_CHOSEN_EVENT;
    @NotNull
    private static final EventId DETAILS_NEXT_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_PREV_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_CHANGE_EVENT;
    @NotNull
    private static final EventId DETAILS_CHECKS_EVENT;
    @NotNull
    private static final EventId2<GHPRAction, Boolean> DETAILS_ACTION_EVENT;
    @NotNull
    private static final PrimitiveEventField<String> anonymizedId;
    @NotNull
    private static final EventId2<String, String> SERVER_META_EVENT;
    @NotNull
    private static final EnumEventField<GithubApiRequestOperation> API_REQUEST_OPERATION_FIELD;
    @NotNull
    private static final IntEventField API_REQUEST_RATELIMIT_REMAINING_FIELD;
    @NotNull
    private static final IntEventField API_REQUEST_RATELIMIT_USED_FIELD;
    @NotNull
    private static final BooleanEventField API_REQUEST_RATELIMIT_GUESSED_FIELD;
    @NotNull
    private static final EnumEventField<RateLimitResource> API_REQUEST_RATELIMIT_RESOURCE_FIELD;
    @NotNull
    private static final IntEventField API_REQUEST_STATUS_CODE_FIELD;
    @NotNull
    private static final IdeActivityDefinition API_REQUEST_EVENT;
    @NotNull
    private static final EventId3<GithubApiRequestOperation, Integer, Boolean> API_REQUEST_RATES_EVENT;

    private GHPRStatisticsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return COUNTERS_GROUP;
    }

    public final void logSelectorsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SELECTORS_OPENED_EVENT.log(project);
    }

    public final void logListOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LIST_OPENED_EVENT.log(project);
    }

    public final void logResizedComments(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        COMMENTS_RESIZED_EVENT.log(project);
    }

    public final void logMultilineCommentsCreated(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MULTILINE_COMMENTS_CREATED.log(project);
    }

    public final void logListFiltersApplied(@NotNull Project project, @NotNull GHPRListSearchValue filters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)FILTER_SEARCH_PRESENT, (Object)(filters.getSearchQuery() != null ? 1 : 0)), new EventPair((EventField)FILTER_STATE_PRESENT, (Object)(filters.getState() != null ? 1 : 0)), new EventPair((EventField)FILTER_AUTHOR_PRESENT, (Object)(filters.getAuthor() != null ? 1 : 0)), new EventPair((EventField)FILTER_ASSIGNEE_PRESENT, (Object)(filters.getAssignee() != null ? 1 : 0)), new EventPair((EventField)FILTER_REVIEW_PRESENT, (Object)(filters.getReviewState() != null ? 1 : 0)), new EventPair((EventField)FILTER_LABEL_PRESENT, (Object)(filters.getLabel() != null ? 1 : 0)), new EventPair((EventField)FILTER_SORT_PRESENT, (Object)(filters.getLabel() != null ? 1 : 0))};
        FILTERS_APPLIED_EVENT.log(project, eventPairArray);
    }

    public final void logDetailsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_OPENED_EVENT.log(project);
    }

    public final void logNewPRViewOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NEW_OPENED_EVENT.log(project);
    }

    public final void logDetailsBranchesOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCHES_EVENT.log(project);
    }

    public final void logDetailsBranchCheckedOut(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCH_CHECKED_OUT_EVENT.log(project);
    }

    public final void logDetailsCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_COMMIT_CHOSEN_EVENT.log(project);
    }

    public final void logDetailsNextCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_NEXT_COMMIT_EVENT.log(project);
    }

    public final void logDetailsPrevCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_PREV_COMMIT_EVENT.log(project);
    }

    public final void logDetailsChecksOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHECKS_EVENT.log(project);
    }

    public final void logDetailsActionInvoked(@NotNull Project project, @NotNull GHPRAction action, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        DETAILS_ACTION_EVENT.log(project, (Object)action, (Object)isDefault);
    }

    public final void logTimelineOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRTimelineVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        TIMELINE_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDiffOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRDiffVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        DIFF_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logChangeSelected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHANGE_EVENT.log(project);
    }

    public final void logMergedEvent(@NotNull Project project, @NotNull GithubPullRequestMergeMethod method) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        MERGED_EVENT.log(project, (Object)method);
    }

    public final void logEnterpriseServerMeta(@NotNull Project project, @NotNull GithubServerPath server, @NotNull GHEnterpriseServerMeta meta) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        SERVER_META_EVENT.log(project, (Object)server.toUrl(), (Object)meta.getInstalledVersion());
    }

    @NotNull
    public final StructuredIdeActivity logApiRequestStart(@NotNull GithubApiRequestOperation operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return API_REQUEST_EVENT.started(null, () -> GHPRStatisticsCollector.logApiRequestStart$lambda$0(operation));
    }

    public final void logApiResponseReceived(@NotNull StructuredIdeActivity activity, int remaining, @NotNull String resourceName, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        RateLimitResource resource = RateLimitResource.Companion.fromString(resourceName);
        if (resource == RateLimitResource.Unknown) {
            LOG.info("Unknown rate limit resource: " + resourceName);
        }
        activity.finished(() -> GHPRStatisticsCollector.logApiResponseReceived$lambda$0(remaining, resource, statusCode));
    }

    public final void logApiResponseRates(@NotNull GithubApiRequestOperation operation, int used, boolean isGuessed) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        LOG.debug("Rates { operation: " + operation + ", used: " + used + ", isGuessed: " + isGuessed + " }");
        API_REQUEST_RATES_EVENT.log((Object)operation, (Object)used, (Object)isGuessed);
    }

    private static final String MERGED_EVENT$lambda$0(GithubPullRequestMergeMethod it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    private static final List logApiRequestStart$lambda$0(GithubApiRequestOperation $operation) {
        return CollectionsKt.listOf((Object)API_REQUEST_OPERATION_FIELD.with((Object)$operation));
    }

    private static final List logApiResponseReceived$lambda$0(int $remaining, RateLimitResource $resource, int $statusCode) {
        Object[] objectArray = new EventPair[]{API_REQUEST_RATELIMIT_REMAINING_FIELD.with((Object)$remaining), API_REQUEST_RATELIMIT_RESOURCE_FIELD.with((Object)$resource), API_REQUEST_STATUS_CODE_FIELD.with((Object)$statusCode)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        EventFields $this$iv;
        String name$iv;
        INSTANCE = new GHPRStatisticsCollector();
        COUNTERS_GROUP = new EventLogGroup("vcs.github.pullrequest.counters", 11, null, 4, null);
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(GHPRStatisticsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        SELECTORS_OPENED_EVENT = COUNTERS_GROUP.registerEvent("selectors.opened");
        LIST_OPENED_EVENT = COUNTERS_GROUP.registerEvent("list.opened");
        COMMENTS_RESIZED_EVENT = COUNTERS_GROUP.registerEvent("comments.resized", "The user resized range of a new comment by dragging its outline across the text");
        MULTILINE_COMMENTS_CREATED = COUNTERS_GROUP.registerEvent("multiline.comments.created", "The user created a new comment that spans multiple lines");
        FILTER_SEARCH_PRESENT = EventFields.Boolean((String)"has_search");
        FILTER_STATE_PRESENT = EventFields.Boolean((String)"has_state");
        FILTER_AUTHOR_PRESENT = EventFields.Boolean((String)"has_author");
        FILTER_ASSIGNEE_PRESENT = EventFields.Boolean((String)"has_assignee");
        FILTER_REVIEW_PRESENT = EventFields.Boolean((String)"has_review_state");
        FILTER_LABEL_PRESENT = EventFields.Boolean((String)"has_label");
        FILTER_SORT_PRESENT = EventFields.Boolean((String)"has_sort");
        EventFields $i$f$logger22 = new EventFields[]{FILTER_SEARCH_PRESENT, FILTER_STATE_PRESENT, FILTER_AUTHOR_PRESENT, FILTER_ASSIGNEE_PRESENT, FILTER_REVIEW_PRESENT, FILTER_LABEL_PRESENT, FILTER_SORT_PRESENT};
        FILTERS_APPLIED_EVENT = COUNTERS_GROUP.registerVarargEvent("list.filters.applied", (EventField[])$i$f$logger22);
        DETAILS_OPENED_EVENT = COUNTERS_GROUP.registerEvent("details.opened");
        NEW_OPENED_EVENT = COUNTERS_GROUP.registerEvent("new.pr.view.opened");
        TIMELINE_OPENED_EVENT = COUNTERS_GROUP.registerEvent("timeline.opened", (EventField)EventFields.Int((String)"count"));
        DIFF_OPENED_EVENT = COUNTERS_GROUP.registerEvent("diff.opened", (EventField)EventFields.Int((String)"count"));
        $i$f$logger22 = EventFields.INSTANCE;
        String string = "method";
        Function1 transform$iv = GHPRStatisticsCollector::MERGED_EVENT$lambda$0;
        boolean $i$f$Enum = false;
        MERGED_EVENT = COUNTERS_GROUP.registerEvent("merged", (EventField)new EnumEventField(name$iv, GithubPullRequestMergeMethod.class, null, transform$iv));
        DETAILS_BRANCHES_EVENT = COUNTERS_GROUP.registerEvent("details.branches.opened");
        DETAILS_BRANCH_CHECKED_OUT_EVENT = COUNTERS_GROUP.registerEvent("details.branch.checked.out");
        DETAILS_COMMIT_CHOSEN_EVENT = COUNTERS_GROUP.registerEvent("details.commit.chosen");
        DETAILS_NEXT_COMMIT_EVENT = COUNTERS_GROUP.registerEvent("details.next.commit.chosen");
        DETAILS_PREV_COMMIT_EVENT = COUNTERS_GROUP.registerEvent("details.prev.commit.chosen");
        DETAILS_CHANGE_EVENT = COUNTERS_GROUP.registerEvent("details.change.selected");
        DETAILS_CHECKS_EVENT = COUNTERS_GROUP.registerEvent("details.checks.opened");
        EventFields this_$iv = EventFields.INSTANCE;
        name$iv = "action";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        DETAILS_ACTION_EVENT = COUNTERS_GROUP.registerEvent("details.additional.actions.invoked", (EventField)new EnumEventField(name$iv, GHPRAction.class, null, transform$iv), (EventField)EventFields.Boolean((String)"is_default"));
        anonymizedId = EventFields.AnonymizedId;
        SERVER_META_EVENT = COUNTERS_GROUP.registerEvent("server.meta.collected", (EventField)anonymizedId, (EventField)EventFields.Version);
        $this$iv = EventFields.INSTANCE;
        name$iv = "operation";
        String description$iv = "The type of operation executed.";
        Function1 transform$iv2 = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum2 = false;
        API_REQUEST_OPERATION_FIELD = new EnumEventField(name$iv, GithubApiRequestOperation.class, description$iv, transform$iv2);
        API_REQUEST_RATELIMIT_REMAINING_FIELD = EventFields.Int((String)"rates_remaining", (String)"The rate limit remaining for the resource as returned by GitHub.This is not a good measure of rates-used-per-request, instead it's a measure of total usage for a session/user.");
        API_REQUEST_RATELIMIT_USED_FIELD = EventFields.Int((String)"rates_used", (String)"The rate limit used during the request. In the case of GraphQL rates, this is taken directly from the request. In the case of REST rates, this defaults to 1, but may be changed in the future if GitHub changes their rate limit policy.");
        API_REQUEST_RATELIMIT_GUESSED_FIELD = EventFields.Boolean((String)"rates_used_guessed", (String)"Whether the rates used during the request are guessed. If `false`, the rates are pulled directly from the request.");
        $this$iv = EventFields.INSTANCE;
        name$iv = "rates_resource";
        description$iv = "The resource from which rates are taken as returned by GitHub.";
        transform$iv2 = $this$iv.getDefaultEnumTransform();
        $i$f$Enum2 = false;
        API_REQUEST_RATELIMIT_RESOURCE_FIELD = new EnumEventField(name$iv, RateLimitResource.class, description$iv, transform$iv2);
        API_REQUEST_STATUS_CODE_FIELD = EventFields.Int((String)"status", (String)"The status code of the response (200 = OK, 404 = Not Found, etc.).");
        EventField[] eventFieldArray = new EventField[]{API_REQUEST_OPERATION_FIELD};
        EventField[] eventFieldArray2 = eventFieldArray;
        eventFieldArray = new EventField[]{API_REQUEST_RATELIMIT_REMAINING_FIELD, API_REQUEST_RATELIMIT_RESOURCE_FIELD, API_REQUEST_STATUS_CODE_FIELD};
        API_REQUEST_EVENT = EventLogGroup.registerIdeActivity$default((EventLogGroup)COUNTERS_GROUP, (String)"api.request", (EventField[])eventFieldArray2, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
        API_REQUEST_RATES_EVENT = COUNTERS_GROUP.registerEvent("api.rates", (EventField)API_REQUEST_OPERATION_FIELD, (EventField)API_REQUEST_RATELIMIT_USED_FIELD, (EventField)API_REQUEST_RATELIMIT_GUESSED_FIELD, "Event that happens internally after we have tried to determine the rates used for a request.");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0082\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$RateLimitResource;", "", "<init>", "(Ljava/lang/String;I)V", "Core", "Search", "CodeSearch", "GraphQL", "IntegrationManifest", "DependencySnapshots", "CodeScanningUpload", "ActionsRunnerRegistration", "SourceImport", "Collaborators", "Unknown", "Companion", "intellij.vcs.github"})
    private static final class RateLimitResource
    extends Enum<RateLimitResource> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ RateLimitResource Core;
        public static final /* enum */ RateLimitResource Search;
        public static final /* enum */ RateLimitResource CodeSearch;
        public static final /* enum */ RateLimitResource GraphQL;
        public static final /* enum */ RateLimitResource IntegrationManifest;
        public static final /* enum */ RateLimitResource DependencySnapshots;
        public static final /* enum */ RateLimitResource CodeScanningUpload;
        public static final /* enum */ RateLimitResource ActionsRunnerRegistration;
        public static final /* enum */ RateLimitResource SourceImport;
        public static final /* enum */ RateLimitResource Collaborators;
        public static final /* enum */ RateLimitResource Unknown;
        private static final /* synthetic */ RateLimitResource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RateLimitResource[] values() {
            return (RateLimitResource[])$VALUES.clone();
        }

        public static RateLimitResource valueOf(String value) {
            return Enum.valueOf(RateLimitResource.class, value);
        }

        @NotNull
        public static EnumEntries<RateLimitResource> getEntries() {
            return $ENTRIES;
        }

        static {
            Core = new RateLimitResource();
            Search = new RateLimitResource();
            CodeSearch = new RateLimitResource();
            GraphQL = new RateLimitResource();
            IntegrationManifest = new RateLimitResource();
            DependencySnapshots = new RateLimitResource();
            CodeScanningUpload = new RateLimitResource();
            ActionsRunnerRegistration = new RateLimitResource();
            SourceImport = new RateLimitResource();
            Collaborators = new RateLimitResource();
            Unknown = new RateLimitResource();
            $VALUES = rateLimitResourceArray = new RateLimitResource[]{RateLimitResource.Core, RateLimitResource.Search, RateLimitResource.CodeSearch, RateLimitResource.GraphQL, RateLimitResource.IntegrationManifest, RateLimitResource.DependencySnapshots, RateLimitResource.CodeScanningUpload, RateLimitResource.ActionsRunnerRegistration, RateLimitResource.SourceImport, RateLimitResource.Collaborators, RateLimitResource.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$RateLimitResource$Companion;", "", "<init>", "()V", "fromString", "Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$RateLimitResource;", "name", "", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RateLimitResource fromString(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return switch (name) {
                    case "core", "rate" -> Core;
                    case "search" -> Search;
                    case "code_search" -> CodeSearch;
                    case "graphql" -> GraphQL;
                    case "integration_manifest" -> IntegrationManifest;
                    case "dependency_snapshots" -> DependencySnapshots;
                    case "code_scanning_upload" -> CodeScanningUpload;
                    case "actions_runner_registration" -> ActionsRunnerRegistration;
                    case "collaborators" -> Collaborators;
                    case "source_import" -> SourceImport;
                    default -> Unknown;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

