/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRAssignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRLabeledEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRRenamedTitleEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewRequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewUnrequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnassignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnlabeledEvent;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedEvents;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0014J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u001c\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergedSimpleEvents;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergedEvents;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Simple;", "<init>", "()V", "_addedLabels", "", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "addedLabels", "", "getAddedLabels", "()Ljava/util/Set;", "_removedLabels", "removedLabels", "getRemovedLabels", "_assignedPeople", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "assignedPeople", "getAssignedPeople", "_unassignedPeople", "unassignedPeople", "getUnassignedPeople", "_addedReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "addedReviewers", "getAddedReviewers", "_removedReviewers", "removedReviewers", "getRemovedReviewers", "_rename", "Lkotlin/Pair;", "", "rename", "getRename", "()Lkotlin/Pair;", "addNonMergedEvent", "", "event", "hasAnyChanges", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineMergedSimpleEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineMergedSimpleEvents.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergedSimpleEvents\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class GHPRTimelineMergedSimpleEvents
extends GHPRTimelineMergedEvents<GHPRTimelineEvent.Simple>
implements GHPRTimelineEvent.Simple {
    @NotNull
    private final Set<GHLabel> _addedLabels = new LinkedHashSet();
    @NotNull
    private final Set<GHLabel> _removedLabels = new LinkedHashSet();
    @NotNull
    private final Set<GHUser> _assignedPeople = new LinkedHashSet();
    @NotNull
    private final Set<GHUser> _unassignedPeople = new LinkedHashSet();
    @NotNull
    private final Set<GHPullRequestRequestedReviewer> _addedReviewers = new LinkedHashSet();
    @NotNull
    private final Set<GHPullRequestRequestedReviewer> _removedReviewers = new LinkedHashSet();
    @Nullable
    private Pair<String, String> _rename;

    @NotNull
    public final Set<GHLabel> getAddedLabels() {
        return this._addedLabels;
    }

    @NotNull
    public final Set<GHLabel> getRemovedLabels() {
        return this._removedLabels;
    }

    @NotNull
    public final Set<GHUser> getAssignedPeople() {
        return this._assignedPeople;
    }

    @NotNull
    public final Set<GHUser> getUnassignedPeople() {
        return this._unassignedPeople;
    }

    @NotNull
    public final Set<GHPullRequestRequestedReviewer> getAddedReviewers() {
        return this._addedReviewers;
    }

    @NotNull
    public final Set<GHPullRequestRequestedReviewer> getRemovedReviewers() {
        return this._removedReviewers;
    }

    @Nullable
    public final Pair<String, String> getRename() {
        Object object;
        Pair<String, String> pair = this._rename;
        if (pair != null) {
            Pair<String, String> it = pair;
            boolean bl = false;
            object = !Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()) ? it : null;
        } else {
            object = null;
        }
        return object;
    }

    @Override
    protected void addNonMergedEvent(@NotNull GHPRTimelineEvent.Simple event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GHPRTimelineEvent.Simple simple = event;
        if (simple instanceof GHPRLabeledEvent) {
            if (!this._removedLabels.remove(((GHPRLabeledEvent)event).getLabel())) {
                this._addedLabels.add(((GHPRLabeledEvent)event).getLabel());
            }
        } else if (simple instanceof GHPRUnlabeledEvent) {
            if (!this._addedLabels.remove(((GHPRUnlabeledEvent)event).getLabel())) {
                this._removedLabels.add(((GHPRUnlabeledEvent)event).getLabel());
            }
        } else if (simple instanceof GHPRAssignedEvent) {
            if (((GHPRAssignedEvent)event).getUser() != null && !this._unassignedPeople.remove(((GHPRAssignedEvent)event).getUser())) {
                this._assignedPeople.add(((GHPRAssignedEvent)event).getUser());
            }
        } else if (simple instanceof GHPRUnassignedEvent) {
            if (((GHPRUnassignedEvent)event).getUser() != null && !this._assignedPeople.remove(((GHPRUnassignedEvent)event).getUser())) {
                this._unassignedPeople.add(((GHPRUnassignedEvent)event).getUser());
            }
        } else if (simple instanceof GHPRReviewRequestedEvent) {
            GHPullRequestRequestedReviewer reviewer = ((GHPRReviewRequestedEvent)event).getRequestedReviewer();
            if (reviewer != null && !this._removedReviewers.remove(reviewer)) {
                this._addedReviewers.add(reviewer);
            }
        } else if (simple instanceof GHPRReviewUnrequestedEvent) {
            GHPullRequestRequestedReviewer reviewer = ((GHPRReviewUnrequestedEvent)event).getRequestedReviewer();
            if (reviewer != null && !this._addedReviewers.remove(reviewer)) {
                this._removedReviewers.add(reviewer);
            }
        } else if (simple instanceof GHPRRenamedTitleEvent) {
            Object object = this._rename;
            if (object == null || (object = (String)object.getFirst()) == null) {
                object = ((GHPRRenamedTitleEvent)event).getPreviousTitle();
            }
            this._rename = TuplesKt.to(object, (Object)((GHPRRenamedTitleEvent)event).getCurrentTitle());
        }
    }

    @Override
    public boolean hasAnyChanges() {
        return !((Collection)this.getAssignedPeople()).isEmpty() || !((Collection)this.getUnassignedPeople()).isEmpty() || !((Collection)this.getAddedLabels()).isEmpty() || !((Collection)this.getRemovedLabels()).isEmpty() || !((Collection)this.getAddedReviewers()).isEmpty() || !((Collection)this.getRemovedReviewers()).isEmpty() || this.getRename() != null;
    }
}

