/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00017Bf\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012:\u0010\u0007\u001a6\b\u0001\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\b\u0012\u000b\u0010\u000f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\tH\u0082@\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020#0.H\u0014J\n\u0010/\u001a\u0004\u0018\u00010#H\u0002J\n\u00100\u001a\u0004\u0018\u00010#H\u0002J\n\u00101\u001a\u0004\u0018\u00010#H\u0002J\b\u00102\u001a\u00020\u0006H\u0014J\b\u00103\u001a\u00020\u0006H\u0014J\b\u00104\u001a\u00020\u0018H\u0016J\u0006\u00105\u001a\u000206R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RD\u0010\u0007\u001a6\b\u0001\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\t0\t0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "existingRemotes", "", "", "accountInformationSupplier", "Lkotlin/Function3;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Ljava/awt/Component;", "Lkotlin/coroutines/Continuation;", "Lkotlin/Pair;", "", "", "projectName", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lkotlin/jvm/functions/Function3;Ljava/lang/String;)V", "Lkotlin/jvm/functions/Function3;", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "repositoryTextField", "Lcom/intellij/ui/components/JBTextField;", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteName", "remoteTextField", "descriptionTextArea", "Lcom/intellij/ui/components/JBTextArea;", "existingRepoValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRemoteValidator", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accounts", "accountsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "switchAccount", "", "account", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doValidateAll", "", "validateRepository", "validateRepositoryName", "validateRemote", "getHelpId", "getDimensionServiceKey", "getPreferredFocusedComponent", "getResult", "Lorg/jetbrains/plugins/github/ui/GithubShareDialog$Result;", "Result", "intellij.vcs.github"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGithubShareDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubShareDialog.kt\norg/jetbrains/plugins/github/ui/GithubShareDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class GithubShareDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Function3<GithubAccount, Component, Continuation<? super Pair<Boolean, ? extends Set<String>>>, Object> accountInformationSupplier;
    private final Pattern GITHUB_REPO_PATTERN;
    @NotNull
    private final JBTextField repositoryTextField;
    @NotNull
    private final JBCheckBox privateCheckBox;
    @NlsSafe
    @NotNull
    private final String remoteName;
    @NotNull
    private final JBTextField remoteTextField;
    @NotNull
    private final JBTextArea descriptionTextArea;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    @Nullable
    private ValidationInfo accountInformationLoadingError;
    @NotNull
    private final Set<GithubAccount> accounts;
    @NotNull
    private final CollectionComboBoxModel<GithubAccount> accountsModel;

    /*
     * WARNING - void declaration
     */
    public GithubShareDialog(@NotNull Project project, @NotNull Set<String> existingRemotes, @NotNull Function3<? super GithubAccount, ? super Component, ? super Continuation<? super Pair<Boolean, ? extends Set<String>>>, ? extends Object> accountInformationSupplier, @NotNull String projectName) {
        void $this$existingRemoteValidator_u24lambda_u240;
        Object $this$descriptionTextArea_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(existingRemotes, (String)"existingRemotes");
        Intrinsics.checkNotNullParameter(accountInformationSupplier, (String)"accountInformationSupplier");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        super(project);
        this.project = project;
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(projectName);
        this.privateCheckBox = new JBCheckBox(GithubBundle.message("share.dialog.private", new Object[0]), true);
        this.remoteName = existingRemotes.isEmpty() ? "origin" : "github";
        this.remoteTextField = new JBTextField(this.remoteName);
        JBTextArea jBTextArea = object = new JBTextArea();
        GithubShareDialog githubShareDialog = this;
        boolean bl = false;
        $this$descriptionTextArea_u24lambda_u240.setLineWrap(true);
        githubShareDialog.descriptionTextArea = object;
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.error.repo.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator(jTextField, string);
        JTextField jTextField2 = (JTextField)this.remoteTextField;
        String string2 = GithubBundle.message("share.error.remote.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$descriptionTextArea_u24lambda_u240 = object = new DialogValidationUtils.RecordUniqueValidator(jTextField2, string2);
        githubShareDialog = this;
        boolean bl2 = false;
        $this$existingRemoteValidator_u24lambda_u240.setRecords(existingRemotes);
        githubShareDialog.existingRemoteValidator = object;
        this.accounts = GHAccountsUtil.getAccounts();
        List list = CollectionsKt.toMutableList((Collection)this.accounts);
        GithubAccount githubAccount = GHAccountsUtil.getDefaultAccount(this.project);
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)this.accounts));
        }
        this.accountsModel = new CollectionComboBoxModel(list, (Object)githubAccount);
        this.setTitle(GithubBundle.message("share.on.github", new Object[0]));
        this.setOKButtonText(GithubBundle.message("share.button", new Object[0]));
        this.init();
        UiScopeKt.initOnShow$default((Component)this.getWindow(), (String)(((Object)((Object)this)).getClass().getName() + "#init"), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.switchAccount((GithubAccount)((Object)this.this$0.accountsModel.getSelected()), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object switchAccount(GithubAccount account, Continuation<? super Unit> $completion) {
        if (!($completion instanceof switchAccount.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GithubShareDialog this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GithubShareDialog.access$switchAccount(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (account == null) {
                    return Unit.INSTANCE;
                }
                this.accountInformationLoadingError = null;
                v0 = this.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getWindow(...)");
                $continuation.L$0 = account;
                $continuation.label = 1;
                v1 = this.accountInformationSupplier.invoke((Object)account, (Object)v0, (Object)$continuation);
                ** if (v1 != var8_5) goto lbl24
lbl23:
                // 1 sources

                return var8_5;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                account = (GithubAccount)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                var3_6 = (Pair)v1;
                canCreatePrivate = (Boolean)var3_6.component1();
                takenNames = (Set)var3_6.component2();
                $continuation.L$0 = account;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)takenNames);
                $continuation.Z$0 = canCreatePrivate;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, canCreatePrivate != false, (Set<String>)takenNames, null){
                    int label;
                    final /* synthetic */ GithubShareDialog this$0;
                    final /* synthetic */ boolean $canCreatePrivate;
                    final /* synthetic */ Set<String> $takenNames;
                    {
                        this.this$0 = $receiver;
                        this.$canCreatePrivate = $canCreatePrivate;
                        this.$takenNames = $takenNames;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                GithubShareDialog.access$getPrivateCheckBox$p(this.this$0).setEnabled(this.$canCreatePrivate);
                                if (!this.$canCreatePrivate) {
                                    GithubShareDialog.access$getPrivateCheckBox$p(this.this$0).setToolTipText(GithubBundle.message("share.error.private.repos.not.supported", new Object[0]));
                                } else {
                                    GithubShareDialog.access$getPrivateCheckBox$p(this.this$0).setToolTipText(null);
                                }
                                GithubShareDialog.access$getExistingRepoValidator$p(this.this$0).setRecords(this.$takenNames);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var8_5) goto lbl41
lbl40:
                // 1 sources

                return var8_5;
lbl41:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                canCreatePrivate = $continuation.Z$0;
                takenNames = (Set)$continuation.L$1;
                account = (GithubAccount)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl64
                }
                catch (Exception e) {
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)account);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                    $continuation.label = 3;
                    v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(account, e, this, null){
                        int label;
                        final /* synthetic */ GithubAccount $account;
                        final /* synthetic */ Exception $e;
                        final /* synthetic */ GithubShareDialog this$0;
                        {
                            this.$account = $account;
                            this.$e = $e;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object[] objectArray = new Object[]{this.$account};
                                    String errorText = GithubBundle.message("share.dialog.account.info.load.error.prefix", objectArray) + (this.$e instanceof ProcessCanceledException ? GithubBundle.message("share.dialog.account.info.load.process.canceled", new Object[0]) : this.$e.getMessage());
                                    GithubShareDialog.access$setAccountInformationLoadingError$p(this.this$0, new ValidationInfo(errorText));
                                    GithubShareDialog.access$getPrivateCheckBox$p(this.this$0).setEnabled(false);
                                    GithubShareDialog.access$getPrivateCheckBox$p(this.this$0).setToolTipText(null);
                                    GithubShareDialog.access$getExistingRepoValidator$p(this.this$0).setRecords(SetsKt.emptySet());
                                    GithubShareDialog.access$startTrackingValidation(this.this$0);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v3 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl64
                }
            }
            case 3: {
                e = (Exception)$continuation.L$1;
                account = (GithubAccount)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl64:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> GithubShareDialog.createCenterPanel$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize((Dimension)JBUI.size((int)500, (int)250));
        return dialogPanel;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List list = super.doValidateAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doValidateAll(...)");
        List uiErrors = list;
        ValidationInfo loadingError2 = this.accountInformationLoadingError;
        return loadingError2 != null ? CollectionsKt.plus((Collection)uiErrors, (Object)loadingError2) : uiErrors;
    }

    private final ValidationInfo validateRepository() {
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.validation.no.repo.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null && (validationInfo = this.validateRepositoryName()) == null) {
            validationInfo = this.existingRepoValidator.invoke();
        }
        return validationInfo;
    }

    private final ValidationInfo validateRepositoryName() {
        return this.GITHUB_REPO_PATTERN.matcher(this.repositoryTextField.getText()).matches() ? null : new ValidationInfo(GithubBundle.message("share.validation.invalid.repo.name", new Object[0]), (JComponent)this.repositoryTextField);
    }

    private final ValidationInfo validateRemote() {
        JTextField jTextField = (JTextField)this.remoteTextField;
        String string = GithubBundle.message("share.validation.no.remote.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null) {
            validationInfo = this.existingRemoteValidator.invoke();
        }
        return validationInfo;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @NotNull
    public final Result getResult() {
        String string = this.repositoryTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.remoteTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        boolean bl = this.privateCheckBox.isSelected();
        String string3 = this.descriptionTextArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return new Result(string, string2, bl, string3, (GithubAccount)((Object)this.accountsModel.getSelected()));
    }

    private static final ValidationInfo createCenterPanel$lambda$0$0$0(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateRepository();
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$0(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateRemote();
    }

    private static final void createCenterPanel$lambda$0$3$1$0(GithubShareDialog this$0, ComboBox $this_applyToComponent, ActionEvent it) {
        UiScopeKt.initOnShow$default((Component)this$0.getWindow(), (String)($this_applyToComponent.getClass().getName() + "#switchAccount"), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GithubShareDialog.access$switchAccount(this.this$0, (GithubAccount)((Object)GithubShareDialog.access$getAccountsModel$p(this.this$0).getSelected()), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final ValidationInfo createCenterPanel$lambda$0$3$0(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.accountsModel.getSelected() == null) {
            String string = GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnApply.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createCenterPanel$lambda$0$3$1(GithubShareDialog this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$3$1$0(this$0, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.repositoryTextField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0, arg_1)).resizableColumn();
        $this$row.cell((JComponent)this$0.privateCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.remoteTextField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GithubBundle.message("share.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE);
        $this$row.scrollCell((JComponent)this$0.descriptionTextArea).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.accountsModel), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$0$3$0(this$0, arg_0, arg_1)).applyToComponent(arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$3$1(this$0, arg_0)).resizableColumn();
        if (this$0.accountsModel.getSize() == 0) {
            $this$row.cell((JComponent)GHAccountsUtil.INSTANCE.createAddAccountLink(this$0.project, this$0.accountsModel, GHLoginSource.SHARE));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(GithubShareDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = GithubBundle.message("share.dialog.repo.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        String string2 = GithubBundle.message("share.dialog.remote", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
        if (this$0.accountsModel.getSize() != 1) {
            String string3 = GithubBundle.message("share.dialog.share.by", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            $this$panel.row(string3, arg_0 -> GithubShareDialog.createCenterPanel$lambda$0$3(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JBCheckBox access$getPrivateCheckBox$p(GithubShareDialog $this) {
        return $this.privateCheckBox;
    }

    public static final /* synthetic */ DialogValidationUtils.RecordUniqueValidator access$getExistingRepoValidator$p(GithubShareDialog $this) {
        return $this.existingRepoValidator;
    }

    public static final /* synthetic */ void access$setAccountInformationLoadingError$p(GithubShareDialog $this, ValidationInfo validationInfo) {
        $this.accountInformationLoadingError = validationInfo;
    }

    public static final /* synthetic */ void access$startTrackingValidation(GithubShareDialog $this) {
        $this.startTrackingValidation();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B6\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u00c6\u0003JB\u0010\u0019\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog$Result;", "", "repositoryName", "", "Lcom/intellij/openapi/util/NlsSafe;", "remoteName", "isPrivate", "", "description", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "getRepositoryName", "()Ljava/lang/String;", "getRemoteName", "()Z", "getDescription", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.github"})
    public static final class Result {
        @NotNull
        private final String repositoryName;
        @NotNull
        private final String remoteName;
        private final boolean isPrivate;
        @NotNull
        private final String description;
        @Nullable
        private final GithubAccount account;

        public Result(@NotNull String repositoryName, @NotNull String remoteName, boolean isPrivate, @NotNull String description, @Nullable GithubAccount account) {
            Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
            Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.repositoryName = repositoryName;
            this.remoteName = remoteName;
            this.isPrivate = isPrivate;
            this.description = description;
            this.account = account;
        }

        @NotNull
        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @NotNull
        public final String getRemoteName() {
            return this.remoteName;
        }

        public final boolean isPrivate() {
            return this.isPrivate;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final GithubAccount getAccount() {
            return this.account;
        }

        @NotNull
        public final String component1() {
            return this.repositoryName;
        }

        @NotNull
        public final String component2() {
            return this.remoteName;
        }

        public final boolean component3() {
            return this.isPrivate;
        }

        @NotNull
        public final String component4() {
            return this.description;
        }

        @Nullable
        public final GithubAccount component5() {
            return this.account;
        }

        @NotNull
        public final Result copy(@NotNull String repositoryName, @NotNull String remoteName, boolean isPrivate, @NotNull String description, @Nullable GithubAccount account) {
            Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
            Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new Result(repositoryName, remoteName, isPrivate, description, account);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, String string2, boolean bl, String string3, GithubAccount githubAccount, int n, Object object) {
            if ((n & 1) != 0) {
                string = result.repositoryName;
            }
            if ((n & 2) != 0) {
                string2 = result.remoteName;
            }
            if ((n & 4) != 0) {
                bl = result.isPrivate;
            }
            if ((n & 8) != 0) {
                string3 = result.description;
            }
            if ((n & 0x10) != 0) {
                githubAccount = result.account;
            }
            return result.copy(string, string2, bl, string3, githubAccount);
        }

        @NotNull
        public String toString() {
            return "Result(repositoryName=" + this.repositoryName + ", remoteName=" + this.remoteName + ", isPrivate=" + this.isPrivate + ", description=" + this.description + ", account=" + this.account + ")";
        }

        public int hashCode() {
            int result = this.repositoryName.hashCode();
            result = result * 31 + this.remoteName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isPrivate);
            result = result * 31 + this.description.hashCode();
            result = result * 31 + (this.account == null ? 0 : this.account.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.repositoryName, (Object)result.repositoryName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.remoteName, (Object)result.remoteName)) {
                return false;
            }
            if (this.isPrivate != result.isPrivate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)result.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.account), (Object)((Object)result.account));
        }
    }
}

