/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.StandardVcsGroup;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsGroupsWrapper
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(VcsGroupsWrapper.class);

    VcsGroupsWrapper() {
    }

    public void update(@NotNull AnActionEvent e) {
        DefaultActionGroup vcsGroup;
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(0);
        }
        if ((vcsGroup = VcsGroupsWrapper.mergeVcsGroups(e)) == null) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().copyFrom(vcsGroup.getTemplatePresentation());
            vcsGroup.update(e);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                VcsGroupsWrapper.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup vcsGroup = VcsGroupsWrapper.mergeVcsGroups(e);
        if (vcsGroup == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                VcsGroupsWrapper.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = vcsGroup.getChildren(e);
        if (anActionArray == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    @NotNull
    private static Set<String> collectVcses(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(6);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Set set2 = VcsContextUtil.selectedFilesIterable(dataContext).filterMap(file -> vcsManager.getVcsFor(VcsUtil.resolveSymlinkIfNeeded((Project)project, (VirtualFile)file))).map(AbstractVcs::getName).unique().take(vcsManager.getAllActiveVcss().length).toSet();
        if (set2 == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(7);
        }
        return set2;
    }

    @Nullable
    private static DefaultActionGroup mergeVcsGroups(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(8);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        Set<String> currentVcses = VcsGroupsWrapper.collectVcses(project, e.getDataContext());
        if (currentVcses.isEmpty()) {
            return null;
        }
        ArrayList<StandardVcsGroup> groups = new ArrayList<StandardVcsGroup>();
        DefaultActionGroup vcsGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("VcsGroup");
        for (AnAction child : vcsGroup.getChildren(e)) {
            StandardVcsGroup standardGroup = (StandardVcsGroup)ObjectUtils.tryCast((Object)child, StandardVcsGroup.class);
            if (standardGroup == null) {
                LOG.error(MessageFormat.format("Any version control group should extend {0}. Violated by {1}, {2}.", StandardVcsGroup.class, ActionManager.getInstance().getId(child), child.getClass()));
                continue;
            }
            String vcsName = standardGroup.getVcsName(project);
            if (!currentVcses.contains(vcsName)) continue;
            groups.add(standardGroup);
        }
        if (groups.isEmpty()) {
            return null;
        }
        if (groups.size() == 1) {
            return (DefaultActionGroup)ContainerUtil.getOnlyItem(groups);
        }
        DefaultActionGroup result2 = DefaultActionGroup.createPopupGroup((Supplier)VcsBundle.messagePointer((String)"group.name.version.control", (Object[])new Object[0]));
        result2.addAll(groups);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVcses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectVcses";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeVcsGroups";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

