/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.platform.vcs.impl.shared.changes.PreviewDiffSplitterComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.changes.viewModel.ChangesViewProxy;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitTabTitleUpdater;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowUi;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.FixedSizeScrollPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewManager
implements ChangesViewEx,
Disposable {
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final CoroutineScope myScope;
    @NotNull
    private final Project myProject;
    @Nullable
    private ChangesViewProxy myChangesView;
    @Nullable
    private ChangesViewToolWindowPanel myToolWindowPanel;

    @NotNull
    @RequiresEdt
    ChangesViewProxy initChangesView() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myChangesView == null) {
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewPanel initialization");
            this.myChangesView = ChangesViewProxy.create(this.myProject, this.myScope);
            activity.end();
        }
        ChangesViewProxy changesViewProxy = this.myChangesView;
        if (changesViewProxy == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        return changesViewProxy;
    }

    @RequiresEdt
    @NotNull
    private ChangesViewToolWindowPanel initToolWindowPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myToolWindowPanel == null) {
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewToolWindowPanel initialization");
            ChangesViewProxy changesView = this.initChangesView();
            ChangesViewToolWindowPanel panel = new ChangesViewToolWindowPanel(this.myProject, changesView);
            Disposer.register((Disposable)this, (Disposable)panel);
            panel.updateCommitWorkflow();
            this.myToolWindowPanel = panel;
            Disposer.register((Disposable)panel, () -> {
                this.myChangesView = null;
                this.myToolWindowPanel = null;
            });
            Disposer.register((Disposable)panel, (Disposable)changesView);
            activity.end();
        }
        ChangesViewToolWindowPanel changesViewToolWindowPanel = this.myToolWindowPanel;
        if (changesViewToolWindowPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewToolWindowPanel;
    }

    public ChangesViewManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        if (coroutineScope == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        this.myScope = coroutineScope;
        this.myProject = project;
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ChangesViewWorkflowManager.TOPIC, () -> this.updateCommitWorkflow());
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public ChangesViewCommitWorkflowUi createCommitPanel() {
        ChangesViewProxy changesView = this.initChangesView();
        return new ChangesViewCommitPanel(this.myProject, changesView);
    }

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        ChangesViewI changesViewI = (ChangesViewI)project.getService(ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        return changesViewI;
    }

    @NotNull
    public static ChangesViewEx getInstanceEx(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        return (ChangesViewEx)ChangesViewManager.getInstance(project);
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(@NlsContexts.Label String text, boolean isError) {
        Factory factory = () -> {
            JBLabel label = new JBLabel(StringUtil.replace((String)text.trim(), (String)"\n", (String)"<br/>")).setCopyable(true);
            label.setVerticalTextPosition(1);
            label.setBorder(JBUI.Borders.empty((int)3));
            label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        return factory;
    }

    public void dispose() {
    }

    @Override
    public void scheduleRefresh(@NotNull Runnable callback) {
        if (callback == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        if (this.myChangesView == null) {
            return;
        }
        this.myChangesView.scheduleRefreshNow(callback);
    }

    @Override
    public void scheduleRefresh() {
        if (this.myChangesView == null) {
            return;
        }
        this.myChangesView.scheduleDelayedRefresh();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (this.myChangesView == null) {
            return;
        }
        this.myChangesView.selectFile(vFile);
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        if (this.myChangesView == null) {
            return;
        }
        this.myChangesView.selectChanges(new ArrayList<Change>(changes));
    }

    @Override
    public void updateProgressComponent(@NotNull List<Supplier<JComponent>> progress) {
        if (progress == null) {
            ChangesViewManager.$$$reportNull$$$0(10);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateProgressComponent(progress);
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (groupingKey == null) {
            ChangesViewManager.$$$reportNull$$$0(11);
        }
        if (this.myChangesView == null) {
            return;
        }
        this.myChangesView.setGrouping(groupingKey);
    }

    private void updateCommitWorkflow() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateCommitWorkflow();
    }

    public void closeEditorPreview(boolean onlyIfEmpty) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.closeEditorPreview(onlyIfEmpty);
    }

    @Override
    public void resetViewImmediatelyAndRefreshLater() {
        if (this.myChangesView != null) {
            this.myChangesView.resetViewImmediatelyAndRefreshLater();
        }
    }

    public boolean isDiffPreviewAvailable() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.mySplitterDiffPreview != null || ChangesViewToolWindowPanel.isOpenEditorDiffPreviewWithSingleClick.asBoolean();
    }

    public void diffPreviewChanged(boolean state) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        DiffPreview preview = (DiffPreview)ObjectUtils.chooseNotNull((Object)this.myToolWindowPanel.mySplitterDiffPreview, (Object)((Object)this.myToolWindowPanel.myEditorDiffPreview));
        DiffPreview.setPreviewVisible((DiffPreview)preview, (boolean)state);
        this.myToolWindowPanel.updatePanelLayout();
    }

    @NotNull
    @Nls
    public static String getLocalChangesToolWindowName(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(12);
        }
        String string = ChangesViewContentManagerKt.isCommitToolWindowShown(project) ? VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]) : VcsBundle.message((String)"local.changes.tab", (Object[])new Object[0]);
        if (string == null) {
            ChangesViewManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        return ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
    }

    @ApiStatus.Internal
    @Nullable
    public ChangesViewProxy getChangesView() {
        return this.myChangesView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initChangesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChangesToolWindowName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceEx";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateProgressComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangesToolWindowName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private static final class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final Wrapper myMainPanelContent;
        @NotNull
        private final BorderLayoutPanel myContentPanel;
        @NotNull
        private final ChangesViewProxy myChangesView;
        @NotNull
        private final ChangesViewCommitPanelSplitter myCommitPanelSplitter;
        @NotNull
        private final ChangesViewEditorDiffPreview myEditorDiffPreview;
        @Nullable
        private ChangesViewSplitterDiffPreview mySplitterDiffPreview;
        @NotNull
        private final Wrapper myProgressLabel;
        @Nullable
        private ChangesViewCommitPanel myCommitPanel;
        @Nullable
        private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
        private boolean myDisposed;

        private ChangesViewToolWindowPanel(@NotNull Project project, @NotNull ChangesViewProxy changesView) {
            if (project == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(0);
            }
            if (changesView == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(1);
            }
            super(false, true);
            this.myProgressLabel = new Wrapper();
            this.myDisposed = false;
            this.myProject = project;
            this.myChangesView = changesView;
            this.myChangesView.initPanel();
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            ChangesViewToolWindowPanel.registerShortcuts((JComponent)((Object)this));
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

                public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                    if (id == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (oldValue == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (newValue == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ("vcs.commit.tool.window".equals(id) && oldValue != newValue) {
                        this.configureToolbars();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "id";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "oldValue";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "newValue";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$1";
                    objectArray[2] = "advancedSettingChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.configureToolbars();
            this.myCommitPanelSplitter = new ChangesViewCommitPanelSplitter(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myCommitPanelSplitter);
            this.myCommitPanelSplitter.setFirstComponent(this.myChangesView.getPanel());
            this.myContentPanel = new BorderLayoutPanel();
            this.myContentPanel.addToCenter((Component)((Object)this.myCommitPanelSplitter));
            this.myMainPanelContent = new Wrapper((JComponent)this.myContentPanel);
            BorderLayoutPanel mainPanel2 = JBUI.Panels.simplePanel((Component)this.myMainPanelContent).addToBottom((Component)this.myProgressLabel);
            this.myEditorDiffPreview = new ChangesViewEditorDiffPreview(changesView, (JComponent)this.myContentPanel);
            Disposer.register((Disposable)this, (Disposable)this.myEditorDiffPreview);
            this.setContent((JComponent)mainPanel2);
            ChangesViewContentManagerKt.subscribeOnVcsToolWindowLayoutChanges(busConnection, this::updatePanelLayout);
            this.updatePanelLayout();
        }

        public void dispose() {
            this.myDisposed = true;
            if (this.mySplitterDiffPreview != null) {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
            }
            this.mySplitterDiffPreview = null;
        }

        private void updatePanelLayout() {
            boolean needUpdatePreviews;
            if (this.myDisposed) {
                return;
            }
            boolean isVertical = ChangesViewContentManager.isToolWindowTabVertical(this.myProject, "Local Changes");
            boolean hasSplitterPreview = ChangesViewContentManager.shouldHaveSplitterDiffPreview(this.myProject, isVertical);
            boolean isPreviewPanelShown = hasSplitterPreview && this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
            this.myCommitPanelSplitter.setOrientation(isPreviewPanelShown || isVertical);
            boolean bl = needUpdatePreviews = hasSplitterPreview != (this.mySplitterDiffPreview != null);
            if (!needUpdatePreviews) {
                return;
            }
            if (hasSplitterPreview) {
                this.mySplitterDiffPreview = new ChangesViewSplitterDiffPreview();
                DiffPreview.setPreviewVisible((DiffPreview)this.mySplitterDiffPreview, (boolean)this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            } else {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
                this.mySplitterDiffPreview = null;
            }
        }

        private void closeEditorPreview(boolean onlyIfEmpty) {
            if (onlyIfEmpty && this.myEditorDiffPreview.hasContent()) {
                return;
            }
            this.myEditorDiffPreview.closePreview();
        }

        public void updateCommitWorkflow() {
            if (this.myDisposed) {
                return;
            }
            ChangesViewCommitWorkflowHandler newWorkflowHandler = ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
            if (this.myCommitWorkflowHandler == newWorkflowHandler) {
                return;
            }
            if (newWorkflowHandler != null) {
                ChangesViewCommitPanel newCommitPanel = (ChangesViewCommitPanel)newWorkflowHandler.getUi();
                newCommitPanel.registerRootComponent((JComponent)((Object)this));
                this.myCommitPanelSplitter.setSecondComponent(newCommitPanel.getComponent());
                this.myCommitWorkflowHandler = newWorkflowHandler;
                this.myCommitPanel = newCommitPanel;
            } else {
                this.myCommitPanelSplitter.setSecondComponent(null);
                this.myCommitWorkflowHandler = null;
                this.myCommitPanel = null;
            }
            this.configureToolbars();
        }

        private void configureToolbars() {
            boolean isToolbarHorizontal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode().useCommitToolWindow();
            this.myChangesView.setToolbarHorizontal(isToolbarHorizontal);
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            ActionManager actionManager = ActionManager.getInstance();
            DefaultActionGroup toolbarActionGroup = (DefaultActionGroup)actionManager.getAction("ChangesViewToolbar.Shared");
            List<AnAction> list = Arrays.asList(toolbarActionGroup.getChildren(actionManager));
            if (list == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(3);
            }
            super.uiDataSnapshot(sink);
            sink.set(DiffDataKeys.EDITOR_TAB_DIFF_PREVIEW, (Object)this.myEditorDiffPreview);
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this.myCommitPanel);
        }

        private static void registerShortcuts(@NotNull JComponent component) {
            if (component == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(4);
            }
            ActionUtil.wrap((String)"ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), component);
            ActionUtil.wrap((String)"ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), component);
            ActionUtil.wrap((String)"ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.getDelete(), component);
            ActionUtil.wrap((String)"ChangesView.Move").registerCustomShortcutSet(CommonShortcuts.getMove(), component);
        }

        private void updateProgressComponent(@NotNull List<Supplier<@Nullable JComponent>> progress) {
            if (progress == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(5);
            }
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                @Nullable List components = ContainerUtil.mapNotNull((Collection)progress, it -> (JComponent)it.get());
                if (!components.isEmpty()) {
                    JComponent component = DiffUtil.createStackedComponents((List)components, (JBValue)DiffUtil.TITLE_GAP);
                    this.myProgressLabel.setContent((JComponent)((Object)new FixedSizeScrollPanel(component, (Dimension)new JBDimension(400, 100))));
                } else {
                    this.myProgressLabel.setContent(null);
                }
            });
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), (Runnable)runnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "registerShortcuts";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProgressComponent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private class ChangesViewSplitterDiffPreview
        implements DiffPreview,
        Disposable {
            private final ChangeViewDiffRequestProcessor myProcessor;
            private final PreviewDiffSplitterComponent mySplitterComponent;

            private ChangesViewSplitterDiffPreview() {
                this.myProcessor = ChangesViewToolWindowPanel.this.myChangesView.createDiffPreviewProcessor(false);
                this.mySplitterComponent = new PreviewDiffSplitterComponent((DiffPreviewUpdateProcessor)this.myProcessor, ChangesViewManager.CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION);
                this.mySplitterComponent.setFirstComponent((JComponent)ChangesViewToolWindowPanel.this.myContentPanel);
                ChangesViewToolWindowPanel.this.myMainPanelContent.setContent((JComponent)this.mySplitterComponent);
            }

            public void dispose() {
                Disposer.dispose((Disposable)this.myProcessor);
                if (!ChangesViewToolWindowPanel.this.myDisposed) {
                    ChangesViewToolWindowPanel.this.myMainPanelContent.setContent((JComponent)ChangesViewToolWindowPanel.this.myContentPanel);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return this.mySplitterComponent.openPreview(requestFocus);
            }

            public void closePreview() {
                this.mySplitterComponent.closePreview();
            }
        }
    }

    private static final class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyContentDnDTarget(@NotNull Project project, @NotNull Content content) {
            if (project == null) {
                MyContentDnDTarget.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyContentDnDTarget.$$$reportNull$$$0(1);
            }
            super(project, content);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, null, !ChangesTreeDnDSupport.isCopyAction((DnDEvent)event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyContentDnDTarget.$$$reportNull$$$0(2);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyContentDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project) {
            if (project == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            ChangesViewManager viewManager = (ChangesViewManager)ChangesViewManager.getInstance(this.myProject);
            ChangesViewToolWindowPanel panel = viewManager.initToolWindowPanel();
            content.setHelpId("ideaInterface.changes");
            content.setComponent((JComponent)((Object)panel));
            content.setPreferredFocusableComponent(panel.myChangesView.getPreferredFocusedComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project) {
            return ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss() && !CommitModeManager.getInstance(project).getCurrentCommitMode().hideLocalChangesTab();
        }
    }

    static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        ContentPreloader(@NotNull Project project) {
            if (project == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            new ChangesViewCommitTabTitleUpdater(this.myProject, "Local Changes").init((Disposable)content);
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.myProject, content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @NotNull
        private final Project myProject;

        public DisplayNameSupplier(@NotNull Project project) {
            if (project == null) {
                DisplayNameSupplier.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public String get() {
            return ChangesViewManager.getLocalChangesToolWindowName(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$DisplayNameSupplier", "<init>"));
        }
    }
}

