/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0003\u001d\u001e\u001fB\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0015\u0010\u0017\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00182\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "P", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "Lcom/intellij/openapi/vfs/NonPhysicalFileSystem;", "pathSerializer", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "<init>", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;)V", "findOrCreateFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "path", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Lcom/intellij/openapi/vfs/VirtualFile;", "getPath", "", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Ljava/lang/String;", "getComplexPath", "(Ljava/lang/String;)Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "getComplexPathSafe", "findFileByPath", "refreshAndFindFileByPath", "extractPresentableUrl", "Lorg/jetbrains/annotations/NotNull;", "refresh", "", "asynchronous", "", "ComplexPath", "ComplexPathSerializer", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nComplexPathVirtualFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexPathVirtualFileSystem.kt\ncom/intellij/vcs/editor/ComplexPathVirtualFileSystem\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n*S KotlinDebug\n*F\n+ 1 ComplexPathVirtualFileSystem.kt\ncom/intellij/vcs/editor/ComplexPathVirtualFileSystem\n*L\n64#1:68\n*E\n"})
public abstract class ComplexPathVirtualFileSystem<P extends ComplexPath>
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComplexPathSerializer<P> pathSerializer;
    @NotNull
    private static final Logger LOG;

    public ComplexPathVirtualFileSystem(@NotNull ComplexPathSerializer<P> pathSerializer) {
        Intrinsics.checkNotNullParameter(pathSerializer, (String)"pathSerializer");
        this.pathSerializer = pathSerializer;
    }

    @Nullable
    protected abstract VirtualFile findOrCreateFile(@NotNull Project var1, @NotNull P var2);

    @NotNull
    public final String getPath(@NotNull P path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return this.pathSerializer.serialize(path);
    }

    private final P getComplexPath(String path) {
        return this.pathSerializer.deserialize(path);
    }

    private final P getComplexPathSafe(String path) {
        P p;
        try {
            p = this.getComplexPath(path);
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize " + path, (Throwable)e);
            return null;
        }
        return p;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        P p = this.getComplexPathSafe(path);
        if (p == null) {
            return null;
        }
        P parsedPath = p;
        Project project = ProjectManagerEx.Companion.getInstanceEx().findOpenProjectByHash(parsedPath.getProjectHash());
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return this.findOrCreateFile(project2, parsedPath);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = this.refreshAndFindFileByPath(path);
        Object object = virtualFile instanceof VirtualFilePathWrapper ? (VirtualFilePathWrapper)virtualFile : null;
        if (object == null || (object = object.getPresentablePath()) == null) {
            object = path;
        }
        return object;
    }

    public void refresh(boolean asynchronous) {
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComplexPathVirtualFileSystem.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "", "sessionId", "", "getSessionId", "()Ljava/lang/String;", "projectHash", "getProjectHash", "intellij.platform.vcs.impl"})
    public static interface ComplexPath {
        @NotNull
        public String getSessionId();

        @NotNull
        public String getProjectHash();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "P", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "", "serialize", "", "path", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Ljava/lang/String;", "deserialize", "rawPath", "(Ljava/lang/String;)Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "intellij.platform.vcs.impl"})
    public static interface ComplexPathSerializer<P extends ComplexPath> {
        @NotNull
        public String serialize(@NotNull P var1);

        @NotNull
        public P deserialize(@NotNull String var1);
    }
}

