/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.ext.tool.file.render;

import ai.koog.agents.ext.tool.file.model.FileSize;
import ai.koog.agents.ext.tool.file.model.FileSystemEntry;
import ai.koog.prompt.text.TextContentBuilder;
import ai.koog.rag.base.files.FileMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0006\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u001a \u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u001a \u0010\r\u001a\u00020\u0007*\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\"\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010\u001c\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\u001e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u000e\u0010 \u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"FOLDER_INDENTATION", "", "CODE_EXTENSIONS", "", "LANGUAGE_ID_MAPPINGS", "", "entry", "", "Lai/koog/prompt/text/TextContentBuilder;", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry;", "parent", "folder", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$Folder;", "file", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$File;", "norm", "calculateDisplayPath", "path", "name", "buildFileMetadata", "", "renderFolderEntries", "renderFileContent", "content", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$File$Content;", "extension", "renderExcerptContent", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$File$Content$Excerpt;", "renderTextContent", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$File$Content$Text;", "codeBlock", "text", "toLanguageId", "agents-ext"})
@SourceDebugExtension(value={"SMAP\nText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Text.kt\nai/koog/agents/ext/tool/file/render/TextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1#2:172\n1869#3,2:173\n1869#3,2:175\n*S KotlinDebug\n*F\n+ 1 Text.kt\nai/koog/agents/ext/tool/file/render/TextKt\n*L\n142#1:173,2\n120#1:175,2\n*E\n"})
public final class TextKt {
    @NotNull
    private static final String FOLDER_INDENTATION = "  ";
    @NotNull
    private static final Set<String> CODE_EXTENSIONS;
    @NotNull
    private static final Map<String, String> LANGUAGE_ID_MAPPINGS;

    public static final void entry(@NotNull TextContentBuilder $this$entry, @NotNull FileSystemEntry entry, @Nullable FileSystemEntry parent) {
        Intrinsics.checkNotNullParameter((Object)$this$entry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        FileSystemEntry fileSystemEntry = entry;
        if (fileSystemEntry instanceof FileSystemEntry.File) {
            TextKt.file($this$entry, (FileSystemEntry.File)entry, parent);
        } else if (fileSystemEntry instanceof FileSystemEntry.Folder) {
            TextKt.folder($this$entry, (FileSystemEntry.Folder)entry, parent);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void entry$default(TextContentBuilder textContentBuilder, FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry2 = null;
        }
        TextKt.entry(textContentBuilder, fileSystemEntry, fileSystemEntry2);
    }

    public static final void folder(@NotNull TextContentBuilder $this$folder, @NotNull FileSystemEntry.Folder folder, @Nullable FileSystemEntry parent) {
        FileSystemEntry fileSystemEntry;
        Intrinsics.checkNotNullParameter((Object)$this$folder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        List<FileSystemEntry> list2 = folder.getEntries();
        if (list2 != null && (fileSystemEntry = (FileSystemEntry)CollectionsKt.singleOrNull(list2)) != null) {
            FileSystemEntry singleEntry = fileSystemEntry;
            boolean bl = false;
            TextKt.entry($this$folder, singleEntry, parent);
            return;
        }
        String displayPath = TextKt.calculateDisplayPath(folder.getPath(), folder.getName(), parent);
        String metadataSuffix = folder.getHidden() ? " (hidden)" : "";
        $this$folder.unaryPlus(displayPath + "/" + metadataSuffix);
        TextKt.renderFolderEntries($this$folder, folder);
    }

    public static /* synthetic */ void folder$default(TextContentBuilder textContentBuilder, FileSystemEntry.Folder folder, FileSystemEntry fileSystemEntry, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry = null;
        }
        TextKt.folder(textContentBuilder, folder, fileSystemEntry);
    }

    public static final void file(@NotNull TextContentBuilder $this$file, @NotNull FileSystemEntry.File file, @Nullable FileSystemEntry parent) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String displayPath = TextKt.calculateDisplayPath(file.getPath(), file.getName(), parent);
        List<String> metadata2 = TextKt.buildFileMetadata(file);
        $this$file.unaryPlus(displayPath + " (" + CollectionsKt.joinToString$default((Iterable)metadata2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")");
        TextKt.renderFileContent($this$file, file.getContent(), file.getExtension());
    }

    public static /* synthetic */ void file$default(TextContentBuilder textContentBuilder, FileSystemEntry.File file, FileSystemEntry fileSystemEntry, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry = null;
        }
        TextKt.file(textContentBuilder, file, fileSystemEntry);
    }

    @NotNull
    public static final String norm(@NotNull String $this$norm) {
        Intrinsics.checkNotNullParameter((Object)$this$norm, (String)"<this>");
        return StringsKt.replace$default((String)$this$norm, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    private static final String calculateDisplayPath(String path, String name, FileSystemEntry parent) {
        String string;
        if (parent == null) {
            string = TextKt.norm(path);
        } else {
            Object object;
            Object object2 = new char[]{'/', '\\'};
            object2 = StringsKt.trimStart((String)StringsKt.removePrefix((String)path, (CharSequence)parent.getPath()), (char[])object2);
            if (object2.length() == 0) {
                boolean bl = false;
                object = name;
            } else {
                object = object2;
            }
            String rel = (String)object;
            string = TextKt.norm(rel);
        }
        return string;
    }

    private static final List<String> buildFileMetadata(FileSystemEntry.File file) {
        List list2;
        List $this$buildFileMetadata_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (file.getContentType() != FileMetadata.FileContentType.Text) {
            $this$buildFileMetadata_u24lambda_u243.add(file.getContentType().getDisplay());
        }
        $this$buildFileMetadata_u24lambda_u243.add(CollectionsKt.joinToString$default((Iterable)file.getSize(), (CharSequence)", ", null, null, (int)0, null, TextKt::buildFileMetadata$lambda$3$lambda$2, (int)30, null));
        if (file.getHidden()) {
            $this$buildFileMetadata_u24lambda_u243.add("hidden");
        }
        return CollectionsKt.build((List)list2);
    }

    private static final void renderFolderEntries(TextContentBuilder $this$renderFolderEntries, FileSystemEntry.Folder folder) {
        List<FileSystemEntry> entries = folder.getEntries();
        Collection collection = entries;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        $this$renderFolderEntries.padding(FOLDER_INDENTATION, (Function1<TextContentBuilder, Unit>)((Function1)arg_0 -> TextKt.renderFolderEntries$lambda$5(entries, folder, arg_0)));
    }

    private static final void renderFileContent(TextContentBuilder $this$renderFileContent, FileSystemEntry.File.Content content, String extension) {
        FileSystemEntry.File.Content content2 = content;
        if (content2 instanceof FileSystemEntry.File.Content.Excerpt) {
            TextKt.renderExcerptContent($this$renderFileContent, (FileSystemEntry.File.Content.Excerpt)content, extension);
        } else if (content2 instanceof FileSystemEntry.File.Content.Text) {
            TextKt.renderTextContent($this$renderFileContent, (FileSystemEntry.File.Content.Text)content, extension);
        } else if (!Intrinsics.areEqual((Object)content2, (Object)FileSystemEntry.File.Content.None.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void renderExcerptContent(TextContentBuilder $this$renderExcerptContent, FileSystemEntry.File.Content.Excerpt content, String extension) {
        if (content.getSnippets().isEmpty()) {
            $this$renderExcerptContent.unaryPlus("(No excerpt)");
            return;
        }
        $this$renderExcerptContent.unaryPlus("Excerpt:");
        Iterable $this$forEach$iv = content.getSnippets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSystemEntry.File.Content.Excerpt.Snippet snippet = (FileSystemEntry.File.Content.Excerpt.Snippet)element$iv;
            boolean bl = false;
            $this$renderExcerptContent.unaryPlus("Lines " + snippet.getRange().getStart().getLine() + "-" + snippet.getRange().getEnd().getLine() + ":");
            TextKt.codeBlock($this$renderExcerptContent, ((Object)StringsKt.trim((CharSequence)snippet.getText())).toString(), extension);
        }
    }

    private static final void renderTextContent(TextContentBuilder $this$renderTextContent, FileSystemEntry.File.Content.Text content, String extension) {
        $this$renderTextContent.unaryPlus("Content:");
        TextKt.codeBlock($this$renderTextContent, ((Object)StringsKt.trim((CharSequence)content.getText())).toString(), extension);
    }

    private static final void codeBlock(TextContentBuilder $this$codeBlock, String text, String extension) {
        String string;
        Iterable iterable = CODE_EXTENSIONS;
        String string2 = extension;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        if (CollectionsKt.contains((Iterable)iterable, (Object)string)) {
            $this$codeBlock.unaryPlus("```" + TextKt.toLanguageId(extension));
            $this$codeBlock.unaryPlus(text);
            $this$codeBlock.unaryPlus("```");
        } else {
            $this$codeBlock.unaryPlus(text);
        }
    }

    static /* synthetic */ void codeBlock$default(TextContentBuilder textContentBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        TextKt.codeBlock(textContentBuilder, string, string2);
    }

    private static final String toLanguageId(String $this$toLanguageId) {
        String string;
        block5: {
            block4: {
                string = $this$toLanguageId;
                if (string == null) break block4;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block5;
            }
            return "";
        }
        String lowercase = string;
        String string3 = LANGUAGE_ID_MAPPINGS.get(lowercase);
        if (string3 == null) {
            string3 = lowercase;
        }
        return string3;
    }

    private static final CharSequence buildFileMetadata$lambda$3$lambda$2(FileSize it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.display();
    }

    private static final Unit renderFolderEntries$lambda$5(List $entries, FileSystemEntry.Folder $folder, TextContentBuilder $this$padding) {
        Intrinsics.checkNotNullParameter((Object)$this$padding, (String)"$this$padding");
        Iterable $this$forEach$iv = $entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSystemEntry it = (FileSystemEntry)element$iv;
            boolean bl = false;
            TextKt.entry($this$padding, it, $folder);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"kt", "java", "js", "ts", "py", "cpp", "c", "h", "hpp", "cs", "cxx", "cc", "go", "rs", "php", "rb", "swift", "scala", "sh", "bash", "sql", "r", "html", "css", "xml", "json", "yaml", "yml", "toml", "md", "dockerfile", "gradle", "properties", "conf", "ini", "cfg", "makefile", "cmake", "dart", "lua", "perl", "powershell", "ps1", "bat", "cmd", "vim"};
        CODE_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"kt", (Object)"kotlin"), TuplesKt.to((Object)"js", (Object)"javascript"), TuplesKt.to((Object)"ts", (Object)"typescript"), TuplesKt.to((Object)"py", (Object)"python"), TuplesKt.to((Object)"sh", (Object)"bash"), TuplesKt.to((Object)"yml", (Object)"yaml"), TuplesKt.to((Object)"cpp", (Object)"cpp"), TuplesKt.to((Object)"cxx", (Object)"cpp"), TuplesKt.to((Object)"cc", (Object)"cpp"), TuplesKt.to((Object)"hpp", (Object)"cpp"), TuplesKt.to((Object)"cs", (Object)"csharp"), TuplesKt.to((Object)"ps1", (Object)"powershell"), TuplesKt.to((Object)"md", (Object)"markdown"), TuplesKt.to((Object)"rb", (Object)"ruby"), TuplesKt.to((Object)"dockerfile", (Object)"docker"), TuplesKt.to((Object)"gradle", (Object)"groovy"), TuplesKt.to((Object)"bat", (Object)"batch"), TuplesKt.to((Object)"cmd", (Object)"batch")};
        LANGUAGE_ID_MAPPINGS = MapsKt.mapOf((Pair[])objectArray);
    }
}

