/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.structure.json.generator;

import ai.koog.prompt.structure.json.generator.JsonSchemaGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\u00020\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0017"}, d2={"Lai/koog/prompt/structure/json/generator/GenericJsonSchemaGenerator;", "Lai/koog/prompt/structure/json/generator/JsonSchemaGenerator;", "<init>", "()V", "process", "Lkotlinx/serialization/json/JsonObject;", "context", "Lai/koog/prompt/structure/json/generator/JsonSchemaGenerator$GenerationContext;", "putDescription", "", "Lkotlinx/serialization/json/JsonObjectBuilder;", "description", "", "processString", "processBoolean", "processInteger", "processNumber", "processEnum", "processList", "processMap", "processObject", "processClassDiscriminator", "processPolymorphic", "prompt-structure"})
@SourceDebugExtension(value={"SMAP\nGenericJsonSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericJsonSchemaGenerator.kt\nai/koog/prompt/structure/json/generator/GenericJsonSchemaGenerator\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,215:1\n29#2,3:216\n29#2,3:219\n29#2,3:222\n29#2,3:225\n29#2,2:228\n31#2:234\n29#2,3:235\n29#2,3:238\n29#2,3:245\n52#2,3:248\n29#2,3:251\n29#2,2:254\n31#2:258\n1563#3:230\n1634#3,3:231\n1563#3:241\n1634#3,3:242\n216#4,2:256\n*S KotlinDebug\n*F\n+ 1 GenericJsonSchemaGenerator.kt\nai/koog/prompt/structure/json/generator/GenericJsonSchemaGenerator\n*L\n71#1:216,3\n76#1:219,3\n81#1:222,3\n86#1:225,3\n91#1:228,2\n91#1:234\n101#1:235,3\n110#1:238,3\n148#1:245,3\n178#1:248,3\n188#1:251,3\n201#1:254,2\n201#1:258\n95#1:230\n95#1:231,3\n139#1:241\n139#1:242,3\n202#1:256,2\n*E\n"})
public abstract class GenericJsonSchemaGenerator
extends JsonSchemaGenerator {
    @Override
    @NotNull
    protected JsonObject process(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SerialKind serialKind = context.getDescriptor().getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.STRING.INSTANCE)) {
            jsonObject = this.processString(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BOOLEAN.INSTANCE)) {
            jsonObject = this.processBoolean(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BYTE.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.SHORT.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.INT.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.LONG.INSTANCE)) {
            jsonObject = this.processInteger(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.FLOAT.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.DOUBLE.INSTANCE)) {
            jsonObject = this.processNumber(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
            jsonObject = this.processEnum(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            jsonObject = this.processList(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            jsonObject = this.processMap(context);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            jsonObject = this.processObject(context);
        } else if (serialKind instanceof PolymorphicKind) {
            jsonObject = this.processPolymorphic(context);
        } else {
            throw new IllegalArgumentException("Encountered unsupported type while generating JSON schema: " + context.getDescriptor().getKind());
        }
        return jsonObject;
    }

    protected final void putDescription(@NotNull JsonObjectBuilder $this$putDescription, @Nullable String description) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$putDescription, (String)"<this>");
            String string = description;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$putDescription, (String)"description", (String)it);
        }
    }

    @Override
    @NotNull
    protected JsonObject processString(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processString_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processString_u24lambda_u241, (String)"type", (String)"string");
        this.putDescription($this$processString_u24lambda_u241, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processBoolean(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processBoolean_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processBoolean_u24lambda_u242, (String)"type", (String)"boolean");
        this.putDescription($this$processBoolean_u24lambda_u242, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processInteger(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processInteger_u24lambda_u243 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processInteger_u24lambda_u243, (String)"type", (String)"integer");
        this.putDescription($this$processInteger_u24lambda_u243, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processNumber(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processNumber_u24lambda_u244 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processNumber_u24lambda_u244, (String)"type", (String)"number");
        this.putDescription($this$processNumber_u24lambda_u244, context.getCurrentDescription());
        return builder$iv.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JsonObject processEnum(@NotNull JsonSchemaGenerator.GenerationContext context) {
        Collection<JsonPrimitive> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processEnum_u24lambda_u246 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processEnum_u24lambda_u246, (String)"type", (String)"string");
        Iterable iterable = SerialDescriptorKt.getElementNames((SerialDescriptor)context.getDescriptor());
        String string = "enum";
        JsonObjectBuilder jsonObjectBuilder = $this$processEnum_u24lambda_u246;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(JsonElementKt.JsonPrimitive((String)it));
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        jsonObjectBuilder.put(string, (JsonElement)new JsonArray(list2));
        this.putDescription($this$processEnum_u24lambda_u246, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processList(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processList_u24lambda_u247 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        SerialDescriptor itemDescriptor = context.getDescriptor().getElementDescriptor(0);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processList_u24lambda_u247, (String)"type", (String)"array");
        $this$processList_u24lambda_u247.put("items", (JsonElement)this.process(JsonSchemaGenerator.GenerationContext.copy$default(context, null, itemDescriptor, null, null, null, null, null, 61, null)));
        this.putDescription($this$processList_u24lambda_u247, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processMap(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processMap_u24lambda_u249 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        SerialDescriptor keyDescriptor = context.getDescriptor().getElementDescriptor(0);
        SerialDescriptor valueDescriptor = context.getDescriptor().getElementDescriptor(1);
        if (!Intrinsics.areEqual((Object)keyDescriptor.getKind(), (Object)PrimitiveKind.STRING.INSTANCE)) {
            boolean bl2 = false;
            String string = "JSON schema only supports string keys in maps, found: " + keyDescriptor.getSerialName();
            throw new IllegalArgumentException(string.toString());
        }
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$processMap_u24lambda_u249, (String)"type", (String)"object");
        $this$processMap_u24lambda_u249.put("additionalProperties", (JsonElement)this.process(JsonSchemaGenerator.GenerationContext.copy$default(context, null, valueDescriptor, null, null, null, null, null, 61, null)));
        this.putDescription($this$processMap_u24lambda_u249, context.getCurrentDescription());
        return builder$iv.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JsonObject processObject(@NotNull JsonSchemaGenerator.GenerationContext context) {
        JsonObjectBuilder builder$iv;
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!context.getCurrentDefPath().contains(context.getDescriptor()))) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$a$-check-GenericJsonSchemaGenerator$processObject$22 = false;
            Iterable iterable = context.getCurrentDefPath();
            String string = context.getDescriptor().getSerialName();
            String string2 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
            boolean $i$f$map = false;
            void var8_21 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SerialDescriptor serialDescriptor = (SerialDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSerialName());
            }
            collection = (List)destination$iv$iv;
            String $i$a$-check-GenericJsonSchemaGenerator$processObject$22 = StringsKt.trimIndent((String)("\n            Recursion detected in type definitions while generating JSON schema.\n            This usually means you have recursive type where one of the fields in a class has a type of this class itself\n            or its base class when using " + string2 + " generator, which is not supported by this generator.\n            \n            Consider some possible solutions:\n            1. Use other JSON schema generator that supports such classes and if the format it produces is supported by the LLM you're using.\n            2. Remove recursive type references.\n            \n            Current definition is " + string + " at path " + (List)collection + "\n            "));
            throw new IllegalStateException($i$a$-check-GenericJsonSchemaGenerator$processObject$22.toString());
        }
        if (context.getProcessedTypeDefs().containsKey(context.getDescriptor())) {
            jsonObject = (JsonObject)MapsKt.getValue(context.getProcessedTypeDefs(), (Object)context.getDescriptor());
        } else {
            JsonArrayBuilder builder$iv2;
            JsonObjectBuilder builder$iv3;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$processObject_u24lambda_u2412 = builder$iv3 = new JsonObjectBuilder();
            boolean bl = false;
            int destination$iv$iv = context.getDescriptor().getElementsCount();
            for (int i = 0; i < destination$iv$iv; ++i) {
                String propertyName = context.getDescriptor().getElementName(i);
                SerialDescriptor propertyDescriptor = context.getDescriptor().getElementDescriptor(i);
                String lookupKey = context.getDescriptor().getSerialName() + "." + propertyName;
                if (context.getExcludedProperties().contains(lookupKey)) {
                    if (context.getDescriptor().isElementOptional(i)) continue;
                    throw new IllegalArgumentException("Property '" + lookupKey + "' is marked as excluded, but it is required in the schema.");
                }
                List list2 = CollectionsKt.plus((Collection)context.getCurrentDefPath(), (Object)context.getDescriptor());
                String string = context.getElementDescription(i);
                if (string == null) {
                    string = JsonSchemaGenerator.GenerationContext.copy$default(context, null, propertyDescriptor, null, null, null, null, null, 125, null).getTypeDescription();
                }
                $this$processObject_u24lambda_u2412.put(propertyName, (JsonElement)this.process(JsonSchemaGenerator.GenerationContext.copy$default(context, null, propertyDescriptor, null, list2, null, null, string, 53, null)));
            }
            JsonObject properties = builder$iv3.build();
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder $this$processObject_u24lambda_u2413 = builder$iv2 = new JsonArrayBuilder();
            boolean bl2 = false;
            int propertyName = context.getDescriptor().getElementsCount();
            for (int i = 0; i < propertyName; ++i) {
                if (context.getDescriptor().isElementOptional(i)) continue;
                JsonElementBuildersKt.add((JsonArrayBuilder)$this$processObject_u24lambda_u2413, (String)context.getDescriptor().getElementName(i));
            }
            JsonArray required = builder$iv2.build();
            boolean $i$f$buildJsonObject2 = false;
            JsonArrayBuilder $this$processObject_u24lambda_u2414 = builder$iv2 = new JsonObjectBuilder();
            boolean bl3 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$processObject_u24lambda_u2414, (String)"type", (String)"object");
            $this$processObject_u24lambda_u2414.put("properties", (JsonElement)properties);
            $this$processObject_u24lambda_u2414.put("required", (JsonElement)required);
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$processObject_u24lambda_u2414, (String)"additionalProperties", (Boolean)false);
            JsonObject it = $i$f$buildJsonObject2 = builder$iv2.build();
            boolean bl4 = false;
            context.getProcessedTypeDefs().put(context.getDescriptor(), it);
            jsonObject = $i$f$buildJsonObject2;
        }
        JsonObject schema = jsonObject;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$processObject_u24lambda_u2417 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = (Map)schema;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl5 = false;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            $this$processObject_u24lambda_u2417.put(key, value);
        }
        this.putDescription($this$processObject_u24lambda_u2417, context.getCurrentDescription());
        return builder$iv.build();
    }

    @Override
    @NotNull
    protected JsonObject processClassDiscriminator(@NotNull JsonSchemaGenerator.GenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new UnsupportedOperationException("Class discriminator is not supported by " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " generator");
    }

    @Override
    @NotNull
    protected JsonObject processPolymorphic(@NotNull JsonSchemaGenerator.GenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new UnsupportedOperationException("Polymorphic types are not supported by " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " generator");
    }
}

