/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"canBeConvertedToJUnit5", "", "aClass", "Lcom/intellij/psi/PsiClass;", "ruleAnnotations", "", "", "intellij.junit"})
public final class JUnit5ConverterInspectionKt {
    @NotNull
    private static final List<String> ruleAnnotations;

    public static final boolean canBeConvertedToJUnit5(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)aClass), (String)"org.junit.runner.RunWith", (int)1)) {
            return false;
        }
        PsiField[] psiFieldArray = aClass.getAllFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getAllFields(...)");
        PsiField[] psiFieldArray2 = psiFieldArray;
        int n = psiFieldArray2.length;
        for (int i = 0; i < n; ++i) {
            PsiField psiField;
            PsiField psiField2 = psiField = psiFieldArray2[i];
            Intrinsics.checkNotNull((Object)psiField2);
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiField2), (Collection)ruleAnnotations, (int)0)) continue;
            return false;
        }
        PsiMethod[] psiMethodArray = aClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        for (PsiField psiField : psiMethodArray) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiField), (Collection)ruleAnnotations, (int)0)) {
                return false;
            }
            String[] stringArray = new String[]{"org.junit.Test"};
            PsiAnnotation testAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiField), (boolean)true, (String[])stringArray);
            if (testAnnotation == null) continue;
            PsiNameValuePair[] psiNameValuePairArray = testAnnotation.getParameterList().getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
            if (!(!(((Object[])psiNameValuePairArray).length == 0))) continue;
            return false;
        }
        return true;
    }

    static {
        Object[] objectArray = new String[]{"org.junit.Rule", "org.junit.ClassRule"};
        ruleAnnotations = CollectionsKt.listOf((Object[])objectArray);
    }
}

