/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002J\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0003J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J&\u0010\u001e\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/junit/codeInspection/MigrateToAssertThatQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "matcherClassFqn", "", "importMemberOnDemand", "", "<init>", "(Ljava/lang/String;Z)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createAssertThat", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/generate/UastElementFactory;", "params", "", "createMatchExpression", "name", "parameter", "isPrimitiveType", "createIdEqualsExpression", "param", "inverse", "Lorg/jetbrains/uast/UastBinaryOperator;", "normalize", "methodName", "buildMatchExpression", "operator", "receiver", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nHamcrestAssertionsConverterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HamcrestAssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/MigrateToAssertThatQuickFix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n207#2:219\n43#3:220\n19#4:221\n19#4:230\n19#4:231\n19#4:232\n244#5,6:222\n251#5:229\n13#6:228\n*S KotlinDebug\n*F\n+ 1 HamcrestAssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/MigrateToAssertThatQuickFix\n*L\n87#1:219\n91#1:220\n105#1:221\n151#1:230\n154#1:231\n155#1:232\n151#1:222,6\n151#1:229\n151#1:228\n*E\n"})
final class MigrateToAssertThatQuickFix
implements LocalQuickFix {
    @NotNull
    private final String matcherClassFqn;
    private final boolean importMemberOnDemand;

    public MigrateToAssertThatQuickFix(@NotNull String matcherClassFqn, boolean importMemberOnDemand) {
        Intrinsics.checkNotNullParameter((Object)matcherClassFqn, (String)"matcherClassFqn");
        this.matcherClassFqn = matcherClassFqn;
        this.importMemberOnDemand = importMemberOnDemand;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{"assertThat()"};
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block70: {
            UExpression replaced;
            UExpression uExpression;
            block72: {
                block71: {
                    UElement uElement;
                    void $this$replace$iv;
                    UElement matchExpression;
                    Object[] conditionMethodName;
                    Pair pair;
                    PsiElement element;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    PsiElement psiElement = descriptor.getPsiElement();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement $this$getUastParentOfType_u24default$iv = element = psiElement;
                    boolean strict$iv = false;
                    boolean $i$f$getUastParentOfType = false;
                    UCallExpression uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
                    if (uCallExpression == null) {
                        return;
                    }
                    UCallExpression call = uCallExpression;
                    UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)call), (Project)project);
                    if (uastElementFactory == null) {
                        return;
                    }
                    UastElementFactory factory = uastElementFactory;
                    String string = call.getMethodName();
                    if (string == null) {
                        return;
                    }
                    String methodName = string;
                    List arguments = CollectionsKt.toMutableList((Collection)call.getValueArguments());
                    UResolvable $this$resolveToUElementOfType$iv = (UResolvable)call;
                    boolean $i$f$resolveToUElementOfType = false;
                    UElement uElement2 = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                    if (!(uElement2 instanceof UMethod)) {
                        uElement2 = null;
                    }
                    UMethod uMethod = (UMethod)((UElement)((UMethod)uElement2));
                    if (uMethod == null) {
                        return;
                    }
                    UMethod method = uMethod;
                    UExpression message = TypeUtils.typeEquals((String)"java.lang.String", (PsiType)((UParameter)CollectionsKt.first((List)method.getUastParameters())).getType()) ? (UExpression)arguments.removeFirst() : null;
                    switch (methodName) {
                        case "assertTrue": 
                        case "assertFalse": {
                            UExpression uExpression2 = (UExpression)CollectionsKt.lastOrNull((List)arguments);
                            if (uExpression2 == null) {
                                return;
                            }
                            UExpression conditionArgument = uExpression2;
                            UExpression uExpression3 = conditionArgument;
                            if (uExpression3 instanceof UBinaryExpression) {
                                UastBinaryOperator operator = this.normalize(((UBinaryExpression)conditionArgument).getOperator(), methodName);
                                UExpression uExpression4 = this.buildMatchExpression(factory, operator, ((UBinaryExpression)conditionArgument).getRightOperand());
                                if (uExpression4 == null) {
                                    return;
                                }
                                UExpression matchExpression2 = uExpression4;
                                pair = TuplesKt.to((Object)((UBinaryExpression)conditionArgument).getLeftOperand(), (Object)matchExpression2);
                                break;
                            }
                            if (uExpression3 instanceof UQualifiedReferenceExpression) {
                                UExpression $this$asSafely$iv = ((UQualifiedReferenceExpression)conditionArgument).getSelector();
                                boolean $i$f$asSafely = false;
                                UExpression uExpression5 = $this$asSafely$iv;
                                if (!(uExpression5 instanceof UCallExpression)) {
                                    uExpression5 = null;
                                }
                                UCallExpression uCallExpression2 = (UCallExpression)uExpression5;
                                if (uCallExpression2 == null) {
                                    return;
                                }
                                UCallExpression conditionCall = uCallExpression2;
                                String string2 = conditionCall.getMethodName();
                                if (string2 == null) {
                                    return;
                                }
                                conditionMethodName = string2;
                                UExpression uExpression6 = StringsKt.contains$default((CharSequence)methodName, (CharSequence)"False", (boolean)false, (int)2, null) ? this.createMatchExpression(factory, "not", this.buildMatchExpression(factory, (String)conditionMethodName, ((UQualifiedReferenceExpression)conditionArgument).getReceiver(), (UExpression)CollectionsKt.first((List)conditionCall.getValueArguments()))) : this.buildMatchExpression(factory, (String)conditionMethodName, ((UQualifiedReferenceExpression)conditionArgument).getReceiver(), (UExpression)CollectionsKt.first((List)conditionCall.getValueArguments()));
                                if (uExpression6 == null) {
                                    return;
                                }
                                matchExpression = uExpression6;
                                pair = TuplesKt.to((Object)((UQualifiedReferenceExpression)conditionArgument).getReceiver(), (Object)matchExpression);
                                break;
                            }
                            return;
                        }
                        case "assertEquals": 
                        case "assertArrayEquals": {
                            UExpression uExpression7 = this.createMatchExpression(factory, "is", (UExpression)CollectionsKt.first((List)arguments));
                            if (uExpression7 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression7;
                            pair = TuplesKt.to((Object)CollectionsKt.last((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        case "assertNotEquals": {
                            UExpression uExpression8 = this.createMatchExpression(factory, "not", this.createMatchExpression(factory, "is", (UExpression)CollectionsKt.first((List)arguments)));
                            if (uExpression8 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression8;
                            pair = TuplesKt.to((Object)CollectionsKt.last((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        case "assertSame": {
                            UExpression uExpression9 = this.createMatchExpression(factory, "sameInstance", (UExpression)CollectionsKt.first((List)arguments));
                            if (uExpression9 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression9;
                            pair = TuplesKt.to((Object)CollectionsKt.last((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        case "assertNotSame": {
                            UExpression uExpression10 = this.createMatchExpression(factory, "not", this.createMatchExpression(factory, "sameInstance", (UExpression)CollectionsKt.first((List)arguments)));
                            if (uExpression10 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression10;
                            pair = TuplesKt.to((Object)CollectionsKt.last((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        case "assertNull": {
                            UExpression uExpression11 = MigrateToAssertThatQuickFix.createMatchExpression$default(this, factory, "nullValue", null, 2, null);
                            if (uExpression11 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression11;
                            pair = TuplesKt.to((Object)CollectionsKt.first((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        case "assertNotNull": {
                            UExpression uExpression12 = MigrateToAssertThatQuickFix.createMatchExpression$default(this, factory, "notNullValue", null, 2, null);
                            if (uExpression12 == null) {
                                return;
                            }
                            UExpression matchExpression3 = uExpression12;
                            pair = TuplesKt.to((Object)CollectionsKt.first((List)arguments), (Object)matchExpression3);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Pair pair2 = pair;
                    UExpression left = (UExpression)pair2.component1();
                    UExpression right = (UExpression)pair2.component2();
                    if (!this.importMemberOnDemand) break block70;
                    conditionMethodName = new UExpression[]{message, left, right};
                    UExpression uExpression13 = this.createAssertThat(factory, CollectionsKt.listOfNotNull((Object[])conditionMethodName));
                    if (uExpression13 == null) {
                        return;
                    }
                    UExpression assertThatCall = uExpression13;
                    matchExpression = (UElement)UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)call));
                    UElement newElement$iv = (UElement)assertThatCall;
                    boolean $i$f$replace = false;
                    if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                        uElement = newElement$iv;
                    } else {
                        UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                        UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UExpression.class) : null;
                        boolean bl = false;
                        if (it$iv == null) {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                        }
                        uElement = uastCodeGenerationPlugin;
                    }
                    if ((uExpression = (UExpression)uElement) == null) break block71;
                    UExpression $this$asSafely$iv = uExpression;
                    boolean $i$f$asSafely = false;
                    UExpression uExpression14 = $this$asSafely$iv;
                    if (!(uExpression14 instanceof UQualifiedReferenceExpression)) {
                        uExpression14 = null;
                    }
                    if ((uExpression = (UQualifiedReferenceExpression)uExpression14) != null) break block72;
                }
                return;
            }
            UExpression toImport = replaced = uExpression;
            while (true) {
                UExpression uExpression15;
                block76: {
                    block75: {
                        boolean $i$f$asSafely;
                        UExpression $this$asSafely$iv;
                        UExpression uExpression16;
                        block74: {
                            block73: {
                                if ((uExpression16 = UastCodeGenerationPluginKt.importMemberOnDemand((UQualifiedReferenceExpression)toImport)) == null) break block73;
                                $this$asSafely$iv = uExpression16;
                                $i$f$asSafely = false;
                                UExpression uExpression17 = $this$asSafely$iv;
                                if (!(uExpression17 instanceof UCallExpression)) {
                                    uExpression17 = null;
                                }
                                if ((uExpression16 = (UCallExpression)uExpression17) != null) break block74;
                            }
                            return;
                        }
                        UExpression imported = uExpression16;
                        uExpression15 = (UExpression)CollectionsKt.lastOrNull((List)imported.getValueArguments());
                        if (uExpression15 == null) break block75;
                        $this$asSafely$iv = uExpression15;
                        $i$f$asSafely = false;
                        UExpression uExpression18 = $this$asSafely$iv;
                        if (!(uExpression18 instanceof UQualifiedReferenceExpression)) {
                            uExpression18 = null;
                        }
                        if ((uExpression15 = (UQualifiedReferenceExpression)uExpression18) != null) break block76;
                    }
                    return;
                }
                toImport = uExpression15;
            }
        }
    }

    private final UExpression createAssertThat(UastElementFactory $this$createAssertThat, List<? extends UExpression> params) {
        UQualifiedReferenceExpression uQualifiedReferenceExpression = $this$createAssertThat.createQualifiedReference("org.hamcrest.MatcherAssert", null);
        if (uQualifiedReferenceExpression == null) {
            return null;
        }
        UQualifiedReferenceExpression matchAssert = uQualifiedReferenceExpression;
        UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)$this$createAssertThat, (UExpression)((UExpression)matchAssert), (String)"assertThat", params, null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
        return uCallExpression != null ? UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)uCallExpression)) : null;
    }

    private final UExpression createMatchExpression(UastElementFactory $this$createMatchExpression, String name, UExpression parameter) {
        UExpression uExpression = parameter;
        List paramList = uExpression == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)uExpression);
        UQualifiedReferenceExpression uQualifiedReferenceExpression = $this$createMatchExpression.createQualifiedReference(this.matcherClassFqn, null);
        if (uQualifiedReferenceExpression == null) {
            return null;
        }
        UQualifiedReferenceExpression matcher = uQualifiedReferenceExpression;
        UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)$this$createMatchExpression, (UExpression)((UExpression)matcher), (String)name, (List)paramList, null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
        return uCallExpression != null ? UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)uCallExpression)) : null;
    }

    static /* synthetic */ UExpression createMatchExpression$default(MigrateToAssertThatQuickFix migrateToAssertThatQuickFix, UastElementFactory uastElementFactory, String string, UExpression uExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uExpression = null;
        }
        return migrateToAssertThatQuickFix.createMatchExpression(uastElementFactory, string, uExpression);
    }

    private final boolean isPrimitiveType(UExpression $this$isPrimitiveType) {
        return $this$isPrimitiveType.getExpressionType() instanceof PsiPrimitiveType;
    }

    private final UExpression createIdEqualsExpression(UastElementFactory $this$createIdEqualsExpression, UExpression param) {
        return this.isPrimitiveType(param) ? this.createMatchExpression($this$createIdEqualsExpression, "is", param) : this.createMatchExpression($this$createIdEqualsExpression, "sameInstance", param);
    }

    private final UastBinaryOperator inverse(UastBinaryOperator $this$inverse) {
        UastBinaryOperator uastBinaryOperator = $this$inverse;
        return Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? (UastBinaryOperator)UastBinaryOperator.NOT_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.IDENTITY_NOT_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.IDENTITY_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? (UastBinaryOperator)UastBinaryOperator.LESS_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? (UastBinaryOperator)UastBinaryOperator.GREATER_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.LESS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.GREATER : $this$inverse)))))));
    }

    @NotNull
    public final UastBinaryOperator normalize(@NotNull UastBinaryOperator $this$normalize, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return StringsKt.contains$default((CharSequence)methodName, (CharSequence)"False", (boolean)false, (int)2, null) ? this.inverse($this$normalize) : $this$normalize;
    }

    private final UExpression buildMatchExpression(UastElementFactory $this$buildMatchExpression, UastBinaryOperator operator, UExpression param) {
        UastBinaryOperator uastBinaryOperator = operator;
        return Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? this.createMatchExpression($this$buildMatchExpression, "is", param) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) ? this.createMatchExpression($this$buildMatchExpression, "not", this.createMatchExpression($this$buildMatchExpression, "is", param)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS) ? this.createIdEqualsExpression($this$buildMatchExpression, param) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS) ? this.createMatchExpression($this$buildMatchExpression, "not", this.createIdEqualsExpression($this$buildMatchExpression, param)) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? this.createMatchExpression($this$buildMatchExpression, "greaterThan", param) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? this.createMatchExpression($this$buildMatchExpression, "lessThan", param) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS) ? this.createMatchExpression($this$buildMatchExpression, "greaterThanOrEqualTo", param) : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS) ? this.createMatchExpression($this$buildMatchExpression, "lessThanOrEqualTo", param) : null)))))));
    }

    private final UExpression buildMatchExpression(UastElementFactory $this$buildMatchExpression, String methodName, UExpression receiver, UExpression param) {
        String string = methodName;
        if (Intrinsics.areEqual((Object)string, (Object)"contains")) {
            String[] stringArray;
            PsiType psiType = receiver.getExpressionType();
            boolean bl = psiType != null ? AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])(stringArray = new String[]{"java.util.Collection"})) : false;
            if (bl) {
                return this.createMatchExpression($this$buildMatchExpression, "hasItem", param);
            }
            if (TypeUtils.typeEquals((String)"java.lang.String", (PsiType)param.getExpressionType())) {
                return this.createMatchExpression($this$buildMatchExpression, "containsString", param);
            }
            return this.createMatchExpression($this$buildMatchExpression, "contains", param);
        }
        return Intrinsics.areEqual((Object)string, (Object)"equals") ? this.createMatchExpression($this$buildMatchExpression, "is", param) : null;
    }
}

