/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg.attr;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextContent;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgUtils;
import org.jetbrains.letsPlot.raster.mapping.svg.attr.SvgAttrMapping;
import org.jetbrains.letsPlot.raster.mapping.svg.attr.SvgShapeMapping;
import org.jetbrains.letsPlot.raster.shape.Figure;
import org.jetbrains.letsPlot.raster.shape.TSpan;
import org.jetbrains.letsPlot.raster.shape.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/attr/SvgTSpanElementAttrMapping;", "Lorg/jetbrains/letsPlot/raster/mapping/svg/attr/SvgShapeMapping;", "Lorg/jetbrains/letsPlot/raster/shape/TSpan;", "()V", "setAttribute", "", "target", "name", "", "value", "", "setAttributes", "tspan", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "plot-raster"})
@SourceDebugExtension(value={"SMAP\nSvgTSpanElementAttrMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgTSpanElementAttrMapping.kt\norg/jetbrains/letsPlot/raster/mapping/svg/attr/SvgTSpanElementAttrMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1855#3,2:76\n*S KotlinDebug\n*F\n+ 1 SvgTSpanElementAttrMapping.kt\norg/jetbrains/letsPlot/raster/mapping/svg/attr/SvgTSpanElementAttrMapping\n*L\n68#1:76,2\n*E\n"})
public final class SvgTSpanElementAttrMapping
extends SvgShapeMapping<TSpan> {
    @NotNull
    public static final SvgTSpanElementAttrMapping INSTANCE = new SvgTSpanElementAttrMapping();

    private SvgTSpanElementAttrMapping() {
    }

    @Override
    public void setAttribute(@NotNull TSpan target, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)SvgShape.Companion.getFILL().getName())) {
            target.setFill(SvgUtils.INSTANCE.toColor(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgShape.Companion.getSTROKE().getName())) {
            target.setStroke(SvgUtils.INSTANCE.toColor(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgShape.Companion.getSTROKE_WIDTH().getName())) {
            List<String> list = value;
            Intrinsics.checkNotNull((Object)list);
            target.setStrokeWidth(SvgAttrMapping.Companion.getAsFloat(list));
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTextContent.Companion.getFONT_FAMILY().getName())) {
            List<String> list = value;
            if (list == null || (list = SvgAttrMapping.Companion.getAsFontFamily(list)) == null) {
                list = Text.Companion.getDEFAULT_FONT_FAMILY();
            }
            target.setFontFamily(list);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTextContent.Companion.getFONT_SIZE().getName())) {
            if (!(value instanceof String)) {
                boolean $i$a$-require-SvgTSpanElementAttrMapping$setAttribute$32 = false;
                String $i$a$-require-SvgTSpanElementAttrMapping$setAttribute$32 = "font-size: only string value is supported";
                throw new IllegalArgumentException($i$a$-require-SvgTSpanElementAttrMapping$setAttribute$32.toString());
            }
            target.setFontScale(StringsKt.contains$default((CharSequence)((CharSequence)((Object)value)), (CharSequence)"em", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.removeSuffix((String)((String)((Object)value)), (CharSequence)"em")) : (StringsKt.contains$default((CharSequence)((CharSequence)((Object)value)), (CharSequence)"%", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.removeSuffix((String)((String)((Object)value)), (CharSequence)"%")) / 100.0f : 1.0f));
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTextContent.Companion.getFONT_WEIGHT().getName())) {
            FontWeight fontWeight;
            List<String> list = value;
            if (Intrinsics.areEqual(list, (Object)"normal")) {
                fontWeight = FontWeight.NORMAL;
            } else if (Intrinsics.areEqual(list, (Object)"bold")) {
                fontWeight = FontWeight.BOLD;
            } else {
                throw new IllegalStateException(("Unexpected font-weight value: " + value).toString());
            }
            target.setFontWeight(fontWeight);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTextContent.Companion.getFONT_STYLE().getName())) {
            FontStyle fontStyle;
            List<String> list = value;
            if (Intrinsics.areEqual(list, (Object)"normal")) {
                fontStyle = FontStyle.NORMAL;
            } else if (Intrinsics.areEqual(list, (Object)"italic")) {
                fontStyle = FontStyle.ITALIC;
            } else {
                throw new IllegalStateException(("Unexpected font-style value: " + value).toString());
            }
            target.setFontStyle(fontStyle);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTextContent.Companion.getTEXT_DY().getName())) {
            if (!(value instanceof String)) {
                boolean bl = false;
                String string2 = "dy: only string value is supported";
                throw new IllegalArgumentException(string2.toString());
            }
            target.setDy(StringsKt.contains$default((CharSequence)((CharSequence)((Object)value)), (CharSequence)"em", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.removeSuffix((String)((String)((Object)value)), (CharSequence)"em")) : (StringsKt.contains$default((CharSequence)((CharSequence)((Object)value)), (CharSequence)"%", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.removeSuffix((String)((String)((Object)value)), (CharSequence)"%")) / 100.0f : 0.0f));
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgTSpanElement.Companion.getBASELINE_SHIFT().getName())) {
            Text.BaselineShift baselineShift;
            List<String> list = value;
            if (Intrinsics.areEqual(list, (Object)"sub")) {
                baselineShift = Text.BaselineShift.SUB;
            } else if (Intrinsics.areEqual(list, (Object)"super")) {
                baselineShift = Text.BaselineShift.SUPER;
            } else {
                throw new IllegalStateException(("Unexpected baseline-shift value: " + value).toString());
            }
            target.setBaselineShift(baselineShift);
        } else {
            super.setAttribute((Figure)target, name, (Object)value);
        }
    }

    public final void setAttributes(@NotNull TSpan target, @NotNull SvgTSpanElement tspan) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)tspan, (String)"tspan");
        Iterable $this$forEach$iv = tspan.getAttributeKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgAttributeSpec key = (SvgAttributeSpec)element$iv;
            boolean bl = false;
            INSTANCE.setAttribute(target, key.getName(), tspan.getAttribute(key).get());
        }
    }
}

