/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.toolkit.json;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u00032\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007*\"\u0010\u0016\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a8\u0006\u0002"}, d2={"deserializeAny", "", "json", "Lkotlinx/serialization/json/JsonElement;", "deserializeJsonMap", "", "", "Lorg/jetbrains/letsPlot/toolkit/json/JsonMap;", "deserializeList", "", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "deserializeMap", "Lkotlinx/serialization/json/JsonObject;", "deserializePrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "serialize", "list", "map", "serializeAny", "obj", "serializeJsonMap", "JsonMap"})
@SourceDebugExtension(value={"SMAP\nserializeSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serializeSpec.kt\norg/jetbrains/letsPlot/toolkit/json/SerializeSpecKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n29#2,2:87\n31#2:90\n52#2,3:91\n1#3:89\n*S KotlinDebug\n*F\n+ 1 serializeSpec.kt\norg/jetbrains/letsPlot/toolkit/json/SerializeSpecKt\n*L\n24#1:87,2\n24#1:90\n33#1:91,3\n*E\n"})
public final class SerializeSpecKt {
    @NotNull
    public static final JsonElement serializeJsonMap(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return (JsonElement)SerializeSpecKt.serialize(map);
    }

    private static final JsonElement serializeAny(Object obj) {
        JsonElement jsonElement;
        Object object = obj;
        if (object == null) {
            jsonElement = (JsonElement)JsonNull.INSTANCE;
        } else if (object instanceof Map) {
            jsonElement = (JsonElement)SerializeSpecKt.serialize((Map)obj);
        } else if (object instanceof List) {
            jsonElement = (JsonElement)SerializeSpecKt.serialize((List)obj);
        } else if (object instanceof String) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((String)((String)obj));
        } else if (object instanceof Boolean) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Boolean)((Boolean)obj));
        } else if (object instanceof Number) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)((Number)obj));
        } else {
            throw new IllegalStateException(("Don't know how to serialize object [" + obj + "] of class " + Reflection.getOrCreateKotlinClass(obj.getClass())).toString());
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonObject serialize(Map<?, ?> map) {
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$serialize_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                KClass kClass;
                StringBuilder stringBuilder = new StringBuilder().append("Map key [").append(key).append("] is of type ");
                Object obj = key;
                if (obj != null) {
                    void it;
                    Object obj2 = obj;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl2 = false;
                    kClass = Reflection.getOrCreateKotlinClass(it.getClass());
                    stringBuilder = stringBuilder2;
                } else {
                    kClass = null;
                }
                String string = stringBuilder.append(kClass).append(". Don't know how to serialize it.").toString();
                throw new IllegalStateException(string.toString());
            }
            $this$serialize_u24lambda_u241.put((String)key, SerializeSpecKt.serializeAny(value));
        }
        return builder$iv.build();
    }

    private static final JsonArray serialize(List<?> list) {
        JsonArrayBuilder builder$iv;
        boolean $i$f$buildJsonArray = false;
        JsonArrayBuilder $this$serialize_u24lambda_u242 = builder$iv = new JsonArrayBuilder();
        boolean bl = false;
        for (Object value : list) {
            $this$serialize_u24lambda_u242.add(SerializeSpecKt.serializeAny(value));
        }
        return builder$iv.build();
    }

    @NotNull
    public static final Map<String, Object> deserializeJsonMap(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException(("Input json should be a key-value object, but it's " + json).toString());
        }
        Map<String, Object> map = SerializeSpecKt.deserializeMap((JsonObject)json);
        for (Object value : map.values()) {
            if (value != null) continue;
            throw new IllegalStateException("Input json shouldn't have null values on the top level".toString());
        }
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>{ org.jetbrains.letsPlot.toolkit.json.SerializeSpecKt.JsonMap }");
        return map;
    }

    private static final Object deserializeAny(JsonElement json) {
        Object object;
        JsonElement jsonElement = json;
        if (jsonElement instanceof JsonObject) {
            object = SerializeSpecKt.deserializeMap((JsonObject)json);
        } else if (jsonElement instanceof JsonArray) {
            object = SerializeSpecKt.deserializeList((JsonArray)json);
        } else if (jsonElement instanceof JsonPrimitive) {
            object = SerializeSpecKt.deserializePrimitive((JsonPrimitive)json);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final Object deserializePrimitive(JsonPrimitive json) {
        Object object;
        if (json instanceof JsonNull) {
            object = null;
        } else if (json.isString()) {
            object = json.getContent();
        } else {
            object = JsonElementKt.getBooleanOrNull((JsonPrimitive)json);
            if (object == null && (object = JsonElementKt.getDoubleOrNull((JsonPrimitive)json)) == null) {
                throw new IllegalStateException(("Unknown JSON primitive type: [" + json + ']').toString());
            }
        }
        return object;
    }

    private static final Map<String, Object> deserializeMap(JsonObject json) {
        Map map;
        Map $this$deserializeMap_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map.Entry entry : ((Map)json).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            $this$deserializeMap_u24lambda_u243.put(key, SerializeSpecKt.deserializeAny(value));
        }
        return MapsKt.build((Map)map);
    }

    private static final List<Object> deserializeList(JsonArray jsonArray) {
        List list;
        List $this$deserializeList_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (JsonElement el : jsonArray) {
            $this$deserializeList_u24lambda_u244.add(SerializeSpecKt.deserializeAny(el));
        }
        return CollectionsKt.build((List)list);
    }
}

