/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargets;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LocalTargetEnvironment
extends TargetEnvironment {
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> myLocalPortBindings;

    public LocalTargetEnvironment(@NotNull LocalTargetEnvironmentRequest request) {
        if (request == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(0);
        }
        super(request);
        this.myUploadVolumes = new HashMap<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume>();
        this.myDownloadVolumes = new HashMap<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume>();
        this.myTargetPortBindings = new HashMap<TargetEnvironment.TargetPortBinding, ResolvedPortBinding>();
        this.myLocalPortBindings = new HashMap<TargetEnvironment.LocalPortBinding, ResolvedPortBinding>();
        for (TargetEnvironment.UploadRoot uploadRoot : request.getUploadVolumes()) {
            Path targetRoot = uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent ? Paths.get(((TargetEnvironment.TargetPath.Persistent)uploadRoot.getTargetRootPath()).getAbsolutePath(), new String[0]) : uploadRoot.getLocalRootPath().toAbsolutePath();
            this.myUploadVolumes.put(uploadRoot, new LocalVolume(uploadRoot.getLocalRootPath(), targetRoot));
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : request.getDownloadVolumes()) {
            Path localRoot;
            if (downloadRoot.getLocalRootPath() != null) {
                localRoot = downloadRoot.getLocalRootPath();
            } else {
                try {
                    localRoot = FileUtil.createTempDirectory((String)"intellij-target", (String)"", (boolean)true).toPath();
                }
                catch (IOException err) {
                    throw new IllegalStateException(err);
                }
            }
            Path targetRoot = downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent ? Paths.get(((TargetEnvironment.TargetPath.Persistent)downloadRoot.getTargetRootPath()).getAbsolutePath(), new String[0]) : localRoot;
            this.myDownloadVolumes.put(downloadRoot, new LocalVolume(localRoot, targetRoot));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : request.getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null && !targetPortBinding.getLocal().equals(theOnlyPort)) {
                throw new UnsupportedOperationException("TCP port forwarding for the local target is not implemented. Please use the same port number for both local and target ports.");
            }
            this.myTargetPortBindings.put(targetPortBinding, LocalTargetEnvironment.getResolvedPortBinding(theOnlyPort));
        }
        for (TargetEnvironment.LocalPortBinding localPortBinding : request.getLocalPortBindings()) {
            int theOnlyPort = localPortBinding.getLocal();
            if (localPortBinding.getTarget() != null && !localPortBinding.getTarget().equals(theOnlyPort)) {
                throw new UnsupportedOperationException("TCP port forwarding for the local target is not implemented. Please use the same port number for both local and target ports.");
            }
            this.myLocalPortBindings.put(localPortBinding, LocalTargetEnvironment.getResolvedPortBinding(theOnlyPort));
        }
    }

    @Override
    @NotNull
    public LocalTargetEnvironmentRequest getRequest() {
        LocalTargetEnvironmentRequest localTargetEnvironmentRequest = (LocalTargetEnvironmentRequest)super.getRequest();
        if (localTargetEnvironmentRequest == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(1);
        }
        return localTargetEnvironmentRequest;
    }

    @NotNull
    private static ResolvedPortBinding getResolvedPortBinding(int port) {
        HostPort hostPort = new HostPort("127.0.0.1", port);
        return new ResolvedPortBinding(hostPort, hostPort);
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map = Collections.unmodifiableMap(this.myUploadVolumes);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map = Collections.unmodifiableMap(this.myDownloadVolumes);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> map = Collections.unmodifiableMap(this.myTargetPortBindings);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> map = Collections.unmodifiableMap(this.myLocalPortBindings);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.CURRENT;
        if (targetPlatform == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(6);
        }
        return targetPlatform;
    }

    @Override
    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (commandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(8);
        }
        Process process = this.createGeneralCommandLine(commandLine).createProcess();
        if (process == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(9);
        }
        return process;
    }

    @NotNull
    public GeneralCommandLine createGeneralCommandLine(@NotNull TargetedCommandLine commandLine) throws CantRunException {
        GeneralCommandLine generalCommandLine;
        if (commandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(10);
        }
        try {
            GeneralCommandLine generalCommandLine2;
            LocalPtyOptions localPtyOptions;
            PtyOptions ptyOption = commandLine.getPtyOptions();
            LocalPtyOptions localPtyOptions2 = localPtyOptions = ptyOption != null ? LocalTargets.toLocalPtyOptions(ptyOption) : null;
            if (localPtyOptions != null) {
                PtyCommandLine ptyCommandLine = new PtyCommandLine(commandLine.collectCommandsSynchronously());
                ptyCommandLine.withOptions(localPtyOptions);
                generalCommandLine2 = ptyCommandLine;
            } else {
                generalCommandLine2 = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
            }
            generalCommandLine2.withParentEnvironmentType(this.getRequest().getParentEnvironmentType());
            String inputFilePath = commandLine.getInputFilePath();
            if (inputFilePath != null) {
                generalCommandLine2.withInput(new File(inputFilePath));
            }
            generalCommandLine2.withCharset(commandLine.getCharset());
            String workingDirectory = commandLine.getWorkingDirectory();
            if (workingDirectory != null) {
                generalCommandLine2.withWorkDirectory(workingDirectory);
            }
            generalCommandLine2.withEnvironment(commandLine.getEnvironmentVariables());
            generalCommandLine2.setRedirectErrorStream(commandLine.isRedirectErrorStream());
            generalCommandLine = generalCommandLine2;
        }
        catch (ExecutionException e) {
            throw new CantRunException(e.getMessage(), e);
        }
        if (generalCommandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    @Override
    public void shutdown() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironment";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadVolumes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadVolumes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortBindings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPortBindings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneralCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createGeneralCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 9, 11 -> new IllegalStateException(string);
        };
    }

    private static final class LocalVolume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        private final Path myLocalRoot;
        private final Path myTargetRoot;
        private final boolean myReal;

        private LocalVolume(@NotNull Path localRoot, @NotNull Path targetRoot) {
            if (localRoot == null) {
                LocalVolume.$$$reportNull$$$0(0);
            }
            if (targetRoot == null) {
                LocalVolume.$$$reportNull$$$0(1);
            }
            this.myLocalRoot = localRoot;
            this.myTargetRoot = targetRoot;
            this.myReal = LocalVolume.isReal(localRoot, targetRoot);
        }

        private static boolean isReal(Path localRoot, Path targetRoot) {
            Path realLocalRoot;
            if (localRoot.equals(targetRoot)) {
                return false;
            }
            try {
                realLocalRoot = localRoot.toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return true;
            }
            try {
                return !realLocalRoot.equals(targetRoot.toRealPath(LinkOption.NOFOLLOW_LINKS));
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        @NotNull
        public Path getLocalRoot() {
            Path path = this.myLocalRoot;
            if (path == null) {
                LocalVolume.$$$reportNull$$$0(2);
            }
            return path;
        }

        @Override
        @NotNull
        public String getTargetRoot() {
            String string = this.myTargetRoot.toString();
            if (string == null) {
                LocalVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(4);
            }
            if (this.myReal) {
                File targetFile = this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile();
                String string = targetFile.toString();
                if (string == null) {
                    LocalVolume.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{this.myLocalRoot.toString(), relativePath})).replace('/', File.separatorChar);
            if (string == null) {
                LocalVolume.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public void upload(@NotNull String relativePath, @NotNull TargetProgressIndicator targetProgressIndicator) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(7);
            }
            if (targetProgressIndicator == null) {
                LocalVolume.$$$reportNull$$$0(8);
            }
            if (this.myReal) {
                File targetFile = this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile();
                FileUtil.copyFileOrDir((File)this.myLocalRoot.resolve(relativePath).toFile().getCanonicalFile(), (File)targetFile);
            }
        }

        @Override
        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(9);
            }
            if (progressIndicator == null) {
                LocalVolume.$$$reportNull$$$0(10);
            }
            if (this.myReal) {
                FileUtil.copyFileOrDir((File)this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile(), (File)this.myLocalRoot.resolve(relativePath).toFile().getCanonicalFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironment$LocalVolume";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProgressIndicator";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironment$LocalVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetRoot";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveTargetPath";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "upload";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "download";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

