/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class FailedTestsNavigator
implements OccurenceNavigator {
    private TestFrameworkRunningModel myModel;

    FailedTestsNavigator() {
    }

    public boolean hasNextOccurence() {
        return this.myModel != null && this.getNextOccurenceInfo().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myModel != null && this.getPreviousOccurenceInfo().hasNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        FailedTestInfo result2 = this.getNextOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            FailedTestsNavigator.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void setModel(TestFrameworkRunningModel model2) {
        this.myModel = model2;
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                FailedTestsNavigator.this.myModel = null;
            }
        });
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        FailedTestInfo result2 = this.getPreviousOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = FailedTestsNavigator.getNextName();
        if (string == null) {
            FailedTestsNavigator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = FailedTestsNavigator.getPreviousName();
        if (string == null) {
            FailedTestsNavigator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private FailedTestInfo getNextOccurenceInfo() {
        return new NextFailedTestInfo(this).execute();
    }

    private FailedTestInfo getPreviousOccurenceInfo() {
        return new PreviousFailedTestInfo(this).execute();
    }

    @NlsActions.ActionText
    static String getNextName() {
        return ExecutionBundle.message("next.failed.test.action.name", new Object[0]);
    }

    @NlsActions.ActionText
    static String getPreviousName() {
        return ExecutionBundle.message("prev.failed.test.action.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/FailedTestsNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private abstract class FailedTestInfo {
        private AbstractTestProxy myDefect = null;
        private List<AbstractTestProxy> myAllTests;
        private List<AbstractTestProxy> myDefects;

        private FailedTestInfo() {
        }

        public AbstractTestProxy getDefect() {
            return this.myDefect;
        }

        private int getDefectNumber() {
            return this.myDefect == null ? this.getDefectsCount() : this.myDefects.indexOf(this.myDefect) + 1;
        }

        FailedTestInfo execute() {
            this.myAllTests = new ArrayList<AbstractTestProxy>();
            FailedTestInfo.collectTests(this.myAllTests, (TreeNode)FailedTestsNavigator.this.myModel.getTreeView().getModel().getRoot());
            this.myDefects = Filter.DEFECTIVE_LEAF.select(this.myAllTests);
            if (this.myDefects.isEmpty()) {
                return this;
            }
            AbstractTestProxy selectedTest = FailedTestsNavigator.this.myModel.getTreeView().getSelectedTest();
            int selectionIndex = this.myAllTests.indexOf(selectedTest);
            if (selectionIndex == -1) {
                return this;
            }
            AbstractTestProxy defect = this.findNextDefect(selectionIndex);
            if (defect == null) {
                return this;
            }
            if (defect != selectedTest) {
                this.myDefect = defect;
                return this;
            }
            int defectIndex = this.myDefects.indexOf(defect);
            if (defectIndex == -1 || defectIndex == this.getBoundIndex()) {
                return this;
            }
            this.myDefect = this.myDefects.get(this.nextIndex(defectIndex));
            return this;
        }

        private static void collectTests(List<? super AbstractTestProxy> tests, TreeNode node) {
            if (node == null) {
                return;
            }
            Object elementFor = TreeUtil.getUserObject((Object)node);
            if (elementFor instanceof BaseTestProxyNodeDescriptor) {
                elementFor = ((BaseTestProxyNodeDescriptor)elementFor).getElement();
            }
            if (elementFor instanceof AbstractTestProxy) {
                tests.add((AbstractTestProxy)elementFor);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                FailedTestInfo.collectTests(tests, node.getChildAt(i));
            }
        }

        private AbstractTestProxy findNextDefect(int startIndex) {
            int i = this.nextIndex(startIndex);
            while (0 <= i && i < this.myAllTests.size()) {
                AbstractTestProxy nextDefect = this.myAllTests.get(i);
                if (Filter.DEFECTIVE_LEAF.shouldAccept(nextDefect)) {
                    return nextDefect;
                }
                i = this.nextIndex(i);
            }
            return null;
        }

        protected abstract int nextIndex(int var1);

        protected abstract int getBoundIndex();

        protected int getDefectsCount() {
            return this.myDefects.size();
        }

        private boolean hasNextOccurence() {
            return this.myDefect != null;
        }
    }

    private class NextFailedTestInfo
    extends FailedTestInfo {
        private NextFailedTestInfo(FailedTestsNavigator failedTestsNavigator) {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex + 1;
        }

        @Override
        protected int getBoundIndex() {
            return this.getDefectsCount() - 1;
        }
    }

    private class PreviousFailedTestInfo
    extends FailedTestInfo {
        private PreviousFailedTestInfo(FailedTestsNavigator failedTestsNavigator) {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex - 1;
        }

        @Override
        protected int getBoundIndex() {
            return 0;
        }
    }
}

