/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DelayedDocumentWatcher
implements AutoTestWatcher {
    private final Project myProject;
    private final int myDelayMillis;
    private final IntConsumer myModificationStampConsumer;
    private final Predicate<? super VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private final AbstractAutoTestManager myAutoTestManager;
    private Disposable myDisposable;
    private SingleAlarm myAlarm;
    private final Set<VirtualFile> myChangedFiles;
    private boolean myDocumentSavingInProgress;
    private MessageBusConnection myConnection;
    private int myModificationStamp;

    public DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @NotNull AbstractAutoTestManager autoTestManager, @Nullable Predicate<? super VirtualFile> changedFileFilter) {
        if (project == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(0);
        }
        if (autoTestManager == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(1);
        }
        this(project, delayMillis, null, autoTestManager, changedFileFilter);
    }

    private DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @Nullable IntConsumer modificationStampConsumer, @Nullable AbstractAutoTestManager autoTestManager, @Nullable Predicate<? super VirtualFile> changedFileFilter) {
        if (project == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(2);
        }
        this.myChangedFiles = CollectionFactory.createSmallMemoryFootprintSet();
        this.myDocumentSavingInProgress = false;
        this.myModificationStamp = 0;
        this.myProject = project;
        this.myDelayMillis = delayMillis;
        this.myModificationStampConsumer = modificationStampConsumer;
        this.myAutoTestManager = autoTestManager;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    @RequiresEdt(generateAssertion=false)
    public void activate() {
        if (this.myConnection == null) {
            this.myDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, this.myDisposable);
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        DelayedDocumentWatcher.this.myDocumentSavingInProgress = false;
                    }, ModalityState.any());
                }
            });
            this.myConnection.subscribe(LookupManagerListener.TOPIC, (Object)new LookupManagerListener(){

                public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
                    if (newLookup == null && !DelayedDocumentWatcher.this.myChangedFiles.isEmpty()) {
                        DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
                    }
                }
            });
            this.myAlarm = SingleAlarm.Companion.singleEdtAlarm(this.myDelayMillis, this.myDisposable, (Runnable)new MyRunnable());
        }
    }

    @Override
    @RequiresEdt(generateAssertion=false)
    public void deactivate() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    private void asyncCheckErrors(@NotNull Collection<? extends VirtualFile> files, @NotNull Consumer<? super Boolean> errorsFoundConsumer) {
        if (files == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(4);
        }
        if (errorsFoundConsumer == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean errorsFound = (Boolean)ReadAction.compute(() -> {
                for (VirtualFile file : files) {
                    if (!PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)file)) continue;
                    return true;
                }
                return false;
            });
            ApplicationManager.getApplication().invokeLater(() -> errorsFoundConsumer.accept(errorsFound), ModalityState.any());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoTestManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsFoundConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asyncCheckErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class MyDocumentAdapter
    implements DocumentListener {
        private MyDocumentAdapter() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentAdapter.$$$reportNull$$$0(0);
            }
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file)) {
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.test((VirtualFile)file)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
            ++DelayedDocumentWatcher.this.myModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher$MyDocumentAdapter", "documentChanged"));
        }
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            int oldModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
            DelayedDocumentWatcher.this.asyncCheckErrors(DelayedDocumentWatcher.this.myChangedFiles, errorsFound -> {
                if (DelayedDocumentWatcher.this.myDisposable == null) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myModificationStamp != oldModificationStamp) {
                    return;
                }
                LookupEx activeLookup = LookupManager.getInstance((Project)DelayedDocumentWatcher.this.myProject).getActiveLookup();
                if (activeLookup != null && activeLookup.isCompletion()) {
                    return;
                }
                if (errorsFound.booleanValue()) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.clear();
                if (DelayedDocumentWatcher.this.myModificationStampConsumer != null) {
                    DelayedDocumentWatcher.this.myModificationStampConsumer.accept(DelayedDocumentWatcher.this.myModificationStamp);
                } else {
                    int initialModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
                    Objects.requireNonNull(DelayedDocumentWatcher.this.myAutoTestManager).restartAllAutoTests(() -> DelayedDocumentWatcher.this.myModificationStamp == initialModificationStamp);
                }
            });
        }
    }
}

