/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.stacktrace;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.actions.ViewAssertEqualsDiffAction;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffHyperlink
implements Printable {
    private static final String NEW_LINE = "\n";
    @NotNull
    private final String myExpected;
    @NotNull
    private final String myActual;
    protected final String myFilePath;
    protected final String myActualFilePath;
    private final boolean myPrintOneLine;
    private final HyperlinkInfo myDiffHyperlink;
    private static final int ourMaxExpectedLength = Registry.intValue((String)"test.console.expected.actual.max.length", (int)255);
    private AbstractTestProxy myTestProxy;

    public DiffHyperlink(@NotNull String expected, @NotNull String actual, String filePath) {
        if (expected == null) {
            DiffHyperlink.$$$reportNull$$$0(0);
        }
        if (actual == null) {
            DiffHyperlink.$$$reportNull$$$0(1);
        }
        this(expected, actual, filePath, null, true);
    }

    public DiffHyperlink(@NotNull String expected, @NotNull String actual, String expectedFilePath, String actualFilePath, boolean printOneLine) {
        if (expected == null) {
            DiffHyperlink.$$$reportNull$$$0(2);
        }
        if (actual == null) {
            DiffHyperlink.$$$reportNull$$$0(3);
        }
        this.myDiffHyperlink = new DiffHyperlinkInfo();
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = DiffHyperlink.normalizeSeparators(expectedFilePath);
        this.myActualFilePath = DiffHyperlink.normalizeSeparators(actualFilePath);
        this.myPrintOneLine = printOneLine;
    }

    public void setTestProxy(AbstractTestProxy testProxy) {
        this.myTestProxy = testProxy;
    }

    public HyperlinkInfo getInfo() {
        return this.myDiffHyperlink;
    }

    public AbstractTestProxy getTestProxy() {
        return this.myTestProxy;
    }

    private static String normalizeSeparators(String filePath) {
        return filePath == null ? null : filePath.replace(File.separatorChar, '/');
    }

    @NlsContexts.DialogTitle
    protected String getTitle() {
        return this.myTestProxy != null ? ExecutionBundle.message("strings.equal.failed.with.test.name.dialog.title", this.myTestProxy) : ExecutionBundle.message("strings.equal.failed.dialog.title", new Object[0]);
    }

    @NlsContexts.DialogTitle
    public String getDiffTitle() {
        return this.getTitle();
    }

    @Nullable
    @NlsSafe
    public String getTestName() {
        return this.myTestProxy.getName();
    }

    @NotNull
    public String getLeft() {
        String string = this.myExpected;
        if (string == null) {
            DiffHyperlink.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getRight() {
        String string = this.myActual;
        if (string == null) {
            DiffHyperlink.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    @Override
    public void printOn(Printer printer) {
        if (!DiffHyperlink.hasMoreThanOneLine(this.myActual) && !DiffHyperlink.hasMoreThanOneLine(this.myExpected) && this.myPrintOneLine) {
            printer.printExpectedActualHeader(StringUtil.trimLog((String)this.myExpected, (int)ourMaxExpectedLength), StringUtil.trimLog((String)this.myActual, (int)ourMaxExpectedLength));
        }
        printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
        printer.printHyperlink(ExecutionBundle.message("junit.click.to.see.diff.link", new Object[0]), this.myDiffHyperlink);
        printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private static boolean hasMoreThanOneLine(@NotNull String string) {
        if (string == null) {
            DiffHyperlink.$$$reportNull$$$0(6);
        }
        return string.indexOf(10) != -1 || string.indexOf(13) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffHyperlink)) {
            return false;
        }
        DiffHyperlink hyperlink = (DiffHyperlink)o;
        if (!this.myActual.equals(hyperlink.myActual)) {
            return false;
        }
        if (!this.myExpected.equals(hyperlink.myExpected)) {
            return false;
        }
        if (!Objects.equals(this.myFilePath, hyperlink.myFilePath)) {
            return false;
        }
        return Objects.equals(this.myActualFilePath, hyperlink.myActualFilePath);
    }

    public int hashCode() {
        int result2 = this.myExpected.hashCode();
        result2 = 31 * result2 + this.myActual.hashCode();
        result2 = 31 * result2 + (this.myFilePath != null ? this.myFilePath.hashCode() : 0);
        result2 = 31 * result2 + (this.myActualFilePath != null ? this.myActualFilePath.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/stacktrace/DiffHyperlink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/stacktrace/DiffHyperlink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeft";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasMoreThanOneLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public class DiffHyperlinkInfo
    extends HyperlinkInfoBase {
        public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
            if (project == null) {
                DiffHyperlinkInfo.$$$reportNull$$$0(0);
            }
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = hyperlinkLocationPoint != null ? dataManager.getDataContext(hyperlinkLocationPoint.getOriginalComponent()) : dataManager.getDataContext();
            ViewAssertEqualsDiffAction.openDiff(dataContext, DiffHyperlink.this);
        }

        public DiffHyperlink getPrintable() {
            return DiffHyperlink.this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/stacktrace/DiffHyperlink$DiffHyperlinkInfo", "navigate"));
        }
    }
}

