/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.ActionLink;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.clustering.ClusteringSearchSession;
import com.intellij.usages.similarity.clustering.UsageCluster;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class ExportClusteringResultActionLink
extends ActionLink {
    public static final String FILENAME = "filename";
    public static final String CLUSTER_NUMBER = "cluster_number";
    public static final String SNIPPET = "snippet";
    public static final String FEATURES = "features";

    ExportClusteringResultActionLink(final @NotNull Project project, @NotNull ClusteringSearchSession session, final @NotNull String fileName) {
        if (project == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(2);
        }
        super(UsageViewBundle.message("similar.usages.internal.export.clustering.data", new Object[0]), event -> {
            final List<UsageCluster> clusters = session.getClusters();
            Task.Backgroundable loadMostCommonUsagePatternsTask = new Task.Backgroundable(project, UsageViewBundle.message("similar.usages.internal.exporting.clustering.data.progress.title", new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        ExportClusteringResultActionLink.buildSessionDataFile(project, clusters, indicator, fileName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/findUsages/similarity/ExportClusteringResultActionLink$1", "run"));
                }
            };
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(loadMostCommonUsagePatternsTask);
            indicator.setIndeterminate(false);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(loadMostCommonUsagePatternsTask, (ProgressIndicator)indicator);
        });
    }

    private static void createScratchFile(@NotNull String fileContent, @NotNull String fileName) throws IOException {
        if (fileContent == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(4);
        }
        ScratchFileService fileService = ScratchFileService.getInstance();
        VirtualFile scratchFile = fileService.findFile(RootType.findById((String)"scratches"), fileName + ".json", ScratchFileService.Option.create_new_always);
        VfsUtil.saveText((VirtualFile)scratchFile, (String)fileContent);
    }

    private static void buildSessionDataFile(@NotNull Project project, @NotNull List<? extends UsageCluster> clusters, @NotNull ProgressIndicator indicator, @NotNull String fileName) throws IOException {
        if (project == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(5);
        }
        if (clusters == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(8);
        }
        int counter = 0;
        StringWriter stringWriter = new StringWriter();
        JsonGenerator generator = new JsonFactory().createGenerator((Writer)stringWriter);
        generator.writeStartArray();
        for (UsageCluster usageCluster : clusters) {
            indicator.setFraction((double)counter++ / (double)clusters.size());
            Set<SimilarUsage> usages = usageCluster.getUsages();
            for (SimilarUsage usage : usages) {
                if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
                indicator.checkCanceled();
                PsiElement element = ExportClusteringResultActionLink.getElement((UsageInfo2UsageAdapter)((Object)usage));
                generator.writeStartObject();
                generator.writeStringField(FILENAME, ExportClusteringResultActionLink.getUsageId(element));
                generator.writeStringField(SNIPPET, ExportClusteringResultActionLink.getUsageLineSnippet(project, element));
                generator.writeNumberField(CLUSTER_NUMBER, counter);
                generator.writeObjectFieldStart(FEATURES);
                List<Object2IntMap.Entry<String>> sortedEntries = Stream.concat(ExportClusteringResultActionLink.getPrimaryFeatures(usage.getFeatures()), ExportClusteringResultActionLink.getStructuralFeatures(usage.getFeatures())).toList();
                for (Object2IntMap.Entry<String> entry : sortedEntries) {
                    generator.writeNumberField((String)entry.getKey(), entry.getIntValue());
                }
                generator.writeEndObject();
                generator.writeEndObject();
            }
        }
        generator.writeEndArray();
        generator.close();
        WriteCommandAction.writeCommandAction((Project)project).run(() -> ExportClusteringResultActionLink.createScratchFile(stringWriter.toString(), fileName));
    }

    private static boolean isStructural(@NotNull String key) {
        if (key == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(9);
        }
        return key.contains("PREV:") || key.contains("NEXT:") || key.contains("GP:") || key.contains("P:");
    }

    private static Stream<Object2IntMap.Entry<String>> getPrimaryFeatures(@NotNull Bag bag) {
        if (bag == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(10);
        }
        return bag.getBag().object2IntEntrySet().stream().filter(entry -> !ExportClusteringResultActionLink.isStructural(String.valueOf(entry.getKey())));
    }

    private static Stream<Object2IntMap.Entry<String>> getStructuralFeatures(@NotNull Bag bag) {
        if (bag == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(11);
        }
        return bag.getBag().object2IntEntrySet().stream().filter(entry -> ExportClusteringResultActionLink.isStructural(String.valueOf(entry.getKey())));
    }

    @NotNull
    public static PsiElement getElement(@NotNull UsageInfo2UsageAdapter usage) {
        if (usage == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(12);
        }
        Ref elementRef = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> elementRef.set((Object)usage.getElement()));
        PsiElement psiElement = (PsiElement)elementRef.get();
        if (psiElement == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @NotNull
    public static String getUsageId(@NotNull PsiElement element) {
        if (element == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(14);
        }
        Ref fileNameRef = new Ref();
        Ref elementTextRange = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile containingVirtualFile = element.getContainingFile().getVirtualFile();
            assert (containingVirtualFile != null);
            VirtualFile rootForFile = ProjectFileIndex.getInstance((Project)element.getProject()).getSourceRootForFile(containingVirtualFile);
            if (rootForFile != null) {
                fileNameRef.set((Object)VfsUtilCore.getRelativePath((VirtualFile)containingVirtualFile, (VirtualFile)rootForFile));
                elementTextRange.set((Object)element.getTextRange());
            }
        });
        TextRange range = (TextRange)elementTextRange.get();
        String string = (String)fileNameRef.get() + ":" + (range != null ? range.getStartOffset() : 0);
        if (string == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getUsageLineSnippet(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(16);
        }
        if (element == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(17);
        }
        Ref usageLineSnippet = new Ref((Object)"");
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
            Document doc = docManager.getDocument(element.getContainingFile());
            if (doc != null) {
                int usageStartLineNumber = doc.getLineNumber(element.getTextRange().getStartOffset());
                int usageEndLineNumber = doc.getLineNumber(element.getTextRange().getEndOffset());
                usageLineSnippet.set((Object)doc.getText(new TextRange(doc.getLineStartOffset(usageStartLineNumber), doc.getLineEndOffset(Math.min(usageEndLineNumber, doc.getLineCount() - 1)))));
            }
        });
        String string = StringUtil.escapeChars((String)ExportClusteringResultActionLink.removeNewLines((String)usageLineSnippet.get()), (char[])new char[]{'\\', '\"'}).trim();
        if (string == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String removeNewLines(@NotNull String snippet) {
        if (snippet == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(19);
        }
        String string = snippet.replace("\n", " ").replace("\t", " ").replace("\r", " ");
        if (string == null) {
            ExportClusteringResultActionLink.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 15, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/similarity/ExportClusteringResultActionLink";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = SNIPPET;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/similarity/ExportClusteringResultActionLink";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageLineSnippet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNewLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createScratchFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildSessionDataFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStructural";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryFeatures";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStructuralFeatures";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUsageId";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUsageLineSnippet";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeNewLines";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 15, 18, 20 -> new IllegalStateException(string);
        };
    }
}

