/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.intellij.find.findUsages.similarity.SnippetRenderingData;
import com.intellij.find.findUsages.similarity.UsageCodeSnippetComponent;
import com.intellij.find.findUsages.similarity.UsagePreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.similarity.statistics.SimilarUsagesCollector;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.scroll.BoundedRangeModelThresholdListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SimilarUsagesComponent
extends JPanel
implements Disposable {
    public static final int SNIPPET_LIMIT = 10;
    private int myAlreadyProcessedUsages;
    private int myAlreadyRenderedUsages;
    @NotNull
    private final UsageInfo myOriginalUsage;
    @NotNull
    private final UsageView myUsageView;

    public SimilarUsagesComponent(@NotNull UsageView usageView, @NotNull UsageInfo originalUsage) {
        if (usageView == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(0);
        }
        if (originalUsage == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(1);
        }
        this.myAlreadyProcessedUsages = 0;
        this.myAlreadyRenderedUsages = 0;
        this.myOriginalUsage = originalUsage;
        this.myUsageView = usageView;
        this.setLayout((LayoutManager)new VerticalLayout(0));
        this.setBackground(UIUtil.getTextFieldBackground());
    }

    public void renderSimilarUsages(@NotNull Collection<? extends SimilarUsage> similarUsagesGroupUsages) {
        if (similarUsagesGroupUsages == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(2);
        }
        similarUsagesGroupUsages.stream().skip(this.myAlreadyProcessedUsages).limit(10L).forEach(usage -> {
            UsageInfo info = usage.getUsageInfo();
            if (this.myOriginalUsage != info) {
                this.renderUsage(info);
            }
            ++this.myAlreadyProcessedUsages;
        });
    }

    private void renderUsage(@NotNull UsageInfo info) {
        if (info == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(3);
        }
        PsiElement element = info.getElement();
        PsiFile file = info.getFile();
        ProperTextRange rangeInElement = info.getRangeInElement();
        ++this.myAlreadyRenderedUsages;
        if (element == null || file == null || rangeInElement == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        SnippetRenderingData data = UsageCodeSnippetComponent.calculateSnippetRenderingData(element, rangeInElement);
        if (data == null) {
            return;
        }
        UsageCodeSnippetComponent codeSnippet = new UsageCodeSnippetComponent(data, info);
        Disposer.register((Disposable)this, (Disposable)codeSnippet);
        JPanel headerPanelForUsage = this.getHeaderPanelForUsage(info, codeSnippet.getEditor().getBackgroundColor());
        if (this.myOriginalUsage == info) {
            SimpleColoredComponent component = new SimpleColoredComponent();
            component.append(UsageViewBundle.message("similar.usages.the.original.usage.label", new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            headerPanelForUsage.add((Component)component);
        }
        this.add(headerPanelForUsage);
        this.add((Component)((Object)codeSnippet));
    }

    public void renderOriginalUsage() {
        this.renderUsage(this.myOriginalUsage);
    }

    @NotNull
    public JPanel getHeaderPanelForUsage(UsageInfo usageInfo, @NotNull Color backGroundColor) {
        if (backGroundColor == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(4);
        }
        JPanel header = new JPanel(new FlowLayout(0));
        header.setBackground(backGroundColor);
        ActionLink link = UsagePreviewComponent.Companion.createNavigationLink(this, this.myUsageView, usageInfo);
        if (link != null) {
            header.add((Component)link);
        }
        JBColor color = new JBColor((Color)Gray.xCD, (Color)Gray.x51);
        header.setBorder(JBUI.Borders.customLineTop((Color)color));
        JPanel jPanel = header;
        if (jPanel == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void dispose() {
    }

    @NotNull
    public JScrollPane createLazyLoadingScrollPane(@NotNull Set<? extends SimilarUsage> usagesToRender) {
        if (usagesToRender == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(6);
        }
        JScrollPane similarUsagesScrollPane = ScrollPaneFactory.createScrollPane((Component)this, (boolean)true);
        this.renderOriginalUsage();
        BoundedRangeModelThresholdListener.install((JScrollBar)similarUsagesScrollPane.getVerticalScrollBar(), () -> {
            if (this.myAlreadyProcessedUsages < usagesToRender.size()) {
                this.renderSimilarUsages(usagesToRender);
                SimilarUsagesCollector.logMoreUsagesLoaded(this.myOriginalUsage.getProject(), this.myUsageView, this.myAlreadyRenderedUsages);
            }
            return Unit.INSTANCE;
        });
        JScrollPane jScrollPane = similarUsagesScrollPane;
        if (jScrollPane == null) {
            SimilarUsagesComponent.$$$reportNull$$$0(7);
        }
        return jScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUsage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "similarUsagesGroupUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backGroundColor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/similarity/SimilarUsagesComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesToRender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/similarity/SimilarUsagesComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderPanelForUsage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyLoadingScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderSimilarUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderUsage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderPanelForUsage";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLazyLoadingScrollPane";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

