/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.intellij.find.findUsages.similarity.SnippetRenderingData;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.RemoteTransferUIManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.ui.JBUI;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UsageCodeSnippetComponent
extends EditorTextFieldCellRenderer.SimpleWithGutterRendererComponent
implements UiDataProvider {
    private static final int CONTEXT_LINE_NUMBER = 3;
    @NotNull
    private final UsageInfo myUsageInfo;

    UsageCodeSnippetComponent(@NotNull SnippetRenderingData renderingData, @NotNull UsageInfo usageInfo) {
        if (renderingData == null) {
            UsageCodeSnippetComponent.$$$reportNull$$$0(0);
        }
        if (usageInfo == null) {
            UsageCodeSnippetComponent.$$$reportNull$$$0(1);
        }
        super(renderingData.getProject(), renderingData.getLanguage(), false);
        this.myUsageInfo = usageInfo;
        this.setupEditor();
        this.addUsagePreview(renderingData);
        this.getEditor().getGutterComponentEx().setLineNumberConverter(renderingData.getConverter());
    }

    private void setupEditor() {
        EditorEx editor = this.getEditor();
        JScrollPane scrollPane = editor.getScrollPane();
        editor.setBorder((Border)JBUI.Borders.empty());
        editor.getMarkupModel().removeAllHighlighters();
        editor.getGutterComponentEx().setPaintBackground(false);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setAdditionalLinesCount(0);
        settings.setLineCursorWidth(1);
        settings.setDndEnabled(false);
        settings.setUseSoftWraps(false);
        RemoteTransferUIManager.forbidBeControlizationInLux((UserDataHolder)editor, (String)"findUsages");
    }

    private void highlightRange(@NotNull TextRange rangeToHighlight) {
        if (rangeToHighlight == null) {
            UsageCodeSnippetComponent.$$$reportNull$$$0(2);
        }
        MarkupModelEx markupModel = this.getEditor().getMarkupModel();
        markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, rangeToHighlight.getStartOffset(), rangeToHighlight.getEndOffset(), 3000, HighlighterTargetArea.EXACT_RANGE);
    }

    private void addUsagePreview(SnippetRenderingData result2) {
        if (result2 == null) {
            return;
        }
        this.setText(result2.getText());
        this.getEditor().getGutterComponentEx().updateUI();
        this.getEditor().getMarkupModel().removeAllHighlighters();
        this.highlightRange(result2.getSelectionRange());
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            UsageCodeSnippetComponent.$$$reportNull$$$0(3);
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
            VirtualFile file = this.myUsageInfo.getVirtualFile();
            if (file == null) {
                return Navigatable.EMPTY_NAVIGATABLE_ARRAY;
            }
            int navigationOffset = this.myUsageInfo.getNavigationOffset();
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myUsageInfo.getProject(), file, navigationOffset);
            return new Navigatable[]{openFileDescriptor};
        });
    }

    @Nullable
    public static SnippetRenderingData calculateSnippetRenderingData(@NotNull PsiElement element, @Nullable ProperTextRange infoRange) {
        PsiDocumentManager docManager;
        Document doc;
        if (element == null) {
            UsageCodeSnippetComponent.$$$reportNull$$$0(4);
        }
        if ((doc = (docManager = PsiDocumentManager.getInstance((Project)element.getProject())).getDocument(InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element))) == null) {
            return null;
        }
        TextRange selectionRange = UsagePreviewPanel.calculateHighlightingRangeForUsage(element, infoRange);
        if (element instanceof PsiNamedElement && !(element instanceof PsiFile)) {
            selectionRange = UsagePreviewPanel.getNameElementTextRange(element);
        }
        selectionRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, selectionRange);
        int usageStartLineNumber = doc.getLineNumber(selectionRange.getStartOffset());
        int usageEndLineNumber = doc.getLineNumber(selectionRange.getEndOffset());
        final int contextStartLineNumber = Math.max(0, usageStartLineNumber - 3);
        int startOffset = doc.getLineStartOffset(contextStartLineNumber);
        int endOffset = doc.getLineEndOffset(Math.min(usageEndLineNumber + 3, doc.getLineCount() - 1));
        selectionRange = selectionRange.shiftLeft(startOffset);
        String text2 = doc.getText(new TextRange(startOffset, endOffset));
        LineNumberConverter converter = contextStartLineNumber == 0 ? LineNumberConverter.DEFAULT : new LineNumberConverter.Increasing(){

            @Override
            public Integer convert(@NotNull Editor editor, int lineNumber) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lineNumber + contextStartLineNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/findUsages/similarity/UsageCodeSnippetComponent$1", "convert"));
            }
        };
        return new SnippetRenderingData(element.getProject(), element.getLanguage(), selectionRange, text2, converter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToHighlight";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findUsages/similarity/UsageCodeSnippetComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateSnippetRenderingData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

