/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class StructureViewComposite
implements StructureView {
    private final StructureViewDescriptor[] myStructureViews;

    public StructureViewComposite(StructureViewDescriptor ... views) {
        if (views == null) {
            StructureViewComposite.$$$reportNull$$$0(0);
        }
        this.myStructureViews = views;
        for (StructureViewDescriptor descriptor : views) {
            Disposer.register((Disposable)this, (Disposable)descriptor.structureView);
        }
    }

    @RequiresBackgroundThread
    public boolean isOutdated() {
        ThreadingAssertions.assertBackgroundThread();
        return false;
    }

    @Nullable
    public StructureView getSelectedStructureView() {
        StructureViewDescriptor descriptor = (StructureViewDescriptor)ArrayUtil.getFirstElement((Object[])this.myStructureViews);
        return descriptor == null ? null : descriptor.structureView;
    }

    @Override
    public boolean navigateToSelectedElement(boolean requestFocus) {
        StructureView view = this.getSelectedStructureView();
        return view != null && view.navigateToSelectedElement(requestFocus);
    }

    @Override
    public JComponent getComponent() {
        StructureView view = this.getSelectedStructureView();
        return view == null ? null : view.getComponent();
    }

    public void dispose() {
    }

    @Override
    public void centerSelectedRow() {
        StructureView view = this.getSelectedStructureView();
        if (view != null) {
            view.centerSelectedRow();
        }
    }

    @Override
    public void restoreState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.restoreState();
        }
    }

    @Override
    public void storeState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.storeState();
        }
    }

    @Override
    public void disableStoreState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.disableStoreState();
        }
    }

    public StructureViewDescriptor @NotNull [] getStructureViews() {
        if (this.myStructureViews == null) {
            StructureViewComposite.$$$reportNull$$$0(1);
        }
        return this.myStructureViews;
    }

    @Override
    @NotNull
    public StructureViewModel getTreeModel() {
        StructureView view = this.getSelectedStructureView();
        if (view != null) {
            StructureViewModel structureViewModel = view.getTreeModel();
            if (structureViewModel == null) {
                StructureViewComposite.$$$reportNull$$$0(2);
            }
            return structureViewModel;
        }
        class M
        extends TextEditorBasedStructureViewModel
        implements StructureViewTreeElement,
        ItemPresentation {
            M(StructureViewComposite this$0) {
                super(null, null);
            }

            @Override
            @NotNull
            public StructureViewTreeElement getRoot() {
                M m = this;
                if (m == null) {
                    M.$$$reportNull$$$0(0);
                }
                return m;
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            @NotNull
            public ItemPresentation getPresentation() {
                M m = this;
                if (m == null) {
                    M.$$$reportNull$$$0(1);
                }
                return m;
            }

            @Override
            public TreeElement @NotNull [] getChildren() {
                if (EMPTY_ARRAY == null) {
                    M.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }

            @Nullable
            public String getPresentableText() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/structureView/impl/StructureViewComposite$1M";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
        return new M(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "views";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/StructureViewComposite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/StructureViewComposite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureViews";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static class StructureViewDescriptor {
        public final String title;
        public final StructureViewModel structureModel;
        public final StructureView structureView;
        public final Icon icon;

        public StructureViewDescriptor(String title, @NotNull StructureView structureView, Icon icon) {
            if (structureView == null) {
                StructureViewDescriptor.$$$reportNull$$$0(0);
            }
            this.title = title;
            this.structureModel = structureView.getTreeModel();
            this.structureView = structureView;
            this.icon = icon;
        }

        public StructureViewDescriptor(String title, @NotNull StructureViewModel structureModel, Icon icon) {
            if (structureModel == null) {
                StructureViewDescriptor.$$$reportNull$$$0(1);
            }
            this.title = title;
            this.structureModel = structureModel;
            this.structureView = null;
            this.icon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "structureView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "structureModel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/structureView/impl/StructureViewComposite$StructureViewDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

