/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import java.awt.image.ImageFilter;
import java.util.EnumMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ColorBlindnessSupport {
    @Nullable
    public static ColorBlindnessSupport get(@Nullable ColorBlindness blindness) {
        return blindness == null ? null : Lazy.MAP.get((Object)blindness);
    }

    @Nullable
    public ImageFilter getFilter() {
        return null;
    }

    private static final class Lazy {
        private static final EnumMap<ColorBlindness, ColorBlindnessSupport> MAP = Lazy.create();

        private Lazy() {
        }

        private static EnumMap<ColorBlindness, ColorBlindnessSupport> create() {
            EnumMap<ColorBlindness, ColorBlindnessSupport> map = new EnumMap<ColorBlindness, ColorBlindnessSupport>(ColorBlindness.class);
            Lazy.init(map, ColorBlindness.protanopia, "com.intellij.protanopiaSupport");
            Lazy.init(map, ColorBlindness.deuteranopia, "com.intellij.deuteranopiaSupport");
            Lazy.init(map, ColorBlindness.tritanopia, "com.intellij.tritanopiaSupport");
            Lazy.init(map, ColorBlindness.achromatopsia, "com.intellij.achromatopsiaSupport");
            if (map.isEmpty()) {
                map.put(ColorBlindness.deuteranopia, new ColorBlindnessSupport());
            }
            return map;
        }

        private static void init(EnumMap<ColorBlindness, ColorBlindnessSupport> map, ColorBlindness blindness, String extensionName) {
            List extensions = Extensions.getRootArea().getExtensionPoint(extensionName).getExtensionList();
            ColorBlindnessSupport support = null;
            for (ColorBlindnessSupport ext : extensions) {
                if (support != null) continue;
                support = ext;
            }
            if (support != null) {
                map.put(blindness, support);
                Logger logger = Logger.getInstance(ColorBlindnessSupport.class);
                if (logger.isDebugEnabled()) {
                    logger.debug(Lazy.toString("use", blindness, support));
                }
                for (ColorBlindnessSupport ext : extensions) {
                    if (support == ext) continue;
                    logger.warn(Lazy.toString("ignore", blindness, ext));
                }
            }
        }

        private static String toString(String prefix, ColorBlindness blindness, ColorBlindnessSupport support) {
            return prefix + " " + blindness.name() + " from " + String.valueOf(support.getClass());
        }
    }
}

