/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.themePicker;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.inspector.themePicker.EditorColorPicker;
import com.intellij.internal.inspector.themePicker.PixelColorMap;
import com.intellij.internal.inspector.themePicker.ThemeColorInfo;
import com.intellij.internal.inspector.themePicker.ThemeColorPickerTransform;
import com.intellij.internal.inspector.themePicker.UiThemeColorPickerKt;
import com.intellij.internal.inspector.themePicker.UiThemeColorPickerState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aJ\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001aJ\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/intellij/internal/inspector/themePicker/UiThemeColorPicker;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope$intellij_platform_ide_ui_inspector", "()Lkotlinx/coroutines/CoroutineScope;", "disposable", "Lcom/intellij/openapi/Disposable;", "colorMap", "Ljava/util/WeakHashMap;", "Ljava/awt/Window;", "Lcom/intellij/internal/inspector/themePicker/PixelColorMap;", "currentPopup", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "hoverState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/intellij/internal/inspector/themePicker/ThemeColorInfo;", "getHoverState$intellij_platform_ide_ui_inspector", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "setHoverState$intellij_platform_ide_ui_inspector", "(Lkotlinx/coroutines/flow/MutableStateFlow;)V", "isEnabled", "", "setEnabled", "", "value", "cleanup", "setupWindowListeners", "window", "showHoverPopup", "colors", "point", "Lcom/intellij/ui/awt/RelativePoint;", "storeColorForPixel", "component", "Ljavax/swing/JComponent;", "rectangle", "Ljava/awt/Rectangle;", "color", "Ljava/awt/Color;", "erase", "getColorsAt", "getDrawColorsAt", "Companion", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nUiThemeColorPicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPicker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,545:1\n1#2:546\n42#3,3:547\n*S KotlinDebug\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPicker\n*L\n184#1:547,3\n*E\n"})
public final class UiThemeColorPicker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Disposable disposable;
    @NotNull
    private final WeakHashMap<Window, PixelColorMap> colorMap;
    @Nullable
    private WeakReference<JBPopup> currentPopup;
    @NotNull
    private MutableStateFlow<List<ThemeColorInfo>> hoverState;

    public UiThemeColorPicker(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.colorMap = new WeakHashMap();
        this.hoverState = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final CoroutineScope getCoroutineScope$intellij_platform_ide_ui_inspector() {
        return this.coroutineScope;
    }

    @NotNull
    public final MutableStateFlow<List<ThemeColorInfo>> getHoverState$intellij_platform_ide_ui_inspector() {
        return this.hoverState;
    }

    public final void setHoverState$intellij_platform_ide_ui_inspector(@NotNull MutableStateFlow<List<ThemeColorInfo>> mutableStateFlow) {
        Intrinsics.checkNotNullParameter(mutableStateFlow, (String)"<set-?>");
        this.hoverState = mutableStateFlow;
    }

    public final boolean isEnabled() {
        return this.disposable != null;
    }

    public final void setEnabled(boolean value) {
        Disposable disposable;
        if (!value) {
            Disposable disposable2 = this.disposable;
            if (disposable2 != null) {
                Disposable it = disposable2;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.disposable = null;
            return;
        }
        if (this.disposable != null) {
            return;
        }
        Disposable disposable3 = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()));
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable(...)");
        this.disposable = disposable = disposable3;
        Disposer.register((Disposable)disposable, () -> UiThemeColorPicker.setEnabled$lambda$1(this));
        Disposable graphicsDisposable = JBSwingUtilities.addGlobalCGTransform((BiFunction)new ThemeColorPickerTransform());
        Disposer.register((Disposable)disposable, (Disposable)graphicsDisposable);
        Window[] windowArray = Window.getWindows();
        Intrinsics.checkNotNullExpressionValue((Object)windowArray, (String)"getWindows(...)");
        for (Window window : windowArray) {
            Intrinsics.checkNotNull((Object)window);
            this.setupWindowListeners(window, disposable);
        }
        long mask = 262209L;
        StartupUiUtil.addAwtListener((long)mask, (Disposable)disposable, arg_0 -> UiThemeColorPicker.setEnabled$lambda$2(this, disposable, arg_0));
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            ToolWindow toolWindow;
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("UI Theme Color Picker");
            if (toolWindow2 != null) {
                toolWindow2.setAvailable(true);
            }
            ToolWindow toolWindow3 = toolWindow;
            if (toolWindow3 == null) continue;
            toolWindow3.activate(null);
        }
    }

    private final void cleanup() {
        this.colorMap.clear();
        JBPopup jBPopup = this.currentPopup;
        if (jBPopup != null && (jBPopup = (JBPopup)jBPopup.get()) != null) {
            jBPopup.cancel();
        }
        this.currentPopup = null;
        this.hoverState.tryEmit((Object)CollectionsKt.emptyList());
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            ToolWindow toolWindow;
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("UI Theme Color Picker");
            if (toolWindow2 == null) continue;
            toolWindow2.setAvailable(false);
        }
    }

    private final void setupWindowListeners(Window window, Disposable disposable) {
        JRootPane jRootPane = UiThemeColorPickerKt.access$getRootPane(window);
        if (jRootPane == null) {
            return;
        }
        JRootPane rootPane = jRootPane;
        Component component = rootPane.getGlassPane();
        IdeGlassPane ideGlassPane = component instanceof IdeGlassPane ? (IdeGlassPane)component : null;
        if (ideGlassPane == null) {
            return;
        }
        IdeGlassPane glassPane = ideGlassPane;
        MouseMotionAdapter mouseMoveListener2 = new MouseMotionAdapter(this){
            final /* synthetic */ UiThemeColorPicker this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RelativePoint point = new RelativePoint(e);
                if (UiThemeColorPickerKt.access$isOurOwnUi(point)) {
                    WeakReference weakReference = UiThemeColorPicker.access$getCurrentPopup$p(this.this$0);
                    if (weakReference != null && (weakReference = (JBPopup)weakReference.get()) != null) {
                        weakReference.cancel();
                    }
                    UiThemeColorPicker.access$setCurrentPopup$p(this.this$0, null);
                    return;
                }
                List colors = UiThemeColorPicker.access$getColorsAt(this.this$0, point);
                UiThemeColorPicker.access$showHoverPopup(this.this$0, colors, point);
            }
        };
        MouseAdapter mouseClickListener2 = new MouseAdapter(this){
            final /* synthetic */ UiThemeColorPicker this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (Intrinsics.areEqual((Object)UiThemeColorPickerKt.access$getUPDATE_TABLE_SHORTCUT$p(), (Object)KeymapUtil.createMouseShortcut((MouseEvent)e))) {
                    RelativePoint point = new RelativePoint(e);
                    if (UiThemeColorPickerKt.access$isOurOwnUi(point)) {
                        return;
                    }
                    List colors = UiThemeColorPicker.access$getColorsAt(this.this$0, point);
                    this.this$0.getHoverState$intellij_platform_ide_ui_inspector().tryEmit((Object)colors);
                    e.consume();
                }
            }
        };
        glassPane.addMousePreprocessor((MouseListener)mouseClickListener2, disposable);
        glassPane.addMouseMotionPreprocessor((MouseMotionListener)mouseMoveListener2, disposable);
        window.repaint();
    }

    private final void showHoverPopup(List<? extends ThemeColorInfo> colors, RelativePoint point) {
        JBPopup oldPopup;
        WeakReference<JBPopup> weakReference = this.currentPopup;
        Object object = oldPopup = weakReference != null ? (JBPopup)weakReference.get() : null;
        if (oldPopup != null && !oldPopup.isDisposed()) {
            Object oldColors = oldPopup.getContent().getClientProperty("ThemeColorPopupIdentity");
            if (Intrinsics.areEqual((Object)oldColors, colors)) {
                return;
            }
            oldPopup.cancel();
        }
        if (colors.isEmpty()) {
            return;
        }
        boolean $i$f$service = false;
        Class<UiThemeColorPickerState> serviceClass$iv = UiThemeColorPickerState.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (!((UiThemeColorPickerState.State)((UiThemeColorPickerState)((Object)object2)).getState()).getShowPopup()) {
            return;
        }
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)BuilderKt.panel(arg_0 -> UiThemeColorPicker.showHoverPopup$lambda$0(colors, arg_0)), null).setRequestFocus(false).setResizable(false).setMovable(false).setCancelOnClickOutside(false).setCancelOnWindowDeactivation(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.getContent().putClientProperty("ThemeColorPopupIdentity", colors);
        this.currentPopup = new WeakReference<JBPopup>(popup);
        popup.show(new RelativePoint(point.getComponent(), new Point(point.getPoint().x + 100, point.getPoint().y + 30)));
    }

    public final void storeColorForPixel(@NotNull JComponent component, @NotNull Rectangle rectangle, @NotNull Color color, boolean erase) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (!this.isEnabled()) {
            return;
        }
        Window window = UIUtil.getWindow((Component)component);
        if (window == null) {
            return;
        }
        Window window2 = window;
        PixelColorMap colorMap = this.colorMap.computeIfAbsent(window2, arg_0 -> UiThemeColorPicker.storeColorForPixel$lambda$1(UiThemeColorPicker::storeColorForPixel$lambda$0, arg_0));
        JRootPane jRootPane = UiThemeColorPickerKt.access$getRootPane(window2);
        Intrinsics.checkNotNull((Object)jRootPane);
        JRootPane rootPane = jRootPane;
        Rectangle windowRectangle = SwingUtilities.convertRectangle(component, rectangle, rootPane);
        Intrinsics.checkNotNull((Object)windowRectangle);
        colorMap.mark(windowRectangle, color, erase);
    }

    private final List<ThemeColorInfo> getColorsAt(RelativePoint point) {
        if (!this.isEnabled()) {
            return CollectionsKt.emptyList();
        }
        List list2 = this.getDrawColorsAt(point);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Collection collection = list2;
        List list3 = EditorColorPicker.INSTANCE.getEditorColorsAt(point);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    private final List<ThemeColorInfo> getDrawColorsAt(RelativePoint point) {
        Window window = UIUtil.getWindow((Component)point.getComponent());
        if (window == null) {
            return null;
        }
        Window window2 = window;
        PixelColorMap pixelColorMap = this.colorMap.get(window2);
        if (pixelColorMap == null) {
            return null;
        }
        PixelColorMap componentMap = pixelColorMap;
        JRootPane jRootPane = UiThemeColorPickerKt.access$getRootPane(window2);
        Intrinsics.checkNotNull((Object)jRootPane);
        JRootPane rootPane = jRootPane;
        Point point2 = point.getPoint((Component)rootPane);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
        Point windowPoint = point2;
        return componentMap.getColor(windowPoint);
    }

    private static final void setEnabled$lambda$1(UiThemeColorPicker this$0) {
        this$0.cleanup();
    }

    private static final void setEnabled$lambda$2(UiThemeColorPicker this$0, Disposable $disposable, AWTEvent event) {
        Object source = event.getSource();
        if (source instanceof Window) {
            this$0.setupWindowListeners((Window)source, $disposable);
        }
    }

    private static final Unit showHoverPopup$lambda$0$0$0(List $colors, JTree $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        JTree tree = $this$applyToComponent;
        tree.setModel(UiThemeColorPickerKt.access$createColorsTreeModel($colors));
        TreeUtil.expandAll((JTree)tree);
        return Unit.INSTANCE;
    }

    private static final Unit showHoverPopup$lambda$0$0(List $colors, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)UiThemeColorPickerKt.access$createThemeColorTree()).applyToComponent(arg_0 -> UiThemeColorPicker.showHoverPopup$lambda$0$0$0($colors, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit showHoverPopup$lambda$0(List $colors, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UiThemeColorPicker.showHoverPopup$lambda$0$0($colors, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final PixelColorMap storeColorForPixel$lambda$0(Window it) {
        return new PixelColorMap();
    }

    private static final PixelColorMap storeColorForPixel$lambda$1(Function1 $tmp0, Object p0) {
        return (PixelColorMap)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final UiThemeColorPicker getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ WeakReference access$getCurrentPopup$p(UiThemeColorPicker $this) {
        return $this.currentPopup;
    }

    public static final /* synthetic */ void access$setCurrentPopup$p(UiThemeColorPicker $this, WeakReference weakReference) {
        $this.currentPopup = weakReference;
    }

    public static final /* synthetic */ List access$getColorsAt(UiThemeColorPicker $this, RelativePoint point) {
        return $this.getColorsAt(point);
    }

    public static final /* synthetic */ void access$showHoverPopup(UiThemeColorPicker $this, List colors, RelativePoint point) {
        $this.showHoverPopup(colors, point);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/inspector/themePicker/UiThemeColorPicker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/internal/inspector/themePicker/UiThemeColorPicker;", "intellij.platform.ide.ui.inspector"})
    @SourceDebugExtension(value={"SMAP\nUiThemeColorPicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPicker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,545:1\n42#2,3:546\n*S KotlinDebug\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPicker$Companion\n*L\n84#1:546,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UiThemeColorPicker getInstance() {
            boolean $i$f$service = false;
            Class<UiThemeColorPicker> serviceClass$iv = UiThemeColorPicker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (UiThemeColorPicker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

