/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J0\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/editor/ScrollPositionCalculator;", "", "calcOffsetsToScroll", "Ljava/awt/Point;", "editor", "Lcom/intellij/openapi/editor/Editor;", "targetLocation", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "viewRect", "Ljava/awt/Rectangle;", "scrollPane", "Ljavax/swing/JScrollPane;", "getHorizontalOffset", "", "getVerticalOffset", "intellij.platform.editor.ui"})
@ApiStatus.Experimental
public interface ScrollPositionCalculator {
    @NotNull
    default public Point calcOffsetsToScroll(@NotNull Editor editor, @NotNull Point targetLocation, @NotNull ScrollType scrollType, @NotNull Rectangle viewRect, @NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)scrollType), (String)"scrollType");
        Intrinsics.checkNotNullParameter((Object)viewRect, (String)"viewRect");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        ScrollType adjustedScrollType = scrollType;
        if (editor.getSettings().isRefrainFromScrolling() && viewRect.contains(targetLocation) && (scrollType == ScrollType.CENTER || scrollType == ScrollType.CENTER_DOWN || scrollType == ScrollType.CENTER_UP)) {
            adjustedScrollType = ScrollType.RELATIVE;
        }
        int hOffset = this.getHorizontalOffset(editor, targetLocation, adjustedScrollType, viewRect, scrollPane);
        int vOffset = this.getVerticalOffset(editor, targetLocation, adjustedScrollType, viewRect, scrollPane);
        return new Point(hOffset, vOffset);
    }

    public int getHorizontalOffset(@NotNull Editor var1, @NotNull Point var2, @NotNull ScrollType var3, @NotNull Rectangle var4, @NotNull JScrollPane var5);

    public int getVerticalOffset(@NotNull Editor var1, @NotNull Point var2, @NotNull ScrollType var3, @NotNull Rectangle var4, @NotNull JScrollPane var5);
}

