/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import java.awt.Font;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EditorFontType {
    PLAIN,
    BOLD,
    ITALIC,
    BOLD_ITALIC,
    CONSOLE_PLAIN,
    CONSOLE_BOLD,
    CONSOLE_ITALIC,
    CONSOLE_BOLD_ITALIC;


    @Nullable
    public static EditorFontType getConsoleType(@Nullable EditorFontType type) {
        return type == PLAIN ? CONSOLE_PLAIN : (type == ITALIC ? CONSOLE_ITALIC : (type == BOLD ? CONSOLE_BOLD : (type == BOLD_ITALIC ? CONSOLE_BOLD_ITALIC : type)));
    }

    @NotNull
    public static Font getGlobalPlainFont() {
        Font font = PLAIN.getGlobalFont();
        if (font == null) {
            EditorFontType.$$$reportNull$$$0(0);
        }
        return font;
    }

    @NotNull
    public Font getGlobalFont() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(this);
        if (font == null) {
            EditorFontType.$$$reportNull$$$0(1);
        }
        return font;
    }

    @NotNull
    public static EditorFontType forJavaStyle(@JdkConstants.FontStyle int style) {
        EditorFontType editorFontType = switch (style) {
            case 1 -> BOLD;
            case 2 -> ITALIC;
            case 3 -> BOLD_ITALIC;
            default -> PLAIN;
        };
        if (editorFontType == null) {
            EditorFontType.$$$reportNull$$$0(2);
        }
        return editorFontType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/editor/colors/EditorFontType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalPlainFont";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalFont";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forJavaStyle";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

