/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="DefaultFont", storages={@Storage(value="editor-font.xml"), @Storage(value="editor.xml", deprecated=true)}, category=SettingsCategory.UI)
public final class AppEditorFontOptions
extends AppFontOptions<PersistentFontPreferences> {
    @ApiStatus.Internal
    public static final String STORAGE_NAME = "editor-font.xml";

    @Override
    protected PersistentFontPreferences createFontState(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppEditorFontOptions.$$$reportNull$$$0(0);
        }
        return new PersistentFontPreferences(fontPreferences);
    }

    public static AppEditorFontOptions getInstance() {
        return (AppEditorFontOptions)ApplicationManager.getApplication().getService(AppEditorFontOptions.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontPreferences", "com/intellij/openapi/editor/colors/impl/AppEditorFontOptions", "createFontState"));
    }

    public static class PersistentFontPreferences {
        public int VERSION = 0;
        @ReportValue
        public int FONT_SIZE = FontPreferences.DEFAULT_FONT_SIZE;
        @ReportValue
        public float FONT_SIZE_2D = FontPreferences.DEFAULT_FONT_SIZE;
        @ReportValue
        @NlsSafe
        @NotNull
        public String FONT_FAMILY = FontPreferences.DEFAULT_FONT_NAME;
        @ReportValue
        @NlsSafe
        @Nullable
        public String FONT_REGULAR_SUB_FAMILY;
        @ReportValue
        @NlsSafe
        @Nullable
        public String FONT_BOLD_SUB_FAMILY;
        @ReportValue
        public float FONT_SCALE = 1.0f;
        @ReportValue
        public float LINE_SPACING = 1.2f;
        @ReportValue
        public boolean USE_LIGATURES = false;
        @ReportValue
        @NotNull
        public @Unmodifiable @NotNull Set<@NotNull String> CHARACTER_VARIANTS = Set.of();
        @ReportValue
        @NlsSafe
        @Nullable
        public String SECONDARY_FONT_FAMILY;

        protected PersistentFontPreferences() {
            if (FontFamilyService.isServiceSupported()) {
                this.FONT_REGULAR_SUB_FAMILY = FontFamilyService.getRecommendedSubFamily(this.FONT_FAMILY);
                this.FONT_BOLD_SUB_FAMILY = FontFamilyService.getRecommendedBoldSubFamily(this.FONT_FAMILY, this.FONT_REGULAR_SUB_FAMILY);
            }
        }

        public PersistentFontPreferences(FontPreferences fontPreferences) {
            this.FONT_FAMILY = fontPreferences.getFontFamily();
            this.FONT_REGULAR_SUB_FAMILY = fontPreferences.getRegularSubFamily();
            this.FONT_BOLD_SUB_FAMILY = fontPreferences.getBoldSubFamily();
            this.FONT_SIZE = fontPreferences.getSize(this.FONT_FAMILY);
            this.FONT_SIZE_2D = fontPreferences.getSize2D(this.FONT_FAMILY);
            this.FONT_SCALE = UISettings.getDefFontScale();
            this.LINE_SPACING = fontPreferences.getLineSpacing();
            this.USE_LIGATURES = fontPreferences.useLigatures();
            List<String> fontFamilies = fontPreferences.getEffectiveFontFamilies();
            this.CHARACTER_VARIANTS = fontPreferences.getCharacterVariants();
            if (fontFamilies.size() > 1) {
                this.SECONDARY_FONT_FAMILY = fontFamilies.get(1);
            }
        }

        protected static PersistentFontPreferences getDefaultState() {
            PersistentFontPreferences preferences = new PersistentFontPreferences();
            preferences.VERSION = 1;
            return preferences;
        }
    }
}

