/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHint;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\u001a%\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a)\u0010\u0002\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\t2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\n\u001a)\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0003\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0010\u001a\u00020\u0003*\u00020\u0004H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\tH\u0007\u001a-\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010\u001f\u001a5\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010#\u001a+\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0003\u00a2\u0006\u0002\u0010%\u001a\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012*\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012*\u0006\u0012\u0002\b\u00030\t8G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\"\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "addActionAvailabilityHint", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "hints", "", "Lcom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHint;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;[Lcom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHint;)V", "Lcom/intellij/openapi/editor/Inlay;", "(Lcom/intellij/openapi/editor/Inlay;[Lcom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHint;)V", "doAddActionAvailabilityHint", "marker", "Lcom/intellij/openapi/util/UserDataHolder;", "newHints", "(Lcom/intellij/openapi/util/UserDataHolder;[Lcom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHint;)V", "clearAvailabilityHints", "actionAvailabilityHints", "", "Lcom/intellij/openapi/editor/RangeMarker;", "getActionAvailabilityHints", "(Lcom/intellij/openapi/editor/RangeMarker;)Ljava/util/List;", "(Lcom/intellij/openapi/editor/Inlay;)Ljava/util/List;", "isActionAvailableByHint", "", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "actionId", "", "backend", "(Lcom/intellij/openapi/editor/Editor;ILjava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;ILjava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "(Lcom/intellij/openapi/editor/ex/MarkupModelEx;ILjava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "clearAvailabilityHintsImpl", "hintsKey", "Lcom/intellij/openapi/util/Key;", "", "intellij.platform.editor.ex"})
@SourceDebugExtension(value={"SMAP\nEditorActionAvailabilityHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorActionAvailabilityHint.kt\ncom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHintKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n1#2:165\n13#3:166\n*S KotlinDebug\n*F\n+ 1 EditorActionAvailabilityHint.kt\ncom/intellij/openapi/editor/ex/util/EditorActionAvailabilityHintKt\n*L\n20#1:166\n*E\n"})
public final class EditorActionAvailabilityHintKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<List<EditorActionAvailabilityHint>> hintsKey;

    @ApiStatus.Experimental
    public static final void addActionAvailabilityHint(@NotNull RangeHighlighter $this$addActionAvailabilityHint, EditorActionAvailabilityHint ... hints) {
        Intrinsics.checkNotNullParameter((Object)$this$addActionAvailabilityHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        EditorActionAvailabilityHintKt.doAddActionAvailabilityHint((UserDataHolder)$this$addActionAvailabilityHint, Arrays.copyOf(hints, hints.length));
    }

    @ApiStatus.Experimental
    public static final void addActionAvailabilityHint(@NotNull Inlay<?> $this$addActionAvailabilityHint, EditorActionAvailabilityHint ... hints) {
        Intrinsics.checkNotNullParameter($this$addActionAvailabilityHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        EditorActionAvailabilityHintKt.doAddActionAvailabilityHint((UserDataHolder)$this$addActionAvailabilityHint, Arrays.copyOf(hints, hints.length));
    }

    @ApiStatus.Experimental
    private static final void doAddActionAvailabilityHint(UserDataHolder marker, EditorActionAvailabilityHint ... newHints) {
        Object object = ConcurrencyUtil.computeIfAbsent((UserDataHolder)marker, hintsKey, EditorActionAvailabilityHintKt::doAddActionAvailabilityHint$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        List hints = (List)object;
        for (EditorActionAvailabilityHint newHint : newHints) {
            Object v1;
            block3: {
                Iterable iterable = hints;
                for (Object t : iterable) {
                    EditorActionAvailabilityHint it = (EditorActionAvailabilityHint)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getActionId(), (Object)newHint.getActionId())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            EditorActionAvailabilityHint existingHint = v1;
            if (existingHint != null) {
                if (existingHint.getCondition() == newHint.getCondition()) continue;
                logger.error("Availability hint for action '" + newHint.getActionId() + "' already exists");
                continue;
            }
            hints.add(newHint);
        }
    }

    @ApiStatus.Experimental
    public static final void clearAvailabilityHints(@NotNull RangeHighlighter $this$clearAvailabilityHints) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAvailabilityHints, (String)"<this>");
        EditorActionAvailabilityHintKt.clearAvailabilityHintsImpl((UserDataHolder)$this$clearAvailabilityHints);
    }

    @ApiStatus.Experimental
    public static final void clearAvailabilityHints(@NotNull Inlay<?> $this$clearAvailabilityHints) {
        Intrinsics.checkNotNullParameter($this$clearAvailabilityHints, (String)"<this>");
        EditorActionAvailabilityHintKt.clearAvailabilityHintsImpl((UserDataHolder)$this$clearAvailabilityHints);
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<EditorActionAvailabilityHint> getActionAvailabilityHints(@NotNull RangeMarker $this$actionAvailabilityHints) {
        Intrinsics.checkNotNullParameter((Object)$this$actionAvailabilityHints, (String)"<this>");
        List list2 = (List)$this$actionAvailabilityHints.getUserData(hintsKey);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<EditorActionAvailabilityHint> getActionAvailabilityHints(@NotNull Inlay<?> $this$actionAvailabilityHints) {
        Intrinsics.checkNotNullParameter($this$actionAvailabilityHints, (String)"<this>");
        List list2 = (List)$this$actionAvailabilityHints.getUserData(hintsKey);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Boolean isActionAvailableByHint(@NotNull Editor $this$isActionAvailableByHint, int offset, @NotNull String actionId, @NotNull String backend) {
        Intrinsics.checkNotNullParameter((Object)$this$isActionAvailableByHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        MarkupModel markupModel = $this$isActionAvailableByHint.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        if (!(markupModel2 instanceof MarkupModelEx)) {
            return null;
        }
        Boolean bl = EditorActionAvailabilityHintKt.isActionAvailableByHint((MarkupModelEx)markupModel2, offset, actionId, backend);
        if (bl == null) {
            Document document = $this$isActionAvailableByHint.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            bl = EditorActionAvailabilityHintKt.isActionAvailableByHint(document, $this$isActionAvailableByHint.getProject(), offset, actionId, backend);
        }
        return bl;
    }

    public static /* synthetic */ Boolean isActionAvailableByHint$default(Editor editor, int n, String string, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = "remote";
        }
        return EditorActionAvailabilityHintKt.isActionAvailableByHint(editor, n, string, string2);
    }

    @ApiStatus.Internal
    @Nullable
    public static final Boolean isActionAvailableByHint(@NotNull Document $this$isActionAvailableByHint, @Nullable Project project, int offset, @NotNull String actionId, @NotNull String backend) {
        Intrinsics.checkNotNullParameter((Object)$this$isActionAvailableByHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        MarkupModel markupModel = DocumentMarkupModel.forDocument($this$isActionAvailableByHint, project, false);
        if (!(markupModel instanceof MarkupModelEx)) {
            return null;
        }
        return EditorActionAvailabilityHintKt.isActionAvailableByHint((MarkupModelEx)markupModel, offset, actionId, backend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    private static final Boolean isActionAvailableByHint(MarkupModelEx $this$isActionAvailableByHint, int offset, String actionId, String backend) {
        AutoCloseable autoCloseable = (AutoCloseable)$this$isActionAvailableByHint.overlappingIterator(offset, offset);
        Throwable throwable = null;
        try {
            MarkupIterator overlappingIterator = (MarkupIterator)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)overlappingIterator);
            MarkupIterator markupIterator = overlappingIterator;
            while (((Iterator)markupIterator).hasNext()) {
                RangeHighlighterEx highlighterEx = (RangeHighlighterEx)markupIterator.next();
                Intrinsics.checkNotNull((Object)highlighterEx);
                for (EditorActionAvailabilityHint actionAvailabilityHint : EditorActionAvailabilityHintKt.getActionAvailabilityHints(highlighterEx)) {
                    if (!Intrinsics.areEqual((Object)actionAvailabilityHint.getActionId(), (Object)actionId) || !Intrinsics.areEqual((Object)actionAvailabilityHint.getBackend(), (Object)"ANY") && !Intrinsics.areEqual((Object)actionAvailabilityHint.getBackend(), (Object)backend)) continue;
                    Boolean bl2 = actionAvailabilityHint.getCondition().isAvailable(offset, highlighterEx);
                    return bl2;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return null;
    }

    private static final void clearAvailabilityHintsImpl(UserDataHolder marker) {
        marker.putUserData(hintsKey, null);
    }

    private static final List doAddActionAvailabilityHint$lambda$0() {
        return (List)ContainerUtil.createConcurrentList();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorActionAvailabilityHint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EditorActionAvailabilityHintKt.logger = logger;
        hintsKey = new Key("EditorActionOnRangeMarkerAvailabilityHints");
    }
}

