/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.localization;

import com.intellij.DynamicBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.feedback.localization.LocalizationFeedbackNotificationService;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="LocalizationFeedbackState", storages={@Storage(value="LocalizationFeedbackState.xml")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\tH\u0002J$\u0010\u000b\u001a \u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014 \u000f*\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000e0\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\u0006\u0010\u0018\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/feedback/localization/LocalizationFeedbackService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/platform/feedback/localization/LocalizationFeedbackService$State;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "myState", "initialTimeSincePluginInstallation", "", "getCurrentSessionTime", "getLanguagePack", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "isEnabled", "", "hasLanguagePack", "tryRecordInstallation", "setInteraction", "", "wasInteracted", "isTimeForNotification", "runWatcher", "getState", "loadState", "state", "Companion", "State", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nLocalizationFeedbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationFeedbackService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class LocalizationFeedbackService
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private State myState;
    private long initialTimeSincePluginInstallation;
    private static final long TIME_TO_WAIT_FOR_NOTIFICATION_MS = Companion.isTesting() ? Duration.ofMinutes(3L).toMillis() : Duration.ofDays(3L).toMillis();
    private static final long REFRESH_TIME_MS = Companion.isTesting() ? Duration.ofMinutes(1L).toMillis() : Duration.ofMinutes(30L).toMillis();

    public LocalizationFeedbackService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.myState = new State();
        this.initialTimeSincePluginInstallation = -1L;
    }

    private final long getCurrentSessionTime() {
        return RangesKt.coerceAtLeast((long)(System.currentTimeMillis() - ApplicationKt.getApplication().getStartTime() - ApplicationKt.getApplication().getIdleTime()), (long)0L);
    }

    @NotNull
    public final Pair<String, String> getLanguagePack() {
        DynamicBundle.LanguageBundleEP languageBundleEP;
        block3: {
            block2: {
                languageBundleEP = LocalizationUtil.findLanguageBundle$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, (int)1, null);
                if (languageBundleEP == null || (languageBundleEP = languageBundleEP.pluginDescriptor) == null) break block2;
                DynamicBundle.LanguageBundleEP it = languageBundleEP;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getPluginId().getIdString(), (Object)it.getVersion());
                languageBundleEP = pair;
                if (pair != null) break block3;
            }
            languageBundleEP = TuplesKt.to((Object)"none", (Object)"none");
        }
        return languageBundleEP;
    }

    public final boolean isEnabled() {
        return PlatformUtils.isRider() && ApplicationKt.getApplication().isEAP() || Companion.isTesting();
    }

    private final boolean hasLanguagePack() {
        return !Intrinsics.areEqual((Object)this.getLanguagePack().getFirst(), (Object)"none");
    }

    public final boolean tryRecordInstallation() {
        if (!this.hasLanguagePack()) {
            return false;
        }
        State state = this.myState;
        if (state.getTimeSincePluginInstallation() != -1L) {
            return false;
        }
        state.setTimeSincePluginInstallation(0L);
        this.initialTimeSincePluginInstallation = 0L;
        return true;
    }

    public final void setInteraction() {
        this.getState().setBalloonWasInteractedWith(true);
    }

    private final boolean wasInteracted() {
        return this.getState().getBalloonWasInteractedWith();
    }

    private final boolean isTimeForNotification() {
        State state = this.myState;
        long time = this.initialTimeSincePluginInstallation + this.getCurrentSessionTime();
        state.setTimeSincePluginInstallation(time);
        return time >= TIME_TO_WAIT_FOR_NOTIFICATION_MS;
    }

    public final void runWatcher() {
        State state = this.myState;
        if (state.getTimeSincePluginInstallation() == -1L) {
            return;
        }
        if (this.wasInteracted()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LocalizationFeedbackService this$0;
            final /* synthetic */ State $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            if (LocalizationFeedbackService.access$isTimeForNotification(this.this$0)) {
                                v0 = ProjectManager.getInstance().getOpenProjects();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getOpenProjects(...)");
                                if (!(((Object[])v0).length == 0)) break block0;
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v1 = DelayKt.delay((long)LocalizationFeedbackService.access$getREFRESH_TIME_MS$cp(), (Continuation)((Continuation)this));
                            if (v1 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl20
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        $this$thisLogger$iv = $this$launch;
                        $i$f$thisLogger = false;
                        v2 = Logger.getInstance(CoroutineScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.debug("Not time for notification, current: " + this.$state.getTimeSincePluginInstallation());
                        ** continue;
                    }
                }
                $this$thisLogger$iv = $this$launch;
                $i$f$thisLogger = false;
                v3 = Logger.getInstance(CoroutineScope.class);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                v3.info("Starting notification flow");
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                this.label = 2;
                v4 = DelayKt.delay((long)10000L, (Continuation)((Continuation)this));
                if (v4 == var5_3) {
                    return var5_3;
                }
                ** GOTO lbl40
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl40:
                        // 2 sources

                        LocalizationFeedbackNotificationService.Companion.getInstance().showNotification();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.myState = state;
        this.initialTimeSincePluginInstallation = state.getTimeSincePluginInstallation();
    }

    public static final /* synthetic */ boolean access$isTimeForNotification(LocalizationFeedbackService $this) {
        return $this.isTimeForNotification();
    }

    public static final /* synthetic */ long access$getREFRESH_TIME_MS$cp() {
        return REFRESH_TIME_MS;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/feedback/localization/LocalizationFeedbackService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/feedback/localization/LocalizationFeedbackService;", "isTesting", "", "TIME_TO_WAIT_FOR_NOTIFICATION_MS", "", "REFRESH_TIME_MS", "intellij.platform.feedback"})
    @SourceDebugExtension(value={"SMAP\nLocalizationFeedbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationFeedbackService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,93:1\n42#2,3:94\n*S KotlinDebug\n*F\n+ 1 LocalizationFeedbackService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackService$Companion\n*L\n19#1:94,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalizationFeedbackService getInstance() {
            boolean $i$f$service = false;
            Class<LocalizationFeedbackService> serviceClass$iv = LocalizationFeedbackService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalizationFeedbackService)object;
        }

        public final boolean isTesting() {
            String string = System.getProperty("ide.feedback.localization.test");
            return string != null ? Boolean.parseBoolean(string) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/feedback/localization/LocalizationFeedbackService$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "timeSincePluginInstallation", "getTimeSincePluginInstallation", "()J", "setTimeSincePluginInstallation", "(J)V", "timeSincePluginInstallation$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "balloonWasInteractedWith", "getBalloonWasInteractedWith", "()Z", "setBalloonWasInteractedWith", "(Z)V", "balloonWasInteractedWith$delegate", "intellij.platform.feedback"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty timeSincePluginInstallation$delegate = this.property(-1L).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty balloonWasInteractedWith$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[1]);

        public final long getTimeSincePluginInstallation() {
            return ((Number)this.timeSincePluginInstallation$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
        }

        public final void setTimeSincePluginInstallation(long l) {
            this.timeSincePluginInstallation$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)l);
        }

        public final boolean getBalloonWasInteractedWith() {
            return (Boolean)this.balloonWasInteractedWith$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setBalloonWasInteractedWith(boolean bl) {
            this.balloonWasInteractedWith$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "timeSincePluginInstallation", "getTimeSincePluginInstallation()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "balloonWasInteractedWith", "getBalloonWasInteractedWith()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

