/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.modifier;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.util.Processor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransientCodeStyleSettings
extends CodeStyleSettings {
    private final WeakReference<VirtualFile> myFileRef;
    private final Project myProject;
    private CodeStyleSettingsModifier myModifier;
    private final List<Object> myDependencies;
    private static final Key<Boolean> INDENT_OPTIONS_APPLY_PROGRESS = Key.create((String)"INDENT_OPTIONS_APPLY_PROGRESS");

    @Deprecated
    public TransientCodeStyleSettings(@NotNull PsiFile psiFile, @NotNull CodeStyleSettings settings) {
        if (psiFile == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(1);
        }
        super(true, false);
        this.myDependencies = new ArrayList<Object>();
        this.myFileRef = new WeakReference<VirtualFile>(psiFile.getVirtualFile());
        this.myProject = psiFile.getProject();
        this.copyFrom(settings);
        this.myDependencies.add(settings.getModificationTracker());
    }

    public TransientCodeStyleSettings(@NotNull VirtualFile file, @NotNull Project project, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(2);
        }
        if (project == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(4);
        }
        super(true, false);
        this.myDependencies = new ArrayList<Object>();
        this.myFileRef = new WeakReference<VirtualFile>(file);
        this.myProject = project;
        this.copyFrom(settings);
        this.myDependencies.add(settings.getModificationTracker());
    }

    public void setModifier(@NotNull CodeStyleSettingsModifier modifier) {
        if (modifier == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(5);
        }
        this.myModifier = modifier;
    }

    @Nullable
    public CodeStyleSettingsModifier getModifier() {
        return this.myModifier;
    }

    @Nullable
    public PsiFile getPsiFile() {
        VirtualFile file = (VirtualFile)this.myFileRef.get();
        return file != null && file.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@NotNull Project project, @NotNull VirtualFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<? super FileIndentOptionsProvider> providerProcessor) {
        if (project == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(6);
        }
        if (file == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(7);
        }
        if (this.myModifier != null && this.myModifier.acceptsFileIndentOptionsProviders()) {
            CommonCodeStyleSettings.IndentOptions indentOptions = super.getIndentOptionsByFile(project, file, formatRange, ignoreDocOptions, providerProcessor);
            if (indentOptions == null) {
                TransientCodeStyleSettings.$$$reportNull$$$0(8);
            }
            return indentOptions;
        }
        if (file.isValid()) {
            FileType fileType = file.getFileType();
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(fileType);
            if (indentOptions == null) {
                TransientCodeStyleSettings.$$$reportNull$$$0(9);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(10);
        }
        return indentOptions;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void applyIndentOptionsFromProviders(@NotNull PsiFile file) {
        if (file == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(11);
        }
        this.applyIndentOptionsFromProviders(file.getProject(), file.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void applyIndentOptionsFromProviders(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(12);
        }
        if (file == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(13);
        }
        if (file.getUserData(INDENT_OPTIONS_APPLY_PROGRESS) != null) {
            return;
        }
        file.putUserData(INDENT_OPTIONS_APPLY_PROGRESS, (Object)Boolean.TRUE);
        try {
            for (FileIndentOptionsProvider provider : FileIndentOptionsProvider.EP_NAME.getExtensionList()) {
                CommonCodeStyleSettings.IndentOptions targetOptions;
                CommonCodeStyleSettings.IndentOptions indentOptions;
                if (!provider.useOnFullReformat() || (indentOptions = provider.getIndentOptions(project, this, file)) == null || (targetOptions = this.getIndentOptions(file.getFileType())) == indentOptions) continue;
                targetOptions.copyFrom(indentOptions);
            }
        }
        finally {
            file.putUserData(INDENT_OPTIONS_APPLY_PROGRESS, null);
        }
    }

    public void addDependency(@NotNull ModificationTracker dependency) {
        if (dependency == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(14);
        }
        this.myDependencies.add(dependency);
    }

    public void addDependencies(@NotNull List<? extends ModificationTracker> dependencies) {
        if (dependencies == null) {
            TransientCodeStyleSettings.$$$reportNull$$$0(15);
        }
        this.myDependencies.addAll(dependencies);
    }

    public List<Object> getDependencies() {
        return this.myDependencies;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModifier";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyIndentOptionsFromProviders";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

