/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.tests.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J)\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/remoteDev/tests/impl/utils/SerializedLambdaHelper;", "", "<init>", "()V", "serialize", "", "obj", "Ljava/io/Serializable;", "decodeObject", "R", "stringToDecode", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/io/Serializable;", "ClassLoaderObjectInputStream", "intellij.remoteDev.util"})
public class SerializedLambdaHelper {
    public SerializedLambdaHelper() {
        System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String serialize(@NotNull Serializable obj) {
        String string;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        try {
            String string2;
            AutoCloseable autoCloseable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)autoCloseable;
                boolean bl = false;
                new ObjectOutputStream(it).writeObject(obj);
                string2 = Base64.getEncoder().encodeToString(it.toByteArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            string = string2;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Throwable t) {
            throw new Error("Failed to save/load the lambda. Most likely, the current lambda was more complex and so Kotlin compiler decided to generate a more complicated constructor for a wrapper class. Try to add java.io.Serializable, simplify the code, cleanup variables from the closure, copy parameters to the local scope. " + t.getMessage(), t);
        }
        return string;
    }

    @Nullable
    public final <R extends Serializable> R decodeObject(@NotNull String stringToDecode, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)stringToDecode, (String)"stringToDecode");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        byte[] byArray = Base64.getDecoder().decode(stringToDecode);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray2);
        Object obj = new ClassLoaderObjectInputStream(inputStream, classLoader).readObject();
        Serializable serializable = obj instanceof Serializable ? (Serializable)obj : null;
        return (R)(serializable instanceof Serializable ? serializable : null);
    }

    public static /* synthetic */ Serializable decodeObject$default(SerializedLambdaHelper serializedLambdaHelper, String string, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeObject");
        }
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = serializedLambdaHelper.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
            classLoader = classLoader2;
        }
        return serializedLambdaHelper.decodeObject(string, classLoader);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/remoteDev/tests/impl/utils/SerializedLambdaHelper$ClassLoaderObjectInputStream;", "Ljava/io/ObjectInputStream;", "inputStream", "Ljava/io/InputStream;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/io/InputStream;Ljava/lang/ClassLoader;)V", "resolveClass", "Ljava/lang/Class;", "desc", "Ljava/io/ObjectStreamClass;", "intellij.remoteDev.util"})
    public static final class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        @NotNull
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(@NotNull InputStream inputStream, @NotNull ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        @NotNull
        protected Class<?> resolveClass(@NotNull ObjectStreamClass desc) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Class<?> clazz = Class.forName(desc.getName(), false, this.classLoader);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            return clazz;
        }
    }
}

