/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.tracing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.AsyncSpanExporter;
import com.intellij.platform.diagnostic.telemetry.FilteredMetricsExporter;
import com.intellij.platform.diagnostic.telemetry.MetricsExtensionsKt;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.CsvGzippedMetricsExporter;
import com.intellij.platform.diagnostic.telemetry.impl.MessageBusSpanExporter;
import com.intellij.platform.diagnostic.telemetry.impl.OpenTelemetryExporterProvider;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\u000f\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/remoteDev/tracing/RdctExportersProvider;", "Lcom/intellij/platform/diagnostic/telemetry/impl/OpenTelemetryExporterProvider;", "<init>", "()V", "getSpanExporters", "", "Lcom/intellij/platform/diagnostic/telemetry/AsyncSpanExporter;", "getMetricsExporters", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "getReadInterval", "Lkotlin/time/Duration;", "getReadInterval-UwyO8pc", "()J", "intellij.remoteDev.util"})
@SourceDebugExtension(value={"SMAP\nRdctExportersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdctExportersProvider.kt\ncom/intellij/remoteDev/tracing/RdctExportersProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n13#2:46\n*S KotlinDebug\n*F\n+ 1 RdctExportersProvider.kt\ncom/intellij/remoteDev/tracing/RdctExportersProvider\n*L\n33#1:46\n*E\n"})
public final class RdctExportersProvider
implements OpenTelemetryExporterProvider {
    @NotNull
    public List<AsyncSpanExporter> getSpanExporters() {
        if (System.getProperty("rdct.diagnostic.otlp") != null && OtlpConfiguration.isTraceEnabled()) {
            return CollectionsKt.listOf((Object)new MessageBusSpanExporter());
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<MetricExporter> getMetricsExporters() {
        Path fileToWrite;
        Path path;
        if (System.getProperty("rdct.connection.metrics.enabled") == null) {
            return CollectionsKt.emptyList();
        }
        try {
            path = CsvGzippedMetricsExporter.Companion.generatePathForConnectionMetrics();
        }
        catch (UnsupportedOperationException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RdctExportersProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create a file for metrics");
            path = null;
        }
        Path path2 = fileToWrite = path;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            return CollectionsKt.listOf((Object)new FilteredMetricsExporter(new SynchronizedClearableLazy(() -> RdctExportersProvider.getMetricsExporters$lambda$0$0(fileToWrite)), RdctExportersProvider::getMetricsExporters$lambda$0$1));
        }
        return CollectionsKt.emptyList();
    }

    public long getReadInterval-UwyO8pc() {
        return DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    }

    private static final MetricExporter getMetricsExporters$lambda$0$0(Path $fileToWrite) {
        return (MetricExporter)new CsvGzippedMetricsExporter($fileToWrite);
    }

    private static final boolean getMetricsExporters$lambda$0$1(MetricData metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        return MetricsExtensionsKt.belongsToScope((MetricData)metric, (Scope)RdctScopesKt.RDCT);
    }
}

