/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceType;
import com.intellij.util.ArrayUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeploymentSourceImpl
implements ModuleDeploymentSource {
    private final ModulePointer myPointer;

    public ModuleDeploymentSourceImpl(@NotNull ModulePointer pointer) {
        if (pointer == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(0);
        }
        this.myPointer = pointer;
    }

    @Override
    @NotNull
    public ModulePointer getModulePointer() {
        ModulePointer modulePointer = this.myPointer;
        if (modulePointer == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(1);
        }
        return modulePointer;
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myPointer.getModule();
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        Module module = this.myPointer.getModule();
        if (module == null) {
            return null;
        }
        return ModuleDeploymentSourceImpl.getContentRoot(module);
    }

    public static VirtualFile getContentRoot(Module module) {
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    @Override
    @Nullable
    public File getFile() {
        VirtualFile contentRoot = this.getContentRoot();
        if (contentRoot == null) {
            return null;
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
    }

    @Override
    @Nullable
    public String getFilePath() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myPointer.getModuleName();
        if (string == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Module;
    }

    @Override
    public boolean isValid() {
        return this.getModule() != null;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDeploymentSource)) {
            return false;
        }
        return this.myPointer.equals((Object)((ModuleDeploymentSource)o).getModulePointer());
    }

    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @Override
    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(ModuleDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(3);
        }
        return deploymentSourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/ModuleDeploymentSourceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/ModuleDeploymentSourceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

