/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private final Map<RemoteServer<?>, ServerConnection<?>> myConnections = new ConcurrentHashMap();
    private final ServerConnectionEventDispatcher myEventDispatcher = new ServerConnectionEventDispatcher();

    @Override
    @NotNull
    public <C extends ServerConfiguration> ServerConnection<?> getOrCreateConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        ServerConnection<?> connection = this.myConnections.get(server);
        if (connection == null) {
            connection = this.doCreateConnection(server, this);
            this.myConnections.put(server, connection);
            this.myEventDispatcher.fireConnectionCreated(connection);
        }
        ServerConnection<?> serverConnection = connection;
        if (serverConnection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(1);
        }
        return serverConnection;
    }

    @Override
    @NotNull
    public <C extends ServerConfiguration> ServerConnection<?> createTemporaryConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(2);
        }
        ServerConnection<?> serverConnection = this.doCreateConnection(server, null);
        if (serverConnection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(3);
        }
        return serverConnection;
    }

    private <C extends ServerConfiguration> ServerConnection<?> doCreateConnection(@NotNull RemoteServer<C> server, ServerConnectionManagerImpl manager) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(4);
        }
        ServerTaskExecutorImpl executor = new ServerTaskExecutorImpl();
        return new ServerConnectionImpl(server, server.getType().createConnector(server, (ServerTaskExecutor)executor), manager, this.getEventDispatcher());
    }

    @Override
    @Nullable
    public <C extends ServerConfiguration> ServerConnection<?> getConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(5);
        }
        return this.myConnections.get(server);
    }

    void removeConnection(RemoteServer<?> server) {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        this.myConnections.remove(server);
    }

    public ServerConnectionEventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    @Override
    @NotNull
    public Collection<ServerConnection<?>> getConnections() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Collection<ServerConnection<?>> collection = Collections.unmodifiableCollection(this.myConnections.values());
        if (collection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryConnection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateConnection";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryConnection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConnection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }

    public static class DisconnectFromRemovedServer
    implements RemoteServerListener {
        @Override
        public void serverRemoved(@NotNull RemoteServer<?> server) {
            ServerConnectionManagerImpl impl;
            ServerConnection<?> connection;
            if (server == null) {
                DisconnectFromRemovedServer.$$$reportNull$$$0(0);
            }
            if ((connection = (impl = (ServerConnectionManagerImpl)ServerConnectionManager.getInstance()).getConnection(server)) != null) {
                connection.disconnect();
            }
        }

        @Override
        public void serverAdded(@NotNull RemoteServer<?> server) {
            if (server == null) {
                DisconnectFromRemovedServer.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "server";
            objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl$DisconnectFromRemovedServer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serverRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serverAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

