/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudProxySettings;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.util.CloudConfigurationUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigurationBase<Self extends CloudConfigurationBase<Self>>
extends ServerConfigurationBase<Self>
implements CloudAgentConfigBase {
    private String myEmail;
    private String myPassword;

    @Override
    @Attribute(value="email")
    public String getEmail() {
        return this.myEmail;
    }

    public void setEmail(String email) {
        this.myEmail = email;
    }

    @Override
    @Attribute(value="password")
    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    @Override
    @Transient
    public CloudProxySettings getProxySettings() {
        final HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        return new CloudProxySettings(){

            @Override
            public boolean useHttpProxy() {
                return httpConfigurable.USE_HTTP_PROXY;
            }

            @Override
            public String getHost() {
                return httpConfigurable.PROXY_HOST;
            }

            @Override
            public int getPort() {
                return httpConfigurable.PROXY_PORT;
            }

            @Override
            public boolean useAuthentication() {
                return httpConfigurable.PROXY_AUTHENTICATION;
            }

            @Override
            public String getLogin() {
                return httpConfigurable.getProxyLogin();
            }

            @Override
            public String getPassword() {
                return httpConfigurable.getPlainProxyPassword();
            }
        };
    }

    @Transient
    public boolean isPasswordSafe() {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes();
        return credentialAttributes != null && PasswordSafe.getInstance().get(credentialAttributes) != null;
    }

    @Nullable
    protected CredentialAttributes createCredentialAttributes() {
        return CloudConfigurationBase.createCredentialAttributes(this.getServiceName(), this.getCredentialUser());
    }

    @Transient
    public void setPasswordSafe(String password) {
        CloudConfigurationBase.doSetSafeValue(this.createCredentialAttributes(), this.getCredentialUser(), password, this::setPassword);
    }

    @Override
    @Transient
    public String getPasswordSafe() {
        return CloudConfigurationBase.doGetSafeValue(this.createCredentialAttributes(), this::getPassword);
    }

    @Transient
    @Nullable
    protected String getServiceName() {
        return null;
    }

    @Transient
    @Nullable
    protected String getCredentialUser() {
        return this.getEmail();
    }

    protected static void doSetSafeValue(@Nullable CredentialAttributes credentialAttributes, @Nullable String credentialUser, @Nullable String secretValue, @NotNull Consumer<? super String> unsafeSetter) {
        if (unsafeSetter == null) {
            CloudConfigurationBase.$$$reportNull$$$0(0);
        }
        CloudConfigurationUtil.doSetSafeValue(credentialAttributes, credentialUser, secretValue, unsafeSetter);
    }

    protected static String doGetSafeValue(@Nullable CredentialAttributes credentialAttributes, @NotNull Supplier<String> unsafeGetter) {
        if (unsafeGetter == null) {
            CloudConfigurationBase.$$$reportNull$$$0(1);
        }
        return CloudConfigurationUtil.doGetSafeValue(credentialAttributes, unsafeGetter);
    }

    protected static boolean hasSafeCredentials(@Nullable CredentialAttributes credentialAttributes) {
        return CloudConfigurationUtil.hasSafeCredentials(credentialAttributes);
    }

    @Nullable
    protected static CredentialAttributes createCredentialAttributes(String serviceName, String credentialsUser) {
        return CloudConfigurationUtil.createCredentialAttributes(serviceName, credentialsUser);
    }

    public boolean shouldMigrateToPasswordSafe() {
        return !StringUtil.isEmpty((String)this.getPassword());
    }

    public void migrateToPasswordSafe() {
        String unsafePassword = this.getPassword();
        if (!StringUtil.isEmpty((String)unsafePassword)) {
            this.setPasswordSafe(unsafePassword);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeSetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeGetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/util/CloudConfigurationBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetSafeValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetSafeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

