/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class UsageViewUtil {
    @NonNls
    public static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";

    private UsageViewUtil() {
    }

    @NotNull
    @NlsSafe
    public static String createNodeText(@NotNull PsiElement element) {
        if (element == null) {
            UsageViewUtil.$$$reportNull$$$0(0);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(2);
        }
        PsiUtilCore.ensureValid((PsiElement)psiElement);
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getLongName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(4);
        }
        PsiUtilCore.ensureValid((PsiElement)psiElement);
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(6);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        if (string == null) {
            UsageViewUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean hasNonCodeUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(8);
        }
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUsagesInGeneratedCode(UsageInfo @NotNull [] usages, @NotNull Project project) {
        if (project == null) {
            UsageViewUtil.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(10);
        }
        for (UsageInfo usage : usages) {
            VirtualFile file = usage.getVirtualFile();
            if (file == null || !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(11);
        }
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    public static UsageInfo @NotNull [] removeDuplicatedUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(12);
        }
        LinkedHashSet<UsageInfo> set = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = Arrays.stream(usages).filter(usage -> usage instanceof NonCodeUsageInfo).map(usage -> ((NonCodeUsageInfo)usage).newText).findFirst().orElse(null);
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage2 : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file;
                if (!(usage2 instanceof MoveRenameUsageInfo) || (file = usage2.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file)) == null || (usageElement = usage2.getElement()) == null || (psiReference = usage2.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage2.getRangeInElement();
                assert (rangeInElement != null) : usage2;
                TextRange range = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage2).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        UsageInfo[] usageInfoArray = set.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(13);
        }
        return usageInfoArray;
    }

    public static UsageInfo @NotNull [] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        int size;
        if (collection == null) {
            UsageViewUtil.$$$reportNull$$$0(14);
        }
        UsageInfo[] usageInfoArray = (size = collection.size()) == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(15);
        }
        return usageInfoArray;
    }

    public static PsiElement @NotNull [] toElements(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            UsageViewUtil.$$$reportNull$$$0(16);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, UsageInfo::getElement);
        if (psiElementArray == null) {
            UsageViewUtil.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    @ApiStatus.Obsolete
    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        if (info == null) {
            UsageViewUtil.$$$reportNull$$$0(18);
        }
        int offset = info.getNavigationOffset();
        VirtualFile file = info.getVirtualFile();
        Project project = info.getProject();
        if (file != null) {
            UsageViewStatisticsCollector.logUsageNavigate(project, info);
            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file, offset), requestFocus);
        }
    }

    @NotNull
    public static @Unmodifiable Set<UsageInfo> getNotExcludedUsageInfos(@NotNull UsageView usageView) {
        if (usageView == null) {
            UsageViewUtil.$$$reportNull$$$0(19);
        }
        Set<Usage> excludedUsages = usageView.getExcludedUsages();
        LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        LinkedHashSet<UsageInfo> linkedHashSet = usageInfos;
        if (linkedHashSet == null) {
            UsageViewUtil.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    public static boolean reportNonRegularUsages(UsageInfo @NotNull [] usages, @NotNull Project project) {
        if (project == null) {
            UsageViewUtil.$$$reportNull$$$0(21);
        }
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(22);
        }
        boolean inGeneratedCode = UsageViewUtil.hasUsagesInGeneratedCode(usages, project);
        if (UsageViewUtil.hasNonCodeUsages(usages) || inGeneratedCode) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(UsageViewBundle.message(inGeneratedCode ? "occurrences.found.in.comments.strings.non.java.files.and.generated.code" : "occurrences.found.in.comments.strings.and.non.java.files", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static KeyboardShortcut getShowUsagesWithSettingsShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut("ShowSettingsAndFindUsages");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 13, 15, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageInfoArray";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toElements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotExcludedUsageInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNodeText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLongName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasNonCodeUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUsagesInGeneratedCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasReadOnlyUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toUsageInfoArray";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNotExcludedUsageInfos";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportNonRegularUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 13, 15, 17, 20 -> new IllegalStateException(string);
        };
    }
}

