/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.RenameableUsage;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageDocumentProcessor;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class UsageInfo2UsageAdapter
implements UsageInModule,
UsageInfoAdapter,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage,
RenameableUsage,
UiCompatibleDataProvider,
UsagePresentation,
UsageDocumentProcessor {
    public static final NotNullFunction<UsageInfo, Usage> CONVERTER = UsageInfo2UsageAdapter::new;
    private static final Comparator<UsageInfo> BY_NAVIGATION_OFFSET = Comparator.comparingInt(UsageInfo::getNavigationOffset);
    public static boolean ourAutomaticallyCalculatePresentationInTests = true;
    @NotNull
    private final UsageInfo myUsageInfo;
    @NotNull
    private Object myMergedUsageInfos;
    @Nullable
    private SmartPsiFileRange myMergedNavigationRange;
    private final int myLineNumber;
    private final int myOffset;
    private volatile UsageNodePresentation myCachedPresentation;
    @Nullable
    private final VirtualFile myVirtualFile;
    @Nullable
    private final SmartPsiFileRange myNavigationRange;
    private volatile UsageType myUsageType;
    private long myModificationStamp;

    @Nullable
    private static SmartPsiFileRange possiblySmart(@Nullable PsiFile psiFile, @Nullable Segment segment) {
        if (segment == null) {
            return null;
        }
        if (psiFile != null && segment instanceof TextRange) {
            TextRange range = (TextRange)segment;
            return SmartPointerManager.getInstance((Project)psiFile.getProject()).createSmartPsiFileRangePointer(psiFile, range);
        }
        return null;
    }

    public UsageInfo2UsageAdapter(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(0);
        }
        this.myUsageInfo = usageInfo;
        this.myMergedUsageInfos = usageInfo;
        ComputedData data = (ComputedData)ReadAction.compute(() -> {
            int lineNumber;
            TextRange navigationRange;
            int offset;
            Document document;
            VirtualFile virtualFile = usageInfo.getVirtualFile();
            PsiElement element = this.getElement();
            PsiFile psiFile = usageInfo.getFile();
            boolean isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
            Document document2 = document = isNullOrBinary ? null : PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            if (document == null) {
                offset = element == null || isNullOrBinary ? 0 : element.getTextOffset();
                navigationRange = element == null || isNullOrBinary ? null : element.getTextRange();
                lineNumber = -1;
            } else {
                Segment range = this.myUsageInfo.getNavigationRange();
                if (range == null || range.getStartOffset() == -1) {
                    offset = element == null ? 0 : element.getTextOffset();
                    navigationRange = element == null ? null : element.getTextRange();
                    lineNumber = -1;
                } else {
                    offset = -1;
                    navigationRange = range;
                    lineNumber = UsageInfo2UsageAdapter.getLineNumber(document, range.getStartOffset());
                }
            }
            long modificationStamp = psiFile == null ? -1L : psiFile.getViewProvider().getModificationStamp();
            return new ComputedData(offset, lineNumber, virtualFile, UsageInfo2UsageAdapter.possiblySmart(psiFile, (Segment)navigationRange), modificationStamp);
        });
        this.myOffset = data.offset;
        this.myLineNumber = data.lineNumber;
        this.myVirtualFile = data.virtualFile;
        this.myNavigationRange = data.navigationRange;
        this.myMergedNavigationRange = data.navigationRange;
        this.myModificationStamp = data.modificationStamp;
    }

    @Override
    public UsageInfo @NotNull [] getMergedInfos() {
        UsageInfo[] usageInfoArray;
        Object infos = this.myMergedUsageInfos;
        if (infos instanceof UsageInfo) {
            UsageInfo[] usageInfoArray2 = new UsageInfo[1];
            usageInfoArray = usageInfoArray2;
            usageInfoArray2[0] = (UsageInfo)infos;
        } else {
            usageInfoArray = (UsageInfo[])infos;
        }
        if (usageInfoArray == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    @Override
    @NotNull
    public CompletableFuture<UsageInfo[]> getMergedInfosAsync() {
        CompletableFuture<UsageInfo[]> completableFuture = CompletableFuture.completedFuture(this.getMergedInfos());
        if (completableFuture == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private static int getLineNumber(@NotNull Document document, int startOffset) {
        if (document == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(3);
        }
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (startOffset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(startOffset);
    }

    private Color computeBackgroundColor() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return EditorTabPresentationUtil.getFileBackgroundColor((Project)this.getProject(), (VirtualFile)file);
    }

    protected TextChunk @NotNull [] computeText() {
        TextChunk[] chunks;
        PsiFile psiFile = this.getPsiFile();
        boolean isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        PsiElement element = this.getElement();
        if (element != null && isNullOrBinary) {
            EditorColorsScheme scheme = UsageTreeColorsScheme.getInstance().getScheme();
            chunks = new TextChunk[]{new TextChunk(scheme.getAttributes(DefaultLanguageHighlighterColors.CLASS_NAME), UsageInfo2UsageAdapter.clsType(element)), new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), " "), new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), UsageInfo2UsageAdapter.clsName(element))};
        } else {
            Document document;
            Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            chunks = document == null ? (element == null ? new TextChunk[]{new TextChunk(SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes(), UsageViewBundle.message("node.invalid", new Object[0]))} : new TextChunk[]{new TextChunk(new TextAttributes(), element.getText())}) : ChunkExtractor.extractChunks(psiFile, this);
        }
        if (chunks == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(4);
        }
        return chunks;
    }

    @Override
    @NotNull
    public UsagePresentation getPresentation() {
        UsageInfo2UsageAdapter usageInfo2UsageAdapter = this;
        if (usageInfo2UsageAdapter == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(5);
        }
        return usageInfo2UsageAdapter;
    }

    @Override
    public boolean isValid() {
        PsiElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        for (UsageInfo usageInfo : this.getMergedInfos()) {
            if (!usageInfo.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        PsiFile psiFile = this.getPsiFile();
        return psiFile == null || psiFile.isValid() && !psiFile.isWritable();
    }

    @Override
    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.getUsageInfo().getSegment();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    @Override
    public void selectInEditor() {
        if (!this.isValid()) {
            return;
        }
        Editor editor = this.openTextEditor(true);
        Segment marker = this.getFirstSegment();
        if (marker != null) {
            editor.getSelectionModel().setSelection(marker.getStartOffset(), marker.getEndOffset());
        }
    }

    @Override
    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        Segment marker = this.getFirstSegment();
        if (marker != null) {
            SelectInEditorManager.getInstance((Project)this.getProject()).selectInEditor(this.getFile(), marker.getStartOffset(), marker.getEndOffset(), false, false);
        }
    }

    private Segment getFirstSegment() {
        return this.getUsageInfo().getSegment();
    }

    @Override
    public Document getDocument() {
        PsiFile file = this.getUsageInfo().getFile();
        if (file == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            UsageViewStatisticsCollector.logUsageNavigate(this.getProject(), this);
            this.openTextEditor(focus);
        }
    }

    public Editor openTextEditor(boolean focus) {
        OpenFileDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, focus);
    }

    public boolean canNavigate() {
        VirtualFile file = this.getFile();
        return file != null && file.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private OpenFileDescriptor getDescriptor() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        Segment range = this.getNavigationRange();
        if (range != null && file instanceof VirtualFileWindow && range.getStartOffset() >= 0) {
            range = ((VirtualFileWindow)file).getDocumentWindow().injectedToHost(TextRange.create((Segment)range));
            file = ((VirtualFileWindow)file).getDelegate();
        }
        return new OpenFileDescriptor(this.getProject(), file, range == null ? this.getNavigationOffset() : range.getStartOffset());
    }

    @Override
    public int getNavigationOffset() {
        Document document = this.getDocument();
        if (document == null) {
            return -1;
        }
        int offset = UsageInfo2UsageAdapter.getStartOffset(this.myMergedNavigationRange);
        if (offset == -1) {
            offset = this.getUsageInfo().getNavigationOffset();
        }
        if (offset == -1) {
            offset = this.myOffset;
        }
        if (offset >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            offset = document.getLineStartOffset(line);
        }
        return offset;
    }

    private static int getStartOffset(@Nullable SmartPsiFileRange smartPsiFileRange) {
        int offset = -1;
        if (smartPsiFileRange != null) {
            Segment range = smartPsiFileRange.getRange();
            offset = range != null ? range.getStartOffset() : -1;
        }
        return offset;
    }

    public Segment getNavigationRange() {
        Segment range;
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        Segment segment = range = this.myMergedNavigationRange != null ? this.myMergedNavigationRange.getRange() : null;
        if (range == null) {
            range = this.getUsageInfo().getNavigationRange();
        }
        if (range == null) {
            ProperTextRange rangeInElement = this.getUsageInfo().getRangeInElement();
            Object object = this.myOffset < 0 ? new UnfairTextRange(-1, -1) : (range = rangeInElement == null ? TextRange.from((int)this.myOffset, (int)1) : rangeInElement.shiftRight(this.myOffset));
        }
        if (range.getEndOffset() >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            range = TextRange.from((int)document.getLineStartOffset(line), (int)1);
        }
        return range;
    }

    @NotNull
    private Project getProject() {
        Project project = this.getUsageInfo().getProject();
        if (project == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(6);
        }
        return project;
    }

    public String toString() {
        TextChunk[] textChunks = this.getPresentation().getText();
        StringBuilder result2 = new StringBuilder();
        for (int j = 0; j < textChunks.length; ++j) {
            if (j > 0) {
                result2.append("|");
            }
            TextChunk textChunk = textChunks[j];
            result2.append(textChunk);
        }
        return result2.toString();
    }

    @Override
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile virtualFile = this.getFile();
        return virtualFile != null ? ProjectFileIndex.getInstance((Project)this.getProject()).getModuleForFile(virtualFile) : null;
    }

    @Override
    public OrderEntry getLibraryEntry() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
        if (virtualFile.getFileType().isBinary() || fileIndex.isInLibrarySource(virtualFile)) {
            List orders = fileIndex.getOrderEntriesForFile(virtualFile);
            for (OrderEntry order : orders) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return order;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<SyntheticLibrary> getSyntheticLibraries() {
        if (!this.isValid()) {
            List<SyntheticLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(7);
            }
            return list2;
        }
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            List<SyntheticLibrary> list3 = Collections.emptyList();
            if (list3 == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(8);
            }
            return list3;
        }
        Project project = this.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (!fileIndex.isInLibrarySource(virtualFile)) {
            List<SyntheticLibrary> list4 = Collections.emptyList();
            if (list4 == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(9);
            }
            return list4;
        }
        VirtualFile sourcesRoot = fileIndex.getSourceRootForFile(virtualFile);
        if (sourcesRoot != null) {
            ArrayList<SyntheticLibrary> list5 = new ArrayList<SyntheticLibrary>();
            for (AdditionalLibraryRootsProvider e : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                for (SyntheticLibrary library : e.getAdditionalProjectLibraries(project)) {
                    Condition excludeFileCondition;
                    if (!library.getSourceRoots().contains(sourcesRoot) || (excludeFileCondition = library.getUnitedExcludeCondition()) != null && excludeFileCondition.value((Object)virtualFile)) continue;
                    list5.add(library);
                }
            }
            ArrayList<SyntheticLibrary> arrayList = list5;
            if (arrayList == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        List<SyntheticLibrary> list6 = Collections.emptyList();
        if (list6 == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(11);
        }
        return list6;
    }

    @Override
    public VirtualFile getFile() {
        return this.myVirtualFile;
    }

    private PsiFile getPsiFile() {
        return this.getUsageInfo().getFile();
    }

    @Override
    @NotNull
    public String getPath() {
        VirtualFile file = this.getFile();
        return file != null ? file.getPath() : "";
    }

    @Override
    public int getLine() {
        return this.myLineNumber;
    }

    @Override
    public boolean merge(@NotNull MergeableUsage other) {
        if (other == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(12);
        }
        if (!(other instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo2UsageAdapter u2 = (UsageInfo2UsageAdapter)other;
        assert (u2 != this);
        if (this.myLineNumber != u2.myLineNumber || !Comparing.equal((Object)this.getFile(), (Object)u2.getFile())) {
            return false;
        }
        UsageInfo merged = (UsageInfo)ArrayUtil.mergeArrays((Object[])this.getMergedInfos(), (Object[])u2.getMergedInfos());
        this.myMergedUsageInfos = ((UsageInfo[])merged).length == 1 ? merged[0] : merged;
        Arrays.sort(this.getMergedInfos(), BY_NAVIGATION_OFFSET);
        this.myMergedNavigationRange = UsageInfo2UsageAdapter.merge(this.myMergedNavigationRange, u2.myMergedNavigationRange);
        this.myModificationStamp = Long.MIN_VALUE;
        return true;
    }

    @Nullable
    private static SmartPsiFileRange merge(@Nullable SmartPsiFileRange sr1, @Nullable SmartPsiFileRange sr2) {
        int r2end;
        int r2start;
        if (sr1 == null) {
            return sr2;
        }
        if (sr2 == null) {
            return sr1;
        }
        Segment r1 = sr1.getRange();
        Segment r2 = sr2.getRange();
        if (r1 == null) {
            return sr2;
        }
        if (r2 == null) {
            return sr1;
        }
        int r1start = r1.getStartOffset();
        if (r1start != (r2start = r2.getStartOffset())) {
            return r1start <= r2start ? sr1 : sr2;
        }
        int r1end = r1.getEndOffset();
        return r1end <= (r2end = r2.getEndOffset()) ? sr1 : sr2;
    }

    @Override
    public void reset() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myMergedUsageInfos = this.myUsageInfo;
        this.myMergedNavigationRange = this.myNavigationRange;
        this.resetCachedPresentation();
    }

    protected final void resetCachedPresentation() {
        this.myModificationStamp = Long.MIN_VALUE;
    }

    @Override
    @Nullable
    public final PsiElement getElement() {
        return this.getUsageInfo().getElement();
    }

    @Override
    public boolean isNonCodeUsage() {
        return this.getUsageInfo().isNonCodeUsage;
    }

    @NotNull
    public UsageInfo getUsageInfo() {
        UsageInfo usageInfo = this.myUsageInfo;
        if (usageInfo == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(13);
        }
        return usageInfo;
    }

    public final int compareTo(@NotNull UsageInfo2UsageAdapter o) {
        int byPath;
        if (o == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(14);
        }
        if ((byPath = VfsUtilCore.compareByPath((VirtualFile)this.myVirtualFile, (VirtualFile)o.myVirtualFile)) != 0) {
            return byPath;
        }
        int offset = UsageInfo2UsageAdapter.getStartOffset(this.myMergedNavigationRange);
        int other = UsageInfo2UsageAdapter.getStartOffset(o.myMergedNavigationRange);
        return Integer.compare(offset, other);
    }

    @Override
    public void rename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(15);
        }
        PsiReference reference = this.getUsageInfo().getReference();
        assert (reference != null) : this;
        reference.handleElementRename(newName);
    }

    public static UsageInfo2UsageAdapter @NotNull [] convert(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(16);
        }
        UsageInfo2UsageAdapter[] result2 = new UsageInfo2UsageAdapter[usageInfos.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = new UsageInfo2UsageAdapter(usageInfos[i]);
        }
        if (result2 == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(17);
        }
        return result2;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(18);
        }
        sink.set(UsageView.USAGE_INFO_KEY, (Object)this.getUsageInfo());
        sink.set(UsageView.USAGE_INFO_LIST_KEY, Arrays.asList(this.getMergedInfos()));
    }

    private long getCurrentModificationStamp() {
        PsiFile containingFile = this.getPsiFile();
        return containingFile == null ? -1L : containingFile.getViewProvider().getModificationStamp();
    }

    @Override
    public TextChunk @NotNull [] getText() {
        TextChunk[] textChunkArray = this.getNotNullCachedPresentation().getText();
        if (textChunkArray == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(19);
        }
        return textChunkArray;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public final UsageNodePresentation getCachedPresentation() {
        return this.myCachedPresentation;
    }

    @Override
    @ApiStatus.Internal
    public final void updateCachedPresentation() {
        boolean isModified;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        UsageNodePresentation cachedPresentation = this.getCachedPresentation();
        long currentModificationStamp = this.getCurrentModificationStamp();
        boolean bl = isModified = currentModificationStamp != this.myModificationStamp;
        if (cachedPresentation == null || isModified && this.isValid()) {
            this.myCachedPresentation = new UsageNodePresentation(this.computeIcon(), this.computeText(), this.computeBackgroundColor());
            this.myModificationStamp = currentModificationStamp;
        }
    }

    @NotNull
    private UsageNodePresentation getNotNullCachedPresentation() {
        UsageNodePresentation cachedPresentation = this.getCachedPresentation();
        UsageNodePresentation usageNodePresentation = cachedPresentation != null ? cachedPresentation : UsageNodePresentation.empty();
        if (usageNodePresentation == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(20);
        }
        return usageNodePresentation;
    }

    @NotNull
    private static String clsType(@NotNull PsiElement psiElement) {
        String type;
        if (psiElement == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(21);
        }
        if (!(type = LanguageFindUsages.getType((PsiElement)psiElement)).isEmpty()) {
            String string = type;
            if (string == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = (String)ObjectUtils.notNull((Object)TypePresentationService.getService().getTypePresentableName(psiElement.getClass()), (Object)"");
        if (string == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String clsName(@NotNull PsiElement psiElement) {
        String name;
        if (psiElement == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(24);
        }
        if (!(name = LanguageFindUsages.getNodeText((PsiElement)psiElement, (boolean)false)).isEmpty()) {
            String string = name;
            if (string == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = (String)ObjectUtils.notNull((Object)(psiElement instanceof PsiNamedElement ? ((PsiNamedElement)psiElement).getName() : null), (Object)"");
        if (string == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPlainText() {
        Document document;
        int startOffset;
        boolean isNullOrBinary;
        PsiElement element = this.getElement();
        PsiFile psiFile = this.getPsiFile();
        boolean bl = isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        if (element != null && isNullOrBinary) {
            String string = UsageInfo2UsageAdapter.clsType(element) + " " + UsageInfo2UsageAdapter.clsName(element);
            if (string == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (element != null && (startOffset = this.getNavigationOffset()) != -1 && (document = this.getDocument()) != null) {
            int lineNumber = document.getLineNumber(startOffset);
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String prefixSuffix = null;
            if (lineEnd - lineStart > 200) {
                prefixSuffix = "...";
                lineStart = Math.max(startOffset - 40, lineStart);
                lineEnd = Math.min(startOffset + 100, lineEnd);
            }
            Object s = document.getCharsSequence().subSequence(lineStart, lineEnd).toString();
            if (prefixSuffix != null) {
                s = prefixSuffix + (String)s + prefixSuffix;
            }
            String string = s;
            if (string == null) {
                UsageInfo2UsageAdapter.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = UsageViewBundle.message("node.invalid", new Object[0]);
        if (string == null) {
            UsageInfo2UsageAdapter.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    @Nullable
    public Color getBackgroundColor() {
        return this.getNotNullCachedPresentation().getBackgroundColor();
    }

    @Override
    public Icon getIcon() {
        return this.getNotNullCachedPresentation().getIcon();
    }

    @Nullable
    protected Icon computeIcon() {
        Icon icon = this.myUsageInfo.getIcon();
        if (icon != null) {
            return icon;
        }
        PsiElement psiElement = this.getElement();
        return psiElement != null && psiElement.isValid() && !this.isFindInPathUsage(psiElement) ? psiElement.getIcon(0) : null;
    }

    private boolean isFindInPathUsage(PsiElement psiElement) {
        return psiElement instanceof PsiFile && this.getUsageInfo().getPsiFileRange() != null;
    }

    @Override
    public String getTooltipText() {
        return this.myUsageInfo.getTooltipText();
    }

    @Nullable
    public UsageType getUsageType() {
        UsageType usageType = this.myUsageType;
        if (usageType == null) {
            usageType = this.computeUsageType();
            if (usageType == null) {
                usageType = UsageType.UNCLASSIFIED;
            }
            this.myUsageType = usageType;
        }
        return usageType;
    }

    @Nullable
    private UsageType computeUsageType() {
        PsiFile file = this.getPsiFile();
        if (file == null) {
            return null;
        }
        Segment segment = this.getFirstSegment();
        if (segment == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        return ChunkExtractor.getExtractor(file).deriveUsageTypeFromHighlighting(document.getCharsSequence(), segment.getStartOffset(), segment.getEndOffset());
    }

    @Override
    @Nullable
    public Class<? extends PsiReference> getReferenceClass() {
        return this.myUsageInfo.getReferenceClass();
    }

    @TestOnly
    @ApiStatus.Internal
    public static void disableAutomaticPresentationCalculationInTests(Runnable block) {
        boolean old = ourAutomaticallyCalculatePresentationInTests;
        ourAutomaticallyCalculatePresentationInTests = false;
        try {
            block.run();
        }
        finally {
            ourAutomaticallyCalculatePresentationInTests = old;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 17, 19, 20, 22, 23, 25, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageInfo2UsageAdapter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageInfo2UsageAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedInfos";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedInfosAsync";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticLibraries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullCachedPresentation";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "clsType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "clsName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clsType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clsName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 17, 19, 20, 22, 23, 25, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    private record ComputedData(int offset, int lineNumber, VirtualFile virtualFile, @Nullable SmartPsiFileRange navigationRange, long modificationStamp) {
    }
}

