/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.ExporterToTextFile;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.PreviewUsageAction;
import com.intellij.usages.impl.UsageFilteringRuleActions;
import com.intellij.usages.impl.UsageFilteringRuleState;
import com.intellij.usages.impl.UsageFilteringRuleStateService;
import com.intellij.usages.impl.UsageModelTracker;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageNodeTreeBuilder;
import com.intellij.usages.impl.UsageReferenceClassProvider;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewElementsListener;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.impl.UsageViewTreeCellRenderer;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.impl.actions.MergeSameLineUsagesAction;
import com.intellij.usages.impl.rules.UsageFilteringRules;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.CoroutineDispatcherBackedExecutor;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public class UsageViewImpl
implements UsageViewEx {
    private final int myUniqueIdentifier;
    private static final GroupNode.NodeComparator COMPARATOR = new GroupNode.NodeComparator();
    private static final Logger LOG = Logger.getInstance(UsageViewImpl.class);
    @NonNls
    public static final String SHOW_RECENT_FIND_USAGES_ACTION_ID = "UsageView.ShowRecentFindUsages";
    private final UsageNodeTreeBuilder myBuilder;
    @NotNull
    private final CoroutineScope coroutineScope;
    private MyPanel myRootPanel;
    private MyTree myTree;
    private final ScheduledFuture<?> myFireEventsFuture;
    private Content myContent;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;
    private final UsageFilteringRuleState myFilteringRulesState;
    private final Supplier<? extends UsageSearcher> myUsageSearcherFactory;
    @NotNull
    private final Project myProject;
    private volatile boolean mySearchInProgress;
    private final ExporterToTextFile myTextFileExporter;
    private final SingleAlarm updateAlarm;
    private final ExclusionHandlerEx<DefaultMutableTreeNode> myExclusionHandler;
    private final Map<Usage, UsageNode> myUsageNodes;
    public static final UsageNode NULL_NODE = new UsageNode(null, NullUsage.INSTANCE);
    private final ButtonPanel myButtonPanel;
    private boolean myNeedUpdateButtons;
    private final JComponent myAdditionalComponent;
    private volatile boolean isDisposed;
    private volatile boolean myChangesDetected;
    @Nullable
    private GroupNode myAutoSelectedGroupNode;
    private final AtomicReference<@NotNull Set<UsageInfo>> myNonDisposableUsageInfos;
    public static final Comparator<Usage> USAGE_COMPARATOR_BY_FILE_AND_OFFSET = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == NullUsage.INSTANCE) {
            return -1;
        }
        if (o2 == NullUsage.INSTANCE) {
            return 1;
        }
        int c = UsageViewImpl.compareByFileAndOffset(o1, o2);
        if (c != 0) {
            return c;
        }
        return o1.toString().compareTo(o2.toString());
    };
    @NonNls
    public static final String HELP_ID = "ideaInterface.find";
    private UsageContextPanel myCurrentUsageContextPanel;
    private final List<UsageContextPanel> myAllUsageContextPanels;
    private UsageContextPanel.Provider myCurrentUsageContextProvider;
    private JPanel myCentralPanel;
    @NotNull
    private final GroupNode myRoot;
    private final UsageViewTreeModelBuilder myModel;
    private Splitter myPreviewSplitter;
    private volatile ProgressIndicator associatedProgress;
    private final UsageViewTreeCellRenderer myUsageViewTreeCellRenderer;
    @Nullable
    private Action myRerunAction;
    private final CoroutineDispatcherBackedExecutor updateRequests;
    private final List<UsageView.ExcludeListener> myExcludeListeners;
    private final Set<Pair<Class<? extends PsiReference>, Language>> myReportedReferenceClasses;
    private Runnable fusRunnable;
    private final MultiMap<Node, Node> fireTreeNodesChangedMap;
    private final Consumer<Node> edtFireTreeNodesChangedQueue;
    private final Set<NodeChange> modelToSwingNodeChanges;
    private final Consumer<NodeChange> edtModelToSwingNodeChangesQueue;
    protected final TreeExpander treeExpander;
    private boolean rulesChanged;

    @ApiStatus.Internal
    public int getFilteredOutNodeCount() {
        return this.myBuilder.getFilteredUsagesCount();
    }

    @ApiStatus.Internal
    public void setFilteringRules(UsageFilteringRule @NotNull [] rules) {
        if (rules == null) {
            UsageViewImpl.$$$reportNull$$$0(0);
        }
        this.myFilteringRules = rules;
        this.myBuilder.setFilteringRules(rules);
        this.rulesChanged();
    }

    private static int compareByFileAndOffset(@NotNull Usage o1, @NotNull Usage o2) {
        VirtualFile file2;
        VirtualFile file1;
        if (o1 == null) {
            UsageViewImpl.$$$reportNull$$$0(1);
        }
        if (o2 == null) {
            UsageViewImpl.$$$reportNull$$$0(2);
        }
        if (o1 instanceof UsageInFile) {
            UsageInFile inFile1 = (UsageInFile)o1;
            v0 = inFile1.getFile();
        } else {
            v0 = file1 = null;
        }
        if (o2 instanceof UsageInFile) {
            UsageInFile inFile2 = (UsageInFile)o2;
            v1 = inFile2.getFile();
        } else {
            v1 = file2 = null;
        }
        if (file1 == null) {
            return file2 == null ? 0 : -1;
        }
        if (file2 == null) {
            return 1;
        }
        if (file1.equals(file2)) {
            return Integer.compare(o1.getNavigationOffset(), o2.getNavigationOffset());
        }
        return VfsUtilCore.compareByPath((VirtualFile)file1, (VirtualFile)file2);
    }

    @ApiStatus.Internal
    public UsageViewImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] targets, @Nullable Supplier<? extends UsageSearcher> usageSearcherFactory) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(3);
        }
        if (coroutineScope == null) {
            UsageViewImpl.$$$reportNull$$$0(4);
        }
        if (presentation == null) {
            UsageViewImpl.$$$reportNull$$$0(5);
        }
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(6);
        }
        this.myFilteringRulesState = UsageFilteringRuleStateService.createFilteringRuleState();
        this.mySearchInProgress = true;
        this.myTextFileExporter = new ExporterToTextFile(this, this.getUsageViewSettings());
        this.myUsageNodes = new ConcurrentHashMap<Usage, UsageNode>();
        this.myAdditionalComponent = new JPanel(new BorderLayout());
        this.myNonDisposableUsageInfos = new AtomicReference(Collections.emptySet());
        this.myAllUsageContextPanels = new ArrayList<UsageContextPanel>();
        this.myExcludeListeners = ContainerUtil.createConcurrentList();
        this.myReportedReferenceClasses = ConcurrentCollectionFactory.createConcurrentSet();
        this.fusRunnable = () -> {
            if (this.myTree == null) {
                return;
            }
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            Object[] navigatables = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dc);
            if (navigatables != null) {
                ContainerUtil.filter((Object[])navigatables, n -> n.canNavigateToSource() && n instanceof PsiElementUsage).forEach(n -> {
                    PsiElement psiElement = ((PsiElementUsage)n).getElement();
                    if (psiElement != null) {
                        UsageViewStatisticsCollector.logItemChosen(this.getProject(), this, CodeNavigateSource.FindToolWindow, psiElement.getLanguage(), n instanceof SimilarUsage);
                    }
                });
            }
        };
        this.fireTreeNodesChangedMap = MultiMap.createLinked();
        this.edtFireTreeNodesChangedQueue = node -> {
            if (!this.getPresentation().isDetachedMode()) {
                MultiMap<Node, Node> multiMap = this.fireTreeNodesChangedMap;
                synchronized (multiMap) {
                    Node parent = (Node)node.getParent();
                    if (parent != null) {
                        this.fireTreeNodesChangedMap.putValue((Object)parent, node);
                    }
                }
            }
        };
        this.modelToSwingNodeChanges = new LinkedHashSet<NodeChange>();
        this.edtModelToSwingNodeChangesQueue = parent -> {
            if (parent == null) {
                UsageViewImpl.$$$reportNull$$$0(95);
            }
            if (!this.getPresentation().isDetachedMode()) {
                Set<NodeChange> set = this.modelToSwingNodeChanges;
                synchronized (set) {
                    this.modelToSwingNodeChanges.add((NodeChange)parent);
                }
            }
        };
        this.treeExpander = new TreeExpander(){

            public void expandAll() {
                UsageViewImpl.this.expandAll();
                UsageViewImpl.this.getUsageViewSettings().setExpanded(true);
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                UsageViewImpl.this.collapseAll();
                UsageViewImpl.this.getUsageViewSettings().setExpanded(false);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        this.coroutineScope = coroutineScope;
        this.myUniqueIdentifier = COUNTER.getAndIncrement();
        this.myFireEventsFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> this.fireEvents(), 50L, 50L, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)this, () -> this.myFireEventsFuture.cancel(false));
        this.myPresentation = presentation;
        this.myTargets = targets;
        this.myUsageSearcherFactory = usageSearcherFactory;
        this.myProject = project;
        this.myButtonPanel = new ButtonPanel();
        this.myModel = new UsageViewTreeModelBuilder(this.myPresentation, targets);
        this.myRoot = (GroupNode)this.myModel.getRoot();
        this.myGroupingRules = UsageViewImpl.getActiveGroupingRules(project, this.getUsageViewSettings(), this.getPresentation());
        this.myBuilder = new UsageNodeTreeBuilder(this.myTargets, this.myGroupingRules, this.getActiveFilteringRules(this.myProject), this.myRoot, this.myProject);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> this.rulesChanged());
        this.myUsageViewTreeCellRenderer = new UsageViewTreeCellRenderer(this);
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> WriteIntentReadAction.run(() -> this.initInEDT()));
        }
        this.myExclusionHandler = new ExclusionHandlerEx<DefaultMutableTreeNode>(){

            public boolean isNodeExclusionAvailable(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return node instanceof UsageNode;
            }

            public boolean isNodeExcluded(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ((UsageNode)node).isDataExcluded();
            }

            public void excludeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                HashSet nodes = new HashSet();
                TreeUtil.treeNodeTraverser((TreeNode)node).traverse().filter(Node.class).addAllTo(nodes);
                this.collectParentNodes(node, true, nodes);
                this.setExcludeNodes(nodes, true, true);
            }

            @Override
            public void excludeNodeSilently(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                HashSet nodes = new HashSet();
                TreeUtil.treeNodeTraverser((TreeNode)node).traverse().filter(Node.class).addAllTo(nodes);
                this.collectParentNodes(node, true, nodes);
                this.setExcludeNodes(nodes, true, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void collectParentNodes(@NotNull DefaultMutableTreeNode node, boolean almostAllChildrenExcluded, @NotNull Set<? super Node> nodes) {
                List otherNodes;
                TreeNode parent;
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (nodes == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((parent = node.getParent()) == UsageViewImpl.this.myRoot || !(parent instanceof GroupNode)) {
                    return;
                }
                GroupNode parentNode = (GroupNode)parent;
                GroupNode groupNode = parentNode;
                synchronized (groupNode) {
                    otherNodes = ContainerUtil.filter(parentNode.getChildren(), n -> n.isExcluded() != almostAllChildrenExcluded);
                }
                if (otherNodes.size() == 1 && otherNodes.get(0) == node) {
                    nodes.add(parentNode);
                    this.collectParentNodes(parentNode, almostAllChildrenExcluded, nodes);
                }
            }

            private void setExcludeNodes(@NotNull Set<? extends Node> nodes, boolean excluded, boolean updateImmediately) {
                if (nodes == null) {
                    1.$$$reportNull$$$0(6);
                }
                LinkedHashSet<Usage> affectedUsages = new LinkedHashSet<Usage>();
                for (Node node : nodes) {
                    Object userObject = node.getUserObject();
                    if (userObject instanceof Usage) {
                        Usage usage = (Usage)userObject;
                        affectedUsages.add(usage);
                    }
                    node.setExcluded(excluded, UsageViewImpl.this.edtFireTreeNodesChangedQueue);
                }
                if (updateImmediately) {
                    UsageViewImpl.this.updateImmediatelyNodesUpToRoot(nodes);
                    for (UsageView.ExcludeListener excludeListener : UsageViewImpl.this.myExcludeListeners) {
                        excludeListener.fireExcluded(affectedUsages, excluded);
                    }
                }
            }

            public void includeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(7);
                }
                HashSet nodes = new HashSet();
                TreeUtil.treeNodeTraverser((TreeNode)node).traverse().filter(Node.class).addAllTo(nodes);
                this.collectParentNodes(node, false, nodes);
                this.setExcludeNodes(nodes, false, true);
            }

            public boolean isActionEnabled(boolean isExcludeAction) {
                return UsageViewImpl.this.getPresentation().isExcludeAvailable();
            }

            public void onDone(boolean isExcludeAction) {
                ThreadingAssertions.assertEventDispatchThread();
                if (UsageViewImpl.this.myRootPanel.hasNextOccurence()) {
                    UsageViewImpl.this.myRootPanel.goNextOccurence();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNodeSilently";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "collectParentNodes";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setExcludeNodes";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.updateRequests = AppJavaExecutorUtil.createBoundedTaskExecutor((String)"Usage View Update Requests", (CoroutineScope)coroutineScope, (int)JobSchedulerImpl.getJobPoolParallelism());
        this.updateAlarm = SingleAlarm.singleEdtAlarm((int)300, (CoroutineScope)coroutineScope, () -> {
            if (!this.isDisposed()) {
                this.updateImmediately();
            }
        });
    }

    @Override
    @IntellijInternalApi
    @ApiStatus.Internal
    public int getId() {
        return this.myUniqueIdentifier;
    }

    @ApiStatus.Internal
    public JTree getTree() {
        return this.myTree;
    }

    private void initInEDT() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.myTree = new MyTree(this.myModel);
        this.myTree.setName("UsageViewTree");
        this.myTree.getAccessibleContext().setAccessibleName(UsageViewBundle.message("usages.tree.accessible.name", new Object[0]));
        this.myRootPanel = new MyPanel((JTree)((Object)this.myTree));
        Disposer.register((Disposable)this, (Disposable)this.myRootPanel);
        this.myTree.setModel(this.myModel);
        this.myRootPanel.setLayout(new BorderLayout());
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
        this.myRootPanel.add((Component)toolWindowPanel, "Center");
        toolWindowPanel.setToolbar(this.createActionsToolbar());
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.setupCentralPanel();
        this.initTree();
        toolWindowPanel.setContent((JComponent)this.myCentralPanel);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)this.myUsageViewTreeCellRenderer));
        SwingUtilities.invokeLater(() -> {
            if (!this.isDisposed()) {
                this.collapseAll();
            }
        });
        UsageModelTracker myModelTracker = new UsageModelTracker(this.getProject());
        Disposer.register((Disposable)this, (Disposable)myModelTracker);
        myModelTracker.addListener(isPropertyChange -> {
            if (!isPropertyChange) {
                this.myChangesDetected = true;
            }
            this.updateLater();
        }, this);
        if (this.myPresentation.isShowCancelButton()) {
            this.addButtonToLowerPane(() -> this.close(), UsageViewBundle.message("usage.view.cancel.button", new Object[0]));
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(__ -> ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.isDisposed()) {
                this.updateOnSelectionChanged(this.myProject);
                this.myNeedUpdateButtons = true;
            }
        }));
        this.myModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                UsageViewImpl.this.myNeedUpdateButtons = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/usages/impl/UsageViewImpl$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (UsageViewImpl.this.rulesChanged) {
                    UsageViewImpl.this.rulesChanged = false;
                    UsageViewImpl.this.rulesChanged();
                }
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    public UsageViewSettings getUsageViewSettings() {
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        if (usageViewSettings == null) {
            UsageViewImpl.$$$reportNull$$$0(7);
        }
        return usageViewSettings;
    }

    private void fireEvents() {
        ThreadingAssertions.assertEventDispatchThread();
        this.syncModelWithSwingNodes();
        this.fireEventsForChangedNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventsForChangedNodes() {
        ArrayList changed;
        IntArrayList indicesToFire = new IntArrayList();
        ArrayList<Node> nodesToFire = new ArrayList<Node>();
        MultiMap<Node, Node> multiMap = this.fireTreeNodesChangedMap;
        synchronized (multiMap) {
            changed = new ArrayList(this.fireTreeNodesChangedMap.entrySet());
            this.fireTreeNodesChangedMap.clear();
        }
        for (Map.Entry entry : changed) {
            Node parentNode = (Node)entry.getKey();
            Collection childrenToUpdate = (Collection)entry.getValue();
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                Node childNode = (Node)parentNode.getChildAt(i);
                if (!childrenToUpdate.contains(childNode)) continue;
                nodesToFire.add(childNode);
                indicesToFire.add(i);
            }
            this.myModel.fireTreeNodesChanged(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toIntArray(), nodesToFire.toArray(new Node[0]));
            indicesToFire.clear();
            nodesToFire.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncModelWithSwingNodes() {
        ArrayList<NodeChange> nodeChanges;
        Set<NodeChange> set = this.modelToSwingNodeChanges;
        synchronized (set) {
            nodeChanges = new ArrayList<NodeChange>(this.modelToSwingNodeChanges);
            this.modelToSwingNodeChanges.clear();
        }
        IntArrayList indicesToFire = new IntArrayList();
        ArrayList<Node> nodesToFire = new ArrayList<Node>();
        Map<Node, List<NodeChange>> groupByParent = nodeChanges.stream().collect(Collectors.groupingBy(change1 -> change1.getParentNode()));
        for (Map.Entry<Node, List<NodeChange>> entry : groupByParent.entrySet()) {
            Node parentNode;
            Node node = parentNode = entry.getKey();
            synchronized (node) {
                List<NodeChange> changes = entry.getValue();
                ArrayList<NodeChange> addedToThisNode = new ArrayList<NodeChange>();
                for (NodeChange change : changes) {
                    if (change.nodeChangeType.equals((Object)NodeChangeType.REMOVED) || change.nodeChangeType.equals((Object)NodeChangeType.REPLACED)) {
                        GroupNode grandParent = (GroupNode)parentNode.getParent();
                        int index = grandParent.getSwingChildren().indexOf(parentNode);
                        if (index < 0) continue;
                        grandParent.getSwingChildren().remove(parentNode);
                        this.myModel.nodesWereRemoved(grandParent, new int[]{index}, new Object[]{parentNode});
                        this.myModel.fireTreeStructureChanged(grandParent, this.myModel.getPathToRoot(parentNode), new int[]{index}, new Object[]{parentNode});
                        if (!(parentNode instanceof UsageNode)) break;
                        grandParent.incrementUsageCount(-1);
                        break;
                    }
                    addedToThisNode.add(change);
                }
                if (!addedToThisNode.isEmpty()) {
                    for (NodeChange change : addedToThisNode) {
                        Node childNode = change.childNode;
                        if (childNode == null) continue;
                        Node node2 = childNode;
                        synchronized (node2) {
                            GroupNode parentGroupNode = (GroupNode)parentNode;
                            List<Node> swingChildren = parentGroupNode.getSwingChildren();
                            boolean contains = swingChildren.contains(childNode);
                            if (!contains) {
                                nodesToFire.add(childNode);
                                parentNode.insertNewNode(childNode, 0);
                                swingChildren.sort(COMPARATOR);
                                indicesToFire.add(swingChildren.indexOf(change.childNode));
                                if (childNode instanceof UsageNode) {
                                    parentGroupNode.incrementUsageCount(1);
                                }
                            }
                        }
                        if (indicesToFire.isEmpty()) continue;
                        this.myModel.fireTreeNodesInserted(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toIntArray(), nodesToFire.toArray(new Node[0]));
                        indicesToFire.clear();
                        nodesToFire.clear();
                    }
                }
            }
        }
    }

    @Override
    public void searchFinished() {
        this.drainQueuedUsageNodes();
        this.setSearchInProgress(false);
    }

    @Override
    public boolean searchHasBeenCancelled() {
        ProgressIndicator progress = this.associatedProgress;
        return progress != null && progress.isCanceled();
    }

    @Override
    public void cancelCurrentSearch() {
        ProgressIndicator progress = this.associatedProgress;
        if (progress != null) {
            ProgressWrapper.unwrapAll((ProgressIndicator)progress).cancel();
        }
    }

    private void setupCentralPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        this.myPreviewSplitter = new OnePixelSplitter(false, 0.5f, 0.1f, 0.9f);
        this.myPreviewSplitter.setFirstComponent((JComponent)treePane);
        this.myCentralPanel.add((Component)this.myPreviewSplitter, "Center");
        this.updateUsagesContextPanels();
        this.myCentralPanel.add((Component)this.myAdditionalComponent, "South");
        this.myAdditionalComponent.add((Component)this.myButtonPanel, "South");
    }

    /*
     * WARNING - void declaration
     */
    private void updateUsagesContextPanels() {
        ThreadingAssertions.assertEventDispatchThread();
        this.disposeUsageContextPanels();
        if (this.isPreviewUsages()) {
            this.myPreviewSplitter.setProportion(this.getUsageViewSettings().getPreviewUsagesSplitterProportion());
            JBTabbedPane tabbedPane = new JBTabbedPane(3);
            tabbedPane.setTabComponentInsets(null);
            Object[] extensions = (UsageContextPanel.Provider[])UsageContextPanel.Provider.EP_NAME.getExtensions((AreaInstance)this.myProject);
            List myUsageContextPanelProviders = ContainerUtil.filter((Object[])extensions, provider -> (Boolean)ReadAction.compute(() -> provider.isAvailableFor(this)));
            LinkedHashMap<@NlsContexts.TabTitle String, void> components = new LinkedHashMap<String, void>();
            for (Object provider2 : myUsageContextPanelProviders) {
                void var7_8;
                if (this.myCurrentUsageContextProvider == null || this.myCurrentUsageContextProvider == provider2) {
                    this.myCurrentUsageContextProvider = provider2;
                    UsageContextPanel panel2 = provider2.create(this);
                    this.myAllUsageContextPanels.add(panel2);
                    this.myCurrentUsageContextPanel = panel2;
                    JComponent jComponent = this.myCurrentUsageContextPanel.createComponent();
                } else {
                    JLabel jLabel = new JLabel();
                }
                components.put(provider2.getTabTitle(), var7_8);
            }
            JBPanelWithEmptyText panel3 = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
            if (components.size() == 1) {
                panel3.add((Component)components.values().iterator().next(), (Object)"Center");
            } else {
                for (Map.Entry entry : components.entrySet()) {
                    tabbedPane.addTab((String)entry.getKey(), (Component)entry.getValue());
                }
                int index = myUsageContextPanelProviders.indexOf(this.myCurrentUsageContextProvider);
                tabbedPane.setSelectedIndex(index);
                tabbedPane.addChangeListener(e -> {
                    int currentIndex = tabbedPane.getSelectedIndex();
                    UsageContextPanel.Provider selectedProvider = (UsageContextPanel.Provider)myUsageContextPanelProviders.get(currentIndex);
                    if (selectedProvider != this.myCurrentUsageContextProvider) {
                        this.tabSelected(selectedProvider);
                        UsageViewStatisticsCollector.logTabSwitched(this.myProject, this);
                    }
                });
                panel3.add((Component)tabbedPane, (Object)"Center");
            }
            this.myPreviewSplitter.setSecondComponent((JComponent)panel3);
        } else {
            this.myPreviewSplitter.setSecondComponent(null);
            this.myPreviewSplitter.setProportion(1.0f);
        }
        this.myRootPanel.revalidate();
        this.myRootPanel.repaint();
    }

    private void tabSelected(@NotNull UsageContextPanel.Provider provider) {
        if (provider == null) {
            UsageViewImpl.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myCurrentUsageContextProvider = provider;
        this.updateUsagesContextPanels();
        this.updateOnSelectionChanged(this.myProject);
    }

    private void disposeUsageContextPanels() {
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myAllUsageContextPanels.isEmpty()) {
            this.saveSplitterProportions();
            for (UsageContextPanel panel2 : this.myAllUsageContextPanels) {
                Disposer.dispose((Disposable)panel2);
            }
            this.myCurrentUsageContextPanel = null;
            this.myAllUsageContextPanels.clear();
        }
    }

    boolean isPreviewUsages() {
        return this.myPresentation.isReplaceMode() ? this.getUsageViewSettings().isReplacePreviewUsages() : this.getUsageViewSettings().isPreviewUsages();
    }

    void setPreviewUsages(boolean state) {
        if (this.myPresentation.isReplaceMode()) {
            this.getUsageViewSettings().setReplacePreviewUsages(state);
        } else {
            this.getUsageViewSettings().setPreviewUsages(state);
        }
    }

    protected UsageFilteringRule @NotNull [] getActiveFilteringRules(Project project) {
        if (this.myFilteringRules != null) {
            if (this.myFilteringRules == null) {
                UsageViewImpl.$$$reportNull$$$0(9);
            }
            return this.myFilteringRules;
        }
        List providers = UsageFilteringRuleProvider.EP_NAME.getExtensionList();
        ArrayList<UsageFilteringRule> list2 = new ArrayList<UsageFilteringRule>(providers.size());
        for (UsageFilteringRule rule : UsageFilteringRules.usageFilteringRules(project)) {
            if (!this.myFilteringRulesState.isActive(rule.getRuleId())) continue;
            list2.add(rule);
        }
        for (UsageFilteringRuleProvider provider : providers) {
            ContainerUtil.addAll(list2, (Object[])provider.getActiveRules(project));
        }
        UsageFilteringRule[] usageFilteringRuleArray = list2.toArray(UsageFilteringRule.EMPTY_ARRAY);
        if (usageFilteringRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(10);
        }
        return usageFilteringRuleArray;
    }

    protected static UsageGroupingRule @NotNull [] getActiveGroupingRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings, @Nullable UsageViewPresentation presentation) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(11);
        }
        if (usageViewSettings == null) {
            UsageViewImpl.$$$reportNull$$$0(12);
        }
        List providers = UsageGroupingRuleProvider.EP_NAME.getExtensionList();
        ArrayList<UsageGroupingRule> list2 = new ArrayList<UsageGroupingRule>(providers.size());
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list2, (Object[])provider.getActiveRules(project, usageViewSettings, presentation));
        }
        list2.sort(Comparator.comparingInt(rule -> rule.getRank()));
        UsageGroupingRule[] usageGroupingRuleArray = list2.toArray(UsageGroupingRule.EMPTY_ARRAY);
        if (usageGroupingRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(13);
        }
        return usageGroupingRuleArray;
    }

    private void initTree() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myTree.setShowsRootHandles(true);
        SmartExpander.installOn((JTree)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree), (Runnable)this.fusRunnable);
        EditSourceOnEnterKeyHandler.install((JComponent)((Object)this.myTree), (Runnable)this.fusRunnable);
        TreeUtil.promiseSelectFirst((JTree)((Object)this.myTree));
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"UsageView.Popup", (String)"UsageViewPopup");
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object component = path.getLastPathComponent();
                if (component instanceof Node) {
                    Node node = (Node)component;
                    if (!UsageViewImpl.this.myTree.myExpandingCollapsing && node.needsUpdate()) {
                        ArrayList toUpdate = new ArrayList();
                        UsageViewImpl.this.checkNodeValidity(node, path, toUpdate);
                        UsageViewImpl.this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this.myTree), o -> {
            Object value = o.getLastPathComponent();
            TreeCellRenderer renderer = this.myTree.getCellRenderer();
            if (renderer instanceof UsageViewTreeCellRenderer) {
                UsageViewTreeCellRenderer coloredRenderer = (UsageViewTreeCellRenderer)((Object)((Object)renderer));
                return coloredRenderer.getPlainTextForNode(value);
            }
            return value == null ? null : value.toString();
        }, true);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        AnAction[] actions;
        ThreadingAssertions.assertEventDispatchThread();
        DefaultActionGroup group = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                super.update(e);
                UsageViewImpl.this.myButtonPanel.update();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        for (AnAction action : actions = this.createActions()) {
            if (action == null) continue;
            group.add(action);
        }
        return this.toUsageViewToolbar(group);
    }

    @NotNull
    private JComponent toUsageViewToolbar(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)group, false);
        actionToolbar.setTargetComponent(this.myRootPanel);
        JComponent jComponent = actionToolbar.getComponent();
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(15);
        }
        return jComponent;
    }

    protected boolean isPreviewUsageActionEnabled() {
        return true;
    }

    public void addFilteringActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.addFilteringActions(group, true);
    }

    protected void addFilteringActions(@NotNull DefaultActionGroup group, boolean includeExtensionPoints) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(17);
        }
        if (this.getPresentation().isMergeDupLinesAvailable()) {
            MergeSameLineUsagesAction mergeDupLines = new MergeSameLineUsagesAction();
            MyPanel component = this.myRootPanel;
            if (component != null) {
                mergeDupLines.registerCustomShortcutSet(mergeDupLines.getShortcutSet(), component, this);
            }
            group.add((AnAction)((Object)mergeDupLines));
        }
        if (includeExtensionPoints) {
            this.addFilteringFromExtensionPoints(group);
        }
    }

    protected void addFilteringFromExtensionPoints(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(18);
        }
        if (this.getPresentation().isCodeUsages()) {
            JComponent component = this.getComponent();
            List<AnAction> actions = UsageFilteringRuleActions.usageFilteringRuleActions(this.myProject, this.myFilteringRulesState);
            for (AnAction action : actions) {
                action.registerCustomShortcutSet(component, this);
                group.add(action);
            }
        }
        for (UsageFilteringRuleProvider provider : UsageFilteringRuleProvider.EP_NAME.getExtensionList()) {
            AnAction[] providerActions;
            for (AnAction action : providerActions = provider.createFilteringActions(this)) {
                group.add(action);
            }
        }
    }

    protected AnAction @NotNull [] createActions() {
        ThreadingAssertions.assertEventDispatchThread();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        JComponent component = this.getComponent();
        AnAction expandAllAction = actionsManager.createExpandAllAction(this.treeExpander, component);
        AnAction collapseAllAction = actionsManager.createCollapseAllAction(this.treeExpander, component);
        Disposer.register((Disposable)this, () -> {
            expandAllAction.unregisterCustomShortcutSet(component);
            collapseAllAction.unregisterCustomShortcutSet(component);
        });
        DefaultActionGroup group = new DefaultActionGroup();
        group.setPopup(true);
        group.getTemplatePresentation().setIcon(AllIcons.Actions.GroupBy);
        group.getTemplatePresentation().setText(UsageViewBundle.messagePointer("action.group.by.title", new Object[0]));
        group.getTemplatePresentation().setDescription(UsageViewBundle.messagePointer("action.group.by.title", new Object[0]));
        AnAction[] groupingActions = this.createGroupingActions();
        if (groupingActions.length > 0) {
            group.add((AnAction)new Separator(UsageViewBundle.message("action.group.by.title", new Object[0])));
            group.addAll(groupingActions);
            group.add((AnAction)new Separator());
        }
        this.addFilteringActions(group, false);
        DefaultActionGroup filteringSubgroup = new DefaultActionGroup();
        this.addFilteringFromExtensionPoints(filteringSubgroup);
        AnAction[] anActionArray = new AnAction[12];
        anActionArray[0] = ActionManager.getInstance().getAction("UsageView.Rerun");
        anActionArray[1] = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myRootPanel);
        anActionArray[2] = actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myRootPanel);
        anActionArray[3] = new Separator();
        anActionArray[4] = this.canShowSettings() ? new ShowSettings() : null;
        anActionArray[5] = this.canShowSettings() ? new Separator() : null;
        anActionArray[6] = group;
        anActionArray[7] = filteringSubgroup;
        anActionArray[8] = expandAllAction;
        anActionArray[9] = collapseAllAction;
        anActionArray[10] = new Separator();
        Object object = anActionArray[11] = this.isPreviewUsageActionEnabled() ? new PreviewUsageAction() : null;
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(19);
        }
        return anActionArray;
    }

    protected boolean canShowSettings() {
        if (this.myTargets.length == 0) {
            return false;
        }
        UsageTarget target = this.myTargets[0];
        return target instanceof ConfigurableUsageTarget;
    }

    private static ConfigurableUsageTarget getConfigurableTarget(UsageTarget @NotNull [] targets) {
        UsageTarget target;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(20);
        }
        ConfigurableUsageTarget configurableUsageTarget = null;
        if (targets.length != 0 && (target = targets[0]) instanceof ConfigurableUsageTarget) {
            ConfigurableUsageTarget configurable;
            configurableUsageTarget = configurable = (ConfigurableUsageTarget)target;
        }
        return configurableUsageTarget;
    }

    protected AnAction @NotNull [] createGroupingActions() {
        List providers = UsageGroupingRuleProvider.EP_NAME.getExtensionList();
        ArrayList<AnAction> list2 = new ArrayList<AnAction>(providers.size());
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list2, (Object[])provider.createGroupingActions(this));
        }
        this.sortGroupingActions(list2);
        UsageViewImpl.moveActionTo(list2, UsageViewBundle.message("action.group.by.module", new Object[0]), UsageViewBundle.message("action.flatten.modules", new Object[0]));
        AnAction[] anActionArray = list2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(21);
        }
        return anActionArray;
    }

    @ApiStatus.Internal
    protected static void moveActionTo(@NotNull List<AnAction> list2, @NotNull String actionText, @NotNull String targetActionText) {
        if (list2 == null) {
            UsageViewImpl.$$$reportNull$$$0(22);
        }
        if (actionText == null) {
            UsageViewImpl.$$$reportNull$$$0(23);
        }
        if (targetActionText == null) {
            UsageViewImpl.$$$reportNull$$$0(24);
        }
        if (Objects.equals(actionText, targetActionText)) {
            return;
        }
        int actionIndex = -1;
        int targetIndex = -1;
        for (int i = 0; i < list2.size(); ++i) {
            AnAction action = list2.get(i);
            if (actionIndex == -1 && Objects.equals(actionText, action.getTemplateText())) {
                actionIndex = i;
            }
            if (targetIndex == -1 && Objects.equals(targetActionText, action.getTemplateText())) {
                targetIndex = i;
            }
            if (actionIndex == -1 || targetIndex == -1) continue;
            if (actionIndex < targetIndex) {
                --targetIndex;
            }
            AnAction anAction = list2.remove(actionIndex);
            list2.add(targetIndex, anAction);
            return;
        }
    }

    @NotNull
    protected AnAction createPreviewAction() {
        return new PreviewUsageAction();
    }

    @NotNull
    protected AnAction createSettingsAction() {
        return new ShowSettings();
    }

    @NotNull
    protected AnAction createPreviousOccurrenceAction() {
        AnAction anAction = CommonActionsManager.getInstance().createPrevOccurenceAction((OccurenceNavigator)this.myRootPanel);
        if (anAction == null) {
            UsageViewImpl.$$$reportNull$$$0(25);
        }
        return anAction;
    }

    @NotNull
    protected AnAction createNextOccurrenceAction() {
        AnAction anAction = CommonActionsManager.getInstance().createNextOccurenceAction((OccurenceNavigator)this.myRootPanel);
        if (anAction == null) {
            UsageViewImpl.$$$reportNull$$$0(26);
        }
        return anAction;
    }

    @Contract(mutates="param1")
    protected void sortGroupingActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            UsageViewImpl.$$$reportNull$$$0(27);
        }
        actions.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplateText()), (Comparable)((Object)o2.getTemplateText())));
    }

    private boolean shouldTreeReactNowToRuleChanges() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myPresentation.isDetachedMode() || this.myTree.isShowing();
    }

    private void rulesChanged() {
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IJPL-164976");){
            ReadAction.run(() -> this.rulesChangedImpl());
        }
    }

    private void rulesChangedImpl() {
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.shouldTreeReactNowToRuleChanges()) {
            this.rulesChanged = true;
            return;
        }
        ArrayList states = new ArrayList();
        if (this.myTree != null) {
            this.captureUsagesExpandState(new TreePath(this.myTree.getModel().getRoot()), states);
        }
        ArrayList<Usage> allUsages = new ArrayList<Usage>(this.myUsageNodes.keySet());
        allUsages.sort(USAGE_COMPARATOR_BY_FILE_AND_OFFSET);
        Set<Usage> excludedUsages = this.getExcludedUsages();
        this.reset();
        this.myGroupingRules = UsageViewImpl.getActiveGroupingRules(this.myProject, this.getUsageViewSettings(), this.getPresentation());
        this.myBuilder.setGroupingRules(this.myGroupingRules);
        this.myBuilder.setFilteringRules(this.getActiveFilteringRules(this.myProject));
        for (int i = allUsages.size() - 1; i >= 0; --i) {
            Usage usage = (Usage)allUsages.get(i);
            if (!usage.isValid()) {
                allUsages.remove(i);
                continue;
            }
            if (!(usage instanceof MergeableUsage)) continue;
            MergeableUsage mergeable = (MergeableUsage)((Object)usage);
            mergeable.reset();
        }
        this.appendUsagesInBulk(allUsages).thenRun(() -> SwingUtilities.invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.myTree != null) {
                if (!this.myPresentation.isDetachedMode()) {
                    this.expandTreeAfterReset();
                }
                this.excludeUsages(excludedUsages.toArray(Usage.EMPTY_ARRAY));
                this.restoreUsageExpandState(states);
                this.updateImmediately();
                if (this.myCentralPanel != null) {
                    this.updateUsagesContextPanels();
                }
            }
        }));
    }

    private void captureUsagesExpandState(@NotNull TreePath pathFrom, @NotNull Collection<? super UsageState> states) {
        if (pathFrom == null) {
            UsageViewImpl.$$$reportNull$$$0(28);
        }
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myTree.isExpanded(pathFrom)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathFrom.getLastPathComponent();
        int childCount = node.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = node.getChildAt(idx);
            if (child instanceof UsageNode) {
                UsageNode usageNode = (UsageNode)child;
                Usage usage = usageNode.getUsage();
                states.add(new UsageState(usage, this.myTree.getSelectionModel().isPathSelected(pathFrom.pathByAddingChild(child))));
                continue;
            }
            this.captureUsagesExpandState(pathFrom.pathByAddingChild(child), states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreUsageExpandState(@NotNull Collection<? extends UsageState> states) {
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        try {
            if (this.myTree != null) {
                this.myTree.suspendExpandCollapseAccessibilityAnnouncements();
            }
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root.getChildAt(i);
                if (!(defaultMutableTreeNode instanceof GroupNode)) continue;
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.myTree.expandPath(treePath);
            }
            this.myTree.getSelectionModel().clearSelection();
            for (UsageState usageState : states) {
                usageState.restore();
            }
        }
        finally {
            if (this.myTree != null) {
                this.myTree.resumeExpandCollapseAccessibilityAnnouncements();
            }
        }
    }

    public void expandAll() {
        this.doExpandingCollapsing(() -> TreeUtil.expandAll((JTree)((Object)this.myTree)));
    }

    private void expandTree(int levels) {
        this.doExpandingCollapsing(() -> TreeUtil.expand((JTree)((Object)this.myTree), (int)levels));
    }

    private void expandTreeAfterReset() {
        this.expandTree(2);
    }

    private void doExpandingCollapsing(@NotNull Runnable task2) {
        if (task2 == null) {
            UsageViewImpl.$$$reportNull$$$0(31);
        }
        if (this.isDisposed()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.fireEvents();
        this.myTree.myExpandingCollapsing = true;
        try {
            task2.run();
        }
        finally {
            this.myTree.myExpandingCollapsing = false;
        }
    }

    private void collapseAll() {
        this.doExpandingCollapsing(() -> {
            TreeUtil.collapseAll((JTree)((Object)this.myTree), (int)3);
            this.myTree.expandRow(0);
        });
    }

    public void expandRoot() {
        this.expandTree(1);
    }

    @NotNull
    DefaultMutableTreeNode getModelRoot() {
        ThreadingAssertions.assertEventDispatchThread();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            UsageViewImpl.$$$reportNull$$$0(32);
        }
        return defaultMutableTreeNode;
    }

    public void select() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myTree != null) {
            this.myTree.requestFocusInWindow();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(33);
        }
        return project;
    }

    static KeyboardShortcut getShowUsagesWithSettingsShortcut(UsageTarget @NotNull [] targets) {
        ConfigurableUsageTarget configurableTarget;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(34);
        }
        return (configurableTarget = UsageViewImpl.getConfigurableTarget(targets)) == null ? UsageViewUtil.getShowUsagesWithSettingsShortcut() : configurableTarget.getShortcut();
    }

    @Override
    public void associateProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UsageViewImpl.$$$reportNull$$$0(35);
        }
        this.associatedProgress = indicator;
    }

    public void refreshUsages() {
        this.reset();
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(() -> this.expandTreeAfterReset());
        }
        this.doReRun();
    }

    protected UsageView doReRun() {
        this.myChangesDetected = false;
        if (this.myRerunAction == null) {
            UsageViewPresentation rerunPresentation = this.myPresentation.copy();
            rerunPresentation.setRerunHash(System.identityHashCode(this.myContent));
            return UsageViewManager.getInstance(this.getProject()).searchAndShowUsages(this.myTargets, this.myUsageSearcherFactory, true, false, rerunPresentation, null);
        }
        this.myRerunAction.actionPerformed(null);
        return this;
    }

    @TestOnly
    @ApiStatus.Internal
    public UsageView doReRunTestAccessor() {
        return this.doReRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myUsageNodes.clear();
        this.myModel.reset();
        this.myBuilder.reset();
        Set<NodeChange> set = this.modelToSwingNodeChanges;
        synchronized (set) {
            this.modelToSwingNodeChanges.clear();
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public void drainQueuedUsageNodes() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        UIUtil.invokeAndWaitIfNeeded(() -> this.fireEvents());
    }

    @Override
    public void appendUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(36);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.addUpdateRequest(() -> ReadAction.run(() -> this.doAppendUsage(usage)));
        } else {
            this.doAppendUsage(usage);
        }
    }

    private void addUpdateRequest(@NotNull Runnable request) {
        if (request == null) {
            UsageViewImpl.$$$reportNull$$$0(37);
        }
        this.updateRequests.execute(request);
    }

    @Override
    public void waitForUpdateRequestsCompletion() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            this.updateRequests.waitAllTasksExecuted(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<?> appendUsagesInBulk(@NotNull Collection<? extends Usage> usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(38);
        }
        CompletableFuture result2 = new CompletableFuture();
        this.addUpdateRequest(() -> ReadAction.run(() -> {
            try {
                for (Usage usage : usages) {
                    this.doAppendUsage(usage);
                }
                result2.complete(null);
            }
            catch (Exception e) {
                result2.completeExceptionally(e);
                throw e;
            }
        }));
        CompletableFuture completableFuture = result2;
        if (completableFuture == null) {
            UsageViewImpl.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    public UsageNode doAppendUsage(@NotNull Usage usage) {
        UsageNode recentNode;
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!usage.isValid()) {
            return null;
        }
        for (Object listener2 : UsageViewElementsListener.EP_NAME.getExtensionList()) {
            if (listener2.skipUsage(this, usage)) {
                return null;
            }
            listener2.beforeUsageAdded(this, usage);
        }
        if (usage instanceof PsiElementUsage) {
            PsiElementUsage psi = (PsiElementUsage)usage;
            this.reportToFUS(psi);
        }
        this.myUsageNodes.put(usage, (recentNode = this.myBuilder.appendOrGet(usage, this.isFilterDuplicateLines(), this.edtModelToSwingNodeChangesQueue)) == null ? NULL_NODE : recentNode);
        if (this.myAutoSelectedGroupNode == null && usage instanceof SimilarUsage && recentNode != null && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                GroupNode groupNode = (GroupNode)ObjectUtils.tryCast((Object)TreeUtil.getPath((TreeNode)this.myRoot, (TreeNode)recentNode).getPath()[1], GroupNode.class);
                if (groupNode != null && this.getSelectedNode() instanceof UsageViewTreeModelBuilder.TargetsRootNode) {
                    this.myAutoSelectedGroupNode = groupNode;
                    this.showNode(groupNode);
                }
            });
        }
        if (recentNode != null && this.getPresentation().isExcludeAvailable()) {
            for (UsageViewElementsListener listener3 : UsageViewElementsListener.EP_NAME.getExtensionList()) {
                if (!listener3.isExcludedByDefault(this, usage)) continue;
                this.myExclusionHandler.excludeNodeSilently(recentNode);
            }
        }
        for (Node node = recentNode; node != this.myRoot && node != null; node = (Node)node.getParent()) {
            node.update(this.edtFireTreeNodesChangedQueue);
        }
        return recentNode;
    }

    private void reportToFUS(@NotNull PsiElementUsage usage) {
        Language language;
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(41);
        }
        Class<? extends PsiReference> referenceClass = UsageReferenceClassProvider.Companion.getReferenceClass(usage);
        PsiElement element = usage.getElement();
        if (element != null && referenceClass != null && this.myReportedReferenceClasses.add((Pair<Class<? extends PsiReference>, Language>)Pair.create(referenceClass, (Object)(language = element.getLanguage())))) {
            UsageViewStatisticsCollector.logUsageShown(this.myProject, referenceClass, language, this);
        }
    }

    @Override
    public void removeUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(42);
        }
        this.removeUsagesBulk(Collections.singleton(usage));
    }

    @Override
    public void removeUsagesBulk(@NotNull Collection<? extends Usage> usages) {
        Set mergedInfos;
        Usage toSelect;
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(43);
        }
        UsageNode nodeToSelect = (toSelect = this.getNextToSelect(usages)) != null ? this.myUsageNodes.get(toSelect) : null;
        Set nodes = this.usagesToNodes(usages.stream()).collect(Collectors.toSet());
        usages.forEach(key -> this.myUsageNodes.remove(key));
        if (!this.myUsageNodes.isEmpty() && !(mergedInfos = usages.stream().filter(usage -> {
            UsageInfo2UsageAdapter adapter;
            return usage instanceof UsageInfo2UsageAdapter && (adapter = (UsageInfo2UsageAdapter)usage).getMergedInfos().length > 1;
        }).flatMap(usage -> Arrays.stream(((UsageInfo2UsageAdapter)usage).getMergedInfos())).collect(Collectors.toSet())).isEmpty()) {
            this.myUsageNodes.keySet().removeIf(usage -> {
                UsageInfo2UsageAdapter adapter;
                return usage instanceof UsageInfo2UsageAdapter && mergedInfos.contains((adapter = (UsageInfo2UsageAdapter)usage).getUsageInfo());
            });
        }
        if (!nodes.isEmpty() && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed()) {
                    return;
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
                ((GroupNode)treeModel.getRoot()).removeUsagesBulk(nodes, treeModel);
                if (nodeToSelect != null) {
                    TreePath path = new TreePath(nodeToSelect.getPath());
                    this.myTree.addSelectionPath(path);
                }
            });
        }
    }

    @Override
    public void includeUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(44);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(node -> this.myExclusionHandler.includeNode(node));
    }

    @Override
    public void excludeUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(45);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(node -> this.myExclusionHandler.excludeNode(node));
    }

    @NotNull
    private Stream<UsageNode> usagesToNodes(@NotNull Stream<? extends Usage> usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(46);
        }
        Stream<UsageNode> stream = usages.map(key -> this.myUsageNodes.get(key)).filter(node -> node != NULL_NODE && node != null);
        if (stream == null) {
            UsageViewImpl.$$$reportNull$$$0(47);
        }
        return stream;
    }

    @Override
    public void selectUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(48);
        }
        ThreadingAssertions.assertEventDispatchThread();
        TreePath[] paths = (TreePath[])this.usagesToNodes(Arrays.stream(usages)).map(node -> new TreePath(node.getPath())).toArray(TreePath[]::new);
        this.myTree.setSelectionPaths(paths);
        if (paths.length != 0) {
            this.myTree.scrollPathToVisible(paths[0]);
        }
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.myTree != null ? this.myTree : this.getComponent();
        if (object == null) {
            UsageViewImpl.$$$reportNull$$$0(49);
        }
        return object;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ThreadingAssertions.assertEventDispatchThread();
        JComponent jComponent = this.myRootPanel == null ? new JLabel() : this.myRootPanel;
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(50);
        }
        return jComponent;
    }

    @Override
    public int getUsagesCount() {
        return this.myUsageNodes.size();
    }

    @Override
    public void addExcludeListener(@NotNull Disposable disposable, @NotNull UsageView.ExcludeListener listener2) {
        if (disposable == null) {
            UsageViewImpl.$$$reportNull$$$0(51);
        }
        if (listener2 == null) {
            UsageViewImpl.$$$reportNull$$$0(52);
        }
        this.myExcludeListeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> this.myExcludeListeners.remove(listener2));
    }

    void setContent(@NotNull Content content) {
        if (content == null) {
            UsageViewImpl.$$$reportNull$$$0(53);
        }
        this.myContent = content;
        content.setDisposer((Disposable)this);
    }

    private void updateImmediately() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        ArrayList toUpdate = new ArrayList();
        this.checkNodeValidity(root, new TreePath(root), toUpdate);
        this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
        this.updateOnSelectionChanged(this.myProject);
    }

    private void queueUpdateBulk(@NotNull List<? extends Node> toUpdate, @NotNull Runnable onCompletedInEdt) {
        if (toUpdate == null) {
            UsageViewImpl.$$$reportNull$$$0(54);
        }
        if (onCompletedInEdt == null) {
            UsageViewImpl.$$$reportNull$$$0(55);
        }
        if (toUpdate.isEmpty() || this.isDisposed()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            for (Node node : toUpdate) {
                try {
                    node.update(this.edtFireTreeNodesChangedQueue);
                }
                catch (IndexNotReadyException indexNotReadyException) {}
            }
            return null;
        }).expireWith((Disposable)this).finishOnUiThread(ModalityState.defaultModalityState(), __ -> onCompletedInEdt.run()).submit((Executor)this.updateRequests);
    }

    private void updateImmediatelyNodesUpToRoot(@NotNull Collection<? extends Node> nodes) {
        if (nodes == null) {
            UsageViewImpl.$$$reportNull$$$0(56);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        HashSet<Node> queued = new HashSet<Node>();
        ArrayList<Node> toUpdate = new ArrayList<Node>();
        while (true) {
            HashSet<? extends Node> parents = new HashSet<Node>();
            for (Node node : nodes) {
                Node parentNode;
                toUpdate.add(node);
                TreeNode parent = node.getParent();
                if (parent == root || !(parent instanceof Node) || !queued.add(parentNode = (Node)parent)) continue;
                parents.add(parentNode);
            }
            if (parents.isEmpty()) break;
            nodes = parents;
        }
        this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
        this.updateImmediately();
    }

    private void updateOnSelectionChanged(@NotNull Project project) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(57);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myCurrentUsageContextPanel != null) {
            DataContext dataContext = Utils.createAsyncDataContext((DataContext)DataManager.getInstance().getDataContext(this.myRootPanel));
            ReadAction.nonBlocking(() -> {
                List result2;
                try {
                    result2 = ContainerUtil.notNullize((List)((List)USAGE_INFO_LIST_KEY.getData(dataContext)));
                }
                catch (IndexNotReadyException ignore) {
                    result2 = Collections.emptyList();
                }
                return result2;
            }).expireWith((Disposable)this).finishOnUiThread(ModalityState.current(), usageInfos -> this.myCurrentUsageContextPanel.updateLayout(project, (List<? extends UsageInfo>)usageInfos, this)).submit((Executor)this.updateRequests);
        }
    }

    private void checkNodeValidity(@NotNull TreeNode node, @NotNull TreePath path, @NotNull List<? super Node> result2) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(58);
        }
        if (path == null) {
            UsageViewImpl.$$$reportNull$$$0(59);
        }
        if (result2 == null) {
            UsageViewImpl.$$$reportNull$$$0(60);
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean shouldCheckChildren = true;
        if (this.myTree.isCollapsed(path)) {
            if (node instanceof Node) {
                Node n = (Node)node;
                n.markNeedUpdate();
            }
            shouldCheckChildren = false;
        }
        UsageViewTreeCellRenderer.RowLocation isVisible = this.myUsageViewTreeCellRenderer.isRowVisible(this.myTree.getRowForPath(new TreePath(((DefaultMutableTreeNode)node).getPath())), this.myTree.getVisibleRect());
        if (shouldCheckChildren && isVisible != UsageViewTreeCellRenderer.RowLocation.AFTER_VISIBLE_RECT) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode child = node.getChildAt(i);
                this.checkNodeValidity(child, path.pathByAddingChild(child), result2);
            }
        }
        if (node instanceof Node) {
            Node n = (Node)node;
            if (node != this.getModelRoot() && isVisible == UsageViewTreeCellRenderer.RowLocation.INSIDE_VISIBLE_RECT) {
                result2.add(n);
            }
        }
    }

    void updateLater() {
        this.updateAlarm.cancelAndRequest();
    }

    @Override
    public void close() {
        this.cancelCurrentSearch();
        if (this.myContent != null) {
            UsageViewContentManager.getInstance(this.myProject).closeContent(this.myContent);
        }
    }

    private void saveSplitterProportions() {
        ThreadingAssertions.assertEventDispatchThread();
        this.getUsageViewSettings().setPreviewUsagesSplitterProportion(this.myPreviewSplitter.getProportion());
    }

    public void dispose() {
        try {
            ThreadingAssertions.assertEventDispatchThread();
            this.disposeUsageContextPanels();
            this.isDisposed = true;
            this.updateAlarm.cancelAllRequests();
            this.fusRunnable = null;
            this.cancelCurrentSearch();
            this.myRerunAction = null;
            if (this.myTree != null) {
                ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this.myTree));
            }
            this.disposeSmartPointers();
        }
        finally {
            JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).cancel(null);
        }
    }

    @ApiStatus.Internal
    public void setNonDisposableUsageInfos(@NotNull Set<UsageInfo> usageInfos) {
        if (usageInfos == null) {
            UsageViewImpl.$$$reportNull$$$0(61);
        }
        this.myNonDisposableUsageInfos.set(usageInfos);
    }

    private void disposeSmartPointers() {
        Set<UsageInfo> nonDisposableUsageInfos = this.myNonDisposableUsageInfos.get();
        ArrayList<SmartPsiElementPointer> smartPointers = new ArrayList<SmartPsiElementPointer>();
        for (Usage usage : this.myUsageNodes.keySet()) {
            UsageInfo2UsageAdapter adapter;
            UsageInfo usageInfo;
            if (!(usage instanceof UsageInfo2UsageAdapter) || nonDisposableUsageInfos.contains(usageInfo = (adapter = (UsageInfo2UsageAdapter)usage).getUsageInfo())) continue;
            smartPointers.add(usageInfo.getSmartPointer());
        }
        if (!smartPointers.isEmpty()) {
            for (SmartPsiElementPointer pointer : smartPointers) {
                Project project = pointer.getProject();
                if (project.isDisposed()) continue;
                SmartPointerManager.getInstance((Project)project).removePointer(pointer);
            }
        }
        this.myUsageNodes.clear();
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchInProgress;
    }

    @Override
    public void setSearchInProgress(boolean searchInProgress) {
        this.mySearchInProgress = searchInProgress;
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed()) {
                    return;
                }
                if (this.getUsageViewSettings().isExpanded() && this.myUsageNodes.size() < 10000) {
                    this.expandAll();
                }
                if (this.userHasSelectedNode()) {
                    return;
                }
                Node nodeToSelect = (Node)ObjectUtils.coalesce((Object)this.myAutoSelectedGroupNode, (Object)this.myModel.getFirstUsageNode());
                if (nodeToSelect == null) {
                    return;
                }
                this.showNode(nodeToSelect);
            });
        }
    }

    private boolean userHasSelectedNode() {
        GroupNode autoSelectedGroupNode = this.myAutoSelectedGroupNode;
        Node selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            TreePath expectedPathToBeSelected = autoSelectedGroupNode != null ? TreeUtil.getPathFromRoot((TreeNode)autoSelectedGroupNode) : TreeUtil.getFirstNodePath((JTree)((Object)this.myTree));
            return !Comparing.equal((Object)TreeUtil.getPathFromRoot((TreeNode)selectedNode), (Object)expectedPathToBeSelected);
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    private void showNode(@NotNull Node node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(62);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isDisposed() && !this.myPresentation.isDetachedMode()) {
            this.fireEvents();
            TreePath usagePath = new TreePath(node.getPath());
            this.myTree.expandPath(usagePath.getParentPath());
            TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)usagePath);
        }
    }

    @Override
    public void setRerunAction(@NotNull Action rerunAction) {
        if (rerunAction == null) {
            UsageViewImpl.$$$reportNull$$$0(63);
        }
        this.myRerunAction = rerunAction;
    }

    @Override
    public void addButtonToLowerPane(@NotNull Action action) {
        if (action == null) {
            UsageViewImpl.$$$reportNull$$$0(64);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int index = this.myButtonPanel.getComponentCount();
        if (!SystemInfo.isMac && index > 0 && this.myPresentation.isShowCancelButton()) {
            --index;
        }
        this.myButtonPanel.addButtonAction(index, action);
        Object o = action.getValue("AcceleratorKey");
        if (o instanceof KeyStroke) {
            KeyStroke stroke = (KeyStroke)o;
            this.myTree.registerKeyboardAction(action, stroke, 0);
        }
    }

    @Override
    public void addButtonToLowerPane(final @NotNull Runnable runnable, @NlsContexts.Button @NotNull String text2) {
        if (runnable == null) {
            UsageViewImpl.$$$reportNull$$$0(65);
        }
        if (text2 == null) {
            UsageViewImpl.$$$reportNull$$$0(66);
        }
        this.addButtonToLowerPane(new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)text2)){

            @Override
            public void actionPerformed(ActionEvent e) {
                WriteIntentReadAction.run((Runnable)runnable);
            }
        });
    }

    @Override
    public void setAdditionalComponent(@Nullable JComponent comp) {
        BorderLayout layout = (BorderLayout)this.myAdditionalComponent.getLayout();
        Component prev = layout.getLayoutComponent(this.myAdditionalComponent, "Center");
        if (prev == comp) {
            return;
        }
        if (prev != null) {
            this.myAdditionalComponent.remove(prev);
        }
        if (comp != null) {
            this.myAdditionalComponent.add((Component)comp, "Center");
        }
        this.myAdditionalComponent.revalidate();
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, @NlsContexts.Command @Nullable String commandName, @NlsContexts.DialogMessage @NotNull String cannotMakeString, @NlsContexts.Button @NotNull String shortDescription) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(67);
        }
        if (cannotMakeString == null) {
            UsageViewImpl.$$$reportNull$$$0(68);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(69);
        }
        this.addPerformOperationAction(processRunnable, commandName, cannotMakeString, shortDescription, true);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, @NlsContexts.Command @Nullable String commandName, @NlsContexts.DialogMessage @NotNull String cannotMakeString, @NlsContexts.Button @NotNull String shortDescription, boolean checkReadOnlyStatus) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(70);
        }
        if (cannotMakeString == null) {
            UsageViewImpl.$$$reportNull$$$0(71);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(72);
        }
        MyPerformOperationRunnable runnable = new MyPerformOperationRunnable(processRunnable, commandName, cannotMakeString, checkReadOnlyStatus);
        this.addButtonToLowerPane(runnable, shortDescription);
    }

    private boolean allTargetsAreValid() {
        for (UsageTarget target : this.myTargets) {
            if (target.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public UsageViewPresentation getPresentation() {
        UsageViewPresentation usageViewPresentation = this.myPresentation;
        if (usageViewPresentation == null) {
            UsageViewImpl.$$$reportNull$$$0(73);
        }
        return usageViewPresentation;
    }

    @ApiStatus.Internal
    public boolean canPerformReRun() {
        if (this.myRerunAction != null && this.myRerunAction.isEnabled()) {
            return this.allTargetsAreValid();
        }
        try {
            return this.myUsageSearcherFactory != null && this.allTargetsAreValid() && this.myUsageSearcherFactory.get() != null;
        }
        catch (PsiInvalidElementAccessException e) {
            return false;
        }
    }

    private boolean checkReadonlyUsages() {
        Set<VirtualFile> readOnlyUsages = this.getReadOnlyUsagesFiles();
        return readOnlyUsages.isEmpty() || !ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(readOnlyUsages).hasReadonlyFiles();
    }

    @NotNull
    private Set<Usage> getReadOnlyUsages() {
        HashSet<Usage> result2 = new HashSet<Usage>();
        Set<Map.Entry<Usage, UsageNode>> usages = this.myUsageNodes.entrySet();
        for (Map.Entry<Usage, UsageNode> entry : usages) {
            Usage usage = entry.getKey();
            UsageNode node = entry.getValue();
            if (node == null || node == NULL_NODE || node.isExcluded() || !usage.isReadOnly()) continue;
            result2.add(usage);
        }
        HashSet<Usage> hashSet = result2;
        if (hashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(74);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getReadOnlyUsagesFiles() {
        Set<Usage> usages = this.getReadOnlyUsages();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (Usage usage : usages) {
            UsageInFile usageInFile;
            VirtualFile file;
            if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null && file.isValid()) {
                result2.add(file);
            }
            if (!(usage instanceof UsageInFiles)) continue;
            UsageInFiles usageInFiles = (UsageInFiles)((Object)usage);
            ContainerUtil.addAll(result2, (Object[])usageInFiles.getFiles());
        }
        for (UsageTarget target : this.myTargets) {
            Object[] files = target.getFiles();
            if (files == null) continue;
            ContainerUtil.addAll(result2, (Object[])files);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(75);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getExcludedUsages() {
        HashSet<Usage> result2 = new HashSet<Usage>();
        for (Map.Entry<Usage, UsageNode> entry : this.myUsageNodes.entrySet()) {
            UsageNode node = entry.getValue();
            Usage usage = entry.getKey();
            if (node == NULL_NODE || node == null || !node.isExcluded()) continue;
            result2.add(usage);
        }
        HashSet<Usage> hashSet = result2;
        if (hashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(76);
        }
        return hashSet;
    }

    @Nullable
    private Node getSelectedNode() {
        Node n;
        ThreadingAssertions.assertEventDispatchThread();
        TreePath path = this.myTree.getLeadSelectionPath();
        Object node = path == null ? null : path.getLastPathComponent();
        return node instanceof Node ? (n = (Node)node) : null;
    }

    @NotNull
    private List<TreeNode> selectedNodes() {
        return UsageViewImpl.selectedNodes(this.myTree);
    }

    @NotNull
    private static List<TreeNode> selectedNodes(@NotNull MyTree tree) {
        if (tree == null) {
            UsageViewImpl.$$$reportNull$$$0(77);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Object[] selectionPaths = tree.getSelectionPaths();
        List list2 = selectionPaths == null ? Collections.emptyList() : ContainerUtil.mapNotNull((Object[])selectionPaths, p -> (TreeNode)ObjectUtils.tryCast((Object)p.getLastPathComponent(), TreeNode.class));
        if (list2 == null) {
            UsageViewImpl.$$$reportNull$$$0(78);
        }
        return list2;
    }

    @NotNull
    private JBIterable<TreeNode> traverseNodesRecursively(@NotNull List<? extends TreeNode> roots) {
        if (roots == null) {
            UsageViewImpl.$$$reportNull$$$0(79);
        }
        JBIterable jBIterable = ((JBTreeTraverser)TreeUtil.treeNodeTraverser(null).withRoots(roots)).traverse();
        if (jBIterable == null) {
            UsageViewImpl.$$$reportNull$$$0(80);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Set<Usage> getSelectedUsages() {
        ThreadingAssertions.assertEventDispatchThread();
        return new HashSet<Usage>(UsageViewImpl.allUsagesRecursive(this.selectedNodes()));
    }

    @NotNull
    private static @Unmodifiable @NotNull List<@NotNull Usage> allUsagesRecursive(@NotNull List<? extends TreeNode> selection) {
        if (selection == null) {
            UsageViewImpl.$$$reportNull$$$0(81);
        }
        List list2 = ((JBTreeTraverser)TreeUtil.treeNodeTraverser(null).withRoots(selection)).traverse().filterMap(o -> {
            Usage usage;
            if (o instanceof UsageNode) {
                UsageNode usageNode = (UsageNode)o;
                usage = usageNode.getUsage();
            } else {
                usage = null;
            }
            return usage;
        }).toList();
        if (list2 == null) {
            UsageViewImpl.$$$reportNull$$$0(82);
        }
        return list2;
    }

    @Override
    @NotNull
    public Set<Usage> getUsages() {
        Set<Usage> set = this.myUsageNodes.keySet();
        if (set == null) {
            UsageViewImpl.$$$reportNull$$$0(83);
        }
        return set;
    }

    @Override
    @NotNull
    public List<Usage> getSortedUsages() {
        ArrayList<Usage> usages = new ArrayList<Usage>(this.getUsages());
        usages.sort(USAGE_COMPARATOR_BY_FILE_AND_OFFSET);
        ArrayList<Usage> arrayList = usages;
        if (arrayList == null) {
            UsageViewImpl.$$$reportNull$$$0(84);
        }
        return arrayList;
    }

    @Nullable
    private Navigatable getNavigatableForNode(@NotNull DefaultMutableTreeNode node, final boolean allowRequestFocus) {
        Object maybeNavigatable;
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(85);
        }
        if (!((maybeNavigatable = node) instanceof Navigatable)) {
            maybeNavigatable = node.getUserObject();
        }
        if (maybeNavigatable instanceof Navigatable) {
            final Navigatable navigatable = (Navigatable)maybeNavigatable;
            return navigatable.canNavigate() ? new Navigatable(){

                public void navigate(boolean requestFocus) {
                    if (Registry.is((String)"ide.usages.next.previous.occurrence.only.show.in.preview") && UsageViewImpl.this.isPreviewUsages() && UsageViewImpl.this.myRootPanel.isShowing()) {
                        UsageViewImpl.this.select();
                    } else {
                        navigatable.navigate(allowRequestFocus && requestFocus);
                    }
                }

                public boolean canNavigate() {
                    return navigatable.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return navigatable.canNavigateToSource();
                }
            } : null;
        }
        return null;
    }

    boolean areTargetsValid() {
        return this.myModel.areTargetsValid();
    }

    @NotNull
    private static JBIterable<Usage> selectedUsages(@NotNull @NotNull JBIterable<@NotNull TreeNode> selectedNodes) {
        if (selectedNodes == null) {
            UsageViewImpl.$$$reportNull$$$0(86);
        }
        JBIterable jBIterable = selectedNodes.filter(UsageNode.class).map(node -> node.getUsage()).unique();
        if (jBIterable == null) {
            UsageViewImpl.$$$reportNull$$$0(87);
        }
        return jBIterable;
    }

    @NotNull
    @NotNull Set<@NotNull GroupNode> selectedGroupNodes() {
        return new HashSet<GroupNode>(ContainerUtil.filterIsInstance(this.selectedNodes(), GroupNode.class));
    }

    @NotNull
    public GroupNode getRoot() {
        GroupNode groupNode = this.myRoot;
        if (groupNode == null) {
            UsageViewImpl.$$$reportNull$$$0(88);
        }
        return groupNode;
    }

    @TestOnly
    @NotNull
    public String getNodeText(@NotNull TreeNode node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(89);
        }
        String string = this.myUsageViewTreeCellRenderer.getPlainTextForNode(node);
        if (string == null) {
            UsageViewImpl.$$$reportNull$$$0(90);
        }
        return string;
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(91);
        }
        return this.myBuilder != null && this.myBuilder.isVisible(usage);
    }

    public UsageTarget @NotNull [] getTargets() {
        if (this.myTargets == null) {
            UsageViewImpl.$$$reportNull$$$0(92);
        }
        return this.myTargets;
    }

    private boolean isFilterDuplicateLines() {
        return this.myPresentation.isMergeDupLinesAvailable() && this.getUsageViewSettings().isFilterDuplicatedLine();
    }

    @ApiStatus.Internal
    public Usage getNextToSelect(@NotNull Usage toDelete) {
        Usage usage;
        Object object;
        if (toDelete == null) {
            UsageViewImpl.$$$reportNull$$$0(93);
        }
        ThreadingAssertions.assertEventDispatchThread();
        UsageNode usageNode = this.myUsageNodes.get(toDelete);
        if (usageNode == null || usageNode.getParent().getChildCount() == 0) {
            return null;
        }
        DefaultMutableTreeNode node = this.myRootPanel.mySupport.findNextNodeAfter((JTree)((Object)this.myTree), (TreeNode)usageNode, true);
        if (node == null) {
            node = this.myRootPanel.mySupport.findNextNodeAfter((JTree)((Object)this.myTree), (TreeNode)usageNode, false);
        }
        return node == null ? null : ((object = node.getUserObject()) instanceof Usage ? (usage = (Usage)object) : null);
    }

    private Usage getNextToSelect(@NotNull Collection<? extends Usage> toDelete) {
        if (toDelete == null) {
            UsageViewImpl.$$$reportNull$$$0(94);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Usage toSelect = null;
        for (Usage usage : toDelete) {
            Usage next = this.getNextToSelect(usage);
            if (next == null || toDelete.contains(next)) continue;
            toSelect = next;
            break;
        }
        return toSelect;
    }

    @Nullable
    public static KeyboardShortcut getShowUsagesWithSettingsShortcut() {
        return UsageViewUtil.getShowUsagesWithSettingsShortcut();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 13, 15, 19, 21, 25, 26, 32, 33, 39, 47, 49, 50, 73, 74, 75, 76, 78, 80, 82, 83, 84, 87, 88, 90, 92 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 3: 
            case 11: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 39: 
            case 47: 
            case 49: 
            case 50: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetActionText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFrom";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdate";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCompletedInEdt";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 58: 
            case 62: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processRunnable";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cannotMakeString";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortDescription";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageViewSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilteringRules";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveGroupingRules";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageViewToolbar";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingActions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviousOccurrenceAction";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createNextOccurrenceAction";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoot";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "appendUsagesInBulk";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "usagesToNodes";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsages";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsagesFiles";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUsages";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedNodes";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseNodesRecursively";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "allUsagesRecursive";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedUsages";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedUsages";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFilteringRules";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareByFileAndOffset";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 39: 
            case 47: 
            case 49: 
            case 50: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 90: 
            case 92: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tabSelected";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActiveGroupingRules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toUsageViewToolbar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFilteringActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFilteringFromExtensionPoints";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableTarget";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveActionTo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sortGroupingActions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "captureUsagesExpandState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "restoreUsageExpandState";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doExpandingCollapsing";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getShowUsagesWithSettingsShortcut";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "associateProgress";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendUsage";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendUsagesInBulk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doAppendUsage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reportToFUS";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeUsage";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "includeUsages";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "excludeUsages";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "usagesToNodes";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "selectUsages";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeListener";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateBulk";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updateImmediatelyNodesUpToRoot";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "updateOnSelectionChanged";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeValidity";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setNonDisposableUsageInfos";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "showNode";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setRerunAction";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addButtonToLowerPane";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addPerformOperationAction";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "selectedNodes";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "traverseNodesRecursively";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "allUsagesRecursive";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableForNode";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "selectedUsages";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getNextToSelect";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$16";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 13, 15, 19, 21, 25, 26, 32, 33, 39, 47, 49, 50, 73, 74, 75, 76, 78, 80, 82, 83, 84, 87, 88, 90, 92 -> new IllegalStateException(string);
        };
    }

    private final class ButtonPanel
    extends JPanel {
        private ButtonPanel() {
            this.setLayout(new FlowLayout(0, 6, 0));
            UsageViewImpl.this.getProject().getMessageBus().connect((Disposable)UsageViewImpl.this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    ButtonPanel.this.update();
                }

                public void exitDumbMode() {
                    ButtonPanel.this.update();
                }
            });
        }

        private void addButtonAction(int index, @NotNull Action action) {
            String string;
            if (action == null) {
                ButtonPanel.$$$reportNull$$$0(0);
            }
            JButton button = new JButton(action);
            this.add((Component)button, index);
            DialogUtil.registerMnemonic((AbstractButton)button);
            if (this.getBorder() == null) {
                this.setBorder(IdeBorderFactory.createBorder((int)2));
            }
            this.update();
            Object s = action.getValue("LongDescription");
            if (s instanceof String) {
                string = (String)s;
                JBLabel label = new JBLabel(string);
                label.setEnabled(false);
                label.setFont((Font)JBUI.Fonts.smallFont());
                this.add(JBUI.Borders.emptyLeft((int)-1).wrap((JComponent)label));
            }
            if ((s = action.getValue("ShortDescription")) instanceof String) {
                string = (String)s;
                button.setToolTipText(string);
            }
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }

        void update() {
            boolean globallyEnabled = !UsageViewImpl.this.isSearchInProgress() && !DumbService.isDumb((Project)UsageViewImpl.this.myProject);
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                Action action = button.getAction();
                if (action != null) {
                    Object name;
                    if (UsageViewImpl.this.myNeedUpdateButtons) {
                        button.setEnabled(globallyEnabled && action.isEnabled());
                    }
                    if (!((name = action.getValue("Name")) instanceof String)) continue;
                    String string = (String)name;
                    DialogUtil.setTextWithMnemonic((AbstractButton)button, (String)string);
                    continue;
                }
                button.setEnabled(globallyEnabled);
            }
            UsageViewImpl.this.myNeedUpdateButtons = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/usages/impl/UsageViewImpl$ButtonPanel", "addButtonAction"));
        }
    }

    private static interface ExclusionHandlerEx<Node>
    extends ExclusionHandler<Node> {
        public void excludeNodeSilently(@NotNull Node var1);
    }

    private static class MyTree
    extends Tree
    implements UiDataProvider {
        boolean myExpandingCollapsing;
        final CopyProvider myCopyProvider = new TextCopyProvider(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                List lines = ContainerUtil.mapNotNull(UsageViewImpl.selectedNodes(this), o -> {
                    String string;
                    if (o instanceof Node) {
                        Node n = (Node)o;
                        string = n.getNodeText();
                    } else {
                        string = null;
                    }
                    return string;
                });
                return lines.isEmpty() ? null : lines;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl$MyTree$1", "getActionUpdateThread"));
            }
        };

        MyTree(UsageViewTreeModelBuilder model2) {
            super((TreeModel)model2);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        }

        public boolean isRootVisible() {
            return false;
        }

        public String getToolTipText(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path != null && this.getCellRenderer() instanceof UsageViewTreeCellRenderer) {
                return UsageViewTreeCellRenderer.getTooltipFromPresentation(path.getLastPathComponent());
            }
            return null;
        }

        public boolean isPathEditable(@NotNull TreePath path) {
            if (path == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            return path.getLastPathComponent() instanceof UsageViewTreeModelBuilder.TargetsRootNode;
        }

        public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
            return this.myExpandingCollapsing ? Collections.emptyEnumeration() : super.getExpandedDescendants(parent);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MyTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPathEditable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyPanel
    extends JPanel
    implements UiDataProvider,
    OccurenceNavigator,
    Disposable {
        @Nullable
        private OccurenceNavigatorSupport mySupport;

        private MyPanel(JTree tree) {
            if (tree == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            this.mySupport = new OccurenceNavigatorSupport(tree){

                protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
                    Node n;
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (node.getChildCount() > 0) {
                        return null;
                    }
                    if (node instanceof Node && (n = (Node)node).isExcluded()) {
                        return null;
                    }
                    return UsageViewImpl.this.getNavigatableForNode(node, !UsageViewImpl.this.myPresentation.isReplaceMode());
                }

                @NotNull
                public String getNextOccurenceActionName() {
                    String string = UsageViewBundle.message("action.next.occurrence", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @NotNull
                public String getPreviousOccurenceActionName() {
                    String string = UsageViewBundle.message("action.previous.occurrence", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$MyPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MyPanel$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNextOccurenceActionName";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPreviousOccurenceActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createDescriptorForNode";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.transferFocus();
            }
        }

        public void dispose() {
            this.mySupport = null;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean hasNextOccurence() {
            return this.mySupport != null && this.mySupport.hasNextOccurence();
        }

        public boolean hasPreviousOccurence() {
            return this.mySupport != null && this.mySupport.hasPreviousOccurence();
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.mySupport != null ? this.mySupport.goNextOccurence() : null;
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.mySupport != null ? this.mySupport.goPreviousOccurence() : null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getNextOccurenceActionName() : "";
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getPreviousOccurenceActionName() : "";
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(2);
            }
            List<TreeNode> selection = UsageViewImpl.this.selectedNodes();
            sink.set(CommonDataKeys.PROJECT, (Object)UsageViewImpl.this.myProject);
            sink.set(UsageView.USAGE_VIEW_KEY, (Object)UsageViewImpl.this);
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)UsageViewImpl.HELP_ID);
            sink.set(ExclusionHandler.EXCLUSION_HANDLER, UsageViewImpl.this.myExclusionHandler);
            sink.set(PlatformDataKeys.EXPORTER_TO_TEXT_FILE, (Object)UsageViewImpl.this.myTextFileExporter);
            sink.set(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ContainerUtil.mapNotNull(selection, n -> (Navigatable)ObjectUtils.tryCast((Object)TreeUtil.getUserObject((Object)n), Navigatable.class)).toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY));
            List targets = ContainerUtil.mapNotNull(selection, o -> {
                UsageTarget usageTarget;
                if (o instanceof UsageTargetNode) {
                    UsageTargetNode oo = (UsageTargetNode)o;
                    usageTarget = oo.getTarget();
                } else {
                    usageTarget = null;
                }
                return usageTarget;
            });
            sink.set(UsageView.USAGE_TARGETS_KEY, targets.isEmpty() ? null : targets.toArray(UsageTarget.EMPTY_ARRAY));
            DataSink.uiDataSnapshot((DataSink)sink, (Object)TreeUtil.getUserObject((Object)UsageViewImpl.this.getSelectedNode()));
            List<TreeNode> selectedNodes = UsageViewImpl.this.selectedNodes();
            sink.lazy(UsageView.USAGES_KEY, () -> (Usage[])UsageViewImpl.selectedUsages(UsageViewImpl.this.traverseNodesRecursively(selectedNodes)).toArray((Object[])Usage.EMPTY_ARRAY));
            sink.lazy(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, () -> (PsiElement[])UsageViewImpl.selectedUsages(UsageViewImpl.this.traverseNodesRecursively(selectedNodes)).filter(PsiElementUsage.class).filterMap(usage -> usage.getElement()).toArray((Object[])PsiElement.EMPTY_ARRAY));
            sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> (VirtualFile[])UsageViewImpl.this.traverseNodesRecursively(selectedNodes).filterMap(o -> {
                Object object;
                if (o instanceof UsageNode) {
                    UsageNode usageNode = (UsageNode)o;
                    object = usageNode.getUsage();
                } else if (o instanceof UsageTargetNode) {
                    UsageTargetNode targetNode = (UsageTargetNode)o;
                    object = targetNode.getTarget();
                } else {
                    object = null;
                }
                return object;
            }).flatMap(o -> {
                List<Object> list2;
                if (o instanceof UsageInFile) {
                    UsageInFile inFile = (UsageInFile)o;
                    list2 = ContainerUtil.createMaybeSingletonList((Object)inFile.getFile());
                } else if (o instanceof UsageInFiles) {
                    UsageInFiles inFiles = (UsageInFiles)o;
                    list2 = Arrays.asList(inFiles.getFiles());
                } else if (o instanceof UsageTarget) {
                    UsageTarget target = (UsageTarget)o;
                    list2 = Arrays.asList((VirtualFile[])ObjectUtils.notNull((Object)target.getFiles(), (Object)VirtualFile.EMPTY_ARRAY));
                } else {
                    list2 = Collections.emptyList();
                }
                return list2;
            }).filter(file -> file.isValid()).unique().toArray((Object[])VirtualFile.EMPTY_ARRAY));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$MyPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MyPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class NodeChange {
        @NotNull
        private final NodeChangeType nodeChangeType;
        @NotNull
        private final Node parentNode;
        @Nullable
        private final Node childNode;

        NodeChange(@NotNull NodeChangeType nodeChangeType, @NotNull Node parentNode, @Nullable Node childNode) {
            if (nodeChangeType == null) {
                NodeChange.$$$reportNull$$$0(0);
            }
            if (parentNode == null) {
                NodeChange.$$$reportNull$$$0(1);
            }
            this.nodeChangeType = nodeChangeType;
            this.parentNode = parentNode;
            this.childNode = childNode;
        }

        @NotNull
        Node getParentNode() {
            Node node = this.parentNode;
            if (node == null) {
                NodeChange.$$$reportNull$$$0(2);
            }
            return node;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeChange that = (NodeChange)o;
            return this.nodeChangeType == that.nodeChangeType && Objects.equals(this.parentNode, that.parentNode) && Objects.equals(this.childNode, that.childNode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.nodeChangeType, this.parentNode, this.childNode});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeChangeType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$NodeChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$NodeChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static enum NodeChangeType {
        ADDED,
        REMOVED,
        REPLACED;

    }

    private final class ShowSettings
    extends AnAction {
        ShowSettings() {
            KeyboardShortcut shortcut;
            super(UsageViewBundle.message("action.text.usage.view.settings", new Object[0]), null, AllIcons.General.GearPlain);
            ConfigurableUsageTarget target = UsageViewImpl.getConfigurableTarget(UsageViewImpl.this.myTargets);
            KeyboardShortcut keyboardShortcut = shortcut = target == null ? UsageViewUtil.getShowUsagesWithSettingsShortcut() : target.getShortcut();
            if (shortcut != null) {
                this.registerCustomShortcutSet(new CustomShortcutSet(shortcut), UsageViewImpl.this.getComponent());
            }
        }

        @Override
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowSettings.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettings.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null);
            if (this.getTemplatePresentation().getDescription() == null) {
                ConfigurableUsageTarget target = UsageViewImpl.getConfigurableTarget(UsageViewImpl.this.myTargets);
                Supplier<String> description = null;
                if (target != null) {
                    try {
                        description = UsageViewBundle.messagePointer("action.ShowSettings.show.settings.for.description", target.getLongDescriptiveName());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
                if (description == null) {
                    description = UsageViewBundle.messagePointer("action.ShowSettings.show.find.usages.settings.dialog.description", new Object[0]);
                }
                this.getTemplatePresentation().setDescription(description);
                e.getPresentation().setDescription(description);
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettings.$$$reportNull$$$0(2);
            }
            FindManager.getInstance((Project)UsageViewImpl.this.getProject()).showSettingsAndFindUsages((NavigationItem[])UsageViewImpl.this.myTargets);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$ShowSettings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$ShowSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class UsageState {
        private final Usage myUsage;
        private final boolean mySelected;

        private UsageState(Usage usage, boolean isSelected) {
            if (usage == null) {
                UsageState.$$$reportNull$$$0(0);
            }
            this.myUsage = usage;
            this.mySelected = isSelected;
        }

        private void restore() {
            ThreadingAssertions.assertEventDispatchThread();
            UsageNode node = UsageViewImpl.this.myUsageNodes.get(this.myUsage);
            if (node == NULL_NODE || node == null) {
                return;
            }
            DefaultMutableTreeNode parentGroupingNode = (DefaultMutableTreeNode)node.getParent();
            if (parentGroupingNode != null) {
                TreePath treePath = new TreePath(parentGroupingNode.getPath());
                UsageViewImpl.this.myTree.expandPath(treePath);
                if (this.mySelected) {
                    UsageViewImpl.this.myTree.addSelectionPath(treePath.pathByAddingChild(node));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl$UsageState", "<init>"));
        }
    }

    private final class MyPerformOperationRunnable
    implements Runnable {
        private final @NlsContexts.DialogMessage String myCannotMakeString;
        private final Runnable myProcessRunnable;
        private final @NlsContexts.Command String myCommandName;
        private final boolean myCheckReadOnlyStatus;

        private MyPerformOperationRunnable(@NlsContexts.Command @Nullable Runnable processRunnable, @NlsContexts.DialogMessage String commandName, String cannotMakeString, boolean checkReadOnlyStatus) {
            if (processRunnable == null) {
                MyPerformOperationRunnable.$$$reportNull$$$0(0);
            }
            this.myCannotMakeString = cannotMakeString;
            this.myProcessRunnable = processRunnable;
            this.myCommandName = commandName;
            this.myCheckReadOnlyStatus = checkReadOnlyStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.myCheckReadOnlyStatus && !UsageViewImpl.this.checkReadonlyUsages()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)UsageViewImpl.this.myProject).commitAllDocuments();
            if (this.myCannotMakeString != null && !this.myCannotMakeString.isEmpty() && UsageViewImpl.this.myChangesDetected) {
                String title = UsageViewBundle.message("changes.detected.error.title", new Object[0]);
                if (UsageViewImpl.this.canPerformReRun()) {
                    String message = this.myCannotMakeString + "\n\n" + UsageViewBundle.message("dialog.rerun.search", new Object[0]);
                    int answer = Messages.showYesNoCancelDialog((Project)UsageViewImpl.this.myProject, (String)message, (String)title, (String)UsageViewBundle.message("action.description.rerun", new Object[0]), (String)UsageViewBundle.message("button.text.continue", new Object[0]), (String)UsageViewBundle.message("usage.view.cancel.button", new Object[0]), (Icon)Messages.getErrorIcon());
                    if (answer == 0) {
                        UsageViewImpl.this.refreshUsages();
                        return;
                    }
                    if (answer == 2) {
                        return;
                    }
                } else {
                    Messages.showMessageDialog((Project)UsageViewImpl.this.myProject, (String)this.myCannotMakeString, (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
            }
            try {
                if (this.myCommandName == null) {
                    this.myProcessRunnable.run();
                } else {
                    CommandProcessor.getInstance().executeCommand(UsageViewImpl.this.myProject, this.myProcessRunnable, this.myCommandName, null);
                }
            }
            finally {
                UsageViewImpl.this.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processRunnable", "com/intellij/usages/impl/UsageViewImpl$MyPerformOperationRunnable", "<init>"));
        }
    }
}

