/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.bag;

import com.intellij.util.containers.Interner;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Bag {
    public static final Bag EMPTY_BAG = new Bag();
    private static final Interner<String> ourInterner = Interner.createWeakInterner();
    @NotNull
    private final Object2IntMap<String> myBag;
    private int myCardinality;

    public Bag() {
        this.myBag = new Object2IntOpenHashMap();
        this.myBag.defaultReturnValue(0);
    }

    public Bag(String ... words) {
        if (words == null) {
            Bag.$$$reportNull$$$0(0);
        }
        this.myBag = new Object2IntOpenHashMap();
        this.myBag.defaultReturnValue(0);
        for (String word : words) {
            String internedWord = (String)ourInterner.intern((Object)word);
            this.myBag.put((Object)internedWord, this.myBag.getInt((Object)internedWord) + 1);
            ++this.myCardinality;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Object2IntMap<String> getBag() {
        Object2IntMap<String> object2IntMap = this.myBag;
        if (object2IntMap == null) {
            Bag.$$$reportNull$$$0(1);
        }
        return object2IntMap;
    }

    public void addAll(@NotNull Bag bag) {
        if (bag == null) {
            Bag.$$$reportNull$$$0(2);
        }
        for (Object2IntMap.Entry entry : bag.myBag.object2IntEntrySet()) {
            String key = (String)entry.getKey();
            this.myBag.put((Object)key, this.myBag.getInt((Object)key) + entry.getIntValue());
            this.myCardinality += entry.getIntValue();
        }
    }

    public int getCardinality() {
        return this.myCardinality;
    }

    public void add(@NotNull String key) {
        if (key == null) {
            Bag.$$$reportNull$$$0(3);
        }
        String internedKey = (String)ourInterner.intern((Object)key);
        this.myBag.put((Object)internedKey, this.myBag.getInt((Object)internedKey) + 1);
        ++this.myCardinality;
    }

    public int get(@NotNull String word) {
        if (word == null) {
            Bag.$$$reportNull$$$0(4);
        }
        return this.myBag.getInt((Object)word);
    }

    public boolean isEmpty() {
        return this.myBag.isEmpty();
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        for (Object2IntMap.Entry entry : this.getBag().object2IntEntrySet()) {
            toReturn.append((String)entry.getKey()).append(" : ").append(entry.getIntValue()).append("\n");
        }
        return toReturn.toString();
    }

    public static int intersectionSize(@NotNull Bag bag1, @NotNull Bag bag2) {
        if (bag1 == null) {
            Bag.$$$reportNull$$$0(5);
        }
        if (bag2 == null) {
            Bag.$$$reportNull$$$0(6);
        }
        Bag toIterate = bag1.getBag().size() > bag2.getBag().size() ? bag2 : bag1;
        Bag toProcess = bag1.getBag().size() > bag2.getBag().size() ? bag1 : bag2;
        int cardinality = 0;
        for (Object2IntMap.Entry entry : toIterate.getBag().object2IntEntrySet()) {
            cardinality += Math.min(toProcess.getBag().getInt(entry.getKey()), toIterate.getBag().getInt(entry.getKey()));
        }
        return cardinality;
    }

    @NotNull
    public static Bag concat(Bag ... bags) {
        if (bags == null) {
            Bag.$$$reportNull$$$0(7);
        }
        Bag bag = new Bag();
        for (Bag it : bags) {
            bag.addAll(it);
        }
        Bag bag2 = bag;
        if (bag2 == null) {
            Bag.$$$reportNull$$$0(8);
        }
        return bag2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/similarity/bag/Bag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/similarity/bag/Bag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectionSize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }
}

