/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\f\u001a\u00020\u000bH\u0096\u0080\u0004J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0011\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0086\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/intellij/build/dependencies/DependenciesProperties;", "", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "customPropertyFiles", "", "Ljava/nio/file/Path;", "<init>", "(Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;[Ljava/nio/file/Path;)V", "dependencies", "", "", "toString", "property", "name", "get", "copy", "", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDependenciesProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesProperties.kt\norg/jetbrains/intellij/build/dependencies/DependenciesProperties\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1342#2:55\n1343#2:59\n221#3:56\n222#3:58\n1#4:57\n*S KotlinDebug\n*F\n+ 1 DependenciesProperties.kt\norg/jetbrains/intellij/build/dependencies/DependenciesProperties\n*L\n23#1:55\n23#1:59\n24#1:56\n24#1:58\n*E\n"})
public final class DependenciesProperties {
    @NotNull
    private final Map<String, String> dependencies;

    /*
     * WARNING - void declaration
     */
    public DependenciesProperties(@NotNull BuildDependenciesCommunityRoot communityRoot, Path ... customPropertyFiles) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Intrinsics.checkNotNullParameter((Object)customPropertyFiles, (String)"customPropertyFiles");
        this.dependencies = new TreeMap();
        Path communityPropertiesFile = communityRoot.communityRoot.resolve("build/dependencies/dependencies.properties");
        Path runtimePropertiesFile = communityRoot.communityRoot.resolve("build/dependencies/runtime.properties");
        Path ultimatePropertiesFile = communityRoot.communityRoot.getParent().resolve("build/dependencies.properties");
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.addSpread((Object)customPropertyFiles);
        spreadBuilder.add((Object)communityPropertiesFile);
        spreadBuilder.add((Object)ultimatePropertiesFile);
        spreadBuilder.add((Object)runtimePropertiesFile);
        spreadBuilder = SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])spreadBuilder.toArray((Object[])new Path[spreadBuilder.size()])))), DependenciesProperties::_init_$lambda$0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path file = (Path)element$iv;
            boolean bl = false;
            Map<String, String> $this$forEach$iv2 = BuildDependenciesUtil.INSTANCE.loadPropertiesFile(file);
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv2;
                Map.Entry<String, String> entry = element$iv2 = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value = entry.getValue();
                if (!(!this.dependencies.containsKey(key))) {
                    boolean bl3 = false;
                    String string = "Key '" + key + "' from " + file + " is already defined";
                    throw new IllegalStateException(string.toString());
                }
                this.dependencies.put(key, value);
            }
        }
        if (!(!this.dependencies.isEmpty())) {
            boolean bl = false;
            String string = "No dependencies are defined";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.dependencies.entrySet(), (CharSequence)"\n", null, null, (int)0, null, DependenciesProperties::toString$lambda$0, (int)30, null);
    }

    @NotNull
    public final String property(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.dependencies.get(name);
        if (string == null) {
            boolean bl = false;
            String string2 = "'" + name + "' is unknown key: " + this;
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    @NotNull
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.property(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copy(@Nullable Path copy) throws IOException {
        Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        object = Files.newBufferedWriter(copy, object);
        Throwable throwable = null;
        try {
            BufferedWriter file = (BufferedWriter)object;
            boolean bl = false;
            file.write(this.toString());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        if (!this.dependencies.containsKey("jdkBuild")) {
            boolean bl = false;
            String string = "'jdkBuild' key is required for backward compatibility with gradle-intellij-plugin";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final boolean _init_$lambda$0(Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Files.exists(file, new LinkOption[0]);
    }

    private static final CharSequence toString$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }
}

